<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Http\Request;
use App\Models\BillModel;
use App\Http\Controllers\MasterController;
use App\Http\Controllers\TreatmentController;
use App\Models\PackageModel;
use App\Models\TempBillChargeModel;
use App\Http\Controllers\CounsellingController;
use App\Models\OTModel;
use App\Models\DischargeModel;
use App\Http\Controllers\PackageController;
use App\Models\OTNoteOtherModel;
use App\Models\DischargeOtherModel;
use App\Models\IpdReceiptModel;
use App\Models\ProcedureModel;
use App\Models\ChargesModel;
use Session;

class BillController extends Controller
{
    function bill(){
        return view('/ipd/view-bill');
    }

    function viewIpdBills(Request $req){
        $CurrDate = date('Y-m-d');
        if(!empty($req->FromDate))
            {   
                if($req->MrdNo == '' || $req->MrdNo == 0){
                    $result =  DB::table('tbl_bills as ti')
                    ->leftJoin('tbl_ipd as tip', 'tip.IpdNo', '=', 'ti.IpdNo')
                    ->leftJoin('tbl_users as tc', 'tc.id', '=', 'ti.Consultant')
                    ->whereBetween('ti.BillDate', array($req->FromDate, $req->ToDate))
                    ->where(['ti.Status'=>'1'])
                    ->select('ti.*','tc.Name As Department')->get();
                }
                else{
                    $MrdNo = $req->MrdNo;
                    $result =  DB::table('tbl_bills as ti')
                    ->leftJoin('tbl_ipd as tip', 'tip.IpdNo', '=', 'ti.IpdNo')
                    ->leftJoin('tbl_users as tc', 'tc.id', '=', 'ti.Consultant')
                    ->whereBetween('ti.BillDate', array($req->FromDate, $req->ToDate))
                    ->where(['ti.Status'=>'1','ti.MrdNo'=>$MrdNo])
                    ->select('ti.*','tc.Name As Department')->get();
                }
               

            }
            else{
                $result =  DB::table('tbl_bills as ti')
                ->leftJoin('tbl_ipd as tip', 'tip.IpdNo', '=', 'ti.IpdNo')
                ->leftJoin('tbl_users as tc', 'tc.id', '=', 'ti.Consultant')
                ->where(['ti.Status'=>'1'])
                ->select('ti.*','tc.Name As Department')
                ->orderBy('ti.id','desc')
                ->limit(10)->get();
            }
        return view('ipd/incipdbills',['data'=>$result]);
    }

    function deletIpdBill(Request $req){
        BillModel::find($req->id)->delete();
        DB::table('tbl_bill_charges')->where(['BillNo'=>$req->id])->delete();
        return 1;
    }

    function BillNo(){
         $BillNo = BillModel::select('SrNo')->max('SrNo');
        $curryr = substr(date('Y'), -2);
        $currmonth = date('m');
        if($BillNo == '' || $BillNo == 0 || $BillNo == NULL){
            $maxid = "CRV1/".($curryr)."-".($curryr+1)."/".$currmonth;
        }
        else{
            $maxid2 = $BillNo + 1;
            $maxid = "CRV".$maxid2."/".($curryr)."-".($curryr+1)."/".$currmonth;
        }

        // if($BillNo == '' || $BillNo == 0 || $BillNo == NULL){
        //     $maxid = 2700;
        // }
        // else{
        //     $maxid = $BillNo + 1;
        // }
        return $maxid;

       
    }

    function BillNoList(){
        $BillNoList = BillModel::all();
        return $BillNoList;
    }
    function addIpdBill(){
        $patientList = (new MasterController)->ipdPatientList();
        $consultantList = (new MasterController)->consultantList();
        //$counsellingList = (new CounsellingController)->getCounsellingId();
        $BillNoList = $this->BillNoList();
        $BillNo = $this->BillNo();
        $counsellingList = OTModel::all();
        $packagelist = (new PackageController)->packageList();
        $procedures = DB::table('tbl_charges')
            ->where('Status', 1)
            ->whereNotNull('Name')
            ->where('Name', '!=', '')
            ->select('Name', DB::raw('MAX(Rate) as Rate'))
            ->groupBy('Name')
            ->get();
        return view('/ipd/add-ipd-bill',['procedures'=>$procedures,'packagelist'=>$packagelist,'roll'=>1,'BillNoList'=>$BillNoList,'counsellingList'=>$counsellingList,'BillNo'=>$BillNo,'consultantList'=>$consultantList,'patientList'=>$patientList]);
    }

    function addIpdBill2($mrdno,$otid){
        $consultantList = (new MasterController)->consultantList();
        $packagelist = (new PackageController)->packageList();
        $SessionId = Session::getId();
        $result = BillModel::where('OtId',$otid)->get();
        $cnt = $result->count();
        if($cnt > 0){
            $otresult = $result;
            $action = "Edit";
            $id = $otresult[0]->id;
            $BillNo = $otresult[0]->BillNo;
            $ConsellingId = $otresult[0]->OtId;
            $BillDate = $otresult[0]->BillDate;
            $OperationDate = $otresult[0]->OperationDate;
            $SurgeryDate=$otresult[0]->DischargeDate;
            $AgeGender = $otresult[0]->AgeGender;
            $SubTotal = $otresult[0]->SubTotal;
            $Diagnosis = $otresult[0]->Diagnosis;
           
            DB::table('tbl_temp_bill_charges')->where(['SessionId'=>$SessionId])->delete();
           
        // ✅ Insert data from tbl_bill_charges into tbl_temp_bill_charges
DB::statement("
INSERT INTO tbl_temp_bill_charges (
    SessionId, PackageName, PackageAmt, BalanceAmt,
    Name, Days, Rate, Amount, Status, CreatedBy
)
SELECT ?, PackageName, PackageAmt, BalanceAmt,
       Name, Days, Rate, Amount, Status, CreatedBy
FROM tbl_bill_charges
WHERE BillNo = ?
", [$SessionId, $BillNo]);

// ✅ Fetch the inserted records from temp table
$result2 = DB::table('tbl_temp_bill_charges')
        ->where('SessionId', $SessionId)
        ->get();

      
        return view('/ipd/add-ipd-bill2',['Diagnosis'=>$Diagnosis,'SubTotal'=>$SubTotal,'SurgeryDate'=>$SurgeryDate,'otid'=>$otid,'mrdno'=>$mrdno,'AgeGender'=>$AgeGender,'data2'=>$result2,'OperationDate'=>$OperationDate,'BillDate'=>$BillDate,'ConsellingId'=>$ConsellingId,'id'=>$id,'action'=>$action,'roll'=>1,'packagelist'=>$packagelist,'otresult'=>$otresult,'BillNo'=>$BillNo,'consultantList'=>$consultantList]);
    }
        else{
            $otresult = OTModel::where('id',$otid)->get();
            $action = "Save";
            $id = "";
            $BillNo = $this->BillNo();
            $ConsellingId = $otid;
            $BillDate = date('Y-m-d');
            $OperationDate = $otresult[0]->SurgeryDate;
            $SurgeryDate=$otresult[0]->SurgeryDate;
            $AgeGender = $otresult[0]->Age."/".$otresult[0]->Gender;
            $Diagnosis = $otresult[0]->SurgeryName;
            return view('/ipd/add-ipd-bill2',['Diagnosis'=>$Diagnosis,'SubTotal'=>0,'SurgeryDate'=>$SurgeryDate,'AgeGender'=>$AgeGender,'OperationDate'=>$OperationDate,'BillDate'=>$BillDate,'ConsellingId'=>$ConsellingId,'id'=>$id,'action'=>$action,'roll'=>1,'packagelist'=>$packagelist,'otresult'=>$otresult,'BillNo'=>$BillNo,'consultantList'=>$consultantList]);
        }
       
    }

    function addOtherIpdBill2($mrdno,$otid,$dcid){
        //$patientList = (new MasterController)->ipdPatientList();
        $consultantList = (new MasterController)->consultantList();
        //$counsellingList = (new CounsellingController)->getCounsellingId();
        //$BillNoList = $this->BillNoList();
        $BillNo = $this->BillNo();
        //$counsellingList = OTModel::all();
        $otresult = OTNoteOtherModel::where('id',$otid)->first();
        $dcresult = DischargeOtherModel::where('id',$dcid)->first();
        $packagelist = (new PackageController)->packageList();
        return view('/ipd/add-ipd-bill2',['roll'=>2,'dcresult'=>$dcresult,'packagelist'=>$packagelist,'otresult'=>$otresult,'BillNo'=>$BillNo,'consultantList'=>$consultantList]);
    }
    

    function getBillPackageDetails(Request $req){
        $SessionId = Session::getId();
        $PackageName = $req->PackageName;
        //$PackageAmt = $req->PackageAmt;
        //return $PackageName;
        DB::table('tbl_temp_bill_charges')->where(['SessionId'=>$SessionId])->delete();
        $result = PackageModel::select()->where(['PackageName'=>$PackageName])->get();
        $firstrecord = $result->first();
        for($count = 0; $count < count($result); $count++)
        {
         if($PackageName == 'Cashless'){
            $PackageAmt = $req->PackageAmt;
         }
         else{
            $PackageAmt = $result[$count]['PackageAmt'];
         }
        $data = array(
        'SessionId'=>$SessionId,
        'PackageName'=>$PackageName,
        'PackageAmt'=>$PackageAmt,
        'BalanceAmt'=>$result[$count]['BalanceAmt'],
        'Name'=>$result[$count]['Name'],
        'Amount'=>$result[$count]['Amount'],
        'Days'=>$result[$count]['Days'],
        'Rate'=>$result[$count]['Rate'],
        'Status'=>1,
        'CreatedBy' => 19,
       );
       $insert_data[] = $data; 
       }
       //return $insert_data;exit();
       TempBillChargeModel::insert($insert_data);
        return json_encode($firstrecord);
    }

    
    function getBillPackageDetails2(Request $req){
        $SessionId = Session::getId();
        $PackageName = $req->PackageName;
        $PackageAmt = $req->PackageAmt;
        //return $PackageName;
        DB::table('tbl_temp_bill_charges')->where(['SessionId'=>$SessionId])->delete();
        if($PackageName == 'AMOUNT TO BE PAID BY INSURED'){
        $otcharges = $req->PackageAmt;
        $Package = new TempBillChargeModel;
        $Package->SessionId = $SessionId;
        //$result = TempBillChargeModel::select('Name')->where(['SessionId'=>$SessionId])->first();
        $Package->Name = 'AMOUNT TO BE PAID BY INSURED'; 
        $Package->Days = 1;
        $Package->Rate = $otcharges; $Package->Amount = $otcharges;
        $Package->PackageName = $req->PackageName; $Package->PackageAmt = $req->PackageAmt;
        $Package->BalanceAmt = 0; $Package->Status = 1;
        $Package->save();
        }
        else if($PackageName == 'SURGEONS CHARGES'){
            $otcharges = $req->PackageAmt;
            $Package = new TempBillChargeModel;
            $Package->SessionId = $SessionId;
            //$result = TempBillChargeModel::select('Name')->where(['SessionId'=>$SessionId])->first();
            $Package->Name = 'SURGEONS CHARGES'; 
            $Package->Days = 1;
            $Package->Rate = $otcharges; $Package->Amount = $otcharges;
            $Package->PackageName = $req->PackageName; $Package->PackageAmt = $req->PackageAmt;
            $Package->BalanceAmt = 0; $Package->Status = 1;
            $Package->save();
            }
        else{
            $otcharges = $req->PackageAmt/4;
            $Package = new TempBillChargeModel;
            $Package->SessionId = $SessionId;
            $Package->Name = 'SURGEONS CHARGES + IOL/CONSUMABLES'; $Package->Days = 1;
            $Package->Rate = $otcharges; $Package->Amount = $otcharges;
            $Package->PackageName = $req->PackageName; $Package->PackageAmt = $req->PackageAmt;
            $Package->BalanceAmt = 0; $Package->Status = 1;
            $Package->save();
            
            $Package2 = new TempBillChargeModel;
            $Package2->SessionId = $SessionId;
            $Package2->Name = 'ROOM RENT'; $Package2->Days = 1;
            $Package2->Rate = $otcharges; $Package2->Amount = $otcharges;
            $Package2->PackageName = $req->PackageName; $Package2->PackageAmt = $req->PackageAmt;
            $Package2->BalanceAmt = 0; $Package2->Status = 1;
            $Package2->save();
            
            $Package3 = new TempBillChargeModel;
            $Package3->SessionId = $SessionId;
            $Package3->Name = 'ANESTHESIA CHARGES'; $Package3->Days = 1;
            $Package3->Rate = $otcharges; $Package3->Amount = $otcharges;
            $Package3->PackageName = $req->PackageName; $Package3->PackageAmt = $req->PackageAmt;
            $Package3->BalanceAmt = 0; $Package3->Status = 1;
            $Package3->save();
    
            $Package4 = new TempBillChargeModel;
            $Package4->SessionId = $SessionId;
            $Package4->Name = 'OT CHARGES'; $Package4->Days = 1;
            $Package4->Rate = $otcharges; $Package4->Amount = $otcharges;
            $Package4->PackageName = $req->PackageName; $Package4->PackageAmt = $req->PackageAmt;
            $Package4->BalanceAmt = 0; $Package4->Status = 1;
            $Package4->save();
        
        // $Package5 = new TempBillChargeModel;
        // $Package5->SessionId = $SessionId;
        // $Package5->Name = 'CONSUMABLES/IOL'; $Package5->Days = 1;
        // $Package5->Rate = 1200; $Package5->Amount = 1200;
        // $Package5->PackageName = $req->PackageName; $Package5->PackageAmt = $req->PackageAmt;
        // $Package5->BalanceAmt = 0; $Package5->Status = 1;
        // $Package5->save();
        }
        return 1;
    }

    function billChargesView(Request $req){
        $SessionId = Session::getId();
        $PackageName = $req->PackageName;
        $result = TempBillChargeModel::select()->where(['PackageName'=>$PackageName,'SessionId'=>$SessionId])->get();
        return view('ipd/incipdbillchargeview',['data'=>$result]);
    }

    function billChargesView2(Request $req){
        try {
            $SessionId = Session::getId();
            $PackageName = $req->PackageName ?? 'GENERAL';
            $result = TempBillChargeModel::select()->where(['PackageName'=>$PackageName,'SessionId'=>$SessionId])->get();
            
            // Ensure we always return an array, even if empty
            if (!$result || $result->isEmpty()) {
                $result = collect([]);
            }
            
            return view('ipd/incipdbillchargeview2',['data'=>$result]);
        } catch (\Exception $e) {
            \Log::error('billChargesView2 Error: ' . $e->getMessage());
            return view('ipd/incipdbillchargeview2',['data'=>collect([])]);
        }
    }


    

    function calBillBalanceAmt(Request $req){
        $PackageName = $req->PackageName;
        $SessionId = Session::getId();
        $result = DB::select("SELECT SUM(Amount) As Amount FROM tbl_temp_bill_charges WHERE PackageName = '$PackageName' AND SessionId='$SessionId'");
        $TotAmt = $result[0]->Amount;
        //$PackageAmt = $result[0]->PackageAmt;
        $PackageAmt = $req->PackageAmt;
    $BalanceAmt = $PackageAmt - $TotAmt;
    return $BalanceAmt;
    }

    function totSumBills(Request $req){
        $SessionId = Session::getId();
        $result = TempBillChargeModel::select()->where(['SessionId'=>$SessionId])->sum('Amount');
        return $result;
    }
    function saveTempBills(Request $req){
        try {
            $SessionId = Session::getId();
            $maxAmt = TempBillChargeModel::where('SessionId', $SessionId)
                ->orderBy('Amount', 'desc')
                ->first();
            
            // Handle null case when no records exist yet
            $max_amt = $maxAmt ? ($maxAmt->Amount ?? 0) : 0;
            $max_amt_id = $maxAmt ? ($maxAmt->id ?? null) : null;
            
            if($req->action == 'Save'){
                $TempBillCharge = new TempBillChargeModel;
            } else {
                $TempBillCharge = TempBillChargeModel::firstWhere(['id'=>$req->id,'SessionId'=>$SessionId]);
                if (!$TempBillCharge) {
                    return response()->json([
                        'success' => false,
                        'error' => 'Record not found for editing'
                    ], 404);
                }
            }
            
            $TempBillCharge->SessionId = Session::getId();
            $TempBillCharge->Name = $req->ChargesName ?? '';
            $TempBillCharge->Days = $req->Days ?? 0;
            $TempBillCharge->Rate = $req->Rate ?? 0;
            $TempBillCharge->Amount = $req->Amount ?? 0;
            $TempBillCharge->PackageName = $req->PackageName ?? 'GENERAL';
            $TempBillCharge->PackageAmt = $req->PackageAmt ?? 0;
            $TempBillCharge->BalanceAmt = $req->BalanceAmt ?? 0;
            $TempBillCharge->Status = 1;
            $TempBillCharge->CreatedBy = Session::get('UserId') ?? 19;
            $TempBillCharge->save();
            
            return response()->json([
                'success' => true,
                'message' => $req->action == 'Save' ? 'Charge added successfully' : 'Charge updated successfully',
                'id' => $TempBillCharge->id
            ]);
        } catch (\Exception $e) {
            Log::error('saveTempBills Error: ' . $e->getMessage());
            return response()->json([
                'success' => false,
                'error' => 'An error occurred while saving: ' . $e->getMessage()
            ], 500);
        }

//            $oldamt = $req->OldAmount;
//            $balamt = $oldamt - $req->Amount;
//            $totamt = $req->Amount;
// DB::table('tbl_temp_bill_charges')->where(['id'=>$max_amt_id])->update(['Amount'=>$totamt,'Rate'=>$totamt]);

           // if($balamt > 0){
           //     $totamt = $max_amt + $balamt;
           // }
           // else{
           //     $totamt = $max_amt - $balamt;
           // }

       return 1;
   }

    function saveIpdBill(Request $req){
        DB::table('tbl_bills')->where(['BillNo'=>$req->BillNo])->delete();
        DB::table('tbl_bill_charges')->where(['BillNo'=>$req->BillNo])->delete();
       // DB::table('tbl_bills')->where(['OtId'=>$req->OtId,'DscId'=>$req->DscId])->delete();
       $SrNo2 = BillModel::select('SrNo')->max('SrNo');
       $SrNo = $SrNo2+1;
       $SessionId = Session::getId();
        $Bill = new BillModel;
        $Bill->Roll = $req->Roll;
        $Bill->SrNo = $SrNo;
        $Bill->BillNo = $req->BillNo;
        $Bill->BillType = $req->BillType;
  $Bill->MrdNo = $req->MrdNo;
  $Bill->IpdNo = $req->IpdNo;
  $Bill->PatientName = $req->PatientName;
  $Bill->AgeGender = $req->AgeGender;
  $Bill->BillDate = $req->BillDate;
  $Bill->AdmissionDate = $req->AdmissionDate;
  $Bill->DischargeDate = $req->DischargeDate;
  $Bill->OperationDate = $req->OperationDate;
  $Bill->Consultant = $req->Consultant;
  $Bill->Diagnosis = $req->Diagnosis;
  $Bill->SurgeryDone = $req->SurgeryDone;
  $Bill->InsuranceComp = $req->InsuranceComp;
  $Bill->ClainNo = $req->ClainNo;
  $Bill->PackageName = $req->PackageName;
  $Bill->PackageAmt = $req->PackageAmt;
  $Bill->BalanceAmt = $req->BalanceAmt;
  $Bill->SubTotal = $req->SubTotal;
  $Bill->Discount = $req->Discount;
  $Bill->GrossAmt = $req->GrossAmt;
  $Bill->BalAmt = $req->BalAmt;
  $Bill->PaidAmt = $req->PaidAmt;
  $Bill->PayMode = $req->PayMode;
  $Bill->Narration = $req->Narration;
  $Bill->OtId = $req->OtId;
  $Bill->DscId = $req->DscId;
  $Bill->CreatedBy =Session::get('UserId');;
  $Bill->save();       
  $BillId = $Bill->id;
  //BillModel::where('id', $BillId)->update(array('SrNo' => $BillId));
  
        
  $result = TempBillChargeModel::select()->where(['SessionId'=>$SessionId])->get();
  for($count = 0; $count < count($result); $count++)
  {
 $data = array(
  'BillNo' => $req->BillNo,
  'MrdNo' => $req->MrdNo,
  'IpdNo' => $req->IpdNo,
  'PackageName'=>$result[$count]['PackageName'],
  'PackageAmt'=>$result[$count]['PackageAmt'],
  'BalanceAmt'=>$result[$count]['BalanceAmt'],
  'Name'=>$result[$count]['Name'],
  'Amount'=>$result[$count]['Amount'],
  'Days'=>$result[$count]['Days'],
  'Rate'=>$result[$count]['Rate'],
  'Status'=>1,
  'CreatedBy' => 19,
 );
 $insert_data[] = $data; 
 }
 //return $insert_data;exit();
 DB::table('tbl_bill_charges')->insert($insert_data);
 DB::table('tbl_temp_bill_charges')->where(['SessionId'=>$SessionId])->delete();
 //return redirect('/ipdBillPrint/'.$BillId);


 $IpdReceipt = new IpdReceiptModel;
 $IpdReceipt->MrdNo = $req->MrdNo;
            $IpdReceipt->IpdNo = $req->IpdNo;
            $IpdReceipt->PatientName = $req->PatientName;
            $IpdReceipt->Procedures = $req->Diagnosis;
            $IpdReceipt->Amount = $req->GrossAmt;
            $IpdReceipt->PayMode = 'Cash';
            $IpdReceipt->ChequeNo = 0;
            $IpdReceipt->Narration = '';
            $IpdReceipt->AdmissionDate = $req->AdmissionDate;
            $IpdReceipt->AdmissionTime = NULL;
            $IpdReceipt->DepositDate = NULL;
            $IpdReceipt->DepositTime = NULL;
            $IpdReceipt->ChqDate = NULL;
            $IpdReceipt->ChqDep = NULL;
            $IpdReceipt->Status = 1;
            $IpdReceipt->CreatedBy = Session::get('UserId');;
            $IpdReceipt->CreatedDate = $req->BillDate;
            $IpdReceipt->ReceiptNo = $req->BillNo;
            $IpdReceipt->BankName = NULL;
            $IpdReceipt->BranchName = NULL;
            $IpdReceipt->AccountNo = NULL;
            $IpdReceipt->AccountHolder = NULL;
            $IpdReceipt->ConsellingId = $req->OtId;
            $IpdReceipt->save();
 return $BillId;
    }

    function fetchBillChargesRecord(Request $req){
        $result = TempBillChargeModel::select()->where(['id'=>$req->id])->first();
        echo json_encode($result);
    }

    function deleteBillChargesRecord(Request $req){
        $SessionId = Session::getId();
        $oldamount = TempBillChargeModel::where('id', $req->id)->value('Amount');

         $maxAmt = TempBillChargeModel::where('SessionId', $SessionId)
            ->orderBy('Amount', 'desc')
            ->first();
           $max_amt =  $maxAmt->Amount;
           $max_amt_id = $maxAmt->id;
           $oldamt = $oldamount;
            $balamt = $oldamt - $req->Amount;
            $totamt = $max_amt + $balamt;
DB::table('tbl_temp_bill_charges')->where(['id'=>$max_amt_id])->update(['Amount'=>$totamt,'Rate'=>$totamt]);
        TempBillChargeModel::where(['id'=>$req->id,'SessionId'=>$SessionId])->delete();
        return 1;
    }

    function deleteBillChargesRecord2(Request $req){
        DB::table('tbl_bill_charges')->where(['id'=>$req->id])->delete();
        return 1;
    }

    function getBillDetails(Request $req){
        $val = $req->id;
        $seperate = explode(" / ", $val);
        $BillNo = $seperate[0];
        $result = BillModel::select()->where('BillNo',$BillNo)->first();
        return json_encode($result);
    }
    function ipdBillPrint($id){
        //$result = BillModel::select()->where('id',$id)->first();
        $result = DB::table('tbl_bills as tbc')
        ->join('tbl_patients as tp', 'tp.MrdNo', '=', 'tbc.MrdNo')
        ->where(['tbc.id'=>$id])
        ->select('tbc.*','tp.Phone','tp.Address')->get();
        $BillNo = $result[0]->BillNo;

        $result2 = DB::table('tbl_bill_charges')->select()->where(['BillNo'=>$BillNo])->get();
        return view('/ipd/inc-bill-print',['data'=>$result,'BillNo'=>$BillNo,'data2'=>$result2]);
    }

    function getBillCharges(Request $req){
        $billno = $req->billno;
        $SessionId = Session::getId();
        DB::table('tbl_temp_bill_charges')->where(['SessionId'=>$SessionId])->delete();
        DB::select("INSERT INTO tbl_temp_bill_charges (SessionId,PackageName,PackageAmt,BalanceAmt,Name,Days,Rate,Amount,Status,CreatedBy)
        SELECT '$SessionId',PackageName,PackageAmt,BalanceAmt,Name,Days,Rate,Amount,Status,CreatedBy FROM `tbl_bill_charges` WHERE BillNo=$billno");
        $result2 = DB::table('tbl_temp_bill_charges')->select()->where(['SessionId'=>$SessionId])->get();
        return view('ipd/incipdbillchargeview',['data'=>$result2]);
    }

    function fetchBillChargesRecord2(Request $req){
        try {
            $result = DB::table('tbl_bill_charges')->select()->where(['id'=>$req->id])->first();
            if (!$result) {
                return response()->json(['error' => 'Charge record not found'], 404);
            }
            return response()->json($result);
        } catch (\Exception $e) {
            \Log::error('fetchBillChargesRecord2 Error: ' . $e->getMessage());
            return response()->json(['error' => 'Failed to fetch charge record: ' . $e->getMessage()], 500);
        }
    }

    function updateBillCharges(Request $req){
        if($req->action=='Save'){
            DB::table('tbl_bill_charges')->insert(['BillNo'=>$req->BillNo,'MrdNo'=>$req->MrdNo,'Name'=>$req->ChargesName,
            'Amount'=>$req->Amount,'Days'=>$req->Days,'Rate'=>$req->Rate,'Status'=>'1']);
            return 1;
        }
        else{
            DB::table('tbl_bill_charges')->where(['id'=>$req->id])->update(['Name'=>$req->ChargesName,
            'Amount'=>$req->Amount,'Days'=>$req->Days,'Rate'=>$req->Rate]);
            return 1;
        }
       
    }

    function totSumBills2(Request $req){
        $result = DB::table('tbl_bill_charges')->where(['BillNo'=>$req->BillNo])->sum('Amount');
        return $result;
    }

    function updateIpdBill(Request $req){
        DB::table('tbl_bills')->where(['id'=>$req->BillId])->update(['SubTotal'=>$req->SubTotal,
        'Discount'=>$req->Discount,'GrossAmt'=>$req->GrossAmt,'PaidAmt'=>$req->PaidAmt,
        'BalAmt'=>$req->BalAmt,'PayMode'=>$req->PayMode,'Narration'=>$req->Narration,'BillDate'=>$req->BillDate,
        'AdmissionDate'=>$req->AdmissionDate,'OperationDate'=>$req->OperationDate,'DischargeDate'=>$req->DischargeDate,
    'Consultant'=>$req->ConsultantId,'PatientName'=>$req->PatientName,'AgeGender'=>$req->AgeGender]);
        return 1;
    }

    function saveUpdateCharges(Request $req){
        TempBillChargeModel::where(['id'=>$req->id])->update(['Name'=>$req->name]);
        return 1;
    }

    function editBill($id){
        $consultantList = (new MasterController)->consultantList();
        $packagelist = (new PackageController)->packageList();
        $result = BillModel::where('BillNo',$id)->first();
        $SessionId = Session::getId();
        DB::table('tbl_temp_bill_charges')->where(['SessionId'=>$SessionId])->delete();
        DB::select("INSERT INTO tbl_temp_bill_charges (SessionId,PackageName,PackageAmt,BalanceAmt,Name,Days,Rate,Amount,Status,CreatedBy)
        SELECT '$SessionId',PackageName,PackageAmt,BalanceAmt,Name,Days,Rate,Amount,Status,CreatedBy FROM `tbl_bill_charges` WHERE BillNo=$id");
        $result2 = DB::table('tbl_temp_bill_charges')->select()->where(['SessionId'=>$SessionId])->get();
        return view('/ipd/edit-ipd-bill',['packagelist'=>$packagelist,'consultantList'=>$consultantList,'data'=>$result,'data2'=>$result2]);
    }
}