<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\ConsentModel;
use App\Models\OTModel;
use Session;

class ConsentController extends Controller
{
    function consent(){
        $result = ConsentModel::all();
        return view('/masters/view-consents',['data'=>$result]);
    }
    function editConsent($id){
        $result = ConsentModel::find($id);
        return view('/masters/edit-consent',['data'=>$result]);
    }

    function addConsent(){
        return view('/masters/add-consent');
    }

    function saveConsent(Request $req){
            if($req->action == 'Save'){
            $Consent = new ConsentModel;
            }
            else{
            $Consent = ConsentModel::find($req->saveid);
            }
            $Consent->Name=$req->Name;
            $Consent->Title=$req->Title;
            $Consent->Details=$req->Details;
            $Consent->Language=$req->Language;
            $Consent->Status=1;
            $Consent->save();
            return redirect('/addConsent')->with('msg', 'saved');
          
    }

    function deleteConsent(Request $req){
        ConsentModel::find($req->id)->delete();
        return 1;
    }

    function getConsentList(){
        $query = ConsentModel::orderBy('Name', 'asc')->get();
        return $query;
    }

    function consentPrint($id,$consentid){
        $result = ConsentModel::where('id',$consentid)->first();
        $result2 = OTModel::select()->where('id',$id)->first();
        $consid = $result2->SurgeonName;
        $DocName = $this->getFullSurgeonName($consid);
        if($result->Language == 'Hindi'){
        return view('/ipd/consent-print-hindi',['data'=>$result,'data2'=>$result2,'DocName'=>$DocName]);
        }
        else{
            return view('/ipd/consent-print-marathi',['data'=>$result,'data2'=>$result2,'DocName'=>$DocName]);  
        }
       
    }


    function getFullSurgeonName($id){
        $result = DB::table('tbl_users')->select('Name')->where('id',$id)->first();
        if($id==''){
            $Name = "";
        }
        else{
           $Name = strtoupper(strtolower($result->Name));
        }
        return $Name;
    }

    function getSurgeonName($id){
        $result = DB::table('tbl_users')->select('Username')->where('id',$id)->first();
        if($id==''){
            $Name = "";
        }
        else{
           $Name = strtoupper(strtolower($result->Username));
        }
        return $Name;
    }
   
    function ipdPaper($id){
        //$result = OTModel::select()->where('id',$id)->first();
        $result =  DB::table('tbl_ot_notes as tn')
        ->leftJoin('tbl_users as tu', 'tn.SurgeonName', '=', 'tu.id')
        ->select('tn.*', 'tu.Name AS Surgeon_Name')
        ->where('tn.id',$id)
        ->first();
        return view('/ipd/ot-ipd-paper',['data'=>$result]);  
    }
   
}
