<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\GeneralReceiptModel;
use App\Http\Controllers\MasterController;
use App\Models\ProcedureModel;
use App\Models\UserMaster;
use Session;

class GeneralReceiptController extends Controller
{
    function GeneralReceipt(){
        $today = $this->todayGeneralReceipt();
        $total = $this->totalGeneralReceipt();
        $procedures = ProcedureModel::where('Type', 1)->get();
        $consultants = UserMaster::where('Type', 'Consultant')->get();
        $saveprocedures = DB::select("SELECT DISTINCT(`Procedure`) AS Procedures FROM tbl_general_receipts WHERE Status=1");
        
        return view('general-receipt/view-general-receipt', [
            'saveprocedures' => $saveprocedures,
            'today' => $today,
            'total' => $total,
            'procedures' => $procedures,
            'consultants' => $consultants
        ]);
    }

    function viewGeneralReceipts(Request $req){
        $CurrDate = date('Y-m-d');
        $Procedures = $req->SrchProcedures;
        $SrchPayMode = $req->SrchPayMode;
        
        if(!empty($req->FromDate)) {
            $sql = "SELECT tgr.*, tp.Phone FROM tbl_general_receipts tgr 
                    LEFT JOIN tbl_patients tp ON tp.MrdNo = tgr.MrdNo 
                    WHERE tgr.Status = 1 AND tgr.Date >= '$req->FromDate' AND tgr.Date <= '$req->ToDate'";
            
            if($Procedures != '') {
                $sql .= " AND tgr.`Procedure` = '$Procedures'";
            }
            if($SrchPayMode != '') {
                $sql .= " AND tgr.PayMode = '$SrchPayMode'";
            }
            $sql .= " ORDER BY tgr.id DESC";
            $result = DB::select($sql);

            $sql2 = "SELECT SUM(Amount) AS Amount FROM tbl_general_receipts 
                     WHERE Status = 1 AND Date >= '$req->FromDate' AND Date <= '$req->ToDate'";
            if($Procedures != '') {
                $sql2 .= " AND `Procedure` = '$Procedures'";
            }
            if($SrchPayMode != '') {
                $sql2 .= " AND PayMode = '$SrchPayMode'";
            }
            $result2 = DB::select($sql2);
            $total = $result2[0]->Amount ? $result2[0]->Amount : 0;
        } else {
            $result = GeneralReceiptModel::where('Date', $CurrDate)->orderBy('id', 'desc')->get();
            $total = $result->sum('Amount');
        }

        return view('general-receipt/inc-general-receipt-list', ['data' => $result, 'total' => $total]);
    }

    function fetchGeneralReceiptRecord(Request $req){
        $result = GeneralReceiptModel::find($req->id);
        echo json_encode($result);
    }

    function deleteGeneralReceipt(Request $req){
        GeneralReceiptModel::where(['id' => $req->id])->update(['Status' => 0]);
        $today = $this->todayGeneralReceipt();
        $total = $this->totalGeneralReceipt();
        echo json_encode(array('status' => '1', 'today' => $today, 'total' => $total)); 
    }

    function saveGeneralReceipt(Request $req){
        $CurrDate = date('Y-m-d');
        
        if($req->action == 'Save') {
            $GeneralReceipt = new GeneralReceiptModel;
            $GeneralReceipt->CreatedBy = Session::get('UserId') ? Session::get('UserId') : 19;
            $GeneralReceipt->CreatedDate = $CurrDate;
            $GeneralReceipt->ReceiptNo = $this->getGeneralReceiptNo();
        } else {
            $GeneralReceipt = GeneralReceiptModel::find($req->id);
            $GeneralReceipt->ModifiedBy = Session::get('UserId') ? Session::get('UserId') : 19;
            $GeneralReceipt->ModifiedDate = $CurrDate;
        }

        $GeneralReceipt->Date = $req->Date ? $req->Date : $CurrDate;
        $GeneralReceipt->MrdNo = $req->MrdNo ? $req->MrdNo : null;
        $GeneralReceipt->IpdNo = $req->IpdNo ? $req->IpdNo : null;
        $GeneralReceipt->UhidNo = $req->UhidNo ? $req->UhidNo : null;
        $GeneralReceipt->PatientName = $req->PatientName ? $req->PatientName : null;
        $GeneralReceipt->Procedure = $req->Procedure ? $req->Procedure : 'GENERAL';
        $GeneralReceipt->TotalNo = $req->TotalNo ? $req->TotalNo : null;
        $GeneralReceipt->ConsultantId = $req->ConsultantId ? $req->ConsultantId : null;
        $GeneralReceipt->Consultant = $req->Consultant ? $req->Consultant : null;
        $GeneralReceipt->Amount = $req->Amount ? $req->Amount : 0;
        $GeneralReceipt->PayMode = $req->PayMode ? $req->PayMode : 'Cash';
        $GeneralReceipt->Status = 1;
        
        $GeneralReceipt->save();
        $postid = $GeneralReceipt->id;
        $today = $this->todayGeneralReceipt();
        $total = $this->totalGeneralReceipt();
        
        return json_encode(array('status' => 1, 'today' => $today, 'total' => $total, 'id' => $postid));
    }

    function todayGeneralReceipt(){
        $CurrDate = date('Y-m-d');
        $rncnt = GeneralReceiptModel::where(['Date' => $CurrDate, 'Status' => 1])->count();
        return $rncnt;
    }

    function totalGeneralReceipt(){
        $rncnt = GeneralReceiptModel::where('Status', 1)->count();
        return $rncnt;
    }

    function getGeneralReceiptNo(){
        $maxReceiptNo = GeneralReceiptModel::max('ReceiptNo');
        $receiptNo = ($maxReceiptNo) ? $maxReceiptNo + 1 : 1;
        return $receiptNo;
    }

    function getGeneralReceiptNoAjax(Request $req){
        $receiptNo = $this->getGeneralReceiptNo();
        return response()->json(['receipt_no' => $receiptNo]);
    }

    function generalReceiptPrint($id){
        $result = GeneralReceiptModel::where('id', $id)->first();
        return view('general-receipt/general-receipt-print', ['result' => $result]);
    }
}
