<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\InvestigationModel;
use App\Models\InvestigationModel2;
use App\Models\ConsultantModel;
use Session;

class InvestigationController extends Controller
{
    function InvestigationList(){
        return view('/investigation/view-investigations');
    }
    
    function viewInvestigationPatientList(Request $req){
//return $req->ToDate;
        try {
            $result = InvestigationModel2::select()
                    ->whereBetween('VisitDate', [$req->FromDate, $req->ToDate])
                    ->where('InvStName', '!=', '')
                    ->get();
   // return $result;
            return view('/investigation/inc-investigation-patient-lists', ['data' => $result]);
        } catch (\Exception $e) {
            // Log or dd the error
            dd($e->getMessage());
        }
    }
    

    function getInvstPtDetails(Request $req){
        $id = $req->id;
        $result2 = InvestigationModel::select()->where('InvId',$id)->get();
        $rnrcnt = $result2->count();
        if($rnrcnt > 0){
            return json_encode(array('id'=>$result2[0]->InvId,'MrdNo'=>$result2[0]->MrdNo
            ,'PatientName'=>$result2[0]->PatientName,'InvStName'=>$result2[0]->Procedures,
            'Amount'=>$result2[0]->Amount,'PayMode'=>$result2[0]->PayMode,
            'Narration'=>$result2[0]->Narration,'action'=>'EditInv'
        ));
        }
        else{
        $result = InvestigationModel2::find($id);
        return json_encode(array('id'=>$result['id'],'MrdNo'=>$result['MrdNo']
        ,'PatientName'=>$result['PatientName'],'InvStName'=>$result['InvStName'],
        'Amount'=>$result['Amount'],'action'=>'Save'
    ));
        }
      
    }

    function checkoutInvst(Request $req){
        $userid =  Session::get('UserId');
        InvestigationModel2::where(['id'=>$req->id])->update(['InvCheckout'=>1,'InvCheckoutBy'=>$userid]);
        return 1;
    }

    function addInvestigation(){
        return view('/investigation/add-investigations');
    }

    function saveInvestigations(Request $req){
        if($req->action == 'Save'){
            $Data = new InvestigationModel2;
            $Data->CreatedDate = Date('Y-m-d');
            $Data->CreatedBy = Session::get('UserId');
            $Data->ModifiedBy = 0;
            $Data->InvCheckout=0;
            }
            else{
            $Data = InvestigationModel2::find($req->id);
            $Data->ModifiedBy = Session::get('UserId');
            $Data->ModifiedDate = Date('Y-m-d');
            }
            $Data->MrdNo=$req->MrdNo;
            $Data->PatientName=$req->PatientName;
            $Data->VisitNo=0;
            $Data->InvMoneyReceived=0;
            $Data->Phone = $req->Phone;
            $Data->VisitDate=$req->VisitDate;
            $Data->InvStName=$req->InvStName;
            $Data->Amount=$req->Amount;
            $Data->save();
            $AppointId = $Data->id;
            return json_encode(array('id'=>$AppointId,'Status'=>1));
    }

    function updateInvestigation(Request $req){
        $Data = InvestigationModel2::find($req->id);
        $Data->ModifiedBy = Session::get('UserId');
            $Data->ModifiedDate = Date('Y-m-d');
            $Data->VisitDate=$req->UpCreatedDate;
            $Data->InvStName=$req->UpProcedures;
            $Data->Amount=$req->UpAmount;
            $Data->InvCheckout=$req->UpInvCheckout;
            $Data->InvMoneyReceived=$req->UpInvMoneyReceived;
            $Data->save();
            return 1;
    }

    function deleteInvstRecord(Request $req){
        InvestigationModel2::find($req->id)->delete();
        return 1;
    }
}

?>