<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\IpdInvestigationModel;
use Session;

class IpdInvestigationController extends Controller
{
    function ipdInvestigationMaster(){
        return view('ipd/ipd-investigation-master');
    }

    function ipdInvestigationList(){
        $query = IpdInvestigationModel::where('Status', 1)->orderBy('TestId', 'asc')->get();
        $result = view('ipd/inc-ipd-investigation-list', ['investigations' => $query]);
        return $result;
    }

    function saveIpdInvestigation(Request $req){
        try {
            if($req->action == 'Save'){
                $Investigation = new IpdInvestigationModel;
                $Investigation->CreatedDate = date('Y-m-d');
                $Investigation->CreatedBy = Session::get('UserId') ? Session::get('UserId') : 19;
                $Investigation->ModifiedBy = 0;
            } else {
                $Investigation = IpdInvestigationModel::find($req->id);
                if(!$Investigation){
                    return response()->json(['error' => 'Investigation not found'], 404);
                }
                $Investigation->ModifiedBy = Session::get('UserId') ? Session::get('UserId') : 19;
                $Investigation->ModifiedDate = date('Y-m-d');
            }

            $Investigation->TestId = $req->TestId ? $req->TestId : null;
            $Investigation->TestName = $req->TestName ? $req->TestName : null;
            $Investigation->Unit = $req->Unit ? $req->Unit : null;
            $Investigation->Status = 1;
            
            $Investigation->save();
            
            return response()->json(['success' => true, 'id' => $Investigation->id, 'message' => 'IPD Investigation saved successfully']);
            
        } catch (\Exception $e) {
            \Log::error('IPD Investigation save error: ' . $e->getMessage());
            return response()->json(['error' => 'Failed to save IPD Investigation: ' . $e->getMessage()], 500);
        }
    }

    function getIpdInvestigation(Request $req){
        $data = IpdInvestigationModel::find($req->id);
        if($data){
            return response()->json($data);
        }
        return response()->json(['error' => 'Investigation not found'], 404);
    }

    function deleteIpdInvestigation(Request $req){
        try {
            $Investigation = IpdInvestigationModel::find($req->id);
            if($Investigation){
                $Investigation->Status = 0;
                $Investigation->ModifiedBy = Session::get('UserId') ? Session::get('UserId') : 19;
                $Investigation->ModifiedDate = date('Y-m-d');
                $Investigation->save();
                return response()->json(['success' => true, 'message' => 'Investigation deleted successfully']);
            }
            return response()->json(['error' => 'Investigation not found'], 404);
        } catch (\Exception $e) {
            \Log::error('IPD Investigation delete error: ' . $e->getMessage());
            return response()->json(['error' => 'Failed to delete Investigation: ' . $e->getMessage()], 500);
        }
    }

    function generateTestId(){
        $maxTestId = IpdInvestigationModel::max('TestId');
        $testId = ($maxTestId) ? $maxTestId + 1 : 1;
        return response()->json(['test_id' => $testId]);
    }

    function getInvestigationByTestId(Request $req){
        $testId = $req->testId;
        $data = IpdInvestigationModel::where('TestId', $testId)->where('Status', 1)->first();
        if($data){
            return response()->json($data);
        }
        return response()->json(['error' => 'Investigation not found'], 404);
    }
}
