<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\IpdReceiptModel;
use App\Http\Controllers\MasterController;
use App\Models\OTModel;
use App\Models\ProcedureModel;
use App\Models\DischargeModel;
use App\Models\DischargeOtherModel;
use App\Models\OTNoteOtherModel;
use Session;
class IpdReceiptController extends Controller
{
    function IpdReceipt(){
        $patientList = (new MasterController)->ipdPatientList();
        $today = $this->todayIpdReceipt();
        $total = $this->totalIpdReceipt();
        $procedures = ProcedureModel::where('Type',1)->get();
        return view('/ipd/view-ipd-receipt',['procedures'=>$procedures,'patientList'=>$patientList,'today'=>$today,'total'=>$total]);
    }

    function addIpdReceipt($mrdno,$otid){
        $procedures = ProcedureModel::where('Type',1)->get();
        $result = IpdReceiptModel::where('ConsellingId',$otid)->get();
        $cnt = $result->count();
        if($cnt > 0){
            $otresult = $result;
            $action = "Edit";
            $id = $otresult[0]->id;
            $receiptno = $otresult[0]->ReceiptNo;
            $ConsellingId = $otresult[0]->ConsellingId;
            $Procedures = $otresult[0]->Procedures;
        }
        else{
            $otresult = OTModel::where('id',$otid)->get();
            $action = "Save";
            $id = "";
            $receiptno = $this->getIpdReceiptNo();
            $ConsellingId = $otid;
            $Procedures = $otresult[0]->SurgeryName;
        }
        return view('/ipd/add-ipd-receipt',['Procedures'=>$Procedures,'ConsellingId'=>$ConsellingId,'receiptno'=>$receiptno,'procedures'=>$procedures,'otresult'=>$otresult,'id'=>$id,'action'=>$action]);
    }

   

    function addOtherIpdReceipt($mrdno,$otid){
        $otresult = OTNoteOtherModel::where('id',$otid)->first();
        $procedures = ProcedureModel::where('Type',1)->get();
        return view('/ipd/add-ipd-receipt',['procedures'=>$procedures,'otresult'=>$otresult]);
    }
    
    function viewIpdReceipts(Request $req){
        $CurrDate = date('Y-m-d');
        $SrchPayMode = $req->SrchPayMode;
        if(!empty($req->FromDate))
            {

                $sql = "SELECT *  From tbl_ipd_receipts WHERE Status=1 AND CreatedDate>='$req->FromDate' AND CreatedDate<='$req->ToDate'";
                if($SrchPayMode != ''){
                    $sql.= " AND PayMode = '$SrchPayMode'";
                }
                $result = DB::select($sql);

                $sql2 = "SELECT SUM(Amount) AS Amount  From tbl_ipd_receipts WHERE Status=1 AND CreatedDate>='$req->FromDate' AND CreatedDate<='$req->ToDate'";
                if($SrchPayMode != ''){
                    $sql2.= " AND PayMode = '$SrchPayMode'";
                }
                $result2 = DB::select($sql2);
                $total = $result2[0]->Amount;

            }
            else{
                $result =  IpdReceiptModel::select()->where(['CreatedDate'=>$CurrDate])->get();  
                $total = $result->sum('Amount');
            }
        return view('ipd/incipdreceipts',['data'=>$result,'total'=>$total]);
    }
    function fetchIpdReceiptRecord(Request $req){
        $result = IpdReceiptModel::find($req->id);
        echo json_encode($result);
    }

    function deleteIpdReceipt(Request $req){
        IpdReceiptModel::where(['id'=>$req->id])->delete();
        $today = $this->todayIpdReceipt();
        $total = $this->totalIpdReceipt();
        echo json_encode(array('status'=>'1','today'=>$today,'total'=>$total)); 
    }
    function saveIpdReceipt(Request $req){
            $CurrDate = date('Y-m-d');
            if($req->action == 'Save'){
            $IpdReceipt = new IpdReceiptModel;
            }
            else{
            $IpdReceipt = IpdReceiptModel::find($req->id);
            }
            $IpdReceipt->MrdNo = $req->MrdNo;
            $IpdReceipt->IpdNo = $req->IpdNo;
            $IpdReceipt->PatientName = $req->PatientName;
            $IpdReceipt->Procedures = $req->Procedures;
            $IpdReceipt->Amount = $req->Amount;
            $IpdReceipt->PayMode = $req->PayMode;
            $IpdReceipt->ChequeNo = $req->ChequeNo;
            $IpdReceipt->Narration = $req->Narration;
            $IpdReceipt->AdmissionDate = $req->AdmissionDate;
            $IpdReceipt->AdmissionTime = $req->AdmissionTime;
            $IpdReceipt->DepositDate = $req->DepositDate;
            $IpdReceipt->DepositTime = $req->DepositTime;
            $IpdReceipt->ChqDate = $req->ChqDate;
            $IpdReceipt->ChqDep = $req->ChqDep;
            $IpdReceipt->Status = 1;
            $IpdReceipt->CreatedBy = 19;
            $IpdReceipt->CreatedDate = $req->CreatedDate;
            $IpdReceipt->ReceiptNo = $req->ReceiptNo;
            $IpdReceipt->BankName = $req->BankName;
            $IpdReceipt->BranchName = $req->BranchName;
            $IpdReceipt->AccountNo = $req->AccountNo;
            $IpdReceipt->AccountHolder = $req->AccountHolder;
            $IpdReceipt->ConsellingId = $req->ConsellingId;
            $IpdReceipt->save();
            $postid = $IpdReceipt->id;
            $today = $this->todayIpdReceipt();
            $total = $this->totalIpdReceipt();
            return json_encode(array('status'=>1,'today'=>$today,'total'=>$total,'id'=>$postid));
    }

    function todayIpdReceipt(){
        $CurrDate = date('Y-m-d');
        $rncnt =  IpdReceiptModel::where(['CreatedDate'=>$CurrDate])->count();
        return $rncnt;
    }

    function totalIpdReceipt(){
        $rncnt =  IpdReceiptModel::count();
        return $rncnt;
    }

    function ipdReceiptPrint($id){
        $result =  IpdReceiptModel::select()->where('id',$id)->get();
        $ProcedureName = $result[0]->Procedures;
        return view('/ipd/ipd-receipt-print',['result'=>$result,'ProcedureName'=>$ProcedureName]);
    }

    function getIpdReceiptNo(){
        $maxid = IpdReceiptModel::select('id')->max('id');
        $curryr = substr(date('Y'), -2);
        $currmonth = date('m');
        if($maxid == 0 || $maxid == ''){
            $maxid = "CRV1/".($curryr)."-".($curryr+1)."/".$currmonth;
        }
        else{
            $maxid2 = $maxid + 1;
            $maxid = "CRV".$maxid2."/".($curryr)."-".($curryr+1)."/".$currmonth;
        }
        return $maxid;
       
    }
    
}