<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\MasterController;
use App\Models\OpdAppointmentModel;
use App\Models\UserMaster;
use App\Models\QueueManagement;
use App\Models\PatientModel;
use Illuminate\Support\Facades\Storage;
use App\Models\ConsultantTreatmentModel;
use App\Models\VisitModel;
use App\Models\OptoModel;
use App\Models\ConsultantModel;
use App\Models\TempQueueManagement;
use Illuminate\Support\Facades\DB;
use Session;
class OpdAppointmentController extends Controller
{
    function opdAppointment(){
        $patientList = (new MasterController)->patientList();
        $consultantList = (new MasterController)->consultantList();
        $cityList = (new MasterController)->cityList();
        $stateList = (new MasterController)->stateList();
        return view('/opd/opd-appointment',['patientList'=>$patientList,'consultantList'=>$consultantList,'stateList'=>$stateList,'cityList'=>$cityList]);
    }

    function viewOpdAppointmentList(Request $req){
        $CurrDate = date('Y-m-d');
        if(!empty($req->FromDate))
            {
                $result =  OpdAppointmentModel::select()
                            ->whereBetween('AppointDate', array($req->FromDate, $req->ToDate))->get();  
            }
            else{
        $result = OpdAppointmentModel::select()->where(['AppointDate'=>$CurrDate])->get();
            }
        //return $result;
        return view('opd/viewopdappointmentlists',['data'=>$result]);
    }

    function saveAppointment(Request $req){
            if($req->action == 'EditAppointment'){
                $OpdAppointment = OpdAppointmentModel::find($req->id);
            }
            else{
                $OpdAppointment = new OpdAppointmentModel;   
            }
            if($req->MrdNo == ''){
                $MrdNo = 0;
            }
            else{
                $MrdNo = $req->MrdNo;
            }
            $OpdAppointment->MrdNo = $MrdNo;
            $OpdAppointment->Suffix = $req->Suffix;
            $OpdAppointment->Fname = $req->Fname;
            $OpdAppointment->Mname = $req->Mname;
            $OpdAppointment->Lname = $req->Lname;
            $OpdAppointment->Gender = $req->Gender;
            $OpdAppointment->Age = $req->Age;
            $OpdAppointment->Phone = $req->Phone;
            $OpdAppointment->City = $req->City;
            $OpdAppointment->State = $req->State;
            $OpdAppointment->Address = $req->Address;
            $OpdAppointment->Consultant = $req->Consultant;
            //$result = UserMaster::select('Name')->where('id',$req->Consultant)->first();
            //$ConsultantName = $result->Name;
            //$OpdAppointment->ConsultantName = $ConsultantName;
            $OpdAppointment->Fees = $req->Fees;
            $OpdAppointment->PayMode = $req->PayMode;
            $OpdAppointment->AppointDate = $req->AppointDate;
            $OpdAppointment->AppointTime = $req->AppointTime;
            $OpdAppointment->CreatedBy = 19;
            $OpdAppointment->CreatedDate = date('Y-m-d');
            $OpdAppointment->Flag = 0;
            $OpdAppointment->PatientName = $req->Suffix." ".$req->Fname." ".$req->Mname." ".$req->Lname;
            $OpdAppointment->save();
            return 1;
    }

    function addInQueue(Request $req){
        $id = $req->id;
        OpdAppointmentModel::where('id',$id)->update(['Flag'=>1]);
        $result = OpdAppointmentModel::find($req->id);
        //return $result->MrdNo;
                if($result->MrdNo == 0){
            $Patient = new PatientModel;   
            $Patient->srno = 0;
            $Patient->Suffix = $result->Suffix;
            $Patient->Fname = $result->Fname;
            $Patient->Mname = $result->Mname;
            $Patient->Lname = $result->Lname;
            $Patient->Gender = $result->Gender;
            $Patient->Age = $result->Age;
            $Patient->Phone = $result->Phone;
            $Patient->City = $result->City;
            $Patient->State = $result->State;
            $Patient->Address = $result->Address;
            //$Patient->Consultant = $result->Consultant;
            //$result2 = UserMaster::select('Name')->where('id',$result->Consultant)->first();
            //$ConsultantName = $result2->Name;
          //  $Patient->ConsultantName = $ConsultantName;
            $Patient->Fees = $result->Fees;
            $Patient->PayMode = $result->PayMode;
            $Patient->Status = 1;
            $Patient->CreatedBy = 19;
            $Patient->ModifiedBy = 19;
            $Patient->CreatedDate = date('Y-m-d');
            $Patient->PatientName = $result->Suffix." ".$result->Fname." ".$result->Mname." ".$result->Lname;
            $Patient->save();
            $id = $Patient->id;
            $MrdNo = (PatientModel::max('MrdNo') ?? 0) + 1;
            PatientModel::where('id',$id)->update(array('MrdNo'=>$MrdNo,'srno'=>$MrdNo)); 
            $PatientType = "New";
        }
        else{
            $MrdNo = $result->MrdNo;
            $PatientType = "Old";
        }
        
        $OutTime = date('H:i:s');
        QueueManagement::where(['MrdNo'=>$MrdNo])->update(['Checked'=>1,'OutTime'=>$OutTime]);
        $QueueManagement = new QueueManagement;
        $QueueManagement->MrdNo = $MrdNo;
        $QueueManagement->PatientName = $result->Fname." ".$result->Mname." ".$result->Lname;
        $QueueManagement->PatientType = $PatientType;
        $QueueManagement->Age = $result->Age;
        $QueueManagement->Gender = $result->Gender;
        $QueueManagement->InDate = $result->AppointDate;
        $QueueManagement->InTime = $result->AppointTime;
        // $QueueManagement->Consultant = $result->Consultant;
        // $result2 = UserMaster::select('Name')->where('id',$result->Consultant)->first();
        // $ConsultantName = $result2->Name;
        // $QueueManagement->ConsultantName = $ConsultantName;
        $QueueManagement->Amount = $result->Fees;
        $QueueManagement->PayMode = $result->PayMode;
        $QueueManagement->Status = 1;
        $QueueManagement->Appointment = 1;
        $QueueManagement->CreatedBy = 19;
        $QueueManagement->ModifiedBy = 19;
        //$maxid = QueueManagement::select()->where(['MrdNo'=>$result->MrdNo])->max('VisitNo');
        //$VisitNo = $maxid+1;
        //$QueueManagement->VisitNo = $VisitNo;
        $QueueManagement->save();
        $qid = $QueueManagement->id;
        $sql = "INSERT INTO tbl_queue_managements_temp SELECT * FROM tbl_queue_managements WHERE id='$qid'";
        DB::select($sql);
        //return $QueueManagement->id;
        OpdAppointmentModel::where('id',$id)->update(['MrdNo'=>$MrdNo]);
        
        $FolderName = $MrdNo;
        $patient_result = PatientModel::select()->where(['MrdNo'=>$MrdNo])->first();
        $patient_data = json_encode(array('items' => $patient_result));
        Storage::disk('local')->put($FolderName."/patient_details.txt", $patient_data);
        
        $visitList = (new MasterController)->getPatientVisit($MrdNo);
        //return $visitList;
        foreach($visitList as $visit){
        $FolderName = $MrdNo;
        $FolderName2 = $visit->VisitDate;
        $opto = "opto.txt";
        $consultant = "consultant.txt";
        $consultant_treatment = "consultant_treatment.txt";
        if(Storage::disk('local')->exists($FolderName."/".$FolderName2)) {
            //echo "exit";
        }
        else{
        $queue_result = QueueManagement::select()->where(['MrdNo'=>$MrdNo,'InDate'=>$visit->VisitDate])->first();
        //return $queue_result
        $opto_result = OptoModel::select()->where(['MrdNo'=>$MrdNo,'VisitDate'=>$visit->VisitDate])->first();
        $consult_result = ConsultantModel::select()->where(['MrdNo'=>$MrdNo,'VisitDate'=>$visit->VisitDate])->first();
        $consulttreat_result = ConsultantTreatmentModel::select()->where(['MrdNo'=>$MrdNo,'VisitDate'=>$visit->VisitDate])->first();
        //echo $FolderName2;
        $queue_data = json_encode(array('items' => $queue_result));
        $opto_data = json_encode(array('items' => $opto_result));
        $consult_data = json_encode(array('items' => $consult_result));
        $consulttreat_data = json_encode(array('items' => $consulttreat_result));
        
         Storage::disk('local')->put($FolderName."/".$FolderName2."/queue.txt", $queue_data);
         Storage::disk('local')->put($FolderName."/".$FolderName2."/".$opto, $opto_data);
         Storage::disk('local')->put($FolderName."/".$FolderName2."/".$consultant, $consult_data);
         Storage::disk('local')->put($FolderName."/".$FolderName2."/".$consultant_treatment, $consulttreat_data);
        }
        }

        $mrdno = $MrdNo;
        $visitdate = date('Y-m-d');
        $checkstatus = QueueManagement::select('Checked','VisitNo','InDate','PatientName')->where('id',$qid)->first();
        $PatientName = $checkstatus->PatientName;
        $check_status = $checkstatus->Checked;
        $visit_no = $checkstatus->VisitNo;
        //return $visit_no;
        if($visit_no == 0){
            $maxid = OptoModel::select()->where(['MrdNo'=>$mrdno])->max('VisitNo');
            $VisitNo = $maxid+1;
            QueueManagement::where(['id'=>$qid])->update(['VisitNo'=>$VisitNo]);
            TempQueueManagement::where(['id'=>$qid])->update(['VisitNo'=>$VisitNo]);
        }
        else if($visit_no != 0){
            $VisitNo = $checkstatus->VisitNo;
        }
        else{
        $result = OptoModel::select()->where(['MrdNo'=>$mrdno,'Checked'=>0,'VisitDate'=>$visitdate])->get();
        $cnt = $result->count();
        if($cnt > 0){
            $VisitNo = $result[0]->VisitNo;
        }
        else{
            $maxid = OptoModel::select()->where(['MrdNo'=>$mrdno])->max('VisitNo');
            $VisitNo = $maxid+1;
            QueueManagement::where(['id'=>$qid])->update(['VisitNo'=>$VisitNo]);
            TempQueueManagement::where(['id'=>$qid])->update(['VisitNo'=>$VisitNo]);
        }
        }

        $CurrDate = date('Y-m-d');
        $FolderName = $mrdno;
        $FolderName2 = $CurrDate;
        $opto = "opto.txt";
        $consultant = "consultant.txt";
        $consultant_treatment = "consultant_treatment.txt";
        if(Storage::disk('local')->exists($FolderName."/".$FolderName2)) {}
        else{
            $Visit = new VisitModel;
            $Visit->MrdNo = $mrdno;
            $Visit->PatientName = $PatientName;
            $Visit->VisitDate = $visitdate;
            $Visit->VisitNo = $VisitNo;
            $Visit->save();
            $VisitPostId = $Visit->id;

            $OptoModel = new OptoModel;
            $OptoModel->MrdNo = $mrdno; $OptoModel->VisitNo = $VisitNo;
            $OptoModel->VisitDate = $visitdate; $OptoModel->PatientName = $PatientName;
            $OptoModel->AllergyHistory = 'No history of allergy';
            $OptoModel->CreatedBy = 19;
            $OptoModel->ModifiedBy = 19;
            $OptoModel->save();
            $OptoPostId = $OptoModel->id;

            $ConsultantModel = new ConsultantModel;
            $ConsultantModel->MrdNo = $mrdno; $ConsultantModel->VisitNo = $VisitNo;
            $ConsultantModel->VisitDate = $visitdate; $ConsultantModel->PatientName = $PatientName;
            $ConsultantModel->CreatedBy = 19;
            $ConsultantModel->ModifiedBy = 19;
            $ConsultantModel->save();
            $ConsultantPostId = $ConsultantModel->id;

            $ConsultantTreatmentModel = new ConsultantTreatmentModel;
            $ConsultantTreatmentModel->MrdNo = $mrdno; $ConsultantTreatmentModel->VisitNo = $VisitNo;
            $ConsultantTreatmentModel->VisitDate = $visitdate;
            $ConsultantTreatmentModel->save();
            $ConsultantTreatmentPostId = $ConsultantTreatmentModel->id;
            
            $opto_result = OptoModel::select()->where(['id'=>$OptoPostId])->first();    
            $opto_data = json_encode(array('items' => $opto_result));

            $consult_result = ConsultantModel::select()->where(['id'=>$ConsultantPostId])->first();
            $consult_data = json_encode(array('items' => $consult_result));
            
            $consulttreat_result = ConsultantTreatmentModel::select()->where(['id'=>$ConsultantTreatmentPostId])->first();
            $consulttreat_data = json_encode(array('items' => $consulttreat_result));

            $queue_result = QueueManagement::select()->where(['MrdNo'=>$mrdno,'InDate'=>$visitdate])->first();
            $queue_data = json_encode(array('items' => $queue_result));
            Storage::disk('local')->put($FolderName."/".$FolderName2."/queue.txt", $queue_data);
            Storage::disk('local')->put($FolderName."/".$FolderName2."/".$opto, $opto_data);
            Storage::disk('local')->put($FolderName."/".$FolderName2."/".$consultant, $consult_data);
            Storage::disk('local')->put($FolderName."/".$FolderName2."/".$consultant_treatment, $consulttreat_data);

            
            }

            $visitList = (new MasterController)->getPatientVisit($mrdno);
            $visitdate_data = json_encode(array('items' => $visitList));
            Storage::disk('local')->put($FolderName."/visitlist.txt", $visitdate_data);

        
    }

    function checkTime($appdate,$apptime){
        $cnt = OpdAppointmentModel::where(['AppointDate'=>$appdate,'AppointTime'=>$apptime])->count();
        return $cnt;
    }

    function getAppTime(Request $req){
        $AppointDate = $req->CurrDate;
        $output = '';
        $output.='<option value="" disabled="" selected="">Select Appointment Time</option>';
         for($h=8; $h<20; $h++){
    for($i=0; $i<60; $i=$i+5){
      $time = date('h:i a',strtotime($h.':'.$i));
      $time2 = date('H:i:s',strtotime($h.':'.$i));
      $chktime = $this->checkTime($AppointDate,$time2);
      if($chktime > 0){} else{
        $output.='<option value="'.$time2.'">'.$time.'</option>';
}
}
}

$output.='<option value="08:00:00">08:00 pm</option>';
return $output;
}
}