<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\OtScheduledModel;
use App\Models\OtOtherScheduledModel;
use App\Http\Controllers\MasterController;
use App\Http\Controllers\PackageController;
use App\Models\MedicineModel;
use App\Models\PreOptTreatmentModel;
use Session;
class OtScheduledController extends Controller
{
   function OtScheduled(){
    $otschid = $this->getOtSchId();
    $ototherschid = $this->getOtOtherSchId();
    //$patientList = (new MasterController)->patientList();
    $packagelist = (new PackageController)->packageList();
    return view('/ipd/add-ot-scheduled',['packagelist'=>$packagelist,'otschid'=>$otschid,'ototherschid'=>$ototherschid]);
   }
   function getOtSchId(){
        $result = OtScheduledModel::select()->where('Roll',1)->orderBy('id','desc')->get();
        return $result;
   }
   function getOtOtherSchId(){
    $result = OtScheduledModel::select()->where('Roll',2)->orderBy('id','desc')->get();
    return $result;
}

   function saveOtScheduled(Request $req){
    if($req->action == 'Save'){
        $OtScheduled = new OtScheduledModel;
        $OtScheduled->CreatedBy = Session::get('UserId');
        $OtScheduled->CreatedDate = date('Y-m-d');
        }
        else{
        $OtScheduled = OtScheduledModel::find($req->id); 
        $OtScheduled->ModifiedBy = Session::get('UserId');
        $OtScheduled->ModifiedDate = date('Y-m-d');  
        }
        $OtScheduled->PatientId = $req->PatientId;
        $OtScheduled->MrdNo = $req->MrdNo;
        $OtScheduled->PatientName = $req->PatientName;
        $OtScheduled->ScheduleDate = $req->ScheduleDate;
        $OtScheduled->Phone = $req->Phone;
        $OtScheduled->Age = $req->Age;
        $OtScheduled->Address = $req->Address;
        $OtScheduled->Gender = $req->Gender;
        $OtScheduled->Eye = $req->Eye;
        $OtScheduled->K1Re = $req->K1Re;
        $OtScheduled->K1Le = $req->K1Le;
        $OtScheduled->K2Re = $req->K2Re;
        $OtScheduled->K2Le = $req->K2Le;
        $OtScheduled->Diff = $req->Diff;
        $OtScheduled->Category = $req->Category;
        $OtScheduled->IolPower = $req->IolPower;
        $OtScheduled->Aconstant = $req->Aconstant;
        $OtScheduled->Diagnosis = $req->Diagnosis;
        $OtScheduled->Ga = $req->Ga;
        $OtScheduled->Amount = $req->Amount;
        $OtScheduled->Bs = $req->Bs;
        $OtScheduled->Us = $req->Us;
        $OtScheduled->Bp = $req->Bp;
        $OtScheduled->Package = $req->Package;
        $OtScheduled->IopRe = $req->IopRe;
        $OtScheduled->IopLe = $req->IopLe;
        $OtScheduled->Advice = $req->Advice;
        $OtScheduled->PkgAmt = $req->PkgAmt;
        $OtScheduled->InsComp = $req->InsComp;
        $OtScheduled->ReqAmt = $req->ReqAmt;
        $OtScheduled->SanctAmt = $req->SanctAmt;
        $OtScheduled->AddAmt = $req->AddAmt;
        $OtScheduled->SettleAmt = $req->SettleAmt;
        $OtScheduled->SettleDate = $req->SettleDate;
        $OtScheduled->UtrNo = $req->UtrNo;
        $OtScheduled->AL = $req->AL;
        $OtScheduled->Acd = $req->Acd;
        $OtScheduled->Consultant = $req->Consultant;
        $OtScheduled->IolType = $req->IolType;
        $OtScheduled->Cyl = $req->Cyl;
        $OtScheduled->LT = $req->LT;
        $OtScheduled->Wtw = $req->Wtw;
        $OtScheduled->IolName = $req->IolName;
        $OtScheduled->AddIol = $req->AddIol;
        $OtScheduled->Language = $req->Language;
        $OtScheduled->Roll = 1;
        if($req->PostPone == 1){
        $OtScheduled->PostPone = 1;
        }
        else{
          $OtScheduled->PostPone = 0;
        }
       
        $OtScheduled->Status = 1;
        if($req->Tab1 == 1){
          $OtScheduled->Tab1 = 1;
          }
          else{
            $OtScheduled->Tab1 = 0;
          }

          if($req->Tab2 == 1){
            $OtScheduled->Tab2 = 1;
            }
            else{
              $OtScheduled->Tab2 = 0;
            }

            if($req->Cataract == 1){
              $OtScheduled->Cataract = 1;
              }
              else{
                $OtScheduled->Cataract = 0;
              }

              $OtScheduled->SmsAdvice = $req->SmsAdvice;
        $cnt = DB::table('tbl_fixed_date')->where('FixedDate',$req->ScheduleDate)->count();
        if($cnt > 0){
        return 0;
        }
        else{
          $OtScheduled->save();
          if($req->SmsAdvice!=''){
            $youtubelink = "https://www.youtube.com/@vyawaharenetralayaamravati4958/videos";
            //$youtubelink = "";
          $msg = "Dear ".$req->PatientName." your appointment for ".$req->SmsAdvice." is on ".date("d/m/Y", strtotime(str_replace('-', '/',$req->ScheduleDate)));
          $msg.= " at 08:00 AM  Vyawahare Netralaya Amravati. For Any Qurey please Call 9370109617,9552731024%0a%0a".$youtubelink."";
          $sms_text = strip_tags($msg);
          $api_url = "https://smswaapi.in/api/send?number=91".$req->Phone."&type=text&message=".$sms_text."&instance_id=64B0F93ED3A13&access_token=649d339dbf9f2";
          $response = file_get_contents( $api_url);
          }
        return 1;
        }
        

   }


   function saveOtOtherScheduled(Request $req){
    if($req->action == 'Save'){
        $OtScheduled = new OtScheduledModel;
        $OtScheduled->CreatedBy = Session::get('UserId');
        $OtScheduled->CreatedDate = date('Y-m-d');
        }
        else{
        $OtScheduled = OtScheduledModel::find($req->id); 
        $OtScheduled->ModifiedBy = Session::get('UserId');
        $OtScheduled->ModifiedDate = date('Y-m-d');  
        }
        $OtScheduled->PatientId = $req->PatientId;
        $OtScheduled->MrdNo = $req->MrdNo;
        $OtScheduled->PatientName = $req->PatientName;
        $OtScheduled->ScheduleDate = $req->ScheduleDate;
        $OtScheduled->Phone = $req->Phone;
        $OtScheduled->Age = $req->Age;
        $OtScheduled->Address = $req->Address;
        $OtScheduled->Gender = $req->Gender;
        $OtScheduled->Eye = $req->Eye;
        $OtScheduled->K1Re = $req->K1Re;
        $OtScheduled->K1Le = $req->K1Le;
        $OtScheduled->K2Re = $req->K2Re;
        $OtScheduled->K2Le = $req->K2Le;
        $OtScheduled->Diff = $req->Diff;
        $OtScheduled->Category = $req->Category;
        $OtScheduled->IolPower = $req->IolPower;
        $OtScheduled->Aconstant = $req->Aconstant;
        $OtScheduled->Diagnosis = $req->Diagnosis;
        $OtScheduled->Ga = $req->Ga;
        $OtScheduled->Amount = $req->Amount;
        $OtScheduled->Bs = $req->Bs;
        $OtScheduled->Us = $req->Us;
        $OtScheduled->Bp = $req->Bp;
        $OtScheduled->Package = $req->Package;
        $OtScheduled->IopRe = $req->IopRe;
        $OtScheduled->IopLe = $req->IopLe;
        $OtScheduled->Advice = $req->Advice;
        $OtScheduled->PkgAmt = $req->PkgAmt;
        $OtScheduled->InsComp = $req->InsComp;
        $OtScheduled->ReqAmt = $req->ReqAmt;
        $OtScheduled->SanctAmt = $req->SanctAmt;
        $OtScheduled->AddAmt = $req->AddAmt;
        $OtScheduled->SettleAmt = $req->SettleAmt;
        $OtScheduled->SettleDate = $req->SettleDate;
        $OtScheduled->UtrNo = $req->UtrNo;
        $OtScheduled->AL = $req->AL;
        $OtScheduled->Acd = $req->Acd;
        $OtScheduled->Consultant = $req->Consultant;
        $OtScheduled->IolType = $req->IolType;
        $OtScheduled->Cyl = $req->Cyl;
        $OtScheduled->LT = $req->LT;
        $OtScheduled->Wtw = $req->Wtw;
        $OtScheduled->IolName = $req->IolName;
        $OtScheduled->AddIol = $req->AddIol;
        $OtScheduled->Language = $req->Language;
        $OtScheduled->Roll = 2;
        if($req->PostPone == 1){
        $OtScheduled->PostPone = 1;
        }
        else{
          $OtScheduled->PostPone = 0;
        }
       
        $OtScheduled->Status = 1;
        if($req->Tab1 == 1){
          $OtScheduled->Tab1 = 1;
          }
          else{
            $OtScheduled->Tab1 = 0;
          }

          if($req->Tab2 == 1){
            $OtScheduled->Tab2 = 1;
            }
            else{
              $OtScheduled->Tab2 = 0;
            }
            $OtScheduled->Cataract = 0;
            $OtScheduled->Status = 1;

            $OtScheduled->SmsAdvice = $req->SmsAdvice;
        $cnt = DB::table('tbl_fixed_date')->where('FixedDate',$req->ScheduleDate)->count();
        if($cnt > 0){
        return 0;
        }
        else{
          $OtScheduled->save();
          if($req->SmsAdvice!=''){
            $youtubelink = "https://www.youtube.com/@vyawaharenetralayaamravati4958/videos";
          $msg = "Dear ".$req->PatientName." your appointment for ".$req->SmsAdvice." is on ".date("d/m/Y", strtotime(str_replace('-', '/',$req->ScheduleDate)));
          $msg.= " at 08:00 AM Vyawahare Netralaya Amravati. For Any Qurey please Call 9370109617,9552731024%0a".$youtubelink."";
          $sms_text = strip_tags($msg);
          $api_url = "https://smswaapi.in/api/send?number=91".$req->Phone."&type=text&message=".$sms_text."&instance_id=64B0F93ED3A13&access_token=649d339dbf9f2";
          $response = file_get_contents( $api_url);
          }
        return 1;
        }
        

   }

   function getOtSchDetails(Request $req){
    $result = OtScheduledModel::where(['id'=>$req->id,'Roll'=>1])->orderBy('id','desc')->first(); 
    $cnt = OtScheduledModel::where(['id'=>$req->id,'Roll'=>1])->count(); 
    if($cnt > 0){
        return json_encode($result);
    }
    else{
        return 0;
    }
    
   }

   function getOtOtherSchDetails(Request $req){
    $result = OtScheduledModel::where(['id'=>$req->id,'Roll'=>2])->orderBy('id','desc')->first(); 
    $cnt = OtScheduledModel::where(['id'=>$req->id,'Roll'=>2])->count(); 
    if($cnt > 0){
        return json_encode($result);
    }
    else{
        return 0;
    }
    
   }

   

   function getMaxSchId(Request $req){
    // $result = DB::select("SELECT AUTO_INCREMENT FROM information_schema.TABLES WHERE TABLE_SCHEMA = 'vyawaharehosp' AND TABLE_NAME = 'tbl_otscheduled'");
    // $max_id = $result[0]->AUTO_INCREMENT;
    // return $max_id;
    $max_id = OtScheduledModel::max('id');
    $MaxId = $max_id+1;
    return $MaxId;
   }

   function getMaxSchId2(Request $req){
    $max_id = OtScheduledModel::max('id');
    $MaxId = $max_id+1;
    return $MaxId;
   }

   function viewOtScheduleList(Request $req){
        $ToDate = $req->ToDate;
        $FromDate = $req->FromDate;
        $result = OtScheduledModel::whereBetween('ScheduleDate', array($FromDate, $ToDate))->where('PostPone','0')->get();
        return view('/ipd/view-ot-scheduled',['data'=>$result]);
   }

   function otSchList($ScheduleDate){
    $result = OtScheduledModel::whereBetween('ScheduleDate', array($ScheduleDate, $ScheduleDate))->where(['PostPone'=>'0','Roll'=>1])->get();
    $cnt = $result->count();
    $result2 = OtScheduledModel::whereBetween('ScheduleDate', array($ScheduleDate, $ScheduleDate))->where(['PostPone'=>'0','Roll'=>2])->get();
    $cnt2 = $result2->count();
    //return $result2;
    return view('/ipd/view-ot-scheduled-lists',['cnt'=>$cnt,'cnt2'=>$cnt2,'data'=>$result,'data2'=>$result2,'ScheduleDate'=>$ScheduleDate]);
   }

   function deleteOtSchedule(Request $req){
    OtScheduledModel::find($req->id)->delete();
    return 1;
   }

   function preOptNotes($id){
    $result = OtScheduledModel::where('id',$id)->first();
    $ptsummary = PreOptTreatmentModel::where('PostId',$id)->get();

    $Treat_Name1 = (new OptoController)->convertMarathi($ptsummary[0]->TreatType1,$ptsummary[0]->TreatDose1,
    $ptsummary[0]->TreatFreq1,$ptsummary[0]->TreatDur1,$ptsummary[0]->TreatEye1);
$Treat_Name2 = (new OptoController)->convertMarathi($ptsummary[0]->TreatType2,$ptsummary[0]->TreatDose2,
    $ptsummary[0]->TreatFreq2,$ptsummary[0]->TreatDur2,$ptsummary[0]->TreatEye2);
$Treat_Name3 = (new OptoController)->convertMarathi($ptsummary[0]->TreatType3,$ptsummary[0]->TreatDose3,
    $ptsummary[0]->TreatFreq3,$ptsummary[0]->TreatDur3,$ptsummary[0]->TreatEye3);
$Treat_Name4 = (new OptoController)->convertMarathi($ptsummary[0]->TreatType4,$ptsummary[0]->TreatDose4,
    $ptsummary[0]->TreatFreq4,$ptsummary[0]->TreatDur4,$ptsummary[0]->TreatEye4);
$Treat_Name5 = (new OptoController)->convertMarathi($ptsummary[0]->TreatType5,$ptsummary[0]->TreatDose5,
    $ptsummary[0]->TreatFreq5,$ptsummary[0]->TreatDur5,$ptsummary[0]->TreatEye5);
$Treat_Name6 = (new OptoController)->convertMarathi($ptsummary[0]->TreatType6,$ptsummary[0]->TreatDose6,
    $ptsummary[0]->TreatFreq6,$ptsummary[0]->TreatDur6,$ptsummary[0]->TreatEye6);
$Treat_Name7 = (new OptoController)->convertMarathi($ptsummary[0]->TreatType7,$ptsummary[0]->TreatDose7,
    $ptsummary[0]->TreatFreq7,$ptsummary[0]->TreatDur7,$ptsummary[0]->TreatEye7);
$Treat_Name8 = (new OptoController)->convertMarathi($ptsummary[0]->TreatType8,$ptsummary[0]->TreatDose8,
    $ptsummary[0]->TreatFreq8,$ptsummary[0]->TreatDur8,$ptsummary[0]->TreatEye8);
$Treat_Name9 = (new OptoController)->convertMarathi($ptsummary[0]->TreatType9,$ptsummary[0]->TreatDose9,
    $ptsummary[0]->TreatFreq9,$ptsummary[0]->TreatDur9,$ptsummary[0]->TreatEye9);
$Treat_Name10 = (new OptoController)->convertMarathi($ptsummary[0]->TreatType10,$ptsummary[0]->TreatDose10,
    $ptsummary[0]->TreatFreq10,$ptsummary[0]->TreatDur10,$ptsummary[0]->TreatEye10);

    
    return view('/ipd/print-pre-operative-notes',['data'=>$result,'ptsummary'=>$ptsummary,'TreatName1'=>$Treat_Name1
    ,'TreatName2'=>$Treat_Name2,'TreatName3'=>$Treat_Name3,'TreatName4'=>$Treat_Name4
    ,'TreatName5'=>$Treat_Name5,'TreatName6'=>$Treat_Name6,'TreatName7'=>$Treat_Name7
    ,'TreatName8'=>$Treat_Name8,'TreatName9'=>$Treat_Name9,'TreatName10'=>$Treat_Name10]);
   }

   function preOptNotes2($id){
    $result = OtScheduledModel::where('id',$id)->first();
    return view('/ipd/print-pre-operative-notes-other',['data'=>$result]);
   }
   function printSurgicalPres($id){
     $result = DB::table('tbl_surgical_medicines as ts')
               ->leftJoin('tbl_otscheduled as tc', 'tc.id', '=', 'ts.OtSchId')
               ->leftJoin('tbl_medicines as tm', 'tm.id', '=', 'ts.MedId')
               ->select('ts.*','tc.*','tm.*')
               ->where('ts.OtSchId',$id)
               ->orderBy('ts.id','asc')->get();
               //return $result;
     $total = $result->sum('Amount');          
    return view('/ipd/print-surgical-pres',['data'=>$result,'total'=>$total]);
   }

   function printSurgicalPres2($id){
    $result = DB::table('tbl_surgical_medicines_other as ts')
              ->leftJoin('tbl_otscheduled as tc', 'tc.id', '=', 'ts.OtSchId')
              ->leftJoin('tbl_medicines as tm', 'tm.id', '=', 'ts.MedId')
              ->select('ts.*','tc.*','tm.*')
              ->where('ts.OtSchId',$id)
              ->orderBy('ts.id','asc')->get();
              //return $result;
    $total = $result->sum('Amount');          
   return view('/ipd/print-surgical-pres2',['data'=>$result,'total'=>$total]);
  }

   function fixedDate(Request $req){
      $FixedDate = $req->FixedDate;
      $data=array('FixedDate'=>$FixedDate);
      DB::table('tbl_fixed_date')->where('FixedDate',$FixedDate)->delete();
      $result = DB::table('tbl_fixed_date')->insert($data);
      echo 1;
   }

   function surgicalPrescLists(Request $req){
        $result = MedicineModel::all();
        return view('/ipd/incsurgicalpreslists',['data'=>$result]);
   }

   function surgicalPrescLists2(Request $req){
    $result = MedicineModel::all();
    return view('/ipd/incsurgicalpreslists2',['data'=>$result]);
}

   function saveSurgicalPres(Request $req){
    $ProcId = $req->ProcId;
    $OtSchId = $req->id;
    DB::table('tbl_surgical_medicines')->where('OtSchId',$req->id)->delete();
    $result = DB::select("INSERT INTO tbl_surgical_medicines (OtSchId,MedId,Amount) SELECT '$OtSchId',id,Amount FROM tbl_medicines WHERE id IN ($ProcId)");
    return 1;
   }

   function saveSurgicalPres2(Request $req){
    $ProcId = $req->ProcId;
    $OtSchId = $req->id;
    DB::table('tbl_surgical_medicines_other')->where('OtSchId',$req->id)->delete();
    $result = DB::select("INSERT INTO tbl_surgical_medicines_other (OtSchId,MedId,Amount) SELECT '$OtSchId',id,Amount FROM tbl_medicines WHERE id IN ($ProcId)");
    return 1;
   }

   function getSurgTotAmount(Request $req){
    $ProcId = $req->ProcId;
    $result = DB::select("SELECT SUM(Amount) As Amount FROM tbl_medicines WHERE id IN ($ProcId)");
    return $result[0]->Amount;
   }

 

   function viewOtSchedulePostPoneList(Request $req){
     $ToDate = $req->ToDate;
     $FromDate = $req->FromDate;
     $result = OtScheduledModel::where(['PostPone'=>'1','Roll'=>1])->get();
     //return $result;
     return view('/ipd/view-postpone-ot-scheduled',['data'=>$result]);
   }

   function viewOtSchedulePostPoneList2(Request $req){
    $ToDate = $req->ToDate;
    $FromDate = $req->FromDate;
    $result = OtScheduledModel::where(['PostPone'=>'1','Roll'=>2])->get();
    //return $result;
    return view('/ipd/view-postpone-ot-scheduled2',['data'=>$result]);
  }

   function updateOperationDate(Request $req){
     $OperationDate = $req->OperationDate;
     $number = count($req->chechvalue);
     if($number > 0)  
     {  
        for($i=0; $i<$number; $i++)  
          {  
            if(trim($req->chechvalue[$i] != '0'))  
              {
                    $otid = $req->otid[$i];
                    OtScheduledModel::where(['id'=>$otid])->update(['ScheduleDate'=>$OperationDate,'PostPone'=>0]);     
              }
          }
     }

     return 1;
   }

   function updateOperationDate2(Request $req){
    $OperationDate = $req->OperationDate;
    $number = count($req->chechvalue);
    if($number > 0)  
    {  
       for($i=0; $i<$number; $i++)  
         {  
           if(trim($req->chechvalue[$i] != '0'))  
             {
                   $otid = $req->otid[$i];
                   OtScheduledModel::where(['id'=>$otid])->update(['ScheduleDate'=>$OperationDate,'PostPone'=>0]);     
             }
         }
    }

    return 1;
  }

   function viewOtSchLists(){
    return view('/ipd/view-all-ot-scheduled-list');

   }

   function preOptNotesTreatments($id){
    $catstatusresult = OtScheduledModel::select('Cataract')->where(['id'=>$id])->first();
    $catstatus = $catstatusresult->Cataract;
    $drugList = (new MasterController)->drugList();
    $durationList = (new MasterController)->durationList();

    $cnt = PreOptTreatmentModel::select()->where(['PostId'=>$id])->count();
    if($cnt > 0){}
    else{
    $PreOptTreatments = new PreOptTreatmentModel;
    $PreOptTreatments->PostId = $id;
    $PreOptTreatments->SaveStatus = 0;
    $PreOptTreatments->save();
    }
    $data3 = PreOptTreatmentModel::select()->where(['PostId'=>$id])->get();
    return view('/ipd/pre-opt-notes-treatments',['catstatus'=>$catstatus,'data3'=>$data3,'id'=>$id,'durationList'=>$durationList,'drugList'=>$drugList]);
   }


   

   function savePreOptNotesTreatments(Request $req){
      $PreOptTreatments = PreOptTreatmentModel::firstWhere(['PostId'=>$req->id]);
    
       $PreOptTreatments->Treatment = $req->Treatment;
       $PreOptTreatments->TreatChk1 = $req->TreatChk1;$PreOptTreatments->TreatType1 = $req->TreatType1;
       $PreOptTreatments->TreatName1 = $req->TreatName1;$PreOptTreatments->TreatDose1 = $req->TreatDose1;
       $PreOptTreatments->TreatFreq1 = $req->TreatFreq1;$PreOptTreatments->TreatDur1 = $req->TreatDur1;
       $PreOptTreatments->TreatEye1 = $req->TreatEye1;

       $PreOptTreatments->TreatChk2 = $req->TreatChk2;$PreOptTreatments->TreatType2 = $req->TreatType2;
       $PreOptTreatments->TreatName2 = $req->TreatName2;$PreOptTreatments->TreatDose2 = $req->TreatDose2;
       $PreOptTreatments->TreatFreq2 = $req->TreatFreq2;$PreOptTreatments->TreatDur2 = $req->TreatDur2;
       $PreOptTreatments->TreatEye2 = $req->TreatEye2;

       $PreOptTreatments->TreatChk3 = $req->TreatChk3;$PreOptTreatments->TreatType3 = $req->TreatType3;
       $PreOptTreatments->TreatName3 = $req->TreatName3;$PreOptTreatments->TreatDose3 = $req->TreatDose3;
       $PreOptTreatments->TreatFreq3 = $req->TreatFreq3;$PreOptTreatments->TreatDur3 = $req->TreatDur3;
       $PreOptTreatments->TreatEye3 = $req->TreatEye3;

       $PreOptTreatments->TreatChk4 = $req->TreatChk4;$PreOptTreatments->TreatType4 = $req->TreatType4;
       $PreOptTreatments->TreatName4 = $req->TreatName4;$PreOptTreatments->TreatDose4 = $req->TreatDose4;
       $PreOptTreatments->TreatFreq4 = $req->TreatFreq4;$PreOptTreatments->TreatDur4 = $req->TreatDur4;
       $PreOptTreatments->TreatEye4 = $req->TreatEye4;

       $PreOptTreatments->TreatChk5 = $req->TreatChk5;$PreOptTreatments->TreatType5 = $req->TreatType5;
       $PreOptTreatments->TreatName5 = $req->TreatName5;$PreOptTreatments->TreatDose5 = $req->TreatDose5;
       $PreOptTreatments->TreatFreq5 = $req->TreatFreq5;$PreOptTreatments->TreatDur5 = $req->TreatDur5;
       $PreOptTreatments->TreatEye5 = $req->TreatEye5;

       $PreOptTreatments->TreatChk6 = $req->TreatChk6;$PreOptTreatments->TreatType6 = $req->TreatType6;
       $PreOptTreatments->TreatName6 = $req->TreatName6;$PreOptTreatments->TreatDose6 = $req->TreatDose6;
       $PreOptTreatments->TreatFreq6 = $req->TreatFreq6;$PreOptTreatments->TreatDur6 = $req->TreatDur6;
       $PreOptTreatments->TreatEye6 = $req->TreatEye6;

       $PreOptTreatments->TreatChk7 = $req->TreatChk7;$PreOptTreatments->TreatType7 = $req->TreatType7;
       $PreOptTreatments->TreatName7 = $req->TreatName7;$PreOptTreatments->TreatDose7 = $req->TreatDose7;
       $PreOptTreatments->TreatFreq7 = $req->TreatFreq7;$PreOptTreatments->TreatDur7 = $req->TreatDur7;
       $PreOptTreatments->TreatEye7 = $req->TreatEye7;

       $PreOptTreatments->TreatChk8 = $req->TreatChk8;$PreOptTreatments->TreatType8 = $req->TreatType8;
       $PreOptTreatments->TreatName8 = $req->TreatName8;$PreOptTreatments->TreatDose8 = $req->TreatDose8;
       $PreOptTreatments->TreatFreq8 = $req->TreatFreq8;$PreOptTreatments->TreatDur8 = $req->TreatDur8;
       $PreOptTreatments->TreatEye8 = $req->TreatEye8;

       $PreOptTreatments->TreatChk9 = $req->TreatChk9;$PreOptTreatments->TreatType9 = $req->TreatType9;
       $PreOptTreatments->TreatName9 = $req->TreatName9;$PreOptTreatments->TreatDose9 = $req->TreatDose9;
       $PreOptTreatments->TreatFreq9 = $req->TreatFreq9;$PreOptTreatments->TreatDur9 = $req->TreatDur9;
       $PreOptTreatments->TreatEye9 = $req->TreatEye9;

       $PreOptTreatments->TreatChk10 = $req->TreatChk10;$PreOptTreatments->TreatType10 = $req->TreatType10;
       $PreOptTreatments->TreatName10 = $req->TreatName10;$PreOptTreatments->TreatDose10 = $req->TreatDose10;
       $PreOptTreatments->TreatFreq10 = $req->TreatFreq10;$PreOptTreatments->TreatDur10 = $req->TreatDur10;
       $PreOptTreatments->TreatEye10 = $req->TreatEye10;
       $PreOptTreatments->SaveStatus = 1;
       $PreOptTreatments->save();
   }
}