<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\TreatmentModel;
use App\Models\DrugsModel;
use App\Http\Controllers\MasterController;
use Dotenv\Util\Regex;
use Session;
class TreatmentController extends Controller
{   
    function getTreatments(Request $req){
        // $data = TreatmentModel::select()->where(['Treatment'=>$Treatment])->orderBy('id')->get();
        $MrdNo = $req->MrdNo;
        $VisitNo = $req->VisitNo;
        $VisitDate = $req->VisitDate;
        $Treatment = $req->Treatment;
        DB::select("INSERT INTO tbl_temp_treatments (MrdNo,VisitNo,VisitDate,Treatment,TreatChk1,TreatType1,TreatName1,TreatDose1,TreatFreq1,TreatDur1,TreatEye1)
        SELECT '$MrdNo','$VisitNo','$VisitDate',Treatment,TreatChk1,TreatType1,TreatName1,TreatDose1,TreatFreq1,TreatDur1,TreatEye1 FROM `tbl_treatments` WHERE Treatment='$Treatment'");
        $resultdata = DB::table('tbl_temp_treatments')->select()->where(['MrdNo'=>$MrdNo,'VisitNo'=>$VisitNo,'VisitDate'=>$VisitDate])->get();
        $rncnt = $resultdata->count();
        $balance = 9 - $rncnt;
        $TreatName = $this->getTreatmentName();
        $advice = TreatmentModel::where('Treatment', $req->Treatment)
                        ->distinct()
                        ->value('Advice');
        $html = view('masters/treatmentlist', ['data'=>$resultdata,'rncnt'=>$rncnt,'TreatName'=>$TreatName])->render();
                        return response()->json([
                        'advice' => $advice,
                        'html' => $html
                    ]);
        // $result = view('masters/treatmentlist',['data'=>$resultdata,'rncnt'=>$rncnt,'TreatName'=>$TreatName]);
        // return $result;
    }

    function deleteConsultantTreatment(Request $req){
        $MrdNo = $req->MrdNo;
        $VisitNo = $req->VisitNo;
        $VisitDate = $req->VisitDate;
        DB::table('tbl_temp_treatments')->where(['MrdNo'=>$MrdNo,'VisitNo'=>$VisitNo,'VisitDate'=>$VisitDate])->delete();
        $resultdata = DB::table('tbl_temp_treatments')->select()->where(['MrdNo'=>$MrdNo,'VisitNo'=>$VisitNo,'VisitDate'=>$VisitDate])->get();
        $rncnt = $resultdata->count();
        $balance = 9 - $rncnt;
        $TreatName = $this->getTreatmentName();
        $result = view('masters/treatmentlist',['data'=>$resultdata,'rncnt'=>$rncnt,'TreatName'=>$TreatName]);
        return $result;
    }

    function deleteConsDrug(Request $req){
        $id = $req->id;
        DB::table('tbl_temp_treatments')->where(['id'=>$id])->delete();
    }
    function showTreatmentList(Request $req){
        $MrdNo = $req->MrdNo;
        $VisitNo = $req->VisitNo;
        $VisitDate = $req->VisitDate;
        $resultdata = DB::table('tbl_temp_treatments')->select()->where(['MrdNo'=>$MrdNo,'VisitNo'=>$VisitNo,'VisitDate'=>$VisitDate])->get();
        $rncnt = $resultdata->count();
        $balance = 9 - $rncnt;
        $TreatName = $this->getTreatmentName();
        $result = view('masters/treatmentlist',['data'=>$resultdata,'rncnt'=>$rncnt,'TreatName'=>$TreatName]);
        return $result;
    }

    function getTreatments2(Request $req){
        $Treatment = $req->Treatment;
        $data = TreatmentModel::select()->where(['Treatment'=>$Treatment])->orderBy('id')->get();
        $rncnt = $data->count();
        $balance = 9 - $rncnt;
        $TreatName = $this->getTreatmentName();
        $durationList = (new MasterController)->durationList();
        //$this->getTreatmentList();
        $result = view('masters/treatmentlist2',['durationList'=>$durationList,'data'=>$data,'rncnt'=>$rncnt,'TreatName'=>$TreatName]);
        return $result;
    }

    function getTreatmentName(){
        //$result = TreatmentModel::select('TreatName1  as TreatName')->distinct()->get();
        $result = DrugsModel::select('Name  as TreatName')->distinct()->get();
        return $result;
    }

    function treatmentmaster($val){
        $treatments = $this->getTreatmentList($val);
        $drugList = (new MasterController)->drugList();
        return view('masters/treatmentmaster',['val'=>$val,'drugList'=>$drugList,'treatments'=>$treatments]);
    }

    function getTreatmentList($val){
        $result = TreatmentModel::select('Treatment')->where(['TreatRoll'=>$val])->distinct()->orderBy('Treatment','asc')->get();
        $final_data = json_encode(array('items' => $result));
        //return $final_data;
        if(file_put_contents('json_files/timetables_date.json', $final_data)){}
        //return $result;

        // $result2 = TreatmentModel::select('Treatment')->where(['TreatRoll'=>'Ipd'])->distinct()->orderBy('Treatment','asc')->get();
        // $final_data2 = json_encode(array('items' => $result2));
        // if(file_put_contents('json_files/ipd_treatment.json', $final_data2)){}
    }

    function getTreatmentList2($val){
        $result = TreatmentModel::select('Treatment')->where(['TreatRoll'=>$val])->distinct()->orderBy('Treatment','asc')->get();
        $final_data = json_encode(array('items' => $result));
      return $result;
    }
    

    function getMoreTreatments(Request $req){
        $drugList = (new MasterController)->drugList();
        return view('masters/getmoretreatments',['drugList'=>$drugList]);
    }

    function saveTreatments(Request $req){
        //return $req->TreatRoll;
        TreatmentModel::where(['Treatment'=>$req->Treatment,'TreatRoll'=>$req->TreatRoll])->delete();    
      $TreatType1 = $req->TreatType1;
      $TreatName1 = $req->TreatName1;
      $TreatDose1 = $req->TreatDose1;
      $TreatFreq1 = $req->TreatFreq1;
      $TreatDur1 = $req->TreatDur1;
      $TreatEye1 = $req->TreatEye1;
      for($count = 0; $count < count($TreatType1); $count++)
      {
        if($TreatType1[$count] != ''){
       $data = array(
        'TreatRoll'=>$req->TreatRoll,
        'Treatment'=>$req->Treatment,
        'Advice'=>$req->Advice,
        'TreatChk1' => 1,
        'TreatType1' => $TreatType1[$count],
        'TreatName1'  => $TreatName1[$count],
        'TreatDose1'  => $TreatDose1[$count],
        'TreatFreq1'  => $TreatFreq1[$count],
        'TreatDur1'  => $TreatDur1[$count],
        'TreatEye1'  => $TreatEye1[$count],
        'CreatedBy' => Session::get('UserId'),
        'ModifiedBy' => Session::get('UserId')
       );
       $insert_data[] = $data; 
    }
      }

      TreatmentModel::insert($insert_data);
      $this->getTreatmentList($req->TreatRoll);
     return redirect("/treatmentmaster/{$req->TreatRoll}");

    }

    function getSaveTreatments(Request $req){
        $drugList = (new MasterController)->drugList();
        $advice = TreatmentModel::where('Treatment', $req->Treatment)
                        ->distinct()
                        ->value('Advice');
        $result = TreatmentModel::select()->where(['Treatment'=>$req->Treatment])
        ->orderBy('id')->get();
        $TreatRoll = $result[0]->TreatRoll;
        $html = view('masters/getsavetreatments', [
        'advice' => $advice,
        'data' => $result,
        'drugList' => $drugList,
        'TreatRoll' => $TreatRoll
    ])->render();
    return response()->json([
        'advice' => $advice,
        'html' => $html
    ]);
        //return view('masters/getsavetreatments',['advice'=>$advice,'data'=>$result,'drugList'=>$drugList,'TreatRoll'=>$TreatRoll]);
    }

    function deleteTreatment(Request $req){
        TreatmentModel::where(['Treatment'=>$req->Treatment])->delete();
        $this->getTreatmentList($req->TreatRoll);
        return "Record Deleted Successfully!";
    }

    function getTreatDate(Request $req){
        $val = $req->val;
        $result = DB::table('tbl_duration')->where('Duration',$val)->first();
        $dur = $result->DurVal;
        $period = $result->DurPeriod;
        $valid_period = "+ ".$dur." ".$period;
        $dt = strtotime(date('Y-m-d'));
        $reviewdt = date("Y-m-d", strtotime("+$valid_period", $dt));
        return $reviewdt;
    }

    function getTreatDate2($val){
        //$val = $req->val;
        $result = DB::table('tbl_duration')->where('Duration',$val)->first();
        $cnt = DB::table('tbl_duration')->where('Duration',$val)->count();
        if($cnt > 0){
        $dur = $result->DurVal;
        $period = $result->DurPeriod;
        $valid_period = "+ ".$dur." ".$period;
        $dt = strtotime(date('Y-m-d'));
        $reviewdt = date("Y-m-d", strtotime("+$valid_period", $dt));
        return $reviewdt;
        }
        else{
            return 0;   
        }
    }

    function getTapDate(Request $req){
        $TreatDate = $req->TreatDate;
        $PrevTreatDate = $req->PrevTreatDate;
        $TreatDur = $req->TreatDur;
        $result = DB::table('tbl_duration')->where('Duration',$TreatDur)->first();
        $cnt = DB::table('tbl_duration')->where('Duration',$TreatDur)->count();
        if($cnt > 0){
            $dur = $result->DurVal;
            $period = $result->DurPeriod;
            $valid_period = $dur." ".$period;
            $reviewdt = date('Y-m-d', strtotime($PrevTreatDate. " + $valid_period"));
            return $reviewdt;
            }
            else{
                return 0;   
            }

    }

    function getUnchkTapDate(Request $req){
        $TreatDate = $req->TreatDate;
        $TreatDur = $req->TreatDur;
        $result = DB::table('tbl_duration')->where('Duration',$TreatDur)->first();
        $cnt = DB::table('tbl_duration')->where('Duration',$TreatDur)->count();
        if($cnt > 0){
            $dur = $result->DurVal;
            $period = $result->DurPeriod;
            $valid_period = $dur." ".$period;
            $reviewdt = date('Y-m-d', strtotime($TreatDate. " - $valid_period"));
            return $reviewdt;
            }
            else{
                return 0;   
            }

    }

    function getDrugByType(Request $req){
         $Type = $req->val;
    $result = DB::table('tbl_drugs')->select('Name')->where('Type', $Type)->get();

    $html = '';
    foreach ($result as $drug) {
        $html .= '<option value="' . htmlspecialchars($drug->Name) . '">';
    }

    return response($html);
    }
}