<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\TubingReceiptModel;
use App\Http\Controllers\MasterController;
use App\Models\UserMaster;
use Session;

class TubingReceiptController extends Controller
{
    function TubingReceipt(){
        $today = $this->todayTubingReceipt();
        $total = $this->totalTubingReceipt();
        $consultants = UserMaster::where('Type', 'Consultant')->get();
        
        return view('tubing-receipt/view-tubing-receipt', [
            'today' => $today,
            'total' => $total,
            'consultants' => $consultants
        ]);
    }

    function viewTubingReceipts(Request $req){
        $CurrDate = date('Y-m-d');
        $SrchPayMode = $req->SrchPayMode;
        
        if(!empty($req->FromDate)) {
            $sql = "SELECT ttr.*, tp.Phone FROM tbl_tubing_receipts ttr 
                    LEFT JOIN tbl_patients tp ON tp.MrdNo = ttr.MrdNo 
                    WHERE ttr.Status = 1 AND ttr.Date >= '$req->FromDate' AND ttr.Date <= '$req->ToDate'";
            
            if($SrchPayMode != '') {
                $sql .= " AND ttr.PayMode = '$SrchPayMode'";
            }
            $sql .= " ORDER BY ttr.id DESC";
            $result = DB::select($sql);

            $sql2 = "SELECT SUM(Amount) AS Amount FROM tbl_tubing_receipts 
                     WHERE Status = 1 AND Date >= '$req->FromDate' AND Date <= '$req->ToDate'";
            if($SrchPayMode != '') {
                $sql2 .= " AND PayMode = '$SrchPayMode'";
            }
            $result2 = DB::select($sql2);
            $total = $result2[0]->Amount ? $result2[0]->Amount : 0;
        } else {
            $result = TubingReceiptModel::where('Date', $CurrDate)->orderBy('id', 'desc')->get();
            $total = $result->sum('Amount');
        }

        return view('tubing-receipt/inc-tubing-receipt-list', ['data' => $result, 'total' => $total]);
    }

    function fetchTubingReceiptRecord(Request $req){
        $result = TubingReceiptModel::find($req->id);
        echo json_encode($result);
    }

    function deleteTubingReceipt(Request $req){
        TubingReceiptModel::where(['id' => $req->id])->update(['Status' => 0]);
        $today = $this->todayTubingReceipt();
        $total = $this->totalTubingReceipt();
        echo json_encode(array('status' => '1', 'today' => $today, 'total' => $total)); 
    }

    function saveTubingReceipt(Request $req){
        $CurrDate = date('Y-m-d');
        
        if($req->action == 'Save') {
            $TubingReceipt = new TubingReceiptModel;
            $TubingReceipt->CreatedBy = Session::get('UserId') ? Session::get('UserId') : 19;
            $TubingReceipt->CreatedDate = $CurrDate;
            $TubingReceipt->ReceiptNo = $this->getTubingReceiptNo();
        } else {
            $TubingReceipt = TubingReceiptModel::find($req->id);
            $TubingReceipt->ModifiedBy = Session::get('UserId') ? Session::get('UserId') : 19;
            $TubingReceipt->ModifiedDate = $CurrDate;
        }

        $TubingReceipt->Date = $req->Date ? $req->Date : $CurrDate;
        $TubingReceipt->MrdNo = $req->MrdNo ? $req->MrdNo : null;
        $TubingReceipt->IpdNo = $req->IpdNo ? $req->IpdNo : null;
        $TubingReceipt->UhidNo = $req->UhidNo ? $req->UhidNo : null;
        $TubingReceipt->PatientName = $req->PatientName ? $req->PatientName : null;
        $TubingReceipt->Procedure = 'TUBING'; // Fixed to TUBING
        $TubingReceipt->TotalNo = $req->TotalNo ? $req->TotalNo : null;
        $TubingReceipt->ConsultantId = $req->ConsultantId ? $req->ConsultantId : null;
        $TubingReceipt->Consultant = $req->Consultant ? $req->Consultant : null;
        $TubingReceipt->Amount = $req->Amount ? $req->Amount : 0;
        $TubingReceipt->PayMode = $req->PayMode ? $req->PayMode : 'Cash';
        $TubingReceipt->Status = 1;
        
        $TubingReceipt->save();
        $postid = $TubingReceipt->id;
        $today = $this->todayTubingReceipt();
        $total = $this->totalTubingReceipt();
        
        return json_encode(array('status' => 1, 'today' => $today, 'total' => $total, 'id' => $postid));
    }

    function todayTubingReceipt(){
        $CurrDate = date('Y-m-d');
        $rncnt = TubingReceiptModel::where(['Date' => $CurrDate, 'Status' => 1])->count();
        return $rncnt;
    }

    function totalTubingReceipt(){
        $rncnt = TubingReceiptModel::where('Status', 1)->count();
        return $rncnt;
    }

    function getTubingReceiptNo(){
        $maxReceiptNo = TubingReceiptModel::max('ReceiptNo');
        $receiptNo = ($maxReceiptNo) ? $maxReceiptNo + 1 : 1;
        return $receiptNo;
    }

    function getTubingReceiptNoAjax(Request $req){
        $receiptNo = $this->getTubingReceiptNo();
        return response()->json(['receipt_no' => $receiptNo]);
    }

    function tubingReceiptPrint($id){
        $result = TubingReceiptModel::where('id', $id)->first();
        return view('tubing-receipt/tubing-receipt-print', ['result' => $result]);
    }
}
