<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Session;
use Illuminate\Support\Facades\DB;
use App\Models\VendorMaster;
use App\Models\VendorModel;
use Stroage;
class VendorController extends Controller
{
    function vendors(){
        return view('/vendors/view-vendors');
    }

    function viewVendors(Request $req){
        //$result = DB::select("SELECT * FROM tbl_vendors");
        $result = VendorMaster::all();
        return view('/vendors/inc-vendor-lists',['data'=>$result]);
    }

    function addNewVendor(){
        return view('/vendors/add-vendor');
    }

    function saveNewVendor(Request $req){
        if($req->action == 'Save'){
            $VendorMaster = new VendorMaster;
            $VendorMaster->CreatedBy = 19;
            $VendorMaster->CreatedDate = date('Y-m-d');
            }
            else{
            $VendorMaster = VendorMaster::find($req->saveid);
            }
            $VendorMaster->VedName=$req->VedName;
            $VendorMaster->Phone=$req->Phone;
            $VendorMaster->EmailId=$req->EmailId;
            $VendorMaster->Address=$req->Address;
            $VendorMaster->Status=1;
            $VendorMaster->save();
            return 1;
    }

    function deletVendor(Request $req){
        $data=VendorMaster::find($req->id)->delete();
        return 1;
    }

    function editVendor($id){
        $data = VendorMaster::find($id);
        return view('/vendors/edit-vendor',['data'=>$data]);
    }

    
    function vendorReceipt(){
        $result = VendorMaster::all();
        return view('/vendors/view-vendor-receipt',['vedlist'=>$result]);
    }
    
    function viewVendorReceipt(Request $req){
        $FromDate = $req->FromDate;
        $ToDate = $req->ToDate;
        $VedId = $req->VedId;
        $PayMode = $req->PayMode;
        //$result =  VendorModel::select()->whereBetween('BillDate', array($req->FromDate, $req->ToDate))->where(['VedId'=>$VedId])->get();  
        //$result = VendorModel::all();
        //return $result;
        $sql = "SELECT * FROM tbl_vendor_receipts WHERE Status=1";
        if($FromDate!=''){
            $sql.=" AND BillDate>='$FromDate'";
        }
        if($ToDate!=''){
            $sql.=" AND BillDate<='$ToDate'";
        }
        if($req->VedId){
            if($VedId == 'all'){
                $sql.= " ";
            }
            else{
            $sql.= " AND VedId='$VedId'";
            }
        }
        if($req->PayMode){
            if($PayMode == 'all'){
                $sql.= " ";
            }
            else{
            $sql.= " AND PayMode='$PayMode'";
            }
        }
        //return $sql;
        $result = DB::select($sql);
        return view('/vendors/inc-vendor-receiot-lists',['data'=>$result]);
    }

    function addVendorReceipt(){
        $result = VendorMaster::all();
        return view('/vendors/add-vendor-receipt',['data'=>$result]);
    }

    function saveVendorReceipt(Request $req){
        if($req->action == 'Save'){
            $VendorModel = new VendorModel;
            $VendorModel->CreatedBy = 19;
            $VendorModel->ModifiedBy = 0;
            $VendorModel->CreatedDate = date('Y-m-d');
            }
            else{
            $VendorModel = VendorModel::find($req->saveid);
            $VendorModel->ModifiedBy = 19;
            $VendorModel->ModifiedDate = date('Y-m-d');
            }
            $result = VendorMaster::select('VedName')->where(['id'=>$req->VedId])->first();
            $VendorModel->VedId=$req->VedId;
            $VendorModel->VendorName=$result->VedName;
            $VendorModel->BillNo=$req->BillNo;
            $VendorModel->BillDate=$req->BillDate;
            $VendorModel->Details=$req->Details;
            $VendorModel->Amount=$req->Amount;
            $VendorModel->PayMode=$req->PayMode;
            $VendorModel->ChequeNo=$req->ChequeNo;
            if($req->Files){
            $file = $req->Files;
            $filename = $file->getClientOriginalName();
            //$file->getClientOriginalExtension()
            $filename = time().'_'.$filename;
            $req->Files->move('uploads/',$filename);
            $VendorModel->Files = $filename;
            }
            else{
            $VendorModel->Files = $req->OldFiles;
            }
            $VendorModel->Status=1;
            $VendorModel->save();
            return 1;
    }

    function download($file){
        return response()->download(public_path('uploads/'.$file));
    }
    
    function deleteVendorReceipt(Request $req){
        $data=VendorModel::find($req->id)->delete();
        return 1;
    }

    function editVendorReceipt($id){
        $data = VendorModel::find($id);
        //return $data;
        $result = VendorMaster::all();
        return view('/vendors/edit-vendor-receipt',['vedlist'=>$result,'data'=>$data]);
    }

    function printVendorReceipt($file){
        return view('/vendors/print-vendor-receipt',['file'=>$file]);
    }
}
