<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\WhatsAppModel;
use App\Models\AppointmentModel;

class WhatsAppController extends Controller
{
    function sendMessage($id){
        $result = AppointmentModel::where('id',$id)->first();
        $msg = "Dear ".$result->PatientName." your appointment for ".$result->ReferFor." is on ".date("d/m/Y", strtotime(str_replace('-', '/',$result->AppDate)));
        if($result->AppTime){
            $msg.= " at ".$result->AppTime;
        }
        $msg.= " at Vyawahare Netralaya Amravati. Any Qurey please Contact 9370109617,9552731024";
        
        return view('/whatsapp/clinic-sms-send',['id'=>$id,'result'=>$result,'msg'=>$msg]); 
    }

    function sendWhatsappSms(Request $req){
        $WhatsApp = new WhatsAppModel;
        $WhatsApp->MrdNo = $req->MrdNo; 
        $WhatsApp->PatientName = $req->PatientName;
        $WhatsApp->Phone = $req->Phone;
        $WhatsApp->ReferFor = $req->ReferFor;
        $WhatsApp->Consultant = $req->Consultant;
        $WhatsApp->AppDate = $req->AppDate;
        $WhatsApp->AppTime = $req->AppTime;
        $WhatsApp->AppId = $req->AppId;
        $WhatsApp->Roll = 1;
        $WhatsApp->Message = $req->Message;
        $WhatsApp->CreatedDate = date('Y-m-d');
        $WhatsApp->CreatedTime = date('h:i a');
        $WhatsApp->save();
        $sms_text = strip_tags($req->Message);
        $api_url = "https://smswaapi.in/api/send?number=91".$req->Phone."&type=text&message=".$sms_text."&instance_id=64B0F93ED3A13&access_token=649d339dbf9f2";
        $response = file_get_contents( $api_url);
        return 1;
        // $character = json_decode($response,true);
        // $status = $character['status'];
        // if($status == 'success'){
        //     return 1;
        // }
        // else{
        //     return 0;
        // }
        //return json_encode(array('id'=>$AppointId,'Status'=>1));
    }
}
