@include('header')
<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold py-3 mb-0">Add Certificate</h4>
<style>
    .autocomplete-list {
        border: 1px solid #ccc;
        max-height: 150px;
        overflow-y: auto;
        position: absolute;
        background-color: white;
        z-index: 1000;
        width: 100%;
    }

    .autocomplete-item {
        padding: 8px;
        cursor: pointer;
    }

    .autocomplete-item:hover,
    .autocomplete-item.active {
        background-color: #98e6ed;
    }
    </style>
    <form id="validation-form" method="POST" action="">

        <input type="hidden" name="action" id="action" value="Save">
        <input type="hidden" name="saveid" id="saveid" value="">
        @csrf
        <div class="card mb-12 mb-4">
            <div class="card-body">
                <div class="row">



            <div class="col-sm-4">
                        <div class="form-group">
                            <label>Search Patient <span class="text-danger">*</span></label>
                             <input type="text" id="TopPatientName" class="form-control" placeholder="Patient Name">
                                <div id="autocomplete-list" class="autocomplete-list" style="display: none; position: absolute;"></div>
                        </div>
                    </div>

                    <div class="col-sm-1">
                        <div class="form-group">
                            <label>Mrd. No <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="MrdNo" id="MrdNo" placeholder="" value="">
                        </div>
                    </div>
                    <div class="col-sm-3">
                        <div class="form-group">
                            <label class="floating-label" for="Name">Patient Name <span
                                    class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="PatientName" id="PatientName" placeholder=""
                                value="">
                        </div>
                    </div>
                    <div class="col-sm-2">
                        <div class="form-group">
                            <label class="floating-label" for="Name">Phone <span
                                    class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="Phone" id="Phone" placeholder=""
                                value="">
                        </div>
                    </div>




                    <div class="col-sm-2">
                        <div class="form-group">
                            <label class="floating-label" for="Phone">Issue Date <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" id="CertiDate" Name="CertiDate"
                                value="{{date('Y-m-d')}}" placeholder="" required>
                        </div>
                    </div>

                    
                    
                    <div class="col-sm-10">
                        <div class="form-group">
                            <label class="floating-label" for="Phone">Suffer From <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="SufferFrom" Name="SufferFrom" value=""
                                placeholder="" required>
                        </div>
                    </div>

                    <div class="col-sm-2">
                                    <span class="input-group-append">
                                        <button class="btn btn-secondary" type="button" data-toggle="modal"
                                            data-target="#modal-report" id="add_button"
                                            onclick="getValue('SufferFrom','SufferFrom')">...</button>
                                    </span>
                                </div>

                     <div class="form-group col-md-2">
                                <label class="floating-label" for="gender">Consultant Name <span
                                    class="text-danger">*</span></label>
                                <select class="form-control" id="Consultant" name="Consultant" required>
                                    <option value="" selected>...</option>
                                   @foreach($consultantList as $consultant)
                                    <option value="{{$consultant->id}}">{{$consultant->Name}}</option>
                                    @endforeach
                                   
                                   
                                </select>
                            </div> 

                     <div class="col-sm-2">
                        <div class="form-group">
                            <label class="floating-label" for="Phone">Registraion No <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="RegNo" Name="RegNo"
                                value="" placeholder="" readonly>
                        </div>
                    </div>

                    <div class="col-sm-2">
                        <div class="form-group">
                            <label class="floating-label" for="Phone">Rest From <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" id="RestFrom" Name="RestFrom"
                                value="{{date('Y-m-d')}}" placeholder="" required>
                        </div>
                    </div>

                    <div class="col-sm-2">
                        <div class="form-group">
                            <label class="floating-label" for="Phone">To <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" id="RestTo" Name="RestTo"
                                value="{{date('Y-m-d')}}" placeholder="" required>
                        </div>
                    </div>

                    <div class="col-sm-2">
                        <div class="form-group">
                            <label class="floating-label" for="Phone">Join Date <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" id="JoinDate" Name="JoinDate"
                                value="{{date('Y-m-d')}}" placeholder="" required>
                        </div>
                    </div>

                   <div class="col-sm-2">
    <div class="form-group">
        <label class="floating-label" for="CertificateType">Print Certificate <span class="text-danger">*</span></label>
        <select class="form-control" id="CertificateType" name="CertificateType" required>
            <option value="">Select Certificate</option>
           @foreach($certificateList as $certificate)
                                    <option value="{{$certificate->id}}">{{$certificate->name}}</option>
                                    @endforeach
        </select>
    </div>
</div>


                    
                    <div class="col-sm-6" style="padding-top:20px;">
                        <button class="btn btn-primary" type="submit" name="submit" id="submit">Save</button>
                        <button class="btn btn-info" type="button" id="print" onclick="printReferralForm()">Print</button>
                        <a href="{{projectUrl()}}addReferralForm" class="btn btn-info">Add New</a>
                        <a href="{{projectUrl()}}referralForm" class="btn btn-info">View Certificates</a>
                    </div><br>
                    <!-- <div class="col-sm-12" id="custresult2" style="padding-top: 25px;">

                        </div> -->

                    <input type="hidden" id="CurrDate" value="{{date('Y-m-d')}}">

                </div>
            </div>



    </form>


</div>

<script src="{{url('assets/js/jquery-3.6.0.min.js')}}"></script>
@include('masters/inccommonmodal')
@include('footerscript')
<script>
 

    $(document).ready(function() {
       let currentFocus2 = -1;

        $("#TopPatientName").on("input", function () {
            let TopPatientName = $(this).val();

            if (TopPatientName.length === 0) {
                $("#autocomplete-list").hide();
                return;
            }

            $.ajax({
                url: "{{ url('getSearchPatientList') }}",
                method: "POST",
                data: {
                    _token: '{{ csrf_token() }}',
                    TopPatientName: TopPatientName
                },
                success: function (data) {
                    $("#autocomplete-list").empty().show();
                    currentFocus2 = -1;

                    if (data.length === 0) {
                        $("#autocomplete-list").hide();
                        return;
                    }

                    data.forEach(function (item) {
                        $("#autocomplete-list").append(`<div class="autocomplete-item" onclick="getPatientVal2('${item.MrdNo}')">${item.PatientNameFull}</div>`);
                    });

                    $(".autocomplete-item").on("click", function () {
                        $("#TopPatientName").val($(this).text());
                        $("#autocomplete-list").hide();
                    });
                }
            });
        });

        $("#TopPatientName").on("keydown", function (e) {
            let items = $(".autocomplete-item");

            if (e.key === "ArrowDown") {
                currentFocus2++;
                if (currentFocus2 >= items.length) currentFocus2 = 0;
                setActive(items);
                e.preventDefault();
            } else if (e.key === "ArrowUp") {
                currentFocus2--;
                if (currentFocus2 < 0) currentFocus2 = items.length - 1;
                setActive(items);
                e.preventDefault();
            } else if (e.key === "Enter") {
                e.preventDefault();
                if (currentFocus2 > -1 && items[currentFocus2]) {
                    items.eq(currentFocus2).click();
                }
            }
        });

        function setActive(items) {
            items.removeClass("active");
            if (currentFocus2 >= 0 && currentFocus2 < items.length) {
                items.eq(currentFocus2).addClass("active");
                items.eq(currentFocus2)[0].scrollIntoView({ block: "nearest" });
            }
        }

        $(document).click(function (e) {
            if (!$(e.target).closest("#TopPatientName, #autocomplete-list").length) {
                $("#autocomplete-list").hide();
            }
        });
    });

    function getPatientVal2(val) {
 $.ajax({
        url: "{{ url('getPatientDetails2') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            id: val
        },
        dataType: "json",
        success: function(data) {
            // Accessing patient object and amount
            let patient = data.patient;
            if (patient) {
                $('#MrdNo').val(patient.MrdNo);
                $('#PatientName').val(patient.PatientName);
                $('#Phone').val(patient.Phone);
               
            }

         
        }
    });
    }
  function getValue(val, idval) {

        $('#ModalValue').val(val);
        $('#ValueId').val(idval);
        $('#OldValue').val('');
        desc_lists(val);
    }

function success_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.notice({
        title: 'Success',
        message: 'Record Created Successfully!',
        location: isRtl ? 'tl' : 'tr'
    });
}

function error_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.error({
        title: 'Error',
        message: 'Record Not Saved',
        location: isRtl ? 'tl' : 'tr'
    });
}

function printReferralForm() {
    var saveid = $('#saveid').val();
    if (!saveid) {
        alert("Save ID is missing");
        return;
    }

    setTimeout(function() {
        window.open(
            '/{{projectUrl()}}printReferralForm/' + saveid,
            'stickerPrint',
            'toolbar=1, scrollbars=1, location=1,statusbar=0, menubar=1, resizable=1, width=800, height=800'
        );
    }, 1);
}
$(document).ready(function() {
    $('#validation-form').on('submit', function(e) {
        e.preventDefault();
        if ($('#validation-form').valid()) {
            $.ajax({
                url: "{{ url('saveReferralForm') }}",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                processData: false,
                beforeSend: function() {
                    $('#submit').attr('disabled', 'disabled');
                    $('#submit').text('Please Wait...');
                },
                success: function(data) {
                    var res = JSON.parse(data);
                    $('#saveid').val(res.id);
                    $('#action').val('Edit');
                    if (res.Status == 1) {
                        success_toast();
                        //window.location.href = "{{ url('referralForm') }}";
                    } else {
                        error_toast();
                    }
                    $('#submit').attr('disabled', false);
                    $('#submit').text('Save');
                }
            });
        }
    });


$(document).on("input", "#MrdNo", function(event) {
    var val = this.value;
    $.ajax({
        url: "{{ url('getPatientDetails') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            id: val
        },
        dataType: "json",
        success: function(data) {
            //console.log(data);
            $('#MrdNo').val(data.MrdNo);
            $('#PatientName').val(data.PatientName);
            $('#Phone').val(data.Phone);

        }
    });

});


    $(document).on("change", "#Consultant", function(event) {
        var val = this.value;
        $.ajax({
            url: "{{ url('consultantDetails') }}",
            method: "POST",
            data: {
                _token: '{{csrf_token()}}',
                val: val
            },
            dataType: "json",
            success: function(data) {
                //console.log(data);
                $('#RegNo').val(data.RegNo);
            }
        });

    });


});
</script>