@include('header')
@php
$UserId = Session::get('UserId');
$UserType = Session::get('UserType');
@endphp
<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold py-3 mb-0">Consultation Charges
    </h4>
    <div class="card mb-4">
        <div class="card-body">

            <div class="row align-items-center m-l-0">



                <div class="col-sm-1 text-left">
                    <button class="btn btn-success btn-sm mb-3 btn-round" data-toggle="modal"
                        data-target="#modal-report" id="add_button"><i class="feather icon-plus"></i> Add
                        </button>
                </div>
                <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="gender">Procedures <span
                                        class="text-danger">*</span></label>
                                      
                               <select class="select2-demo form-control" id="SrchProcedures">
<option selected value="">...</option>
@foreach($saveprocedures as $result)
<option value="{{$result->Procedures}}">{{$result->Procedures}}</option>
@endforeach
                               <select>
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="gender">Payment Mode </label>
                                <select class="form-control" id="SrchPayMode" name="SrchPayMode">
                                    <option value="">All</option>
                                    <option value="Cash">Cash</option>
                                    <!-- <option value="Card">Card</option> -->
                                    <option value="Mobile Payment">Mobile Payment</option>
                                </select>
                            </div>
                        </div>
                <div class="form-group col-md-2">
                            <label class="form-label">From Date </label>
                            <input type="date" id="FromDate" class="form-control" value="{{date('Y-m-d')}}" autocomplete="off" required>
                        </div>
                        <div class="form-group col-md-2">
                            <label class="form-label">To Date</label>
                            <input type="date" id="ToDate" class="form-control" value="{{date('Y-m-d')}}" autocomplete="off" required>
                        </div>
                        <input type="hidden" name="Search" value="Search">
                        <div class="form-group col-md-1" style="padding-top:20px;">
                            <button type="button" class="btn btn-primary btn-finish"
                            id="filter">Search</button>
                            <!-- <button type="button" id="refresh" class="btn btn-secondary btn-finish">Refresh</button> -->
                        </div>

                        <div class="col-sm-2 text-right">
                            <a href="javascript:void(0)" class="badge badge-pill badge-danger" id="today">Today's Receipt :
                                {{$today}}</a>
                            <a href="javascript:void(0)" class="badge badge-pill badge-success"
                                id="total">Total Receipt : {{$total}}</a>
                            
                        </div>
                


            </div>
            <hr>
            <div class="table-responsive" id="custresult">


            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-report" tabindex="-1" role="dialog" aria-labelledby="myExtraLargeModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" style="max-width: 70rem; ">
        <div class="modal-content">


            <div class="modal-header">
                <h5 class="modal-title">Add Consultation Charges</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="validation-form" method="POST">
                    @csrf
                    <input type="hidden" name="action" id="action" value="Save">
                    <input type="hidden" name="id" id="id" />
                    <input type="hidden" name="ConsultantId" id="ConsultantId" />
                    <input type="hidden" name="Consultant" id="Consultant" />
                    <div class="row">
                        
                   
                        <div class="col-sm-2">
                            <div class="form-group">
                                <label>Mrd. No <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="MrdNo" id="MrdNo" placeholder=""
                                    >
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label class="floating-label" for="Name">Patient Name <span
                                        class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="PatientName" id="PatientName"
                                    placeholder="">
                            </div>
                        </div>

                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="floating-label" for="gender">Procedures <span
                                        class="text-danger">*</span></label>
                                        <input class="form-control" list="DataList2" name="Procedures" id="Procedures" onchange="getProcedureDetails(this.value)">
                                <datalist id="DataList2">
                                    @foreach($procedures as $result)
                                   
                                    <option value="{{$result->Name}}">
                                        @endforeach
                                </datalist>
                            </div>
                        </div>

                        <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="Phone">Amount <span
                                        class="text-danger">*</span></label>
                                        <select class="form-control" id="Amount" Name="Amount" required>
                                            <option value="" selected>...</option>
<option value="400">400</option>
<option value="150">150</option>
</select>
                                
                            </div>
                        </div>

                        <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="Phone">Date <span
                                        class="text-danger">*</span></label>
                                <input type="date" value="{{date('Y-m-d')}}" class="form-control" id="CreatedDate" Name="CreatedDate" placeholder="" required>
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="gender">Payment Mode <span
                                        class="text-danger">*</span></label>
                                <select class="form-control" id="PayMode" name="PayMode" required>
                                    <option value=""></option>
                                    <option value="Cash">Cash</option>
                                    <!-- <option value="Card">Card</option> -->
                                    <option value="Mobile Payment">Mobile Payment</option>
                                </select>
                            </div>
                        </div>
                        <!-- <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="Phone">Cheque No</label>
                                <input type="text" class="form-control" id="ChequeNo" Name="ChequeNo" placeholder="">
                            </div>
                        </div> -->
                        
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="floating-label" for="gender">Transaction ID </label>
                                <input type="text" class="form-control" id="Narration" Name="Narration" placeholder=""
                                    >
                            </div>
                        </div>
                        <div class="col-sm-12" >
                            <button class="btn btn-primary" type="submit" name="submit" id="submit" onclick="btnaction2('submit')">Submit</button>
                            <button class="btn btn-danger" type="reset">Clear</button>
                            <button class="btn btn-success" type="submit" name="submit" id="print" onclick="btnaction2('print')">Print</button>
                        </div><br>
                        <!-- <div class="col-sm-12" id="custresult2" style="padding-top: 25px;">

                        </div> -->

                    <input type="hidden" id="CurrDate" value="{{date('Y-m-d')}}">
                    <input type="hidden" id="btnaction" value="submit">

                        
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@include('footerscript')
@include('excelscript')
<script type="text/javascript">
    function btnaction2(val){
        $('#btnaction').val(val);
    }
function isNumberKey(evt) {
    var charCode = (evt.which) ? evt.which : evt.keyCode
    if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
    return true;
}

function success_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.notice({
        title: 'Success',
        message: 'New Expenses Added Successfully!',
        location: isRtl ? 'tl' : 'tr'
    });
}

function error_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.error({
        title: 'Error',
        message: 'Expenses Already Exists',
        location: isRtl ? 'tl' : 'tr'
    });
}

function printCard(id){
    setTimeout(function () {
    window.open(
        '/{{projectUrl()}}consultationChargesPrint/'+id, 'name', 'toolbar=1, scrollbars=1, location=1,statusbar=0, menubar=1, resizable=1, width=900, height=1000'
    );
}, 1);
}

$('#filter').click(function(){
  var FromDate = $('#FromDate').val();
  var ToDate = $('#ToDate').val();
  var SrchProcedures = $('#SrchProcedures').val();
  var SrchPayMode = $('#SrchPayMode').val();
  if(FromDate != '' &&  ToDate != '')
  {
   queueList(FromDate, ToDate,SrchProcedures,SrchPayMode);
  }
  else
  {
   alert('Both Date is required');
  }
 });

 $('#refresh').click(function(){
  $('#FromDate').val('');
  $('#ToDate').val('');
  $('#SrchProcedures').val('');
  $('#SrchPayMode').val('');
  queueList();
 });


function queueList(FromDate = '', ToDate = '',SrchProcedures= '',SrchPayMode='') {
    $.ajax({
        url: "{{ url('viewConsultationCharges') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            FromDate: FromDate,
            ToDate: ToDate,
            SrchProcedures:SrchProcedures,
            SrchPayMode:SrchPayMode
        },
        success: function(data) {
            console.log(data);
            $('#custresult').html(data);
        }
    });
}

function getProcRec() {
    $.ajax({
        method: "POST",
        url: "{{ url('getProcRec') }}",
        data: {
            _token: '{{csrf_token()}}'
        },
        success: function(data) {
            //console.log(data);
            $('#custresult2').html(data);
        }
    });
}

function getProcedureDetails(val){
    $.ajax({
        method: "POST",
        url: "{{ url('getProcedureDetails') }}",
        data: {
            _token: '{{csrf_token()}}',
            val:val
        },
        success: function(data) {
            console.log(data);
            $('#Amount').val(data);
        }
    });
}

function getProcRec2(id) {
    $.ajax({
        method: "POST",
        url: "{{ url('getProcRec2') }}",
        data: {
            _token: '{{csrf_token()}}',
            id:id
        },
        success: function(data) {
            //console.log(data);
            $('#custresult2').html(data);
        }
    });
}

$(document).ready(function() {
    $('#modal-report').modal('show');
    queueList();

    $(document).on("input", "#MrdNo", function(event) {
        var val = this.value;
        $.ajax({
            url: "{{ url('getPatientDetails') }}",
            method: "POST",
            data: {
                _token: '{{csrf_token()}}',
                id: val
            },
            dataType: "json",
            success: function(data) {
                //console.log(data);
               
                $('#MrdNo').val(data.MrdNo);
                $('#PatientName').val(data.PatientName);
                $('#ConsultantId').val(data.Consultant);
                $('#Consultant').val(data.ConsultantName);
        
             
            }
        });

    });

    $('#add_button').click(function() {
        getProcRec();
        var CurrDate = $('#CurrDate').val();
        $('.modal-title').html("Add <span class='font-weight-light'>Receipt</span>");
        $('#action').val("Save");
        $('#id').val('');
        $('#PatientId').val('');
        $('#MrdNo').val('');
        $('#PatientName').val('');
        $('#AgeGender').val('');
        $('#Amount').val('').attr("selected", true);
        $('#ChequeNo').val('');
        $('#Narration').val('');
        $('#Procedures').val('');
        $('#CreatedDate').val(CurrDate)
        $('#PayMode').val('').attr("selected", true);
        $('#submit').text('Submit');

    })

    $('#validation-form').on('submit', function(e) {
        e.preventDefault();
        var btnaction = $('#btnaction').val();
        if ($('#validation-form').valid()) {
            $.ajax({
                url: "{{ url('saveConsultationCharges') }}",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                processData: false,
                beforeSend: function() {
                    $('#'+btnaction).attr('disabled', 'disabled');
                    $('#'+btnaction).text('Please Wait...');
                },
                success: function(data) {

                    //console.log(data);exit();
                    var res = JSON.parse(data);
                    var status = res.status;
                    var today = res.today;
                    var total = res.total;
                    var id = res.id;
                    if (status == 1) {
                        $('#modal-report').modal('hide');
                        success_toast();
                        queueList();
                        $('#today').html('Todays Total Receipt : '+today);
                        $('#total').html(' Total Receipt : '+total);
                        if(btnaction == 'print'){
                            setTimeout(function () {
    window.open(
        '/{{projectUrl()}}consultationChargesPrint/'+id, 'name', 'toolbar=1, scrollbars=1, location=1,statusbar=0, menubar=1, resizable=1, width=900, height=1000'
    );
}, 1);
                        }
                        //window.location.href="ipd-receipt.php";
                        //window.open('ipd-receipt-print.php?id='+id,'_blank');
                    } else {
                        error_toast();
                        $('#modal-report').modal('show');
                    }
                    $('#'+btnaction).attr('disabled', false);
                    $('#'+btnaction).text('Submit');
                }
            });
        }
    });

    $(document).on("click", ".update", function(event) {
        event.preventDefault();
        event.stopPropagation();
        var id = $(this).attr("data-id");
        $.ajax({
            url: "{{ url('fetchConsultationChargesRecord') }}",
            method: "POST",
            data: {
                _token: '{{csrf_token()}}',
                id: id
            },
            dataType: "json",
            success: function(data) {
                //console.log(data);
                //alert(data.Procedures);
                $('#PatientId').val(data.PatientId).attr("selected",true);
                $('#IpdNo').val(data.IpdNo);
                $('#MrdNo').val(data.MrdNo);
                $('#PatientName').val(data.PatientName);
                $('#Procedures').val(data.Procedures);
                $('#Amount').val(data.Amount).attr("selected", true);
                $('#PayMode').val(data.PayMode).attr("selected", true);
                $('#ChequeNo').val(data.ChequeNo);
                $('#Narration').val(data.Narration);
                $('#CreatedDate').val(data.CreatedDate);
                $('#AdmissionTime').val(data.AdmissionTime);
                $('#DepositDate').val(data.DepositDate);
                $('#DepositTime').val(data.DepositTime);
                $('#action').val('Edit');

                $('#id').val(id);
                getProcRec2(id);
                $('#submit').text("Update");
                $('#modal-report').modal('show');
                $('.modal-title').html(
                    "Update <span class='font-weight-light'>Receipt</span>");

            }
        });
    });



    $(document).on("click", ".delete", function(event) {
        event.preventDefault();
        var id = $(this).attr("data-id");
        var action = "delete";
        //alert(id);
        swal({
            title: "Are you sure?",
            text: "You will not be able to recover this Charges!",
            type: "warning",
            showCancelButton: true,
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Yes, delete",
            cancelButtonText: "No, cancel",
            closeOnConfirm: false,
            closeOnCancel: false
        }, function(isConfirm) {
            if (isConfirm) {
                $.ajax({
                    url: "{{ url('deleteConsultationCharges') }}",
                    method: "POST",
                    data: {
                        _token: '{{csrf_token()}}',
                        id: id
                    },

                    success: function(data) {
                        var res = JSON.parse(data);
                        var status = res.status;
                        var today = res.today;
                        var total = res.total;
                        queueList();
                        $('#today').html('Todays Total Receipt : '+today);
                        $('#total').html(' Total Receipt : '+total);
                        swal("Deleted!", "Receipt has been deleted.", "success");

                    }
                });

            } else {
                swal("Cancelled", "Receipt is safe :)", "error");
            }
        });
    });

});
</script>
</script>
