@include('header')
<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold py-3 mb-0">Add Investigation</h4>

    <form id="validation-form" method="POST" action="">

        <input type="hidden" name="action" id="action" value="Save">
        <input type="hidden" name="saveid" id="saveid" value="">
        @csrf
        <div class="card mb-12 mb-4">
            <div class="card-body">
                <div class="row">


                    <div class="col-sm-2">
                        <div class="form-group">
                            <label>Mrd. No <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="MrdNo" id="MrdNo" placeholder="" value="">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label class="floating-label" for="Name">Patient Name <span
                                    class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="PatientName" id="PatientName" placeholder=""
                                value="">
                        </div>
                    </div>
                    <div class="col-sm-2">
                        <div class="form-group">
                            <label class="floating-label" for="Name">Phone <span
                                    class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="Phone" id="Phone" placeholder=""
                                value="">
                        </div>
                    </div>




                    <div class="col-sm-2">
                        <div class="form-group">
                            <label class="floating-label" for="Phone">Date <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" id="VisitDate" Name="VisitDate"
                                value="{{date('Y-m-d')}}" placeholder="" required>
                        </div>
                    </div>
                    </div>

                     <div class="row">
                <div class="col-lg-9">
                    <div class="form-group">
                         <label class="floating-label" for="Phone">Investigation <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" placeholder="" name="InvStName" id="InvStName"
                            value="">

                    </div>
                </div>
                <div class="col-lg-2">
                    <div class="form-group">
                        <label class="floating-label" for="Phone">Amount <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" placeholder="Amount" name="Amount"
                            id="InvStAmount" value="" readonly>

                    </div>
                </div>
                <div class="col-lg-1" style="padding-left: 5px;">
                    <span class="input-group-append">
                        <button class="btn btn-secondary" type="button" onclick="investigationLists()"
                            id="invst_add_button">...</button>
                    </span>
                </div>
            </div>
                    

                    <div class="row">
                    <div class="col-sm-6" style="padding-top:20px;">
                        <button class="btn btn-primary" type="submit" name="submit" id="submit">Save</button>
                       
                    </div>
                    <input type="hidden" id="CurrDate" value="{{date('Y-m-d')}}">

                </div>
            </div>



    </form>


</div>

<script src="{{url('assets/js/jquery-3.6.0.min.js')}}"></script>
@include('masters/incinvestigationmodal')
@include('footerscript')
<script>
    function investigationLists() {
    $.ajax({
        url: "{{ url('investigationLists') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}'
        },
        success: function(data) {
            //console.log(data);
            $('#investigationresult').html(data);
            $('#modal-report-invst').modal("show");
        }
    });

}
   
function success_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.notice({
        title: 'Success',
        message: 'New Investigation Created Successfully!',
        location: isRtl ? 'tl' : 'tr'
    });
}

function error_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.error({
        title: 'Error',
        message: 'Record Not Saved',
        location: isRtl ? 'tl' : 'tr'
    });
}

$(document).ready(function() {
    $('#validation-form').on('submit', function(e) {
        e.preventDefault();
        if ($('#validation-form').valid()) {
            $.ajax({
                url: "{{ url('saveInvestigations') }}",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                processData: false,
                beforeSend: function() {
                    $('#submit').attr('disabled', 'disabled');
                    $('#submit').text('Please Wait...');
                },
                success: function(data) {
                    var res = JSON.parse(data);
                    $('#saveid').val(res.id);
                    $('#action').val('Edit');
                    if (res.Status == 1) {
                        success_toast();
                        window.location.href = "{{ url('InvestigationList') }}";
                    } else {
                        error_toast();
                    }
                    $('#submit').attr('disabled', false);
                    $('#submit').text('Save');
                }
            });
        }
    });


$(document).on("input", "#MrdNo", function(event) {
    var val = this.value;
    $.ajax({
        url: "{{ url('getPatientDetails') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            id: val
        },
        dataType: "json",
        success: function(data) {
            //console.log(data);
            $('#MrdNo').val(data.MrdNo);
            $('#PatientName').val(data.PatientName);
            $('#Phone').val(data.Phone);

        }
    });

});

});
</script>