@php
$UserId = Session::get('UserId');
@endphp
<table id="example" class="table table-striped table-bordered" style="width:100%">
    <thead>
        <tr>
             {{-- <th>#</th>  --}}
            <th>Sr No</th>
            <th>Mrd. No</th>
            <th>Patient Name</th>
            <th>Investigation Name</th>
            <th>Amount</th>
            <th>Date</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        @php 
            $i = 1;
            $total = 0;
            $total1 = 0;
        @endphp

        @foreach($data as $result)
            @php 
                $total += $result->Amount;
                if ($result->InvMoneyReceived == 1) {
                    $total1 += $result->Amount;
                }
                $bgcolor = match(true) {
                    $result['InvCheckout'] == 1 => "background-color: green;color:white;",
                    $result['InvMoneyReceived'] == 1 => "background-color: yellow;",
                    default => "background-color: blue;color:white;"
                };
            @endphp
            <tr style="{{ $bgcolor }}">
                 {{-- <td style="cursor: pointer;background-color: white;">
                    <label class="custom-control custom-radio">
                        <input type="radio" class="custom-control-input" name="radioinvid" onclick="getInvId({{ $result->id }})">
                        <span class="custom-control-label"></span>
                    </label>
                </td> --}}
                <td>{{ $i }}</td>
                <td>{{ $result->MrdNo }}</td>
                <td>{{ strtoupper(strtolower($result->PatientName)) }}</td>
                <td>{{ $result->InvStName }}</td>
                <td>{{ number_format($result->Amount, 2) }}</td>
                <td>{{ date("d-m-Y", strtotime(str_replace('-', '/', $result->VisitDate))) }}</td>
                <td>
                    <button class="btn btn-success btn-sm" onclick="moneyReceived({{ $result->id }})" style="background-color: yellow;color:black;" @if($result['InvMoneyReceived'] == 1) disabled @endif>Money Received</button>
                    <button class="btn btn-primary btn-sm" onclick="checkout({{ $result->id }})" style="background-color: green;" @if($result['InvMoneyReceived'] == 0 || $result['InvCheckout'] == 1) disabled @endif>Checkout</button>
                      
                    @if($UserId == 58)
                    <!-- <button 
                        class="btn btn-danger btn-sm" 
                        onclick="deleteRecord({{ $result->id }})" style="background-color: red;">
                        Delete
                    </button> -->
                    <button 
    class="btn btn-info btn-sm" 
    data-toggle="modal" 
    data-target="#modal-report2" 
    onclick="editRecord(
        {{ $result->id }},
        '{{ $result->MrdNo }}',
        '{{ addslashes($result->PatientName) }}',
        '{{ addslashes($result->InvStName) }}',
        '{{ $result->Amount }}',
        '{{ date('Y-m-d', strtotime($result->VisitDate)) }}',
        '{{ $result->InvMoneyReceived }}',
        '{{ $result->InvCheckout }}'
    )"
>
    Edit
</button>
                    @endif
                </td>
            </tr>
            @php $i++; @endphp
        @endforeach

        <tr>
            {{-- <th></th> --}}
            <th>{{$i}}</th>
            <th></th>
            <th></th>
            <th style="text-align: right;">Total Amount</th>
            <th>&#8377;{{ number_format($total, 2) }}</th>
            <th></th>
            <th></th>
            <th></th>
        </tr>
        <tr>
        {{-- <th></th> --}}
        <th>{{$i+1}}</th>
            <th></th>
            <th></th>
            <th style="text-align: right;">Received Amount</th>
            <th>&#8377;{{ number_format($total1, 2) }}</th>
            <th></th>
            <th></th>
            <th></th>
        </tr>
        <tr>
        {{-- <th></th> --}}
        <th>{{$i+2}}</th>
            <th></th>
            <th></th>
            <th style="text-align: right;">Not Received Amount</th>
            <th>&#8377;{{ number_format($total-$total1, 2) }}</th>
            <th></th>
            <th></th>
            <th></th>
        </tr>
    </tbody>
</table>

<script type="text/javascript">
$(document).ready(function() {
    $('#example').DataTable({
        "scrollX": true,
        "pageLength": 50,
        dom: 'Bfrtip',
        order: [[0, 'asc']],
        buttons: ['excelHtml5']
    });
});

function moneyReceived(id) {
    $('#modal-report').modal('show');
    getInvId(id);
}

function checkout(id) {
    $('#InvId').val(id);
    checkoutInvst();
}

function deleteRecord(id) {
    var FromDate = $('#FromDate').val();
  var ToDate = $('#ToDate').val();
    if (confirm('Are you sure you want to delete record ID ?')) {
        // Add your AJAX or redirect logic here
         $.ajax({
        url: "{{ url('deleteInvstRecord') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            id: id
        },
        success: function(data) {
          console.log(data);
  queueList(FromDate,ToDate);
        }
    });

    }
}

function editRecord(id, mrdNo, patientName, invStName, amount, visitDate,moneyreceived,checkout) {
    $('#UpInvId').val(id);
    $('#UpMrdNo').val(mrdNo);
    $('#UpPatientName').val(patientName);
    $('#UpProcedures').val(invStName);
    $('#UpAmount').val(amount);
    $('#UpCreatedDate').val(visitDate);
    $('#UpInvMoneyReceived').val(moneyreceived).attr("selected",true);
    $('#UpInvCheckout').val(checkout).attr("selected",true);
    
}
</script>
