@include('header')
@php
$UserId = Session::get('UserId');
@endphp
<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold py-3 mb-0">Investigation List
        <span style="float: right;">
<a href="/addInvestigation" class="btn btn-secondary btn-round"><i class="ion ion-md-add mr-2"></i> Add New</a></span>
         </h4>
    <div class="card mb-4">
        <div class="card-body">
            <div id="alert_message"></div>
            <form method="post" enctype="multipart/form-data">
                <div class="form-row">
                   
                    <div class="form-group col-md-2">
                        <label class="form-label">From Date </label>
                        <input type="date" name="FromDate" id="FromDate" class="form-control" value="{{date('Y-m-d')}}"
                            autocomplete="off">
                    </div>
                     <div class="form-group col-md-2">
                        <label class="form-label">To Date</label>
                        <input type="date" name="ToDate" id="ToDate" class="form-control" value="{{date('Y-m-d')}}" autocomplete="off">
                    </div> 
                    <input type="hidden" name="Search" value="Search">
                    <div class="form-group col-md-5" style="padding-top:20px;">
                    <button type="button" class="btn btn-primary btn-finish"
                            id="filter">Search</button>
                            
                            
                           <button type="button" class="btn btn-primary btn-finish" data-toggle="modal"
                           data-target="#modal-report" id="moneyreceived" disabled
                           >Money Received</button>
                           <button type="button" class="btn btn-primary btn-finish" disabled id="checkout"
                         onclick="checkoutInvst()"  >Checkout</button>
                         <a href="/InvestigationList" type="button" class="btn btn-primary btn-finish"
                         >Refesh</a>
                    </div>
                </div>

            </form>
           
            <div class="table-responsive" id="custresult">


            </div>
        </div>
    </div>

    <div class="modal fade" id="modal-report" tabindex="-1" role="dialog" aria-labelledby="myExtraLargeModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" style="max-width: 70rem; ">
        <div class="modal-content">


            <div class="modal-header">
                <h5 class="modal-title">OPD Investigation Receipt</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="validation-form" method="POST" action="">
                    @csrf
                    <input type="hidden" name="action" id="action" value="Save">
                    <input type="hidden" name="InvId" id="InvId" />
                    <input type="hidden" name="ConsultantId" id="ConsultantId" />
                    <input type="hidden" name="Consultant" id="Consultant" />
                    <div class="row">
                        
                   
                        <div class="col-sm-2">
                            <div class="form-group">
                                <label>Mrd. No <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="MrdNo" id="MrdNo" placeholder=""
                                    >
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label class="floating-label" for="Name">Patient Name <span
                                        class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="PatientName" id="PatientName"
                                    placeholder="">
                            </div>
                        </div>

                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="floating-label" for="gender">Procedures <span
                                        class="text-danger">*</span></label>
                                        <input class="form-control" list="DataList2" name="Procedures" id="Procedures" onchange="getProcedureDetails(this.value)">
                                
                            </div>
                        </div>

                        <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="Phone">Amount <span
                                        class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="Amount" Name="Amount" placeholder="" required readonly>
                            </div>
                        </div>

                        <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="Phone">Date <span
                                        class="text-danger">*</span></label>
                                <input type="date" value="{{date('Y-m-d')}}" class="form-control" id="CreatedDate" Name="CreatedDate" placeholder="" required>
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="gender">Payment Mode <span
                                        class="text-danger">*</span></label>
                                <select class="form-control" id="PayMode" name="PayMode" required>
                                    <option value=""></option>
                                    <option value="Cash">Cash</option>
                                    <!-- <option value="Card">Card</option> -->
                                    <option value="Mobile Payment">Mobile Payment</option>
                                </select>
                            </div>
                        </div>
                        <!-- <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="Phone">Cheque No</label>
                                <input type="text" class="form-control" id="ChequeNo" Name="ChequeNo" placeholder="">
                            </div>
                        </div> -->
                        
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="floating-label" for="gender">Transaction ID </label>
                                <input type="text" class="form-control" id="Narration" Name="Narration" placeholder=""
                                    >
                            </div>
                        </div>
                        <div class="col-sm-12" >
                            <button class="btn btn-primary" type="submit" name="submit" id="submit" onclick="btnaction2('submit')">Submit</button>
                            <button class="btn btn-danger" type="reset">Clear</button>
                            <button class="btn btn-success" type="submit" name="submit" id="print" onclick="btnaction2('print')">Print</button>
                        </div><br>
                        <!-- <div class="col-sm-12" id="custresult2" style="padding-top: 25px;">

                        </div> -->

                    <input type="hidden" id="CurrDate" value="{{date('Y-m-d')}}">
                    <input type="hidden" id="btnaction" value="submit">
                    <input type="hidden" name="Roll" value="2">
                    
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-report2" tabindex="-1" role="dialog" aria-labelledby="modalReportLabel" aria-hidden="true">
    <div class="modal-dialog" style="max-width: 50rem;">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modalReportLabel">Update OPD Investigation</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form method="POST" action="">
                    @csrf
                    <input type="hidden" name="UpInvId" id="UpInvId">

                    <div class="row">
                        <div class="col-sm-3">
                            <div class="form-group">
                                <label>Mrd. No <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="UpMrdNo" id="UpMrdNo" readonly>
                            </div>
                        </div>

                        <div class="col-sm-6">
                            <div class="form-group">
                                <label>Patient Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="UpPatientName" id="UpPatientName" readonly>
                            </div>
                        </div>

                        <div class="col-sm-3">
                            <div class="form-group">
                                <label>Date <span class="text-danger">*</span></label>
                                <input type="date" class="form-control" name="UpCreatedDate" id="UpCreatedDate" required>
                            </div>
                        </div>

                        <div class="col-sm-9">
                            <div class="form-group">
                                <label>Procedures <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="UpProcedures" id="UpProcedures"  @if($UserId != 58) readonly @endif required>
                            </div>
                        </div>

                        <div class="col-sm-3">
                            <div class="form-group">
                                <label>Amount <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="UpAmount" id="UpAmount"  @if($UserId != 58) readonly @endif required>
                            </div>
                        </div>
                        
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label class="floating-label" for="gender">Money Received Status <span
                                        class="text-danger">*</span></label>
                                <select class="form-control" id="UpInvMoneyReceived" name="UpInvMoneyReceived" required>
                                    
                                    <option value="1">Received</option>
                                    
                                    <option value="0">Not Received</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-sm-4">
                            <div class="form-group">
                                <label class="floating-label" for="gender">Checkout Status <span
                                        class="text-danger">*</span></label>
                                <select class="form-control" id="UpInvCheckout" name="UpInvCheckout" required>
                                    
                                    <option value="1">Out</option>
                                    
                                    <option value="0">Not Out</option>
                                </select>
                            </div>
                        </div>
                        

                        <div class="col-sm-12">
                            <button class="btn btn-primary" type="button" id="updatebutton" onclick="updateInvestigation()">Submit</button>
                            <button class="btn btn-danger" type="reset">Clear</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


</div>

@include('footerscript')
@include('excelscript')
<script type="text/javascript">
    function updateInvestigation(){
    var UpInvId = $('#UpInvId').val();
    var UpCreatedDate = $('#UpCreatedDate').val();
    var UpProcedures = $('#UpProcedures').val();
    var UpAmount = $('#UpAmount').val();
    var UpInvCheckout = $('#UpInvCheckout').val();
    var UpInvMoneyReceived = $('#UpInvMoneyReceived').val();
    var FromDate = $('#FromDate').val();
  var ToDate = $('#ToDate').val();
    $.ajax({
        url: "{{ url('updateInvestigation') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            id: UpInvId,
            UpCreatedDate:UpCreatedDate,
            UpProcedures:UpProcedures,
            UpAmount:UpAmount,
            UpInvCheckout:UpInvCheckout,
            UpInvMoneyReceived:UpInvMoneyReceived
        },
        beforeSend: function() {
                    $('#updatebutton').attr('disabled', 'disabled');
                    $('#updatebutton').text('Please Wait...');
                },
        success: function(data) {
          console.log(data);
          $('#updatebutton').attr('disabled', false);
                    $('#updatebutton').text('Submit');
           $('#modal-report2').modal('hide');
                        success_toast();
  queueList(FromDate,ToDate);
        }
    });
}
function checkoutInvst(){
    var id = $('#InvId').val();
    var FromDate = $('#FromDate').val();
  var ToDate = $('#ToDate').val();
    $.ajax({
        url: "{{ url('checkoutInvst') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            id: id
        },
        success: function(data) {
          console.log(data);
  queueList(FromDate,ToDate);
        }
    });
}
function isNumberKey(evt) {
    var charCode = (evt.which) ? evt.which : evt.keyCode
    if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
    return true;
}

function success_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.notice({
        title: 'Success',
        message: 'New Expenses Added Successfully!',
        location: isRtl ? 'tl' : 'tr'
    });
}

function error_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.error({
        title: 'Error',
        message: 'Expenses Already Exists',
        location: isRtl ? 'tl' : 'tr'
    });
}


function getInvId(id){
    $('#InvId').val(id);
    $('#moneyreceived').attr('disabled',false);
    $('#checkout').attr('disabled',false);
    $.ajax({
        url: "{{ url('getInvstPtDetails') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            id: id
        },
        success: function(data) {
            console.log(data);
            var res = JSON.parse(data);
            $('#InvId').val(res.id);
            $('#MrdNo').val(res.MrdNo);
            $('#PatientName').val(res.PatientName);
            $('#Procedures').val(res.InvStName);
            $('#Amount').val(res.Amount);
            $('#Narration').val(res.Narration);
            $('#PayMode').val(res.PayMode).attr("selected",true);
            $('#action').val(res.action);
        }
    });
}

$(document).ready(function() {
    var FromDate = $('#FromDate').val();
  var ToDate = $('#ToDate').val();
  queueList(FromDate,ToDate);

    $('#filter').click(function(){
  var FromDate = $('#FromDate').val();
  var MrdNo = $('#MrdNo').val();
  var ToDate = $('#ToDate').val();
  if(FromDate != '')
  {
   //$('.yajra-datatable').DataTable().destroy();
   //load_data(FromDate, ToDate);
   queueList(FromDate,ToDate);
  }
  else
  {
   alert('Date is required');
  }
 });

 $('#refresh').click(function(){
  $('#FromDate').val('');
  //$('.yajra-datatable').DataTable().destroy();
  //load_data();
  queueList();
 });

 
 $('#validation-form').on('submit', function(e) {
        e.preventDefault();
        var btnaction = $('#btnaction').val();
        var FromDate = $('#FromDate').val();
  var ToDate = $('#ToDate').val();

        if ($('#validation-form').valid()) {
            $.ajax({
                url: "{{ url('saveOpdReceipt') }}",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                processData: false,
                beforeSend: function() {
                    $('#'+btnaction).attr('disabled', 'disabled');
                    $('#'+btnaction).text('Please Wait...');
                },
                success: function(data) {

                    //console.log(data);exit();
                    var res = JSON.parse(data);
                    var status = res.status;
                    var today = res.today;
                    var total = res.total;
                    var id = res.id;
                    if (status == 1) {
                        $('#modal-report').modal('hide');
                        success_toast();
                        queueList(FromDate,ToDate);
                        //$('#today').html('Todays Total Receipt : '+today);
                       // $('#total').html(' Total Receipt : '+total);
                        if(btnaction == 'print'){
                            setTimeout(function () {
    window.open(
        '/{{projectUrl()}}opdReceiptPrint/'+id, 'name', 'toolbar=1, scrollbars=1, location=1,statusbar=0, menubar=1, resizable=1, width=900, height=1000'
    );
}, 1);
                        }
                        //window.location.href="ipd-receipt.php";
                        //window.open('ipd-receipt-print.php?id='+id,'_blank');
                    } else {
                        error_toast();
                        $('#modal-report').modal('show');
                    }
                    $('#'+btnaction).attr('disabled', false);
                    $('#'+btnaction).text('Submit');
                }
            });
        }
    });

});

function queueList(FromDate = '',ToDate='') {
    //alert(FromDate);alert(MrdNo);
    $.ajax({
        url: "{{ url('viewInvestigationPatientList') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            FromDate: FromDate,
            ToDate:ToDate
        },
        success: function(data) {
            console.log(data);
            $('#custresult').html(data);
        }
    });
}


</script>
