@include('header')
<style type="text/css">
fieldset legend {
    background: inherit;
    font-family: "Lato", sans-serif;
    color: #650812;
    font-size: 15px;
    left: 10px;
    padding: 0 10px;
    position: absolute;
    top: -12px;
    font-weight: 400;
    width: auto !important;
    border: none !important;
}

fieldset {
    background: #ffffff;
    border: 1px solid #C43853;
    border-radius: 5px;
    margin: 20px 0 1px 0;
    padding: 13px;
    position: relative;
}

.form-control {
    min-height: 1px;
    height: 25px;

    font-size: 17px;
}


.table th,
.table td {
    padding: 0.325rem;
    font-weight: bold;
}

label {
    font-weight: bold;
}

.select {
    height: 32px;
}

.btnpadding {
    padding: 3px;
}

.btnpadding2 {
    padding: 5px;
}
</style>
<div class="container-fluid flex-grow-1 container-p-y">
    <!-- <h4 class="font-weight-bold py-3 mb-0">O.T Schedule</h4> -->

    <div class="nav-tabs-top mb-4">
        <ul class="nav nav-tabs">
            <li class="nav-item">
                <a class="nav-link active" data-toggle="tab" href="#tab1">O.T. Schedule Form</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" data-toggle="tab" href="#tab2">O.T. Schedule List</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" data-toggle="tab" href="#tab3" onclick="tab3()">Postpone O.T. List</a>
            </li>
            <!-- <li class="nav-item">
                <a class="nav-link" data-toggle="tab" href="#tab3">OPD Summary Report 2</a>
            </li> -->

        </ul>
        <div class="tab-content">
            <div class="tab-pane fade show active" id="tab1">
                <div class="row">
                    <!-- customar project  start -->
                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-body">

                                <form id="validation-form" novalidate="novalidate" method="POST"
                                    enctype="multipart/form-data" autocomplete="off" action="">
                                    <input type="hidden" name="action" id="action" value="Save">

                                    @csrf
                                    <div class="form-row">
                                        <div class="form-group col-md-1">
                                            <label class="floating-label" for="Name">ID </label>
                                            <input class="form-control" list="DataList2" name="id" id="id"
                                                oninput="getCounselDetails()">
                                            <datalist id="DataList2">
                                                @foreach($otschid as $result)
                                                <option value="{{$result->id}}">
                                                    @endforeach
                                            </datalist>


                                        </div>


                                        <div class="form-group col-md-1" style="margin-bottom: 0rem;">
                                            <label class="floating-label" for="Name">MRD No <span
                                                    class="text-danger">*</span></label>
                                            <input name="MrdNo" type="text" class="form-control" id="MrdNo" value=""
                                                placeholder="" oninput="get">

                                        </div>
                                        <div class="form-group col-md-2" style="margin-bottom: 0rem;">
                                            <label class="floating-label" for="Name">Patient Name <span
                                                    class="text-danger">*</span></label>
                                            <input name="PatientName" type="text" class="form-control" id="PatientName"
                                                value="" placeholder="">

                                        </div>
                                        <div class="form-group col-md-3" style="margin-bottom: 0rem;">
                                            <label class="floating-label" for="Name">Scheudle Date <span
                                                    class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <input type="date" class="form-control" name="ScheduleDate"
                                                    id="ScheduleDate" value="{{date('Y-m-d')}}">
                                                <span class="input-group-append" style="height: 25px;line-height: 1px;">
                                                    <button class="btn btn-secondary" type="button"
                                                        onclick="otSchList()" style="line-height: 1px;">View OT
                                                        List</button>
                                                </span>
                                            </div>

                                        </div>
                                        <div class="form-group col-md-2" style="margin-bottom: 0rem;">
                                            <label class="floating-label" for="Name">Contact No <span
                                                    class="text-danger">*</span></label>
                                            <input name="Phone" type="text" class="form-control" id="Phone" value=""
                                                placeholder="">
                                            <input type="hidden" name="Age" id="Age" value="">
                                            <input type="hidden" name="Address" id="Address" value="">
                                            <input type="hidden" name="Gender" id="Gender" value="">
                                        </div>

                                        <div class="form-group col-md-3" style="margin-bottom: 0rem;">
                                            <label class="floating-label" for="Name">Lock Date <span
                                                    class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <!-- <span class="input-group-prepend">
                                                    <input name="Phone" type="date" class="form-control" id="Phone"
                                                        value="" placeholder="">
                                                </span> -->

                                                <input name="FixedDate" type="date" class="form-control" id="FixedDate"
                                                    value="" placeholder="">
                                                <span class="input-group-append" style="height: 25px;line-height: 1px;">
                                                    <button class="btn btn-secondary" type="button"
                                                        onclick="fixedDate()" style="line-height: 1px;">Fixed</button>
                                                </span>
                                            </div>
                                        </div>


                                    </div>


                                    <div class="row">
                                        <div class="col-md-4"
                                            style="margin-bottom: 0rem;padding-right: 1px;padding-left: 1px;">

                                            <fieldset>
                                                <legend>Biometry & Keratometry</legend>
                                                <table class="table table-bordered table-striped mb-0">
                                                    <thead>
                                                        <tr>
                                                            <td width="10" align="left" valign="top">AL </td>
                                                            <td width="100" align="left" valign="top"><input name="AL"
                                                                    type="text" class="form-control" id="AL" value=""
                                                                    placeholder=""></td>
                                                            <td width="10" align="left" valign="top">K1 </td>
                                                            <td width="75" align="left" valign="top"><input name="K1Re"
                                                                    type="text" class="form-control" id="K1Re" value=""
                                                                    placeholder=""></td>
                                                            <td width="75" align="left" valign="top"><input name="K1Le"
                                                                    type="text" class="form-control" id="K1Le" value=""
                                                                    placeholder=""></td>
                                                        </tr>
                                                        <tr>
                                                            <td width="10" align="left" valign="top">ACD </td>
                                                            <td width="50" align="left" valign="top"><input name="Acd"
                                                                    type="text" class="form-control" id="Acd" value=""
                                                                    placeholder=""></td>
                                                            <td width="50" align="left" valign="top">K2 </td>
                                                            <td width="50" align="left" valign="top"><input name="K2Re"
                                                                    type="text" class="form-control" id="K2Re" value=""
                                                                    placeholder=""></td>
                                                            <td width="50" align="left" valign="top"><input name="K2Le"
                                                                    type="text" class="form-control" id="K2Le" value=""
                                                                    placeholder=""></td>
                                                        </tr>
                                                        <tr>
                                                            <td width="10" align="left" valign="top">LT </td>
                                                            <td width="50" align="left" valign="top"><input name="LT"
                                                                    type="text" class="form-control" id="LT" value=""
                                                                    placeholder=""></td>
                                                            <td width="50" align="left" valign="top">Diff </td>
                                                            <td width="50" align="left" valign="top" colspan="2"><input
                                                                    name="Diff" type="text" class="form-control"
                                                                    id="Diff" value="" placeholder=""></td>
                                                        </tr>
                                                        <tr>
                                                            <td width="10" align="left" valign="top">WTW </td>
                                                            <td width="50" align="left" valign="top"><input name="Wtw"
                                                                    type="text" class="form-control" id="Wtw" value=""
                                                                    placeholder=""></td>
                                                            <td width="50" align="left" valign="top">A Constant </td>
                                                            <td width="50" align="left" valign="top" colspan="2"><input
                                                                    name="Aconstant" type="text" class="form-control"
                                                                    id="Aconstant" value="" placeholder=""></td>
                                                        </tr>

                                                    </thead>
                                                </table>
                                            </fieldset>
                                        </div>
                                        <!-- 
                                        <div class="col-md-2"
                                            style="margin-bottom: 0rem;padding-right: 1px;padding-left: 1px;">

                                            <fieldset>
                                                <legend>Keratometry</legend>
                                                <table class="table table-bordered table-striped mb-0">
                                                    <thead>
                                                        
                                                    </thead>
                                                </table>
                                            </fieldset>
                                        </div> -->

                                        <div class="col-md-3"
                                            style="margin-bottom: 0rem;padding-right: 1px;padding-left: 1px;">

                                            <fieldset>
                                                <legend>IOl Details </legend>
                                                <table class="table table-bordered table-striped mb-0">
                                                    <thead>
                                                        <tr>
                                                            <td width="20" align="left" valign="top">Eye</td>
                                                            <td width="150" align="left" valign="top" colspan="2">
                                                                <select class="form-control" name="Eye" id="Eye"
                                                                    style="height: 33px;">
                                                                    <option selected="" value="">...
                                                                    </option>
                                                                    <option value="RE">RE
                                                                    </option>
                                                                    <option value="LE">LE
                                                                    </option>
                                                                    <option value="BE">BE
                                                                    </option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td width="10" align="left" valign="top">IOL Name </td>
                                                            <td width="50" align="left" valign="top" colspan="2">
                                                                <input type="text" name="IolName"
                                                                    list="DataList" id="IolName"
                                                                    class="form-control" placeholder="" value=""
                                                                    oninput="modelLists()" style="height: 22px;">
                                                                <datalist id="DataList">

                                                                </datalist>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td width="10" align="left" valign="top">IOL Type </td>
                                                            <td width="50" align="left" valign="top" colspan="2">
                                                                <input type="text" name="IolType"
                                                                    list="IolType_DataList" id="IolType"
                                                                    class="form-control" placeholder="" value=""
                                                                    oninput="powerLists()" style="height: 22px;">
                                                                <datalist id="IolType_DataList">

                                                                </datalist>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td width="10" align="left" valign="top">IOL Power </td>
                                                            <td width="50" align="left" valign="top">
                                                                <input type="text" name="IolPower"
                                                                    list="IolPower_DataList" id="IolPower"
                                                                    class="form-control" placeholder="" value=""
                                                                    style="height: 22px;">
                                                                <datalist id="IolPower_DataList">

                                                                </datalist>
                                                                </td>
                                                                <td width="50" align="left" valign="top">
                                                                <input name="Cyl"
                                                                    type="text" class="form-control" id="Cyl" value=""
                                                                    placeholder="Cyl" style="height: 22px;">
                                                            </td>
                                                        </tr>
                                                        

                                                    </thead>
                                                </table>
                                            </fieldset>
                                        </div>

                                        <div class="col-md-5"
                                            style="margin-bottom: 0rem;padding-right: 1px;padding-left: 1px;">

                                            <fieldset style="height: 180px;">
                                                <legend>Investigation</legend>
                                                <table class="table table-bordered table-striped mb-0">
                                                    <thead>
                                                        <tr>
                                                            <td width="10" align="left" valign="top">IOP </td>
                                                            <td width="75" align="left" valign="top"><input name="IopRe"
                                                                    type="text" class="form-control" id="IopRe" value=""
                                                                    placeholder="" style="height: 20px;"></td>
                                                            <td width="75" align="left" valign="top"><input name="IopLe"
                                                                    type="text" class="form-control" id="IopLe" value=""
                                                                    placeholder="" style="height: 20px;"></td>
                                                            <td width="10" align="left" valign="top">B.S </td>
                                                            <td width="50" align="left" valign="top"><input name="Bs"
                                                                    type="text" class="form-control" id="Bs" value=""
                                                                    placeholder="" style="height: 20px;"></td>
                                                            <td width="50" align="left" valign="top">B.P </td>
                                                            <td width="50" align="left" valign="top"><input name="Bp"
                                                                    type="text" class="form-control" id="Bp" value=""
                                                                    placeholder="" style="height: 20px;"></td>

                                                        </tr>

                                                        <tr>
                                                            <td width="20" align="left" valign="top">Package</td>
                                                            <td width="100" align="left" valign="top" colspan="2">
                                                            <input type="text"  style="height: 33px;"
                                                        name="Package" list="package_list" id="Package"
                                                        class="form-control" placeholder="" value=""
                                                        oninput="getPkgDetails(document.getElementById('Package').value)">
                                                    <datalist id="package_list">
                                                    @foreach($packagelist as $result)
                                                    <option value="{{$result->PackageName}}">{{$result->PackageName}}
                                                    </option>
                                                    @endforeach
                                                    </datalist>
                                                                <!-- <select class="form-control" name="Package" id="Package"
                                                                    style="height: 33px;"
                                                                    onchange=getPkgDetails(this.value)>
                                                                    <option selected="" value="">...
                                                                    </option>
                                                                    @foreach($packagelist as $result)
                                                                    <option value="{{$result->PackageName}}">
                                                                        {{$result->PackageName}}
                                                                    </option>
                                                                    @endforeach

                                                                </select> -->
                                                            </td>
                                                            <td width="10" align="left" valign="top">Package Amount </td>
                                                            <td width="50" align="left" valign="top" colspan="3"><input
                                                                    name="Amount" type="text" class="form-control"
                                                                    id="Amount" value="" placeholder=""></td>
                                                        </tr>
                                                        <tr>
                                                        <td width="10" align="left" valign="top">Category </td>
                                                            <td width="50" align="left" valign="top" colspan="2">
                                                                <select class="form-control" name="Category"
                                                                    id="Category" style="height: 33px;">
                                                                    <option selected="" value="">...
                                                                    </option>
                                                                    <option value="Routine">Routine
                                                                    </option>
                                                                    <option value="Cashless">Cashless
                                                                    </option>

                                                                </select>
                                                            </td>
                                                            <td width="20" align="left" valign="top">Anaethetia</td>
                                                            <td width="50" align="left" valign="top" colspan="3">
                                                                <select class="form-control" name="Ga" id="Ga"
                                                                    style="height: 33px;">
                                                                    <option selected="" value="">...
                                                                    </option>
                                                                    <option value="Yes">Yes
                                                                    </option>
                                                                    <option value="No">No
                                                                    </option>

                                                                </select>
                                                            </td>
                                                            <!-- <td width="10" align="left" valign="top">CYL </td>
                                                            <td width="50" align="left" valign="top" colspan="3"><input name="Cyl"
                                                                    type="text" class="form-control" id="Cyl" value=""
                                                                    placeholder="" style="height: 22px;"></td> -->
                                                        </tr>
                                                        <!-- <tr>
                                                        <td width="10" align="left" valign="top">ADD </td>
                                                            <td width="50" align="left" valign="top" colspan="2"><input name="AddIol"
                                                                    type="text" class="form-control" id="AddIol" value=""
                                                                    placeholder="" style="height: 22px;"></td>
                                                        </tr> -->



                                                    </thead>
                                                </table>
                                            </fieldset>
                                        </div>



                                        <div class="form-group col-md-3"
                                            style="margin-bottom: 0rem;padding-right: 1px;padding-left: 1px;">
                                            <fieldset>
                                                <legend>Diagnosis</legend>
                                                <table id="report-table"
                                                    class="table table-bordered table-striped mb-0">
                                                    <thead>
                                                        <td width="50" align="left" valign="top" colspan="5"><textarea
                                                                name="Diagnosis" class="form-control" id="Diagnosis"
                                                                placeholder=""></textarea></td>
                                                    </thead>
                                                </table>
                                            </fieldset>

                                            <fieldset>
                                                <legend>Advice</legend>
                                                <table id="report-table"
                                                    class="table table-bordered table-striped mb-0">
                                                    <thead>
                                                        <td width="50" align="left" valign="top" colspan="5"><textarea
                                                                name="Advice" class="form-control" id="Advice" value=""
                                                                placeholder=""></textarea></td>
                                                    </thead>
                                                </table>
                                            </fieldset>
                                        </div>

                                        <div class="form-group col-md-9"
                                            style="margin-bottom: 0rem;padding-right: 1px;padding-left: 1px;">


                                            <fieldset>
                                                <legend>Cashless Package</legend>
                                                <div class="table-responsive" style="overflow-x:auto;">
                                                    <table id="report-table"
                                                        class="table table-bordered table-striped mb-0">
                                                        <thead>
                                                            <tr>


                                                                <td width="10" align="left" valign="top">Package Amount
                                                                </td>
                                                                <td width="100" align="left" valign="top"><input
                                                                        name="PkgAmt" type="text" class="form-control"
                                                                        id="PkgAmt" value="" placeholder="">
                                                                </td>

                                                                <td width="10" align="left" valign="top">Insurane
                                                                    Company
                                                                </td>
                                                                <td width="200" align="left" valign="top"><input
                                                                        name="InsComp" type="text" class="form-control"
                                                                        id="InsComp" value="" placeholder="">
                                                                </td>

                                                                <td width="10" align="left" valign="top">Request Amount
                                                                </td>
                                                                <td width="100" align="left" valign="top"><input
                                                                        name="ReqAmt" type="text" class="form-control"
                                                                        id="ReqAmt" value="" placeholder="">
                                                                </td>
                                                            </tr>
                                                            <tr>

                                                                <td width="10" align="left" valign="top">Sanctioned
                                                                    Amount
                                                                </td>
                                                                <td width="100" align="left" valign="top"><input
                                                                        name="SanctAmt" type="text" class="form-control"
                                                                        id="SanctAmt" value="" placeholder="">
                                                                </td>

                                                                <td width="10" align="left" valign="top">Additional Amt
                                                                    Paid
                                                                    from Patient
                                                                </td>
                                                                <td width="100" align="left" valign="top"><input
                                                                        name="AddAmt" type="text" class="form-control"
                                                                        id="AddAmt" value="" placeholder="">
                                                                </td>

                                                                <td width="10" align="left" valign="top">Settle Amount
                                                                </td>
                                                                <td width="200" align="left" valign="top"><input
                                                                        name="SettleAmt" type="text"
                                                                        class="form-control" id="SettleAmt" value=""
                                                                        placeholder="">
                                                                </td>

                                                            </tr>
                                                            <tr>
                                                                <td width="10" align="left" valign="top">Settle Date
                                                                </td>
                                                                <td width="100" align="left" valign="top"><input
                                                                        type="date" class="form-control"
                                                                        name="SettleDate" id="SettleDate" value=""></td>
                                                                <td width="10" align="left" valign="top">UTR No </td>
                                                                <td width="100" align="left" valign="top"><input
                                                                        name="UtrNo" type="text" class="form-control"
                                                                        id="UtrNo" value="" placeholder="">
                                                                </td>

                                                              
                                                                <td width="100" align="left" valign="top" colspan="1">
                                                                    <input type="checkbox" class="" name="PostPone" id="PostPone"
                                                                        value="1" 
                                                                        style="transform: scale(1);margin-left: 10px;margin-right: 10px;">
                                                                        <label for="PostPone">PostPone</label>
                                                                  
                                                                </td>
                                                                <td width="150" align="left" valign="top">
                                                                <select class="form-control" name="Language" id="Language"
                                                                    style="height: 40px;">
                                                                    
                                                                    <option value="1">Marathi
                                                                    </option>
                                                                    <option value="2">Hindi
                                                                    </option>
                                                                    <option value="3">English
                                                                    </option>
                                                                </select>
                                                            </td>
                                                            </tr>
                                                        </thead>

                                                    </table>

                                                </div>

                                            </fieldset>
                                            <fieldset style="padding-top: 1px;">
                                                <table id="report-table"
                                                    class="table table-bordered table-striped mb-0">
                                                    <thead>
                                                        <tr>


                                                            <td width="10" align="left" valign="top">Consultant
                                                            </td>
                                                            <td width="150" align="left" valign="top"><input
                                                                    name="Consultant" type="text" class="form-control"
                                                                    id="Consultant" value="" placeholder="">
                                                            </td>
                                                            <td align="center" style="padding-top: 10px;"><button
                                                                    type="button" id="preopt_notes"
                                                                    class="btn btn-primary btn-finish btnpadding"
                                                                    onclick="preOptNotes()" disabled>Pre-Operative
                                                                    Prescription</button></td>
                                                            <td align="center"><button type="button"
                                                                    class="btn btn-primary btn-finish btnpadding"
                                                                    onclick="surgicalPresc()" id="surgical_presc"
                                                                    disabled>Surgical
                                                                    Prescription</button>
                                                                <button class="btn btn-secondary" type="button"
                                                                    data-toggle="modal" data-target="#modal-report656"
                                                                    id="add-drugs" onclick="addNewDrug()">+</button>
                                                            </td>
                                                            <td align="center" valign="top">
                                                                <button name="submit" type="submit" id="submit"
                                                                    class="btn btn-primary btn-finish btnpadding2">Save</button>
                                                                <button type="button"
                                                                    class="btn btn-primary btn-finish btnpadding2"
                                                                    onclick="refresh()">Refresh</button>
                                                                <button type="button" id="delete"
                                                                    onclick="deleteRecord()"
                                                                    class="btn btn-primary btn-finish btnpadding2"
                                                                    disabled>Delete</button>


                                                            </td>

                                                        </tr>
                                                    </thead>
                                                </table>
                                            </fieldset>

                                        </div>

                                    </div>




                                </form>

                                <input type="hidden" id="CurrDate" value="{{date('Y-m-d')}}">
                            </div>
                        </div>
                    </div>
                    <!-- customar project  end -->
                </div>
            </div>

            <div class="tab-pane fade" id="tab2">
                <div class="card-body">
                    <form id="validation-form33" method="post" enctype="multipart/form-data">
                        <div class="form-row">

                            <div class="form-group col-md-2">
                                <label class="form-label">From Date </label>
                                <input type="date" name="FromDate" id="FromDate" class="form-control"
                                    value="{{date('Y-m-d')}}" autocomplete="off" required>
                            </div>
                            <div class="form-group col-md-2">
                                <label class="form-label">To Date</label>
                                <input type="date" name="ToDate" id="ToDate" class="form-control"
                                    value="{{date('Y-m-d')}}" autocomplete="off" required>
                            </div>

                            <input type="hidden" name="Search" value="Search">
                            <div class="form-group col-md-2" style="padding-top:20px;">
                                <button type="button" id="filter" class="btn btn-primary btn-finish">Search</button>
                            </div>
                        </div>

                    </form>

                    <div class="card">
                        <div class="card-body">


                            <div class="table-responsive" id="custresult">


                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="tab-pane fade" id="tab3">
                <div class="card-body">
                     <form id="validation-form44" method="post" enctype="multipart/form-data">
                     @csrf
                        <div class="form-row">

                            <div class="form-group col-md-2">
                                <label class="form-label">Next Operation Date </label>
                                <input type="date" name="OperationDate" id="OperationDate" class="form-control"
                                    value="{{date('Y-m-d')}}" autocomplete="off" required>
                            </div>
                            <!-- <div class="form-group col-md-2">
                                <label class="form-label">To Date</label>
                                <input type="date" name="ToDate3" id="ToDate3" class="form-control"
                                    value="{{date('Y-m-d')}}" autocomplete="off" required>
                            </div> -->

                            <input type="hidden" name="Search3" value="Search">
                            <div class="form-group col-md-2" style="padding-top:20px;">
                                <button type="submit" id="filter3" name="submit" class="btn btn-primary btn-finish">Update</button>
                            </div>
                        </div>

                    

                    <div class="card">
                        <div class="card-body">


                            <div class="table-responsive" id="custresult3">


                            </div>
                        </div>
                    </div>
                    </form>
                </div>
            </div>

        </div>
    </div>


</div>
@include('masters/incmedicinemodal')
@include('ipd/incsurgicalprescmodal')
@include('footerscript')
@include('excelscript')
<script>
    function companyLists() {
    $.ajax({
        url: "{{ url('companyLists') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}'
        },
        success: function(data) {
            $('#DataList').html(data);
        }
    });
}
function modelLists() {
    var Cname = $('#IolName').val();
    $.ajax({
        url: "{{ url('modelLists2') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            Cname: Cname
        },
        success: function(data) {
            $('#IolType_DataList').html(data);
        }
    });
}

function powerLists() {
    //var Cname = $('#IolName').val();
    var Model = $('#IolType').val();
    $.ajax({
        url: "{{ url('powerLists2') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            Model: Model
        },
        success: function(data) {
            $('#IolPower_DataList').html(data);
        }
    });
}

function printSurgicalPres() {
    var id = $('#id').val();
    if (id == '') {
        alert("Please Select OT Scheduled Id");
    } else {
        setTimeout(function() {
            window.open(
                '/{{projectUrl()}}printSurgicalPres/' + id, 'popUpWindow4',
                'height=1000,width=800,left=0,top=0,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
            );
        }, 1);
    }
}

function surgicalPresc() {
    $.ajax({
        url: "{{ url('surgicalPrescLists') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}'
        },
        success: function(data) {
            //console.log(data);
            $('#surgicalpresccustresult').html(data);
            $('#modal-report-surgical').modal("show");
        }
    });

}

function fixedDate() {
    var FixedDate = $('#FixedDate').val();
    $.ajax({
        url: "{{ url('fixedDate') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            FixedDate: FixedDate
        },
        success: function(data) {
            alert('Date Fixed Successfully!');
        }
    });
}

function addNewDrug() {
    $('#Medicineaction').val('Save');
    $('#Medicineid').val('');
    $('#MedicineName').val('');
    $('#Amount').val('');
    $('#medicinebtn').text("Save");
    $('#drugtitle').html(
        "Add <span class='font-weight-light'>Medicine</span>");
    procedure_lists();

}

function procedure_lists() {
    $.ajax({
        url: "{{ url('viewMedicineList') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}'
        },
        success: function(data) {
            //console.log(data);
            $('#medicinecustresult').html(data);
        }
    });
}



function saveMedicine() {
    var MedicineName = $('#MedicineName').val();
    var Amount = $('#Amount').val();
    var action = $('#Medicineaction').val();
    var id = $('#Medicineid').val();
    $.ajax({
        url: "{{ url('saveMedicine') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            Name: MedicineName,
            Amount: Amount,
            action: action,
            id: id
        },
        beforeSend: function() {
            $('#medicinebtn').attr('disabled', 'disabled');
            $('#medicinebtn').text('Please Wait...');
        },
        success: function(data) {

            $('#modal-report656').modal('hide');
            $('#drugaction').val('Save');
            $('#drugid').val('');
            $('#medicinebtn').attr('disabled', false);
            $('#medicinebtn').text('Submit');


        }
    });
}

function otSchList() {
    var ScheduleDate = $('#ScheduleDate').val();
    setTimeout(function() {
        window.open(
            '/{{projectUrl()}}otSchList/' + ScheduleDate, 'popUpWindow3',
            'height=600,width=1300,left=20,top=40,right=20,bottom=40,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
        );
    }, 1);
}

function preOptNotes() {
    var id = $('#id').val();
    if (id == '') {
        alert("Please Select OT Scheduled Id");
    } else {
        setTimeout(function() {
            window.open(
                '/{{projectUrl()}}preOptNotes/' + id, 'popUpWindow3',
                'height=1000,width=800,left=0,top=0,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
            );
        }, 1);
    }
}

function getPkgDetails(PackageName) {
    $.ajax({
        url: "{{ url('getPackageDetails') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            PackageName: PackageName
        },
        dataType: "json",
        success: function(data) {
            $('#Amount').val(data.PackageAmt);
        }
    });

}

function refresh() {
    window.location.href = "/{{projectUrl()}}OtScheduled";
}

function blankCounselDetails() {
    var CurrDate = $('#CurrDate').val();
    $('#action').val('Save');
    $('#ScheduleDate').val(CurrDate);
    $('#Eye').val('');
    $('#K1Re').val('');
    $('#K1Le').val('');
    $('#K2Re').val('');
    $('#K2Le').val('');
    $('#Diff').val('');
    $('#Category').val('');
    $('#IolPower').val('');
    $('#Aconstant').val('');
    $('#Diagnosis').val('');
    $('#Ga').val('');
    $('#Amount').val('');
    $('#Bs').val('');
    $('#Us').val('');
    $('#Bp').val('');
    $('#Package').val('');
    $('#IopRe').val('');
    $('#IopLe').val('');
    $('#Advice').val('');
    $('#PkgAmt').val('');
    $('#InsComp').val('');
    $('#ReqAmt').val('');
    $('#SanctAmt').val('');
    $('#AddAmt').val('');
    $('#SettleAmt').val('');
    $('#SettleDate').val('');
    $('#UtrNo').val('');
    $('#AL').val('');
    $('#Acd').val('');
    $('#Consultant').val('');
    $('#IolType').val('');
    $('#Cyl').val('');
    $('#LT').val('');
    $('#Wtw').val('');
    $('#delete').attr('disabled', true);
    $('#preopt_notes').attr('disabled', true);
    $('#surgical_presc').attr('disabled', true);
    $('#PostPone').attr('checked',false);
    $('#Language').val(1);
}

function getCounselDetails() {
    var val = $('#id').val();
    var CurrDate = $('#CurrDate').val();
    $.ajax({
        url: "{{ url('getOtSchDetails') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            id: val
        },
        dataType: "json",
        success: function(data) {
           // console.log(data);
            if (data == 0) {
                $('#action').val('Save');
                $('#PatientId').val('');
                $('#MrdNo').val('');
                $('#PatientName').val('');
                $('#ScheduleDate').val(CurrDate);
                $('#Phone').val('');
                $('#Age').val('');
                $('#Address').val('');
                $('#Gender').val('');
                $('#Eye').val('');
                $('#K1Re').val('');
                $('#K1Le').val('');
                $('#K2Re').val('');
                $('#K2Le').val('');
                $('#Diff').val('');
                $('#Category').val('');
                $('#IolPower').val('');
                $('#Aconstant').val('');
                $('#Diagnosis').val('');
                $('#Ga').val('');
                $('#Amount').val('');
                $('#Bs').val('');
                $('#Us').val('');
                $('#Bp').val('');
                $('#Package').val('');
                $('#IopRe').val('');
                $('#IopLe').val('');
                $('#Advice').val('');
                $('#PkgAmt').val('');
                $('#InsComp').val('');
                $('#ReqAmt').val('');
                $('#SanctAmt').val('');
                $('#AddAmt').val('');
                $('#SettleAmt').val('');
                $('#SettleDate').val('');
                $('#UtrNo').val('');
                $('#AL').val('');
                $('#Acd').val('');
                $('#Consultant').val('');
                $('#IolType').val('');
                $('#Cyl').val('');
                $('#LT').val('');
                $('#Wtw').val('');
                $('#delete').attr('disabled', true);
                $('#preopt_notes').attr('disabled', true);
                $('#surgical_presc').attr('disabled', true);
                $('#PostPone').attr('checked',false);
                $('#IolName').val('');
                $('#AddIol').val('');
                $('#Language').val(1);

            } else {
                $('#action').val('Edit');
                $('#PatientId').val(data.PatientId);
                $('#MrdNo').val(data.MrdNo);
                $('#PatientName').val(data.PatientName);
                $('#ScheduleDate').val(data.ScheduleDate);
                $('#Phone').val(data.Phone);
                $('#Age').val(data.Age);
                $('#Address').val(data.Address);
                $('#Gender').val(data.Gender);
                $('#Eye').val(data.Eye);
                $('#K1Re').val(data.K1Re);
                $('#K1Le').val(data.K1Le);
                $('#K2Re').val(data.K2Re);
                $('#K2Le').val(data.K2Le);
                $('#Diff').val(data.Diff);
                $('#Category').val(data.Category);
                $('#IolPower').val(data.IolPower);
                $('#Aconstant').val(data.Aconstant);
                $('#Diagnosis').val(data.Diagnosis);
                $('#Ga').val(data.Ga);
                $('#Amount').val(data.Amount);
                $('#Bs').val(data.Bs);
                $('#Us').val(data.Us);
                $('#Bp').val(data.Bp);
                $('#Package').val(data.Package);
                $('#IopRe').val(data.IopRe);
                $('#IopLe').val(data.IopLe);
                $('#Advice').val(data.Advice);
                $('#PkgAmt').val(data.PkgAmt);
                $('#InsComp').val(data.InsComp);
                $('#ReqAmt').val(data.ReqAmt);
                $('#SanctAmt').val(data.SanctAmt);
                $('#AddAmt').val(data.AddAmt);
                $('#SettleAmt').val(data.SettleAmt);
                $('#SettleDate').val(data.SettleDate);
                $('#UtrNo').val(data.UtrNo);
                $('#AL').val(data.AL);
                $('#Acd').val(data.Acd);
                $('#Consultant').val(data.Consultant);
                $('#IolType').val(data.IolType);
                $('#Cyl').val(data.Cyl);
                $('#LT').val(data.LT);
                $('#Wtw').val(data.Wtw);
                $('#delete').attr('disabled', false);
                $('#preopt_notes').attr('disabled', false);
                $('#surgical_presc').attr('disabled', false);
                $('#IolName').val(data.IolName);
                $('#AddIol').val(data.AddIol);
                $('#Language').val(data.Language);
                if(data.PostPone == 1){
                    $('#PostPone').attr('checked',true);
                }
                else{
                    $('#PostPone').attr('checked',false);
                }
                


            }
        }
    });
}

function getMaxSchId() {
    $.ajax({
        url: "{{ url('getMaxSchId') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}'
        },
        success: function(data) {
            //alert(data);
            $('#id').val(data);
        }
    });
}

function success_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.notice({
        title: 'Success',
        message: 'Record Saved Successfully!',
        location: isRtl ? 'tl' : 'tr'
    });
}

function error_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.error({
        title: 'Error',
        message: 'Record Saved Successfully!',
        location: isRtl ? 'tl' : 'tr'
    });
}


function deleteRecord() {
    var id = $('#id').val();
    swal({
        title: "Are you sure?",
        text: "You will not be able to recover this Queue Record!",
        type: "warning",
        showCancelButton: true,
        confirmButtonClass: "btn-danger",
        confirmButtonText: "Yes, delete",
        cancelButtonText: "No, cancel",
        closeOnConfirm: false,
        closeOnCancel: false
    }, function(isConfirm) {
        if (isConfirm) {
            $.ajax({
                url: "{{ url('deleteOtSchedule') }}",
                method: "POST",
                data: {
                    _token: '{{csrf_token()}}',
                    id: id
                },
                beforeSend: function() {
                    $('.confirm').attr('disabled', 'disabled');
                    $('.confirm').text('Please Wait...');
                },
                success: function(data) {
                    swal("Deleted!", "Record has been deleted.", "success");
                    window.location.href = "/{{projectUrl()}}OtScheduled";
                }
            });
        } else {
            swal("Cancelled", "Record is safe :)", "error");
        }
    });
}

function getPrevVisitDetails(MrdNo) {
    //var MrdNo = $('#MrdNo').val();
    $.ajax({
        url: "{{ url('getPrevVisitDetails') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            MrdNo: MrdNo
        },
        dataType: "json",
        success: function(data) {
            //console.log(data);
            // $('#K1Re').val(data.RefK1Re);
            // $('#K1Le').val(data.RefK1Le);
            // $('#K2Re').val(data.RefK2Re);
            // $('#K2Le').val(data.RefK2Le);
            // $('#Diff').val(data.RefDiffRe);
            $('#Diagnosis').val(data.Diagnosis);
            $('#Bp').val(data.BP);
            $('#IopRe').val(data.IopNctRe);
            $('#IopLe').val(data.IopNctLe);
            $('#Advice').val(data.Advice);
        }
    });
}
$(document).ready(function() {
    modelLists();
    companyLists();
    powerLists();
    //queueList3();
    $(document).on("click", ".updatemedicine", function(event) {
        event.preventDefault();
        event.stopPropagation();
        var id = $(this).attr("data-id");
        var action = "fetch_record";
        $.ajax({
            url: "{{ url('editMedicine') }}",
            method: "POST",
            data: {
                _token: '{{csrf_token()}}',
                id: id
            },
            dataType: "json",
            success: function(data) {
                $('#MedicineName').val(data.Name);
                $('#Amount').val(data.Amount);
                $('#Medicineaction').val('Edit');

                $('#Medicineid').val(id);
                $('#medicinebtn').text("Update");
                $('#modal-report656').modal('show');
                $('.modal-title').html(
                    "Update <span class='font-weight-light'>Medicine</span>");

            }
        });
    });



    $(document).on("click", ".deletemedicine", function(event) {
        event.preventDefault();
        var id = $(this).attr("data-id");
        var action = "delete";
        //alert(id);
        swal({
            title: "Are you sure?",
            text: "You will not be able to recover this Medicine!",
            type: "warning",
            showCancelButton: true,
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Yes, delete",
            cancelButtonText: "No, cancel",
            closeOnConfirm: false,
            closeOnCancel: false
        }, function(isConfirm) {
            if (isConfirm) {
                $.ajax({
                    url: "{{ url('deleteMedicine') }}",
                    method: "POST",
                    data: {
                        _token: '{{csrf_token()}}',
                        id: id
                    },

                    success: function(data) {
                        swal("Deleted!", "Medicine has been deleted.", "success");

                        procedure_lists();

                    }
                });

            } else {
                swal("Cancelled", "Medicine is safe :)", "error");
            }
        });


    });
    $(document).on("input", "#MrdNo", function(event) {
        getMaxSchId();
        blankCounselDetails();
        var val = this.value;
        if (val == '') {
            blankCounselDetails();
            $('#action').val('Save');
            $('#PatientId').val('');
            //$('#MrdNo').val('');
            $('#PatientName').val('');
            $('#Phone').val('');
            $('#Age').val('');
            $('#Address').val('');
            $('#Gender').val('');
        }
        $.ajax({
            url: "{{ url('getPatientDetails') }}",
            method: "POST",
            data: {
                _token: '{{csrf_token()}}',
                id: val
            },
            dataType: "json",
            success: function(data) {
                //console.log(data);
                //$('#MrdNo').val(data.MrdNo);
                $('#PatientName').val(data.PatientName);
                $('#Phone').val(data.Phone);
                $('#Age').val(data.Age);
                $('#Address').val(data.Address);
                $('#Gender').val(data.Gender);
                getPrevVisitDetails(data.MrdNo);

            }
        });

    });

    $('#validation-form').on('submit', function(e) {
        e.preventDefault();
        if ($('#validation-form').valid()) {
            $.ajax({
                url: "{{ url('saveOtScheduled') }}",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                processData: false,
                beforeSend: function() {
                    $('#submit').attr('disabled', 'disabled');
                    $('#submit').text('Please Wait...');
                },
                success: function(data) {
                    //alert(data);exit();
                    if (data == 0) {
                        alert("Scheduled Date is Fixed");
                    } else {
                        success_toast();
                        $('#delete').attr('disabled', false);
                        $('#preopt_notes').attr('disabled', false);
                        $('#surgical_presc').attr('disabled', false);
                        $('#action').val('Edit');
                    }

                    $('#submit').attr('disabled', false);
                    $('#submit').text('Save');

                }
            });
        }
    });


    $('#validation-form22').on('submit', function(e) {
        //alert();
        e.preventDefault();

    });


    $('#filter').click(function() {
        var FromDate = $('#FromDate').val();
        var ToDate = $('#ToDate').val();
        if (FromDate != '' && ToDate != '') {
            queueList(FromDate, ToDate);
        } else {
            alert('Both Date is required');
        }
    });

    $('#refresh').click(function() {
        $('#FromDate').val('');
        $('#ToDate').val('');
        queueList();
    });

    function queueList(FromDate = '', ToDate = '') {
        $.ajax({
            url: "{{ url('viewOtScheduleList') }}",
            method: "POST",
            data: {
                _token: '{{csrf_token()}}',
                FromDate: FromDate,
                ToDate: ToDate
            },
            success: function(data) {
                //console.log(data);
                $('#custresult').html(data);
            }
        });
    }


    $('#validation-form44').on('submit', function(e) {
        e.preventDefault();
        if ($('#validation-form44').valid()) {
            $.ajax({
                url: "{{ url('updateOperationDate') }}",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                processData: false,
                beforeSend: function() {
                    $('#filter3').attr('disabled', 'disabled');
                    $('#filter3').text('Please Wait...');
                },
                success: function(data) {
                    queueList3();
                    $('#filter3').attr('disabled', false);
                    $('#filter3').text('Update');
                    console.log(data);
                }
            });
        }
    });


    $('#filter3').click(function() {
        var FromDate = $('#FromDate3').val();
        var ToDate = $('#ToDate3').val();
        if (FromDate != '' && ToDate != '') {
            queueList(FromDate, ToDate);
        } else {
            alert('Both Date is required');
        }
    });

    $('#refresh3').click(function() {
        $('#FromDate3').val('');
        $('#ToDate3').val('');
        queueList3();
    });


});

function queueList3() {
        $.ajax({
            url: "{{ url('viewOtSchedulePostPoneList') }}",
            method: "POST",
            data: {
                _token: '{{csrf_token()}}'
            },
            success: function(data) {
                console.log(data);
                $('#custresult3').html(data);
            }
        });
    }

function tab3(){
    queueList3();
}
</script>