<!DOCTYPE html>
<html lang="en" class="default-style">

<head>
    <title>{{projectTitle()}}</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=no,minimum-scale=1,maximum-scale=1">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <meta name="author" content="Codedthemes">
    @include('headerscript')
    <style type="text/css">
    fieldset legend {
        background: inherit;
        font-family: "Lato", sans-serif;
        color: #650812;
        font-size: 15px;
        left: 10px;
        padding: 0 10px;
        position: absolute;
        top: -12px;
        font-weight: 400;
        width: auto !important;
        border: none !important;
    }

    fieldset {
        background: #ffffff;
        border: 1px solid #C43853;
        border-radius: 5px;
        margin: 20px 0 1px 0;
        padding: 25px;
        position: relative;
    }

    .form-control {
        min-height: 1px;
        height: 25px;
    }

    .table th,
    .table td {
        padding: 0.325rem;
    }

    .col-sm-12,
    .col-sm,
    .col-sm-auto,
    .col-md-1,
    .col-md-2,
    .col-md-3,
    .col-md-4,
    .col-md-5,
    .col-md-6,
    .col-md-7,
    .col-md-8,
    .col-md-9,
    .col-md-10,
    .col-md-11,
    .col-md-12,
    .col-md,
    .col-md-auto,
    .col-lg-1,
    .col-lg-2,
    .col-lg-3,
    .col-lg-4,
    .col-lg-5,
    .col-lg-6,
    .col-lg-7,
    .col-lg-8,
    .col-lg-9,
    .col-lg-10,
    .col-lg-11,
    .col-lg-12,
    .col-lg,
    .col-lg-auto,
    .col-xl-1,
    .col-xl-2,
    .col-xl-3,
    .col-xl-4,
    .col-xl-5,
    .col-xl-6,
    .col-xl-7,
    .col-xl-8,
    .col-xl-9,
    .col-xl-10,
    .col-xl-11,
    .col-xl-12,
    .col-xl,
    .col-xl-auto {
        position: relative;
        width: 100%;
        padding-right: 1px;
        padding-left: 6px;
    }
    </style>
</head>
<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold mb-0">O.T. Notes Other</h4>
    <form id="validation-form" novalidate="novalidate" method="POST" enctype="multipart/form-data" autocomplete="off"
        action="">
        <input type="hidden" name="action" id="actionvalue" value="Save">
        <input type="hidden" name="saveid" id="saveid" value="">
        @csrf

        <div class="row">

            <div class="col-md-12">



                <div class="card mb-2">


                    <div class="table-responsive" style="overflow-x:auto;">
                        <table class="table table-bordered table-striped mb-0">
                            <thead>

                                <tr>

                                    <th width="10" align="center" valign="top">EYE </th>
                                    <th width="50" align="center" valign="top">
                                        <select class="form-control" name="cmbtreateye" id="cmbtreateye"
                                            style="height:31px;" required>
                                            <!-- <option selected disabled value="">Select Eye</option> -->
                                            <option value="R.E">R.E</option>

                                            <option value="L.E">L.E</option>
                                        </select>

                                        <div class="clearfix"></div>
                                    </th>
                                    <th width="30" align="center" valign="top">Date</th>
                                    <th width="80" align="center" valign="top"><input type="date" name="dtentrydate"
                                            class="form-control" id="dtentrydate" value="{{date('Y-m-d')}}">
                                        <div class="clearfix"></div>
                                    </th>
                                    <th width="20" align="center" valign="top">Allergic To </th>
                                    <th width="80" align="center" valign="top"><input type="text" class="form-control"
                                            placeholder="" id="txtallergicto" name="txtallergicto" value="">

                                    <th width="30" align="center" valign="top">Category</th>
                                    <th width="80" align="center" valign="top"><input class="form-control" type="text"
                                            list="category" name="cmbcategory" id="cmbcategory" value="">
                                        <datalist id="category">
                                            <option value=" Cashless">
                                            <option value="Routine">
                                            <option value="State Govt.">
                                            <option value="Insurance">
                                            <option value="Cash">
                                        </datalist>
                                        <div class="clearfix"></div>
                                    </th>
                                    <th width="30" align="center" valign="top">Package</th>
                                    <th width="80" align="center" valign="top">
                                        <input class="form-control" type="text" list="emails2" style="overflow-x:auto;"
                                            name="cmbpackage" id="cmbpackage">


                                        <div class="clearfix"></div>
                                    </th>
                                    <th width="30" align="center" valign="top">Advance</th>
                                    <th width="80" align="center" valign="top"><input type="text" class="form-control"
                                            placeholder="" id="txtadvance" name="txtadvance" value="">
                                        <div class="clearfix"></div>
                                    </th>
                                </tr>

                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>


                </div>



            </div>

        </div>
        <div class="row">
            <div class="col-md-12 mb-1">


                <div class="card mb-2">


                    <div class="table-responsive" style="overflow-x:auto;">
                        <table class="table table-bordered table-striped mb-0">
                            <thead>


                                <tr>


                                    <th width="10" align="center" valign="top">Mrd.No </th>
                                    <th width="50" align="center" valign="top"><input type="text" class="form-control"
                                            placeholder="" id="MrdNo" name="txtmrdno" readonly value="{{$MrdNo}}">
                                        <div class="clearfix"></div>
                                    </th>
                                    <th width="30" align="center" valign="top">Patient Name </th>
                                    <th width="180" align="center" valign="top"><input type="text" class="form-control"
                                            placeholder="" name="txtptname" id="PatientName" value="">
                                        <div class="clearfix"></div>
                                    </th>
                                    <th width="30" align="center" valign="top">Age </th>
                                    <th width="80" align="center" valign="top"><input type="text" class="form-control"
                                            placeholder="" id="Age" name="txtage" value="">
                                    <th width="30" align="center" valign="top">Mobile</th>
                                    <th width="80" align="center" valign="top"><input type="text" class="form-control"
                                            placeholder="" id="Phone" name="txtmobile" value="">
                                        <div class="clearfix"></div>
                                    </th>
                                    <th width="30" align="center" valign="top">Address</th>
                                    <th width="80" align="center" valign="top"><input type="text" class="form-control"
                                            placeholder="" id="Address" name="txtaddress" value="">
                                        <div class="clearfix"></div>
                                    </th>
                                </tr>

                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>


                </div>


            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="row">
                    <div class="col-md-5">
                        <div class="col-md-12">
                            <fieldset>
                                <legend>Diagnosis</legend>
                                <div class="row">
                                    <div class="col-lg-10">
                                        <div class="form-group">
                                            <textarea class="form-control" placeholder="Search for..."
                                                name="txtdiagnosis" id="txtdiagnosis"></textarea>

                                        </div>
                                    </div>
                                    <div class="col-lg-2">
                                        <span class="input-group-append">
                                            <button class="btn btn-secondary" type="button" data-toggle="modal"
                                                data-target="#modal-report" id="add_button"
                                                onclick="getValue('Diagnosis','txtdiagnosis')">...</button>
                                        </span>
                                    </div>
                                </div>


                            </fieldset>
                        </div>
                        <div class="col-md-12">
                            <fieldset>
                                <legend>Suggested Surgery</legend>
                                <div class="row">
                                    <div class="col-lg-10">
                                        <div class="form-group">
                                            <textarea class="form-control" placeholder="Search for..."
                                                name="txtsugestedsurgery" id="txtsugestedsurgery"></textarea>

                                        </div>
                                    </div>
                                    <div class="col-lg-2">
                                        <span class="input-group-append">
                                            <button class="btn btn-secondary" type="button" data-toggle="modal"
                                                data-target="#modal-report" id="add_button"
                                                onclick="getValue('sugestedsurgery','txtsugestedsurgery')">...</button>
                                        </span>
                                    </div>
                                </div>


                            </fieldset>
                        </div>

                        <div class="col-md-12">
                            <fieldset>
                                <legend>Remark</legend>
                                <div class="row">
                                    <div class="col-lg-10">
                                        <div class="form-group">
                                            <textarea class="form-control" placeholder="Search for..." name="txtremark"
                                                id="txtremark"></textarea>

                                        </div>
                                    </div>
                                    <div class="col-lg-2">
                                        <span class="input-group-append">
                                            <button class="btn btn-secondary" type="button" data-toggle="modal"
                                                data-target="#modal-report" id="add_button"
                                                onclick="getValue('otremark','txtremark')">...</button>
                                        </span>
                                    </div>
                                </div>


                            </fieldset>
                        </div>

                        <div class="col-md-12">
                            <fieldset>

                                <div class="row">
                                    <div class="col-lg-4">
                                        <label class="floating-label" for="Name">Admission Date</label>

                                        <input type="date" name="admissiondate" class="form-control" id="admissiondate"
                                            value="{{date('Y-m-d')}}">

                                    </div>
                                    <div class="col-lg-4">
                                        <label class="floating-label" for="Name">Surgery Date</label>

                                        <input type="date" name="txtsurgerydate" class="form-control"
                                            id="txtsurgerydate" value="{{date('Y-m-d')}}">

                                    </div>

                                    <div class="col-lg-4">
                                        <label class="floating-label" for="Name">Follow Up Date</label>

                                        <input type="date" name="followupdate" class="form-control" id="followupdate"
                                            value="{{date('Y-m-d')}}">

                                    </div>

                                </div>
                            </fieldset>


                        </div>

                        <div class="col-md-12">
                            <fieldset>
                                <legend>Surgery Notes</legend>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <label class="floating-label" for="Name">Surgery Notes</label>
                                    
                                        <select class="form-control" name="surgerynotes"
                                                        id="surgerynotes" style="height:32px;">
                                                        <option>...</option>
                                                        @foreach($surgerynotesList as $result)
                                                        <option value="{{$result->Name}}">{{$result->Name}}</option>
                                                        @endforeach
                                                    </select>

                                    </div>
                                    <div class="col-lg-12">
                                        <textarea class="form-control" name="txtsurgerynotes" id="txtsurgerynotes"></textarea>


                                    </div>


                                </div>
                            </fieldset>


                        </div>



                    </div>
                    <div class="col-md-7">
                        <div class="col-md-12">
                            <fieldset>
                                <legend>Investigation</legend>
                                <div class="row">
                                    <table class="table table-bordered table-striped mb-0">
                                        <thead>

                                            <tr>
                                                <th width="50" align="center" valign="top">B.S</th>
                                                <th width="100" align="center" valign="top">
                                                    <select class="form-control" name="cmbbsrandom" id="cmbbsrandom"
                                                        style="height: 31px;">
                                                        <option value="Random" selected>Random</option>
                                                        <option value="Fasting">Fasting</option>
                                                    </select>

                                                </th>
                                                <th width="113" align="center" valign="top"><input type="text"
                                                        name="txtbsfasting" id="txtbsfasting" class="form-control"
                                                        placeholder="" value="">
                                                    <div class="clearfix"></div>
                                                    </td>
                                                </th>
                                                <th width="50" align="center" valign="top">U.S </th>
                                                <th width="100" align="center" valign="top">
                                                    <select class="form-control" name="cmbusrandom" id="cmbusrandom"
                                                        style="height: 31px;">
                                                        <option value="Random" selected>Random</option>
                                                        <option value="Fasting">Fasting</option>
                                                    </select>
                                                    <!-- <input class="form-control" type="text" list="usrndm"
                                                        name="cmbusrandom" id="cmbusrandom" value="">
                                                    <datalist id="usrndm">

                                                        <option value="Random">
                                                        <option value="Fasting">
                                                    </datalist> -->
                                                </th>
                                                <th width="105" align="center" valign="top"><input type="text"
                                                        name="txtusfasting" id="txtusfasting" class="form-control"
                                                        placeholder="" value="">
                                                    <div class="clearfix"></div>
                                                    </td>
                                                </th>
                                                <th width="100" align="center" valign="top">HbS Ag</th>
                                                <th width="105" align="center" valign="top">
                                                    <select class="form-control" name="cmbhbsag" id="cmbhbsag"
                                                        style="height: 31px;">
                                                        <option value="Positive" selected>Positive</option>
                                                        <option value="Negative">Negative</option>
                                                    </select>

                                                    </td>
                                                </th>
                                                <th width="50" align="center" valign="top">B.P </th>
                                                <th width="129" align="center" valign="top"><input type="text"
                                                        name="txtbp" id="txtbp" class="form-control" placeholder=""
                                                        value="">
                                                    <div class="clearfix"></div>
                                                    </td>
                                                </th>



                                            </tr>
                                            <tr>
                                                <th width="50" align="center" valign="top">B.S</th>
                                                <th width="100" align="center" valign="top"><input class="form-control"
                                                        type="text" name="cmbbspostmeal" id="cmbbspostmeal"
                                                        value="Post Meal">
                                                    <datalist id="bspostmeal">

                                                        <option value="Post Meal">
                                                    </datalist>
                                                </th>
                                                <th width="129" align="center" valign="top"><input type="text"
                                                        name="txtbspostmeal" id="txtbspostmeal" class="form-control"
                                                        placeholder="" value="">
                                                    <div class="clearfix"></div>
                                                    </td>
                                                </th>
                                                <th width="50" align="center" valign="top">U.S</th>
                                                <th width="100" align="center" valign="top"><input class="form-control"
                                                        type="text" name="cmbuspostmeal" id="cmbuspostmeal"
                                                        value="Post Meal">
                                                    <datalist id="uspostmeal">

                                                        <option value="Post Meal">
                                                    </datalist>
                                                </th>
                                                <th width="113" align="center" valign="top"><input type="text"
                                                        name="txtuspostmeal" id="txtuspostmeal" class="form-control"
                                                        placeholder="" value=""></th>
                                                <th width="100" align="center" valign="top">E.C.G</th>
                                                <th width="105" align="center" valign="top"><input class="form-control"
                                                        type="text" list="ecg" name="cmbecg" id="cmbecg" value="">
                                                    <datalist id="ecg">

                                                        <option value="Normal">
                                                    </datalist>
                                                </th>
                                                <th width="50" align="center" valign="top">HIV</th>
                                                <th width="105" align="center" valign="top">
                                                    <select class="form-control" name="cmbhiv" id="cmbhiv"
                                                        style="height: 31px;">
                                                        <option value="Positive" selected>Positive</option>
                                                        <option value="Negative">Negative</option>
                                                    </select>

                                                </th>


                                            </tr>

                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>


                            </fieldset>
                        </div>

                        <div class="col-md-12">
                            <fieldset>
                                <legend>Quick Tips</legend>
                                <div class="row">
                                    <table class="table table-bordered table-striped mb-0">
                                        <thead>

                                            
                                            
                                            <tr>
                                                
                                                <th width="100" align="center" valign="top">Prop. Anaesthesia</th>
                                                <th width="105" align="center" valign="top"><input
                                                        class="form-control" type="text" list="anthgiven"
                                                        name="cmbpropanaesthesia" id="cmbpropanaesthesia" value="">

                                                    <div class="clearfix"></div>
                                                    </td>
                                                </th>

                                                <th width="50" align="center" valign="top">Fitness By</th>

<th width="129" align="center" valign="top"><input type="text"
        name="txtfitnessby" id="txtfitnessby" class="form-control"
        placeholder="" value="">
    <div class="clearfix"></div>
    </td>
</th>
                                            </tr>
                                            
                                            <tr>
                                                <th colspan="7"
                                                    style="border-left: 1px solid white;border-right: 1px solid white;">
                                                </th>
                                            </tr>
                                            <tr>
                                                <th width="50" align="center" valign="top">Remark</th>
                                                <th colspan="4" width="129" align="center" valign="top" colspan="4">
                                                    <textarea name="txtquickremark" id="txtquickremark"
                                                        class="form-control" placeholder=""></textarea>

                                               

                                            </tr>
                                            <tr>

                                                <!-- <th width="50" align="center" valign="top" colspan="2"><input
                                                        class="form-control" type="text" list="prostate"
                                                        name="cmbprostate" id="cmbprostate" value="">
                                                    <datalist id="prostate">

                                                        <option value="Normal">
                                                    </datalist>
                                                </th> -->



                                            </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>


                            </fieldset>
                        </div>
                        <div class="col-md-12">
                            <fieldset>
                                <legend>Pre-OP Notes</legend>
                                <div class="row">
                                    <table class="table table-bordered table-striped mb-0">
                                        <thead>

                                            <tr>
                                                <th width="10" align="center" valign="top">Opr. Surgeon</th>

                                                <th width="120" align="center" valign="top"><input type="text"
                                                        name="txtsurgeon" id="txtsurgeon" class="form-control"
                                                        placeholder="" value="">
                                                    <div class="clearfix"></div>
                                                    </td>
                                                </th>
                                                <th width="10" align="center" valign="top"><span
                                                        class="input-group-append">
                                                        <button class="btn btn-secondary" type="button"
                                                            data-toggle="modal" data-target="#modal-report"
                                                            id="add_button"
                                                            onclick="getValue('Surgeon','txtsurgeon')">...</button>
                                                    </span> </th>

                                                <th width="60" align="center" valign="top">Assistant
                                                    <div class="clearfix"></div>
                                                    </td>
                                                </th>
                                                <th width="120" align="center" valign="top"><input type="text"
                                                        name="txtsurassitant" id="txtsurassitant" class="form-control"
                                                        placeholder="" value=""></th>
                                                <th width="10" align="center" valign="top"><span
                                                        class="input-group-append">
                                                        <button class="btn btn-secondary" type="button"
                                                            data-toggle="modal" data-target="#modal-report"
                                                            id="add_button"
                                                            onclick="getValue('Assistant','txtsurassitant')">...</button>
                                                    </span>
                                                    <div class="clearfix"></div>
                                                    </td>
                                                </th>
                                            </tr>
                                            <tr>
                                                <th width="40" align="center" valign="top">Anaethetist</th>
                                                <th width="120" align="center" valign="top"><input type="text"
                                                        name="txtanesthetist" id="txtanesthetist" class="form-control"
                                                        placeholder="" value="">
                                                    <div class="clearfix"></div>
                                                    </td>
                                                </th>
                                                <th width="10" align="center" valign="top"><span
                                                        class="input-group-append">
                                                        <button class="btn btn-secondary" type="button"
                                                            data-toggle="modal" data-target="#modal-report"
                                                            id="add_button"
                                                            onclick="getValue('Anaesthetist','txtanesthetist')">...</button>
                                                    </span></th>
                                                <th width="129" align="center" valign="top">Anesthesia Given
                                                    <div class="clearfix"></div>
                                                    </td>
                                                </th>
                                                <th width="129" align="center" valign="top"><input class="form-control"
                                                        type="text" list="anthgiven" name="txtanasthesiagiven"
                                                        id="txtanasthesiagiven" value="">
                                                    <datalist id="anthgiven">

                                                        <option value="TA">
                                                        <option value="Block">
                                                        <option value="General">
                                                    </datalist>

                                            </tr>

                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>
<br>
                                <div class="col-sm-12">
                                    <button class="btn btn-primary" id="submit" type="submit"
                                        name="submit">Save</button>
                                    <button class="btn btn-success" onclick="printOt()" id="printbtn" type="button"
                                        disabled>Print</button>
                                    <button class="btn btn-danger" type="button" onclick="dischargeCard({{$MrdNo}})"
                                        id="discbtn" disabled>Discharge
                                        Card</button>
                                </div>
                            </fieldset>
                        </div>

                        
                    </div>
                </div>





                
            </div>
        </div>

        <input type="hidden" id="CurrDate" value="{{date('Y-m-d')}}">






    </form>
</div>
</div>
</div>
<!-- [ Layout content ] Start -->

</div>
<!-- [ Layout container ] End -->

</div>
<!-- Overlay -->

<div class="layout-overlay layout-sidenav-toggle"></div>
</div>
<script src="{{url('assets/js/jquery-3.6.0.min.js')}}"></script>
@include('masters/inccommonmodal')
<div class="layout-overlay layout-sidenav-toggle"></div><!-- [ Layout wrapper] End -->
<!-- Modal -->
@include('footerscript')
<script>
$('.datalist').on('click', function() {
    $(this).val('');
});

function dlRestoreValue(i) {

    let t = $('#' + i);
    if (t.val() === '') {

        if (t.attr('org-placeholder') !== t.attr('placeholder')) {
            t.val(t.attr('placeholder'));
        }

        t.attr('placeholder', '');
        if (t.val() === '') {
            t.attr('placeholder', t.attr('org-placeholder'));
        }

    }

}

function dlShowAllOnArrowClick(i) {

    $('#' + i)
        .on('click', function(e) {

            let t = $(this);
            if ((t.width() - (e.clientX - t.offset().left)) < 14) {
                if (t.val() !== "") {
                    t.attr('placeholder', t.val());
                    t.val('');
                }
            } else {
                dlRestoreValue(i)
            }
        })

        .on('mouseleave', function() {
            dlRestoreValue(this.id);
        })


        .on('mouseenter', function() {
            if (!$(this).is("[org-placeholder]")) $(this).attr('org-placeholder', $(this).attr('placeholder'));
        })

}


dlShowAllOnArrowClick('cmbdialatedwith');
dlShowAllOnArrowClick('cmbhearingstatus');
dlShowAllOnArrowClick('cmbpupdilation');
dlShowAllOnArrowClick('cmbsocket');

function dischargeCard(mrdno) {
    var otid = $('#saveid').val();
    setTimeout(function() {
        window.open(
            '/{{projectUrl()}}addDischargeCard2/' + mrdno + '/' + otid, 'popUpWindow3',
            'height=1000,width=1500,left=0,top=0,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
        );
    }, 1);
}

function printOt() {
    var id = $('#saveid').val();
    setTimeout(function() {
        window.open(
            '/{{projectUrl()}}printOtNotesOther/' + id, 'popUpWindow2',
            'height=1000,width=1500,left=0,top=0,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
        );
    }, 1);
}

function getValue(val, idval) {
    $('#ModalValue').val(val);
    $('#ValueId').val(idval);
    $('#OldValue').val('');
    desc_lists(val);
}

function getRecords(val) {
    $.ajax({
        url: "{{ url('getTreatments') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            Treatment: val
        },
        success: function(data) {
            console.log(data);
            $('#showTreatments').html(data);
        }
    });
}

function getPatientDetails(val) {
    $.ajax({
        url: "{{ url('getPatientDetails') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            id: val
        },
        dataType: "json",
        success: function(data) {
            var AgeGender = data.Age + "/" + data.Gender;
            $('#MrdNo').val(data.MrdNo);
            $('#PatientName').val(data.PatientName);
            $('#Age').val(AgeGender);
            //$('#Gender').val(data.Gender);
            $('#Phone').val(data.Phone);
            $('#Address').val(data.Address);
            getPatientTreatment(data.MrdNo);
        }
    });
}

function checkOtPatient(val, eye) {
    var CurrDate = $('#CurrDate').val();
    $.ajax({
        url: "{{ url('checkOtOtherPatient') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            id: val,
            eye: eye
        },
        success: function(data) {
            var res = JSON.parse(data);
            var Status = res.Status;
            var result = res.result;
            if (Status == 0) {
                getPatientDetails(val);
                getPrevVisitDetails(val);
                $('#actionvalue').val('Save');
                $('#saveid').val('');
                $('#printbtn').attr("disabled", true);
                $('#discbtn').attr("disabled", true);
                //$('#cmbtreateye').val('').attr("selected",true);
                $('#dtentrydate').val(CurrDate);
                $('#txtallergicto').val('');
                $('#cmbvip').val('');
                $('#cmbcategory').val('');
                $('#cmbpackage').val('');
                $('#txtadvance').val('');
                $('#MrdNo').val('');
                $('#PatientName').val('');
                $('#Age').val('');
                $('#Phone').val('');
                $('#Address').val('');
                $('#txtdiagnosis').val('');
                $('#txtsugestedsurgery').val('');
                $('#txtoct').val('');
                $('#cmbsurgeryperformed').val('');
                $('#cmbbsrandom').val('Random').attr("selected", true);
                $('#txtbsfasting').val('');
                $('#cmbusrandom').val('Random').attr("selected", true);
                $('#txtusfasting').val('');
                $('#cmbhbsag').val('');
                $('#txtbp').val('');
                $('#cmbbspostmeal').val('Post Meal');
                $('#txtbspostmeal').val('');
                $('#cmbuspostmeal').val('Post Meal');
                $('#txtuspostmeal').val('');
                $('#cmbecg').val('');
                $('#cmbhiv').val('');
                $('#txtfitnessby').val('');
                $('#txtother').val('');
                $('#txtramtest').val('');

                $('#chkprostate').val('').attr('checked', false);

                $('#txtprostate').val('');
                $('#cmbprostate').val('');
                $('#cmbdialatedwith').val('');
                $('#cmbpupdilation').val('');
                $('#cmbopdlri').val('');
                $('#txtpropincision').val('');
                $('#txtpropincisionat').val('');
                $('#txtpropincisioncyl').val('');
                $('#cmbsocket').val('');
                $('#cmbptcooperation').val('');
                $('#cmbpropanaesthesia').val('');
                $('#txtnucleus').val('');
                $('#txtquickremark').val('');
                $('#txtsurgeon').val('');
                $('#txtsurassitant').val('');
                $('#txtanesthetist').val('');
                $('#txtanasthesiagiven').val('');
                $('#cmbioltype').val('');
                $('#txtcompanyname').val('');
                $('#txtipdiolpower').val('');
                $('#txtcylfortoric').val('');
                $('#txtaxis').val('');
                $('#txtaconstant').val('');
                $('#cmbccc').val('');
                $('#txtcapstaining').val('');
                $('#txtirrigationsol').val('');
                $('#txtviscoelastic').val('');
                $('#txtintracameralantibiotic').val('');
                $('#cmblri').val('');
                $('#cmbwoundhydration').val('');
                $('#txtremark').val('');
                $('#admissiondate').val(CurrDate);
                $('#txtsurgerydate').val(CurrDate);
                $('#followupdate').val(CurrDate);
                $('#cmbhearingstatus').val('');
                $('#surgerynotes').val(null).attr("selected",true);
                $('#txtsurgerynotes').val('');
            } else {

                $('#actionvalue').val('Edit');
                $('#printbtn').attr("disabled", false);
                $('#discbtn').attr("disabled", false);
                $('#saveid').val(result.id);
                $('#cmbtreateye').val(result.cmbtreateye).attr("selected", true);
                $('#dtentrydate').val(result.dtentrydate);
                $('#txtallergicto').val(result.txtallergicto);
                $('#cmbvip').val(result.cmbvip);
                $('#cmbcategory').val(result.cmbcategory);
                $('#cmbpackage').val(result.cmbpackage);
                $('#txtadvance').val(result.txtadvance);
                $('#MrdNo').val(result.txtmrdno);
                $('#PatientName').val(result.txtptname);
                $('#Age').val(result.txtage);
                $('#Phone').val(result.txtmobile);
                $('#Address').val(result.txtaddress);
                $('#txtdiagnosis').val(result.txtdiagnosis);
                $('#txtsugestedsurgery').val(result.txtsugestedsurgery);
                $('#txtoct').val(result.txtoct);
                $('#cmbsurgeryperformed').val(result.cmbsurgeryperformed);
                $('#cmbbsrandom').val(result.cmbbsrandom);
                $('#txtbsfasting').val(result.txtbsfasting);
                $('#cmbusrandom').val(result.cmbusrandom);
                $('#txtusfasting').val(result.txtusfasting);
                $('#cmbhbsag').val(result.cmbhbsag);
                $('#txtbp').val(result.txtbp);
                $('#cmbbspostmeal').val(result.cmbbspostmeal);
                $('#txtbspostmeal').val(result.txtbspostmeal);
                $('#cmbuspostmeal').val(result.cmbuspostmeal);
                $('#txtuspostmeal').val(result.txtuspostmeal);
                $('#cmbecg').val(result.cmbecg);
                $('#cmbhiv').val(result.cmbhiv);
                $('#txtfitnessby').val(result.txtfitnessby);
                $('#txtother').val(result.txtother);
                $('#txtramtest').val(result.txtramtest);
                if (result.chkprostate == 1) {
                    $('#chkprostate').val(result.chkprostate).attr('checked', true);
                } else {
                    $('#chkprostate').val(result.chkprostate);
                }
                $('#txtprostate').val(result.txtprostate);
                $('#cmbprostate').val(result.cmbprostate);
                $('#cmbdialatedwith').val(result.cmbdialatedwith);
                $('#cmbpupdilation').val(result.cmbpupdilation);
                $('#cmbopdlri').val(result.cmbopdlri);
                $('#txtpropincision').val(result.txtpropincision);
                $('#txtpropincisionat').val(result.txtpropincisionat);
                $('#txtpropincisioncyl').val(result.txtpropincisioncyl);
                $('#cmbsocket').val(result.cmbsocket);
                $('#cmbptcooperation').val(result.cmbptcooperation);
                $('#cmbpropanaesthesia').val(result.cmbpropanaesthesia);
                $('#txtnucleus').val(result.txtnucleus);
                $('#txtquickremark').val(result.txtquickremark);
                $('#txtsurgeon').val(result.txtsurgeon);
                $('#txtsurassitant').val(result.txtsurassitant);
                $('#txtanesthetist').val(result.txtanesthetist);
                $('#txtanasthesiagiven').val(result.txtanasthesiagiven);
                $('#cmbioltype').val(result.cmbioltype);
                $('#txtcompanyname').val(result.txtcompanyname);
                $('#txtipdiolpower').val(result.txtipdiolpower);
                $('#txtcylfortoric').val(result.txtcylfortoric);
                $('#txtaxis').val(result.txtaxis);
                $('#txtaconstant').val(result.txtaconstant);
                $('#cmbccc').val(result.cmbccc);
                $('#txtcapstaining').val(result.txtcapstaining);
                $('#txtirrigationsol').val(result.txtirrigationsol);
                $('#txtviscoelastic').val(result.txtviscoelastic);
                $('#txtintracameralantibiotic').val(result.txtintracameralantibiotic);
                $('#cmblri').val(result.cmblri);
                $('#cmbwoundhydration').val(result.cmbwoundhydration);
                $('#txtremark').val(result.txtremark);
                $('#admissiondate').val(result.admissiondate);
                $('#txtsurgerydate').val(result.txtsurgerydate);
                $('#cmbhearingstatus').val(result.cmbhearingstatus);
                $('#followupdate').val(result.followupdate);
                $('#surgerynotes').val(result.surgerynotes).attr("selected",true);
                $('#txtsurgerynotes').val(result.txtsurgerynotes);
            }
        }
    });
}

function getPrevVisitDetails(MrdNo) {
    //var MrdNo = $('#MrdNo').val();
    $.ajax({
        url: "{{ url('getPrevVisitDetails') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            MrdNo: MrdNo
        },
        dataType: "json",
        success: function(data) {
            console.log(data);
            $('#txtbp').val(data.BP);
            $('#txtdiagnosis').val(data.Diagnosis);
        }
    });
}
$(document).ready(function() {
    var MrdNo = $('#MrdNo').val();
    getPatientDetails(MrdNo);
    //getPrevVisitDetails(MrdNo);
    var eye = $('#cmbtreateye').val();
    checkOtPatient(MrdNo, eye);
    $('#validation-form').on('submit', function(e) {
        e.preventDefault();
        if ($('#validation-form').valid()) {
            $.ajax({
                url: "{{ url('saveOtNotesOther') }}",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                processData: false,
                beforeSend: function() {
                    $('#submit').attr('disabled', 'disabled');
                    $('#submit').text('Please Wait...');
                },
                success: function(data) {
                    $('#actionvalue').val('Edit');
                    $('#saveid').val(data);
                    $('#printbtn').attr("disabled", false);
                    $('#discbtn').attr("disabled", false);
                    $('#submit').attr('disabled', false);
                    $('#submit').text('Submit');

                }
            });
        }

    });


    $(document).on("change", "#cmbtreateye", function(event) {
        var eye = this.value;
        var val = $('#MrdNo').val();
        checkOtPatient(val, eye);
    });
    $(document).on("change", "#PatientId", function(event) {
        var val = this.value;
        var eye = $('#cmbtreateye').val();
        checkOtPatient(val, eye);

    });

    $(document).on("shown.bs.modal", "#modal-report", function() {
        $('#search_text77').focus();
    });

    $(document).on("change", "#surgerynotes", function(event) {
        var type = this.value;
        $.ajax({
        url: "{{ url('getSurgeryNotes') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            type: type
        },
        dataType: "json",
        success: function(data) {
          $('#txtsurgerynotes').val(data.Details);
         
        }
    });
    });

    

});
</script>