<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8" />
    <title>Counselling List</title>
    <style type="text/css">
        body {
            font-family: Verdana, Arial, Helvetica, sans-serif;
            margin: 0;
            padding: 20px;
        }

        .style2 {
            font-size: 18px;
            font-weight: bold;
        }

        .alltxt2 {
            border-collapse: collapse;
            width: 100%;
        }

        .alltxt2 th,
        .alltxt2 td {
            border: 1px solid #000;
            padding: 8px 12px; /* increased padding */
            font-size: 14px;
            text-align: left;
        }

        /* Alternate row colors: odd = grey, even = white */
        .alltxt2 tbody tr:nth-child(odd) {
            background-color: #f0f0f0;
        }

        .alltxt2 tbody tr:nth-child(even) {
            background-color: #ffffff;
        }

        .button-container {
            text-align: right;
            margin-bottom: 10px;
        }

        .button-container button {
            font-size: 16px;
            margin-left: 10px;
            padding: 6px 12px;
        }

        @media print {
            .noPrint {
                display: none !important;
            }

            @page {
                size: A4 landscape;
                margin: 10mm;
            }

            body {
                -webkit-print-color-adjust: exact;
            }

            a[href]:after {
                content: none !important;
            }
        }
    </style>

    <script>
        function exportTableToExcel(tableID, filename = '') {
            const dataType = 'application/vnd.ms-excel';
            const table = document.getElementById(tableID);

            // Add borders explicitly via inline style for Excel
            let html = '<table border="1" style="border-collapse:collapse">';
            html += table.innerHTML;
            html += '</table>';

            const blob = new Blob(['\ufeff', html], { type: dataType });

            // File name
            filename = filename ? filename + '.xls' : 'Counselling_List.xls';

            // Create download link
            const downloadLink = document.createElement('a');
            downloadLink.href = URL.createObjectURL(blob);
            downloadLink.download = filename;
            document.body.appendChild(downloadLink);
            downloadLink.click();
            document.body.removeChild(downloadLink);
        }

        window.onafterprint = window.close;
    </script>
</head>
<body>

<div class="button-container noPrint">
    <button onclick="window.print()">🖨️ Print</button>
    <button onclick="exportTableToExcel('otTable', 'Counselling_List')">📤 Export Excel</button>
</div>

<table width="100%">
    <tr>
        <td align="center"><span class="style2">Counselling LIST</span></td>
    </tr>
    <tr>
        <td align="left">Date : {{ date("d/m/Y", strtotime(str_replace('-', '/',$fromdate))) }}</td>
    </tr>
    <tr>
        <td>
            <table id="otTable" class="alltxt2">
                <thead>
                    <tr>
                        <th>Sr.No</th>
                        <th>MRD No</th>
                        <th>Eye</th>
                        <th>Name</th>
                        <th>Mobile</th>
                        <th>Age</th>
                        <th>Gender</th>
                        <th>Consl Date</th>
                        <th>Surgery Dt</th>
                        <th>Srg.Nm</th>
                        <th>Surgery Name</th>
                        <th>Amount</th>
                        <th>IOL</th>
                        <th>Confirm for Surgery</th>
                        <th>Counselor</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $i = 1;
                    use App\Http\Controllers\ConsentController;
                    foreach ($data as $result) {
                        $docname = (new ConsentController)->getSurgeonName($result->SurgeonName);
                    ?>
                        <tr>
                            <td><?= $i ?></td>
                            <td><?= $result->MrdNo ?></td>
                            <td><?= $result->Eye ?></td>
                            <td><?= strtoupper(strtolower($result->PatientName)) ?></td>
                            <td><?= $result->Phone ?></td>
                            <td><?= $result->Age ?></td>
                            <td><?= $result->Gender ?></td>
                            <td><?= date("d/m/Y", strtotime(str_replace('-', '/', $result->CounsellingDate))) ?></td>
                            <td><?= date("d/m/Y", strtotime(str_replace('-', '/', $result->SurgeryDate))) ?></td>
                            <td><?= $docname ?></td>
                            <td><?= $result->SurgeryName ?></td>
                            <td><?= $result->SurgeryCharges ?></td>
                            <td><?= $result->Iol ?></td>
                             <td><?= $result->ConfirmSurgery ?></td>
                             <td><?= $result->CounsellingDoneBy ?></td>
                        </tr>
                    <?php $i++; } ?>
                </tbody>
            </table>
        </td>
    </tr>
</table>

</body>
</html>
