@extends('layout')

@section('content')
@php
$UserId = Session::get('UserId');
@endphp
<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold py-3 mb-0">IPD Temp Bills
        <span style="float: right;">
            <a href="/{{projectUrl()}}addIpdTempBill" class="btn btn-secondary btn-round"><i
                    class="ion ion-md-add mr-2"></i> Add New</a></span>
    </h4>
    <div class="card mb-4">
        <div class="card-body">
            <div id="alert_message"></div>
            <form id="validation-form" method="post" enctype="multipart/form-data">
                <div class="form-row">
                    <div class="form-group col-md-3">
                        <label class="form-label">Bill Date From </label>
                        <input type="date" name="FromDate" id="FromDate" class="form-control" value=""
                            autocomplete="off">
                    </div>
                    <div class="form-group col-md-3">
                        <label class="form-label">Bill Date To</label>
                        <input type="date" name="ToDate" id="ToDate" class="form-control" value="" autocomplete="off">
                    </div>
                    <input type="hidden" name="Search" value="Search">
                    <div class="form-group col-md-2" style="padding-top:20px;">
                        <button type="button" class="btn btn-primary btn-finish" id="filter">Search</button>
                    </div>
                </div>

            </form>

            <div class="table-responsive" id="custresult">


            </div>
        </div>
    </div>




</div>
@endsection
@section('scriptcontent')
@include('excelscript')
<script type="text/javascript">
$(document).ready(function() {
    queueList();

    $('#filter').click(function() {
        var FromDate = $('#FromDate').val();
        var ToDate = $('#ToDate').val();
        if (FromDate != '' && ToDate != '') {
            //$('.yajra-datatable').DataTable().destroy();
            //load_data(FromDate, ToDate);
            queueList(FromDate, ToDate);
        } else {
            alert('Both Date is required');
        }
    });

    $('#refresh').click(function() {
        $('#FromDate').val('');
        $('#ToDate').val('');
        //$('.yajra-datatable').DataTable().destroy();
        //load_data();
        queueList();
    });


    $(document).on("click", ".delete", function(event) {
        event.preventDefault();
        var id = $(this).attr("data-id");
        var action = "delete";
        swal({
            title: "Are you sure?",
            text: "You will not be able to recover this Record!",
            type: "warning",
            showCancelButton: true,
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Yes, delete",
            cancelButtonText: "No, cancel",
            closeOnConfirm: false,
            closeOnCancel: false
        }, function(isConfirm) {
            if (isConfirm) {
                $.ajax({
                    url: "{{ url('deletIpdTempBill') }}",
                    method: "POST",
                    data: {
                        _token: '{{csrf_token()}}',
                        id: id
                    },
                    beforeSend: function() {
                        $('.confirm').attr('disabled', 'disabled');
                        $('.confirm').text('Please Wait...');
                    },

                    success: function(data) {

                        swal("Deleted!", "Record has been deleted.", "success");
                        //window.location.href = "/queuemanagement";
                        queueList();



                    }
                });

            } else {
                swal("Cancelled", "Record is safe :)", "error");
            }
        });


    });


});

function queueList(FromDate = '', ToDate = '') {
    $.ajax({
        url: "{{ url('viewIpdTempBills') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}',
            FromDate: FromDate,
            ToDate: ToDate
        },
        success: function(data) {
            console.log(data);
            $('#custresult').html(data);
        }
    });
}
</script>
</script>
@endsection





