@php $page="all";
$UserType = Session::get('UserType');
$UserId = Session::get('UserId');
@endphp
{{authUser()}}
<!DOCTYPE html>

<html lang="en" class="default-style">

<head>
    <title>{{projectTitle()}}</title>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0">
    <meta name="description" content="" />
    <meta name="keywords" content="" />
    <meta name="csrf-token" content="{{ csrf_token() }}">
    @include('headerscript')
</head>

<body>
    <!-- [ Preloader ] Start -->
    <div class="page-loader">
        <div class="bg-primary"></div>
    </div>
    <!-- [ Preloader ] End -->

    <!-- [ Layout wrapper ] Start -->
    <div class="layout-wrapper layout-1 layout-without-sidenav">
        <div class="layout-inner">
            <!-- [ Layout sidenav ] Start -->
            @section('topheader')

            <!-- [ Layout navbar ( Header ) ] End -->
            @show
            @section('header')
            <div class="sidenav bg-dark align-items-lg-center">
                <div id="layout-sidenav"
                    class=" container layout-sidenav-horizontal sidenav-horizontal flex-grow-0 bg-dark" style="max-width: 1200px;">

                    <!-- Links -->
                    <ul class="sidenav-inner">
                        <!-- Dashboards -->

                        <!-- Layouts -->
                        <li class="sidenav-divider mb-1"></li>
                        <li class="sidenav-header small font-weight-semibold">UI Components</li>

                        @if($UserType == 'Optometrist')
                            @include('incadminmenu')
                        @endif

                        @if($UserId == '38' || $UserId == '39' || $UserId == '40')
                            @include('incadminmenu')
                        @endif

                        @if($UserId == '38' || $UserId == '39' || $UserId == '40')
                        @else
                        @if($UserType == 'Consultant' || $UserType == 'Admin' || $UserType == 'Superadmin')

                            @include('incadminmenu')
                           
                        @endif
                        @endif

                        

                        @if($UserType == 'Reception')
                            @include('incadminmenu')
                        @endif

                        @if($UserType == 'Optical')
                            @include('incopticalmenu')
                        @endif

                    </ul>
                </div>
            </div>

            
            @show
            <!-- [ Layout sidenav ] End -->
            <!-- [ Layout container ] Start -->
            <div class="layout-container">
                <!-- [ Layout navbar ( Header ) ] Start -->

                <!-- [ Layout content ] Start -->
                <div class="layout-content">

                    <!-- [ content ] Start -->

                    @section('content')
                    @show

                    <!-- [ content ] End -->
                    @section('footer')
                    <!-- [ Layout footer ] Start -->
                    <nav class="layout-footer footer footer-light">
                        <div
                            class="container-fluid d-flex flex-wrap justify-content-between text-center container-p-x pb-3">
                            <div class="pt-3">
                                <span class="float-md-right d-none d-lg-block"  style="color: black;">&copy; {{Session::get('User_Name')}} <i
                                        class="fas fa-heart text-danger mr-2"></i></span>
                            </div>

                        </div>
                    </nav>
                    <!-- [ Layout footer ] End -->
                    @show
                </div>
                <!-- [ Layout content ] Start -->
            </div>
            <!-- [ Layout container ] End -->
        </div>
        <!-- Overlay -->
        <div class="layout-overlay layout-sidenav-toggle"></div>
    </div>

    @include('footerscript')
    @section('scriptcontent')

    @show
    <script>
    function openNewWindow(val, height, width, left, top, right, bottom) {
        setTimeout(function() {
            window.open(
                '/{{projectUrl()}}' + val, val,
                'height=' + height + ',width=' + width + ',left=' + left + ',top=' + top + ',right=' +
                right + ',bottom=' + bottom +
                ',resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
            );
        }, 1);
    }
    </script>
</body>

</html>