
<!DOCTYPE html>

<html lang="en" class="default-style layout-fixed layout-navbar-fixed">

<head>
    <title>{{projectTitle()}}</title>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0">
    <meta name="description" content="" />
    <meta name="keywords" content="">
    <meta name="author" content="Codedthemes" />
    <link rel="icon" type="image/x-icon" href="{{url('assets/img/favicon.jpg')}}">

    <!-- Google fonts -->
    <link href="{{url('assets/fonts/roboto.css')}}" rel="stylesheet">

    <!-- Icon fonts -->
    <link rel="stylesheet" href="{{url('assets/fonts/fontawesome.css')}}">
    <link rel="stylesheet" href="{{url('assets/fonts/ionicons.css')}}">
    <link rel="stylesheet" href="{{url('assets/fonts/linearicons.css')}}">
    <link rel="stylesheet" href="{{url('assets/fonts/open-iconic.css')}}">
    <link rel="stylesheet" href="{{url('assets/fonts/pe-icon-7-stroke.css')}}">
    <link rel="stylesheet" href="{{url('assets/fonts/feather.css')}}">

    <!-- Core stylesheets -->
    <link rel="stylesheet" href="{{url('assets/css/bootstrap-material.css')}}">
    <link rel="stylesheet" href="{{url('assets/css/shreerang-material.css')}}">
    <link rel="stylesheet" href="{{url('assets/css/uikit.css')}}">

    <!-- Libs -->
    <link rel="stylesheet" href="{{url('assets/libs/perfect-scrollbar/perfect-scrollbar.css')}}">
    <!-- Page -->
    <link rel="stylesheet" href="{{url('assets/css/pages/authentication.css')}}">
    <link rel="stylesheet" href="{{url('assets/libs/growl/growl.css')}}">
    <link rel="stylesheet" href="{{url('assets/libs/toastr/toastr.css')}}">
</head>

<body>
    <!-- [ Preloader ] Start -->
    <div class="page-loader">
        <div class="bg-primary"></div>
    </div>
    <!-- [ Preloader ] End -->

    <!-- [ Content ] Start -->
    <div class="authentication-wrapper authentication-2 ui-bg-cover ui-bg-overlay-container px-4" style="background-image: url('{{url('assets/img/bg/21.jpg')}}">
        <div class="ui-bg-overlay bg-dark opacity-25"></div>

        <div class="authentication-inner py-5">

            <div class="card">
                <div class="p-4 p-sm-5">
                    <!-- [ Logo ] Start -->
                    <div class="d-flex justify-content-center align-items-center pb-2 mb-4">
                        <div class="">
                            <div class="w-100 position-relative">
                                <img src="{{url('assets/img/mainlogo.jpg')}}" alt="Brand Logo" class="img-fluid">
                                <div class="clearfix"></div>
                            </div>
                        </div>
                    </div>
                    <!-- [ Logo ] End -->

                    <h5 class="text-center text-muted font-weight-normal mb-4"><strong>Siddhivinayak</strong> <strong style="color:#3badb5;">Netralaya</strong></h5>

                    <!-- Form -->
                    <form id="validation-form" method="post" novalidate="novalidate" autocomplete="off">
                        @csrf
                        <div class="form-group">
                            <label class="form-label">Username</label>
                            <input type="text" class="form-control" name="Username" id="Username">
                            <div class="clearfix"></div>
                        </div>
                        <div class="form-group">
                            <label class="form-label d-flex justify-content-between align-items-end">
                                <span>Password</span>
                                <!-- <a href="pages_authentication_password-reset.html" class="d-block small">Forgot password?</a> -->
                            </label>
                            <input type="password" class="form-control" name="Password" id="Password">
                            <div class="clearfix"></div>
                        </div>
                        <div class="d-flex justify-content-between align-items-center m-0">
                            <!-- <label class="custom-control custom-checkbox m-0">
                                <input type="checkbox" class="custom-control-input">
                                <span class="custom-control-label">Remember me</span>
                            </label> -->
                            <button type="submit" name="submit" id="login" class="btn btn-primary">Sign In</button>
                        </div>
                    </form>
                    <!-- [ Form ] End -->

                </div>
                <!-- <div class="card-footer py-3 px-4 px-sm-5">
                    <div class="text-center text-muted">
                        Don't have an account yet?
                        <a href="pages_authentication_register-v2.html">Sign Up</a>
                    </div>
                </div> -->
            </div>

        </div>
    </div>
    <!-- / Content -->

    <!-- Core scripts -->
    <script src="{{url('assets/js/pace.js')}}"></script>
    <script src="{{url('assets/js/jquery-3.6.0.min.js')}}"></script>
    <script src="{{url('assets/libs/popper/popper.js')}}"></script>
    <script src="{{url('assets/js/bootstrap.js')}}"></script>
    <script src="{{url('assets/js/sidenav.js')}}"></script>
    <script src="{{url('assets/js/layout-helpers.js')}}"></script>
    <script src="{{url('assets/js/material-ripple.js')}}"></script>

    <!-- Libs -->
    <script src="{{url('assets/libs/perfect-scrollbar/perfect-scrollbar.js')}}"></script>
    <script src="{{url('assets/libs/growl/growl.js')}}"></script>
    <script src="{{url('assets/libs/toastr/toastr.js')}}"></script>

    <!-- Demo -->
    <script src="{{url('assets/js/demo.js')}}"></script>
    <script src="{{url('assets/js/analytics.js')}}"></script>
    <script src="{{url('assets/js/pages/ui_notifications.js')}}"></script>

    <script>
        function error_toast(){
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
   $.growl.error({
      title:    'Error',
      message:  'Invalid Username / Password',
      location: isRtl ? 'tl' : 'tr'
    });
  }
    function success_toast(){
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
   $.growl.notice({
      title:    'Success',
      message:  'Login Successfull! Please Wait...',
      location: isRtl ? 'tl' : 'tr'
    });
  }
        $(document).ready(function(){
            $('#validation-form').on('submit', function(e){
      e.preventDefault();    
         $.ajax({  
                url :"{{ url('login') }}",
                method:"POST",  
                data:new FormData(this),  
                contentType:false,  
                processData:false,  
                 beforeSend:function(){
     $('#login').attr('disabled','disabled');
     $('#login').text('Please Wait...');
    },
                success:function(data){ 
                   console.log(data);
                   if(data == 1){
                    success_toast();
                    setTimeout(function(){  
                   
                   window.location.href = '/{{projectUrl()}}dashboard'; 
                   
                      }, 2000);
                   }
                   else{
                    error_toast();
                   }
                      $('#login').attr('disabled',false);
                       $('#login').text('Submit');
                       
                }  
           })  

  
  });   
        });
    </script>
</body>

</html>
