<!DOCTYPE html>
<html lang="en" class="default-style">

<head>
    <title>{{projectTitle()}}</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=no,minimum-scale=1,maximum-scale=1">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <meta name="author" content="Codedthemes">
    @include('headerscript')
</head>
<style>
    #cover-spin {
    position:fixed;
    width:100%;
    left:0;right:0;top:0;bottom:0;
    background-color: rgba(255,255,255,0.7);
    z-index:9999;
    display:none;
}

@-webkit-keyframes spin {
	from {-webkit-transform:rotate(0deg);}
	to {-webkit-transform:rotate(360deg);}
}

@keyframes spin {
	from {transform:rotate(0deg);}
	to {transform:rotate(360deg);}
}

#cover-spin::after {
    content:'';
    display:block;
    position:absolute;
    left:48%;top:40%;
    width:40px;height:40px;
    border-style:solid;
    border-color:rgb(79, 175, 184);
    border-top-color:transparent;
    border-width: 4px;
    border-radius:50%;
    -webkit-animation: spin .8s linear infinite;
    animation: spin .8s linear infinite;
}
    </style>
<div class="container-fluid flex-grow-1 container-p-y">
    <!-- <h4 class="font-weight-bold py-3 mb-0">Counsellings Lists</h4> -->

    <div class="row">
        <!-- customar project  start -->
        <div class="col-xl-12">

            <div class="card mb-4">
                <div class="card-body">
                    <div id="alert_message"></div>
                    <form id="validation-form22" method="post" enctype="multipart/form-data">
                        <div class="form-row">
                            <div class="form-group col-md-2">
                                <label class="form-label">MRD No </label>
                                <input type="text" name="MrdNo" id="MrdNo" class="form-control" value=""
                                    autocomplete="off" oninput="getLastQueueDetails()">
                            </div>
                            <div class="form-group col-md-3">
                                <label class="form-label">Patient Name </label>
                                <input type="text" name="PatientName" id="PatientName" class="form-control" value=""
                                    autocomplete="off">
                            </div>
                            <!-- <div class="form-group col-md-2">
                                <label class="form-label">Visit No</label>
                                <input type="text" name="VisitNo" id="VisitNo" class="form-control" value=""
                                    autocomplete="off" readonly>
                            </div> -->
                            <div class="form-group col-md-2">
                                <label class="form-label">Visit Date</label>
                                <input type="date" name="VisitDate" id="VisitDate" class="form-control" value="{{date('Y-m-d')}}"
                                    autocomplete="off" readonly>
                            </div>


                            <div class="form-group col-md-2" style="padding-top:20px;">
                                <button type="button" id="filter" class="btn btn-primary btn-finish" onclick="backToQueue()">Submit</button>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
          
        </div>
        <!-- customar project  end -->
    </div>
    <div id="cover-spin"></div>



</div>
@include('footerscript')
<script type="text/javascript">
function getLastQueueDetails(){
    var MrdNo = $('#MrdNo').val();
    var VisitDate = $('#VisitDate').val();
    $.ajax({
            url: "{{ url('getLastQueueDetails') }}",
            method: "POST",
            data: {
                _token: '{{csrf_token()}}',
                MrdNo: MrdNo,
                VisitDate:VisitDate
            },
            dataType: "json",
            success: function(data) {
                //console.log(data);
            //$('#MrdNo').val(data.MrdNo);
            $('#PatientName').val(data.PatientName);
            }
        });
}
function backToQueue(){
    $('#cover-spin').show(0);
    var MrdNo = $('#MrdNo').val();
    var VisitDate = $('#VisitDate').val();
    $.ajax({
            url: "{{ url('backToQueue') }}",
            method: "POST",
            data: {
                _token: '{{csrf_token()}}',
                MrdNo: MrdNo,
                VisitDate:VisitDate
            },
            success: function(data) {
                //console.log(data);
                $('#cover-spin').hide(0);
                alert("Patient Added in queue Successfully!");
                window.close();
            }
        });
}
</script>