@include('header')
<div class="container-fluid flex-grow-1 container-p-y">
    <div class="nav-tabs-top mb-4">
        <ul class="nav nav-tabs">
            <li class="nav-item">
                <a class="nav-link active" data-toggle="tab" href="#tab1">IPD Temp Bill Report</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" data-toggle="tab" href="#tab2">IPD Bill Report</a>
            </li>
            <!-- <li class="nav-item">
                <a class="nav-link" data-toggle="tab" href="#tab3">OPD Summary Report 2</a>
            </li> -->

        </ul>
        <div class="tab-content">
            <div class="tab-pane fade show active" id="tab1">
                <div class="card-body">
                    <form id="validation-form22" method="post" enctype="multipart/form-data">
                        <div class="form-row">

                            <div class="form-group col-md-3">
                                <label class="form-label">Consultant </label>
                                <select class="form-control" style="width: 100%;margin-top: 3px !important;"
                                    data-allow-clear="true" name="Consultant" id="ConsultantId" required>
                                    <option value="all" selected="">All</option>
                                    @foreach($consultantList as $result)
                                    <option value="{{$result->id}}">{{$result->Name}}</option>
                                    @endforeach
                                </select>
                                <div class="clearfix"></div>
                            </div>

                            <div class="form-group col-md-2">
                                <label class="form-label">From Date </label>
                                <input type="date" name="FromDate" id="FromDate" class="form-control"
                                    value="{{date('Y-m-d')}}" autocomplete="off" required>
                            </div>
                            <div class="form-group col-md-2">
                                <label class="form-label">To Date</label>
                                <input type="date" name="ToDate" id="ToDate" class="form-control"
                                    value="{{date('Y-m-d')}}" autocomplete="off" required>
                            </div>

                            <input type="hidden" name="Search" value="Search">
                            <div class="form-group col-md-2" style="padding-top:20px;">
                                <button type="button" id="filter" class="btn btn-primary btn-finish">Search</button>
                            </div>
                        </div>

                    </form>

                    <div class="card">
                        <div class="card-body">


                            <div class="table-responsive" id="custresult">


                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="tab2">
                <div class="card-body">
                    <form id="validation-form33" method="post" enctype="multipart/form-data">
                        <div class="form-row">
                            <div class="form-group col-md-3">
                                <label class="form-label">Consultant </label>
                                <select class="form-control" style="width: 100%;margin-top: 3px !important;"
                                    data-allow-clear="true" name="Consultant2" id="ConsultantId2" required>
                                    <option value="all" selected="">All</option>
                                    @foreach($consultantList as $result)
                                    <option value="{{$result->id}}">{{$result->Name}}</option>
                                    @endforeach
                                </select>
                                <div class="clearfix"></div>
                            </div>
                            <div class="form-group col-md-2">
                                <label class="form-label">From Date </label>
                                <input type="date" name="FromDate2" id="FromDate2" class="form-control"
                                    value="{{date('Y-m-d')}}" autocomplete="off" required>
                            </div>
                            <div class="form-group col-md-2">
                                <label class="form-label">To Date</label>
                                <input type="date" name="ToDate2" id="ToDate2" class="form-control"
                                    value="{{date('Y-m-d')}}" autocomplete="off" required>
                            </div>

                            <input type="hidden" name="Search" value="Search">
                            <div class="form-group col-md-2" style="padding-top:20px;">
                                <button type="button" id="filter2" class="btn btn-primary btn-finish">Search</button>
                            </div>
                        </div>

                    </form>

                    <div class="card">
                        <div class="card-body">


                            <div class="table-responsive" id="custresult2">


                            </div>
                        </div>
                    </div>
                </div>
            </div>



        </div>
    </div>





</div>

@include('footerscript')
@include('excelscript')
<script>
$(document).ready(function() {
    $('#filter').click(function() {
        var FromDate = $('#FromDate').val();
        var ToDate = $('#ToDate').val();
        var Consultant = $('#ConsultantId').val();
        if (FromDate != '' && ToDate != '') {
            //$('.yajra-datatable').DataTable().destroy();
            //load_data(FromDate, ToDate);
            queueList(FromDate, ToDate, Consultant);
        } else {
            alert('Both Date is required');
        }
    });

    $('#refresh').click(function() {
        $('#FromDate').val('');
        $('#ToDate').val('');
        $('#ConsultantId').val('all').attr("selected", true);
        queueList();
    });

    function queueList(FromDate = '', ToDate = '', Consultant = 'all') {
        $.ajax({
            url: "{{ url('viewIpdTempBillReport') }}",
            method: "POST",
            data: {
                _token: '{{csrf_token()}}',
                FromDate: FromDate,
                ToDate: ToDate,
                Consultant: Consultant
            },
            success: function(data) {
                console.log(data);
                $('#custresult').html(data);
            }
        });
    }



    $('#filter2').click(function() {
        var FromDate = $('#FromDate2').val();
        var ToDate = $('#ToDate2').val();
        var Consultant = $('#ConsultantId2').val();
        if (FromDate != '' && ToDate != '') {
            queueList2(FromDate, ToDate, Consultant);
        } else {
            alert('Both Date is required');
        }
    });

    $('#refresh2').click(function() {
        $('#FromDate2').val('');
        $('#ToDate2').val('');
        $('#ConsultantId2').val('all').attr("selected", true);
        queueList2();
    });

    function queueList2(FromDate = '', ToDate = '', Consultant = 'all') {
        $.ajax({
            url: "{{ url('viewIpdBillReport') }}",
            method: "POST",
            data: {
                _token: '{{csrf_token()}}',
                FromDate: FromDate,
                ToDate: ToDate,
                Consultant: Consultant
            },
            success: function(data) {

                $('#custresult2').html(data);
            }
        });
    }



});
</script>
