@php $UserType = Session::get('UserType');@endphp
<table id="example" class="table table-striped table-bordered" style="width:100%">
    <thead>
        <tr>
            <th>Sr.No</th>
            <th>Receipt No</th>
            <th>Date</th>
            <th>Patient Name</th>
            <th>UHID/IPD No</th>
            <th>Procedure</th>
            <th>Total No</th>
            <th>Consultant</th>
            <th>Amount</th>
            <th>Payment Mode</th>
            
            <th>Action</th>
           
            <th>Print</th>
        </tr>
    </thead>
    <tbody>
        @php $i=1;
        use App\Http\Controllers\TubingReceiptController;
        @endphp
        @foreach($data as $result)
        <tr>
            <td>{{$i}}</td>
            <td>{{$result->ReceiptNo}}</td>
            <td>{{date("d/m/Y", strtotime(str_replace('-', '/', $result->Date)))}}</td>
            <td>{{$result->MrdNo}}/{{$result->PatientName}}</td>
            <td>{{$result->UhidNo ? $result->UhidNo : ($result->IpdNo ? $result->IpdNo : '-')}}</td>
            <td>{{$result->Procedure}}</td>
            <td>{{$result->TotalNo ? $result->TotalNo : '-'}}</td>
            <td>{{$result->Consultant ? $result->Consultant : '-'}}</td>
            <td>&#8377;{{number_format($result->Amount,2)}}</td>
            <td>{{$result->PayMode}}</td>
           
            <td>
                <a data-id="{{$result->id}}" href='javascript:void(0);' data-toggle="tooltip" data-placement="top"
                    title="Edit" data-original-title="Edit" class="update"><i
                        class="lnr lnr-pencil mr-2"></i></a>&nbsp;&nbsp;
                <a data-id="{{$result->id}}" href='javascript:void(0);' data-toggle="tooltip" data-placement="top"
                    title="Delete" data-original-title="Delete" class="delete" id="bootbox-confirm"><i
                        class="lnr lnr-trash text-danger"></i></a> 
            </td> 
            
            <td><a href='javascript:void(0)' onclick="printCard({{$result->id}})" class="btn btn-info btn-sm"><i
                        class="feather icon-printer"></i>&nbsp;Print </a></td>
        </tr>
        @php $i++;@endphp
        @endforeach
        <tr>
            <td>{{$i}}</td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <th>Total</th>
            <th>&#8377;{{number_format($total,2)}}</th>
            <td></td>
            <td></td>
            <td></td>
        </tr>
    </tbody>
</table>
<script type="text/javascript">
$(document).ready(function() {
    $('#example').DataTable({
        "scrollX": true,
        order: [[0, 'desc']],
        dom: 'Bfrtip',
        buttons: [
            'excelHtml5'
        ]
    });
});
</script>
