<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\RestoController;
use App\Http\Controllers\MasterController;
use App\Http\Controllers\QueueController;
use App\Http\Controllers\OptoController;
use App\Http\Controllers\ConsultantController;
use App\Http\Controllers\TreatmentController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\PackageController;
use App\Http\Controllers\ProcedureController;
use App\Http\Controllers\SurgeryNoteController;
use App\Http\Controllers\EmpController;
use App\Http\Controllers\AccountSettingController;
use App\Http\Controllers\OpdAppointmentController;
use App\Http\Controllers\DischargeController;
use App\Http\Controllers\BillController;
use App\Http\Controllers\IpdReceiptController;
use App\Http\Controllers\IpdController;
use App\Http\Controllers\OpdReceiptController;
use App\Http\Controllers\CounsellingController;
use App\Http\Controllers\IpdInvestigationController;
use App\Http\Controllers\GeneralReceiptController;
use App\Http\Controllers\TubingReceiptController;
use App\Http\Controllers\VaccineReceiptController;
use App\Http\Controllers\XrayReceiptController;
use App\Http\Controllers\TempBillController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\DrugsController;
use App\Http\Controllers\OTNoteController;
use App\Http\Controllers\OtConsentController;
use App\Http\Controllers\OpticalController;
use App\Http\Controllers\LenseController;
use App\Http\Controllers\MedicalCertiController;
use App\Http\Controllers\OTNoteOtherController;
use App\Http\Controllers\DischargeOtherController;
use App\Http\Controllers\SpecInstController;
use App\Http\Controllers\OtScheduledController;
use App\Http\Controllers\OpdExpenseController;
use App\Http\Controllers\MedicineController;
use App\Http\Controllers\IpdMadamReceiptController;
use App\Http\Controllers\AppointmentController;
use App\Http\Controllers\IpdReportController;
use App\Http\Controllers\PatientBalanceController;
use App\Http\Controllers\SpecialityController;
use App\Http\Controllers\OtherReceiptController;
use App\Http\Controllers\UtilityController;
use App\Http\Controllers\WhatsAppController;
use App\Http\Controllers\ConsultationChargesController;
use App\Http\Controllers\VendorController;
use App\Http\Controllers\YoutubeController;
use App\Http\Controllers\InvestigationController;
use App\Http\Controllers\ReferedByController;
use App\Http\Controllers\ConsentController;
use App\Http\Controllers\CertificateController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::controller(CertificateController::class)->group(function(){
    Route::get('/referralForm','referralForm');
    Route::post('/viewReferralForm','viewReferralForm');
    Route::get('/addReferralForm','addReferralForm');
    Route::post('/saveReferralForm','saveReferralForm');
    Route::get('/printReferralForm/{id}','printReferralForm');
    Route::post('/deleteCertiticate','deleteCertiticate');
    });

Route::controller(RestoController::class)->group(function(){
   // Artisan::call('cache:clear');
    Route::get('/', 'index');
    Route::post('/login', 'login');
    Route::get('/dashboard','dashboard');
});

Route::controller(ConsentController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::get('/consent','consent');
    Route::get('/addConsent', 'addConsent');
    Route::get('/editConsent/{id}', 'editConsent');
    Route::post('/saveConsent', 'saveConsent');
    Route::post('/deleteConsent','deleteConsent');
    Route::get('/consentPrint/{id}/{consentid}', 'consentPrint');
    Route::get('/ipdPaper/{id}', 'ipdPaper');
});

Route::controller(InvestigationController::class)->group(function(){
   // Artisan::call('cache:clear');
    Route::get('/InvestigationList', 'InvestigationList');
    Route::post('/viewInvestigationPatientList', 'viewInvestigationPatientList');
    Route::post('/getInvstPtDetails', 'getInvstPtDetails');
    Route::post('/checkoutInvst', 'checkoutInvst');
    Route::get('/addInvestigation', 'addInvestigation');
    Route::post('/saveInvestigations', 'saveInvestigations');
    Route::post('/updateInvestigation', 'updateInvestigation');
    Route::post('/deleteInvstRecord', 'deleteInvstRecord');
    
});



Route::controller(MasterController::class)->group(function(){
   // Artisan::call('cache:clear');
    Route::post('/getPatientDetails','getPatientDetails');
    Route::post('/getPatientDetails2','getPatientDetails2');
    Route::post('/getIpdPatientDetails','getIpdPatientDetails');
    Route::post('/patientList','getPatientList');
    Route::post('/visitdate','visitdate');
    Route::post('/getDescList','getDescList');
    Route::post('/saveDesc','saveDesc');
    Route::post('/updateDesc','updateDesc');
    Route::post('/deleteDesc','deleteDesc');
    Route::post('/newPatientDataList','newPatientDataList');
    Route::post('/findCurrAge','findCurrAge');
    Route::post('/getDescList2','getDescList2');
    Route::post('/getSurgeryNotes','getSurgeryNotes');
});

Route::controller(UserController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::get('/usermaster', 'usermaster');
    Route::post('/usermasterlist', 'usermasterlist');
    Route::post('/usermastersave', 'usermastersave');
    Route::post('/deleteuser','deleteuser');
    Route::post('/showData','showData');
    Route::post('/consultantDetails','consultantDetails');
});

Route::controller(TreatmentController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::post('/getTreatments','getTreatments');
    Route::get('/treatmentmaster/{val}','treatmentmaster');
    Route::post('/getMoreTreatments','getMoreTreatments');
    Route::post('/saveTreatments','saveTreatments');
    Route::post('/getSaveTreatments','getSaveTreatments');
    Route::post('/deleteTreatment','deleteTreatment');
    Route::post('/getTreatments2','getTreatments2');
    Route::post('/getTreatDate','getTreatDate');
    Route::post('/getTapDate','getTapDate');
    Route::post('/getUnchkTapDate','getUnchkTapDate');
    Route::post('/deleteConsultantTreatment','deleteConsultantTreatment');
    Route::post('/deleteConsDrug','deleteConsDrug');
    Route::post('/showTreatmentList','showTreatmentList');
    Route::post('/getDrugByType','getDrugByType');
    
    
    
});

Route::controller(PackageController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::get('/packagemaster','packagemaster');
    Route::post('/savePackage','savePackage');
    Route::post('/calBalanceAmt','calBalanceAmt');
    Route::post('/getPackageDetails','getPackageDetails');
    Route::post('/viewPackageList','viewPackageList');
    Route::post('/editPackage','editPackage');
    Route::post('/deleteCharge','deleteCharge');
    Route::post('/deletePackage','deletePackage');
    
});

Route::controller(ProcedureController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::get('/procedure','procedure');
    Route::post('/viewProcedureList','viewProcedureList');
    Route::post('/saveProcedure','saveProcedure');
    Route::post('/editProcedure','editProcedure');
    Route::post('/deleteProcedure','deleteProcedure');
    Route::post('/getProcedureDetails','getProcedureDetails');
    
    Route::post('/investigationLists','investigationLists');
    Route::post('/getInvestigationAmount','getInvestigationAmount');
    
});

Route::controller(ReferedByController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::get('/referedBy','referedBy');
    Route::post('/viewReferedByList','viewReferedByList');
    Route::post('/saveReferedBy','saveReferedBy');
    Route::post('/editReferedBy','editReferedBy');
    Route::post('/deleteReferedBy','deleteReferedBy');
   // Route::post('/getProcedureDetails','getProcedureDetails');
    
});

Route::controller(SpecialityController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::get('/specialityclinic','specialityclinic');
    Route::post('/viewSpecialityClinicList','viewSpecialityClinicList');
    Route::post('/saveSpecialityClinic','saveSpecialityClinic');
    Route::post('/editSpecialityClinic','editSpecialityClinic');
    Route::post('/deleteSpecialityClinic','deleteSpecialityClinic');
    Route::post('/getSpecialityClinicDetails','getSpecialityClinicDetails');
    Route::post('/getSpecConsultant','getSpecConsultant');
    Route::post('/getSpecClinic','getSpecClinic');
    
    
    
});

Route::controller(SurgeryNoteController::class)->group(function(){
   // Artisan::call('cache:clear');
    Route::get('/surgerynotes','surgerynotes');
    Route::post('/viewSurgeryNoteList','viewSurgeryNoteList');
    Route::post('/saveSurgeryNote','saveSurgeryNote');
    Route::post('/editSurgeryNote','editSurgeryNote');
    Route::post('/deleteSurgeryNote','deleteSurgeryNote');
});



Route::controller(DrugsController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::get('/drugs','drugs');
    Route::post('/viewDrugList','viewDrugList');
    Route::post('/saveDrug','saveDrug');
    Route::post('/editDrug','editDrug');
    Route::post('/deleteDrug','deleteDrug');
    Route::post('/saveDrugList','saveDrugList');
});

Route::controller(MedicineController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::post('/viewMedicineList','viewMedicineList');
    Route::post('/saveMedicine','saveMedicine');
    Route::post('/editMedicine','editMedicine');
    Route::post('/deleteMedicine','deleteMedicine');
    
    
});

Route::controller(SpecInstController::class)->group(function(){
   // Artisan::call('cache:clear');
    Route::post('/viewSpecInstList','viewSpecInstList');
    Route::post('/saveSpecInst','saveSpecInst');
    Route::post('/editSpecInst','editSpecInst');
    Route::post('/deleteSpecInst','deleteSpecInst');
    Route::post('/saveSpecInstList','saveSpecInstList');
    Route::post('/getSpecInstDetails','getSpecInstDetails');
});

Route::controller(QueueController::class)->group(function(){
   // Artisan::call('cache:clear');
    Route::get('/queuemanagement', 'queuemanagement');
    Route::get('/queuelist', 'queuelist')->name('queue.listing');
    Route::post('/saveQueue', 'saveQueue');
    Route::post('/EditQueue', 'EditQueue');
    Route::post('/deletqueue','deletqueue');
    Route::post('/saveOldQueue', 'saveOldQueue');
    Route::get('/new-patients', 'newpatients')->name('emp.listing');
    Route::post('/getPatientRes', 'getPatientRes');
    Route::post('/viewQueueList', 'viewQueueList');
    Route::post('/viewNewPatientList', 'viewNewPatientList');
    Route::get('/opdPrint/{id}', 'opdPrint');
    Route::post('/fetchPatientDetails', 'fetchPatientDetails');
    Route::get('/newPatient', 'newPatient');
    Route::post('/deletPatient','deletPatient');
    Route::post('/updatePatientData','updatePatientData');
    Route::post('/calculateAge','calculateAge');
    Route::post('/patientOut','patientOut');
    Route::post('/fetchQueuePatientDetails', 'fetchQueuePatientDetails');
    Route::post('/updateQueueDetails', 'updateQueueDetails');
    Route::post('/changeFees', 'changeFees');
    Route::post('/refreshQueue', 'refreshQueue');
    Route::get('/dailyReport/{date}', 'dailyReport');
    Route::get('/viewOpdQueue', 'viewOpdQueue');
    Route::get('/patientPrevSummary', 'patientPrevSummary');
    Route::post('/getLastVisit', 'getLastVisit');
    Route::post('/getPatientList', 'getPatientList');
    Route::get('/BringBackToQueue', 'BringBackToQueue');
    Route::post('/getLastQueueDetails', 'getLastQueueDetails');
    Route::post('/backToQueue', 'backToQueue');
    Route::get('/stickerPrint/{mrdno}','stickerPrint');
    Route::post('/getRefList', 'getRefList');
    Route::post('/getSearchPatientList', 'getSearchPatientList');
    Route::post('/clearBlankRecord', 'clearBlankRecord');
    Route::get('/todayPatientList/{val}', 'todayPatientList');
    
});

Route::controller(OptoController::class)->group(function(){
// Artisan::call('cache:clear');
    Route::get('/optoform/{id}/{date}/{qid}', 'optoform');
    Route::post('/saveOpto', 'saveOpto');
    Route::get('/opdDetailPrint/{id}/{no}/{date}', 'opdDetailPrint');
    Route::post('/patientCheck', 'patientCheck');
    Route::post('/getMaxVisitNo', 'getMaxVisitNo');
    Route::post('/getVisitNoDate', 'getVisitNoDate');
    Route::post('/copyRecord', 'copyRecord');
    Route::post('/pasteRecord', 'pasteRecord');
    Route::get('/opdShortDetailPrint/{id}/{no}/{date}', 'opdShortDetailPrint');
    Route::post('/getVisitDetails', 'getVisitDetails');
    Route::post('/fetchData', 'fetchData');
    Route::post('/fetchData2', 'fetchData2');
    
    
});

Route::controller(ConsultantController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::post('/saveConsultant', 'saveConsultant');
    Route::get('/opdSummary/{mrdno}', 'opdSummary');
    Route::post('/getAppDate', 'getAppDate');
    Route::post('/copyRecord2', 'copyRecord2');
    Route::post('/pasteRecord2', 'pasteRecord2');
    Route::post('/getTreatNameDetails', 'getTreatNameDetails');
    Route::post('/getReviewDays', 'getReviewDays');
    Route::post('/getConsultVisitDetails', 'getConsultVisitDetails');
    Route::post('/getVisitSummaryDetails', 'getVisitSummaryDetails');
    Route::post('/getPrevOptoCons', 'getPrevOptoCons');
    
    
});

Route::controller(OpdAppointmentController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::get('/opdAppointment', 'opdAppointment');
    Route::post('/viewOpdAppointmentList', 'viewOpdAppointmentList');
    Route::post('/saveAppointment', 'saveAppointment');
    Route::post('/addInQueue', 'addInQueue');
    Route::post('/getAppTime','getAppTime');
});

Route::controller(CounsellingController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::get('/counselling', 'addCounselling');
    Route::post('/getLastCounsellingId', 'getLastCounsellingId');
    Route::post('/saveCounselling', 'saveCounselling');
    Route::post('/fetchCounsellingDetails', 'fetchCounsellingDetails');
    Route::get('/viewCounsellings', 'viewCounsellings');
    Route::post('/viewCounsellingList', 'viewCounsellingList');
    Route::post('/deletCounselling', 'deletCounselling');
});

Route::controller(DischargeController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::get('/dischargeCard', 'dischargeCard');
    Route::post('/viewDischargeCard', 'viewDischargeCard');
    Route::get('/addDischargeCard', 'addDischargeCard');
    Route::post('/saveDischargeCard', 'saveDischargeCard');
    Route::post('/deletDischargeCard', 'deletDischargeCard');
    Route::get('/editDischargeCard/{id}', 'editDischargeCard');
    Route::post('/getPatientTreatment', 'getPatientTreatment');
    Route::get('/printDischargeCard/{id}', 'printDischargeCard');
    Route::post('/checkDcPatient', 'checkDcPatient');
    Route::post('/getPatientTreatment2', 'getPatientTreatment2');
    Route::get('/addDischargeCard2/{mrdno}/{otid}', 'addDischargeCard2');
    Route::post('/checkDcPatient2', 'checkDcPatient2');
    Route::post('/getFollowupDate', 'getFollowupDate');
    
});

Route::controller(IpdController::class)->group(function(){
    Route::get('/addIpdCasePaper', 'addIpdCasePaper');
    Route::get('/ipdCasePaperList', 'ipdCasePaperList');
    Route::post('/deleteIpdCasePaper', 'deleteIpdCasePaper');
    Route::post('/getIpdCasePaper', 'getIpdCasePaper');
    Route::post('/generateIpdNo', 'generateIpdNo');
    Route::post('/getPatientByMrdOrUhid', 'getPatientByMrdOrUhid');
    Route::post('/saveIpdCasePaper', 'saveIpdCasePaper');
});

Route::controller(IpdInvestigationController::class)->group(function(){
    Route::get('/ipdInvestigationMaster', 'ipdInvestigationMaster');
    Route::post('/ipdInvestigationList', 'ipdInvestigationList');
    Route::post('/saveIpdInvestigation', 'saveIpdInvestigation');
    Route::post('/getIpdInvestigation', 'getIpdInvestigation');
    Route::post('/deleteIpdInvestigation', 'deleteIpdInvestigation');
    Route::post('/generateIpdTestId', 'generateTestId');
    Route::post('/getInvestigationByTestId', 'getInvestigationByTestId');
});

Route::controller(OtScheduledController::class)->group(function(){
   // Artisan::call('cache:clear');
    Route::get('/OtScheduled', 'OtScheduled');
    Route::post('/saveOtScheduled', 'saveOtScheduled');
    Route::post('/getOtSchDetails', 'getOtSchDetails');
    Route::post('/getMaxSchId', 'getMaxSchId');
    Route::post('/viewOtScheduleList', 'viewOtScheduleList');
    Route::post('/viewOtScheduleList2', 'viewOtScheduleList2');
    Route::post('/deleteOtSchedule', 'deleteOtSchedule');
    Route::get('/otSchList/{schdate}', 'otSchList');
    Route::get('/preOptNotes/{id}', 'preOptNotes');
    Route::post('/fixedDate','fixedDate');
    Route::post('/surgicalPrescLists','surgicalPrescLists');
    Route::post('/saveSurgicalPres','saveSurgicalPres');
    Route::post('/getSurgTotAmount','getSurgTotAmount');
    Route::get('/printSurgicalPres/{id}','printSurgicalPres');
    Route::post('/viewOtSchedulePostPoneList','viewOtSchedulePostPoneList');
    Route::post('/updateOperationDate','updateOperationDate');
    Route::get('/viewOtSchLists', 'viewOtSchLists');

    Route::post('/getMaxSchId2', 'getMaxSchId2');
    Route::post('/saveOtOtherScheduled', 'saveOtOtherScheduled');
    Route::post('/getOtOtherSchDetails', 'getOtOtherSchDetails');
    Route::get('/preOptNotes2/{id}', 'preOptNotes2');
    Route::post('/surgicalPrescLists2','surgicalPrescLists2');
    Route::post('/saveSurgicalPres2','saveSurgicalPres2');
    Route::get('/printSurgicalPres2/{id}','printSurgicalPres2');
    Route::post('/viewOtSchedulePostPoneList2','viewOtSchedulePostPoneList2');
    Route::post('/updateOperationDate2','updateOperationDate2');
    Route::get('/preOptNotesTreatments/{id}','preOptNotesTreatments');
    Route::post('/savePreOptNotesTreatments','savePreOptNotesTreatments');
});

Route::controller(OTNoteController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::get('/otNotes','otNotes');
    Route::get('/addOtNotes','addOtNotes');
    Route::get('/addOtNotes2/{mrdno}','addOtNotes2');
    Route::get('/addOtNotes3/{id}','addOtNotes3');
    Route::post('/saveOtNotes', 'saveOtNotes');
    Route::post('/checkOtPatient', 'checkOtPatient');
    Route::get('/printOtNotes/{id}', 'printOtNotes');
    Route::post('/getPrevVisitDetails', 'getPrevVisitDetails');
    Route::post('/checkLastOtPatient', 'checkLastOtPatient');
    Route::get('/opdOtNotesReport/{mrdno}', 'opdOtNotesReport');
    Route::get('/viewOtNoteLists', 'viewOtNoteLists');
    Route::post('/otNoteLists', 'otNoteLists');
    Route::get('/searchCounsellingList', 'searchCounsellingList');
    Route::get('/counsellingList/{fromdate}/{todate}', 'counsellingList');
    Route::get('/searchOtList', 'searchOtList');
    Route::get('/counsellingotList/{fromdate}/{todate}', 'counsellingotList');
    Route::get('/printIpdSticker/{id}', 'printIpdSticker');
    Route::get('/opdCounsellingList', 'opdCounsellingList');
    Route::post('/getCounsellingList', 'getCounsellingList');
    Route::post('/deleteCounsellingRecord', 'deleteCounsellingRecord');
    Route::post('/saveCounsellingRemark', 'saveCounsellingRemark');
    Route::post('/counsellingPtOut', 'counsellingPtOut');
    
    
});

Route::controller(OTNoteOtherController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::get('/otNotesOther','otNotesOther');
    Route::get('/addOtNotesOther/{id}','addOtNotesOther');
    Route::get('/addOtNotesOther2/{mrdno}','addOtNotesOther2');
    Route::post('/saveOtNotesOther', 'saveOtNotesOther');
    Route::post('/checkOtOtherPatient', 'checkOtOtherPatient');
    Route::get('/printOtNotesOther/{id}', 'printOtNotesOther');

});

Route::controller(DischargeOtherController::class)->group(function(){
    Artisan::call('cache:clear');
    Route::get('/addDischargeCardOther2/{mrdno}/{otid}', 'addDischargeCardOther2');
    Route::post('/checkDcOtherPatient', 'checkDcOtherPatient');
    Route::post('/saveDischargeCardOther', 'saveDischargeCardOther');
    Route::get('/printDischargeCardOther/{id}', 'printDischargeCardOther');
    Route::post('/getDichargeOtherTreatment', 'getDichargeOtherTreatment');
});

Route::controller(BillController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::get('/bill', 'bill');
    Route::post('/viewIpdBills', 'viewIpdBills');
    Route::get('/addIpdBill', 'addIpdBill');
    Route::post('/saveIpdBill', 'saveIpdBill');
    Route::post('/deletIpdBill', 'deletIpdBill');
    Route::post('/getBillPackageDetails', 'getBillPackageDetails');
    Route::post('/billChargesView', 'billChargesView');
    Route::post('/calBillBalanceAmt', 'calBillBalanceAmt');
    Route::post('/totSumBills', 'totSumBills');
    Route::post('/saveTempBills', 'saveTempBills');
    Route::post('/saveIpdBill', 'saveIpdBill');
    Route::post('/fetchBillChargesRecord', 'fetchBillChargesRecord');
    Route::post('/deleteBillChargesRecord', 'deleteBillChargesRecord');
    Route::post('/getBillDetails', 'getBillDetails');
    Route::get('/ipdBillPrint/{billno}', 'ipdBillPrint');
    Route::post('/getBillCharges', 'getBillCharges');
    Route::post('/fetchBillChargesRecord2', 'fetchBillChargesRecord2');
    Route::post('/updateBillCharges', 'updateBillCharges');
    Route::post('/totSumBills2', 'totSumBills2');
    Route::post('/updateIpdBill', 'updateIpdBill');
    Route::get('/addIpdBill2/{mrdno}/{otid}', 'addIpdBill2');
    Route::get('/addOtherIpdBill2/{mrdno}/{otid}/{dcid}', 'addOtherIpdBill2');
    Route::post('/billChargesView2', 'billChargesView2');
    Route::post('/getBillPackageDetails2', 'getBillPackageDetails2');
    Route::post('/saveUpdateCharges', 'saveUpdateCharges');
    Route::get('/editBill/{id}', 'editBill');
    
});

// Route::controller(TempBillController::class)->group(function(){
//     Route::get('/tempBill', 'tempBill');
//     Route::post('/viewIpdTempBills', 'viewIpdTempBills');
//     Route::post('/deletIpdTempBill', 'deletIpdTempBill');
//     Route::get('/addIpdTempBill', 'addIpdTempBill');
//     Route::post('/getCounsellingDetails', 'getCounsellingDetails');
//     Route::post('/saveIpdTempBill', 'saveIpdTempBill');
//     Route::post('/billChargesView2', 'billChargesView');
//     Route::post('/transferTempBill', 'transferTempBill');
//     Route::post('/divideAmt', 'divideAmt');
//     Route::get('/editTempBill/{id}', 'editTempBill');
//     Route::post('/getBillCharges2', 'getBillCharges');
//     Route::post('/fetchBillChargesRecord3', 'fetchBillChargesRecord3');
//     Route::post('/updateBillCharges2', 'updateBillCharges2');
//     Route::post('/totSumBills3', 'totSumBills3');
//     Route::post('/updateIpdTempBill', 'updateIpdTempBill');
// });

Route::controller(IpdReceiptController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::get('/IpdReceipt', 'IpdReceipt');
    Route::post('/viewIpdReceipts', 'viewIpdReceipts');
    Route::post('/saveIpdReceipt', 'saveIpdReceipt');
    Route::post('/fetchIpdReceiptRecord', 'fetchIpdReceiptRecord');
    Route::post('/deleteIpdReceipt', 'deleteIpdReceipt');
    Route::get('/addIpdReceipt/{mrdno}/{otid}', 'addIpdReceipt');
    Route::get('/ipdReceiptPrint/{id}', 'ipdReceiptPrint');
    Route::post('/getIpdReceiptNo', 'getIpdReceiptNo');
    Route::get('/addOtherIpdReceipt/{mrdno}/{otid}', 'addOtherIpdReceipt');
});

Route::controller(OtherReceiptController::class)->group(function(){
   // Artisan::call('cache:clear');
    Route::get('/OtherReceipt', 'OtherReceipt');
    Route::post('/viewOtherReceipts', 'viewOtherReceipts');
    Route::post('/saveOtherReceipt', 'saveOtherReceipt');
    Route::post('/fetchOtherReceiptRecord', 'fetchOtherReceiptRecord');
    Route::post('/deleteOtherReceipt', 'deleteOtherReceipt');
    Route::get('/otherReceiptPrint/{id}', 'otherReceiptPrint');
    Route::post('/getOtherReceiptNo', 'getOtherReceiptNo');
});

Route::controller(IpdMadamReceiptController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::get('/IpdMadamReceipt', 'IpdMadamReceipt');
    Route::post('/viewIpdMadamReceipts', 'viewIpdMadamReceipts');
    Route::post('/saveIpdMadamReceipt', 'saveIpdMadamReceipt');
    Route::post('/fetchIpdMadamReceiptRecord', 'fetchIpdMadamReceiptRecord');
    Route::post('/deleteIpdMadamReceipt', 'deleteIpdMadamReceipt');
    Route::get('/addIpdMadamReceipt/{mrdno}/{otid}', 'addIpdMadamReceipt');
    Route::get('/ipdMadamReceiptPrint/{id}', 'ipdMadamReceiptPrint');
    Route::post('/getIpdMadamReceiptNo', 'getIpdMadamReceiptNo');
});

Route::controller(GeneralReceiptController::class)->group(function(){
    Route::get('/generalReceipt', 'GeneralReceipt');
    Route::post('/viewGeneralReceipts', 'viewGeneralReceipts');
    Route::post('/saveGeneralReceipt', 'saveGeneralReceipt');
    Route::post('/fetchGeneralReceiptRecord', 'fetchGeneralReceiptRecord');
    Route::post('/deleteGeneralReceipt', 'deleteGeneralReceipt');
    Route::post('/getGeneralReceiptNo', 'getGeneralReceiptNoAjax');
    Route::get('/generalReceiptPrint/{id}', 'generalReceiptPrint');
});

Route::controller(TubingReceiptController::class)->group(function(){
    Route::get('/tubingReceipt', 'TubingReceipt');
    Route::post('/viewTubingReceipts', 'viewTubingReceipts');
    Route::post('/saveTubingReceipt', 'saveTubingReceipt');
    Route::post('/fetchTubingReceiptRecord', 'fetchTubingReceiptRecord');
    Route::post('/deleteTubingReceipt', 'deleteTubingReceipt');
    Route::post('/getTubingReceiptNo', 'getTubingReceiptNoAjax');
    Route::get('/tubingReceiptPrint/{id}', 'tubingReceiptPrint');
});

Route::controller(VaccineReceiptController::class)->group(function(){
    Route::get('/vaccineReceipt', 'VaccineReceipt');
    Route::post('/viewVaccineReceipts', 'viewVaccineReceipts');
    Route::post('/saveVaccineReceipt', 'saveVaccineReceipt');
    Route::post('/fetchVaccineReceiptRecord', 'fetchVaccineReceiptRecord');
    Route::post('/deleteVaccineReceipt', 'deleteVaccineReceipt');
    Route::post('/getVaccineReceiptNo', 'getVaccineReceiptNoAjax');
    Route::get('/vaccineReceiptPrint/{id}', 'vaccineReceiptPrint');
});

Route::controller(XrayReceiptController::class)->group(function(){
    Route::get('/xrayReceipt', 'XrayReceipt');
    Route::post('/viewXrayReceipts', 'viewXrayReceipts');
    Route::post('/saveXrayReceipt', 'saveXrayReceipt');
    Route::post('/fetchXrayReceiptRecord', 'fetchXrayReceiptRecord');
    Route::post('/deleteXrayReceipt', 'deleteXrayReceipt');
    Route::post('/getXrayReceiptNo', 'getXrayReceiptNoAjax');
    Route::get('/xrayReceiptPrint/{id}', 'xrayReceiptPrint');
});

Route::controller(OpdReceiptController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::get('/OpdReceipt', 'OpdReceipt');
    Route::post('/viewOpdReceipts', 'viewOpdReceipts');
    Route::post('/saveOpdReceipt', 'saveOpdReceipt');
    Route::post('/fetchOpdReceiptRecord', 'fetchOpdReceiptRecord');
    Route::post('/deleteOpdReceipt', 'deleteOpdReceipt');
    Route::post('/getProcRec', 'getProcRec');
    Route::post('/getProcRec2', 'getProcRec2');
    Route::get('/opdReceiptPrint/{id}', 'opdReceiptPrint');
});

Route::controller(OpdExpenseController::class)->group(function(){
//Artisan::call('cache:clear');
Route::get('/OpdExpense', 'OpdReceipt');
Route::post('/viewOpdExpense', 'viewOpdReceipts');
Route::post('/saveOpdExpense', 'saveOpdReceipt');
Route::post('/fetchOpdExpenseRecord', 'fetchOpdReceiptRecord');
Route::post('/deleteOpdExpense', 'deleteOpdReceipt');
Route::post('/getExpenseProcRec', 'getProcRec');
Route::post('/getExpenseProcRec2', 'getProcRec2');
Route::get('/opdExpensePrint/{id}', 'opdReceiptPrint');
});

Route::controller(ReportController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::get('/queueReport', 'queueReport');
    Route::post('/viewDailyQueueReport', 'viewDailyQueueReport');
    Route::post('/viewQueueSummaryReport', 'viewQueueSummaryReport');
    Route::post('/viewQueueSummaryReport2', 'viewQueueSummaryReport2');
    Route::post('/viewExpensesReport', 'viewExpensesReport');
    Route::post('/viewExpensesSummaryReport', 'viewExpensesSummaryReport');
    Route::post('/allSummaryReport', 'allSummaryReport');
    Route::get('/ipdBillReport', 'ipdBillReport');
    Route::post('/viewIpdTempBillReport', 'viewIpdTempBillReport');
    Route::post('/viewIpdBillReport', 'viewIpdBillReport');
    Route::post('/opdReport', 'opdReport');
    Route::post('/opdReceiptReport', 'opdReceiptReport');
    Route::post('/opdExpenseReport', 'opdExpenseReport');
    Route::post('/viewReceiptReport', 'viewReceiptReport');
    Route::post('/viewIpd_ReceiptReport', 'viewIpd_ReceiptReport');
    Route::post('/viewIpd_Madam_ReceiptReport', 'viewIpd_Madam_ReceiptReport');
    Route::post('/viewIpdReport', 'viewIpdReport');
    Route::post('/viewOpdCounsellingReport', 'viewOpdCounsellingReport');
    Route::post('/invstReport', 'invstReport');
    Route::post('/viewReferredByReport', 'viewReferredByReport');
    
    
});

Route::controller(IpdReportController::class)->group(function(){
   // Artisan::call('cache:clear');
    Route::get('/IpdReport', 'IpdReport');
    Route::post('/viewIpdReceiptReport', 'viewIpdReceiptReport');
    Route::post('/viewIpdMadamReceiptReport', 'viewIpdMadamReceiptReport');
});



Route::controller(OtConsentController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::get('/OtConsent', 'OtConsent');
    Route::post('/saveOtConsent', 'saveOtConsent');
    Route::get('/printOtConsent/{id}', 'printOtConsent');
});

Route::controller(OpticalController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::get('/itemMaster', 'itemMaster');
    Route::post('/viewItemList', 'viewItemList');
    Route::post('/itemCode', 'itemCode');
    Route::post('/getFrameDetails', 'getFrameDetails');
    Route::post('/saveItem', 'saveItem');
    Route::get('/saleBill', 'saleBill');
    Route::post('/getBillNoList', 'getBillNoList');
    Route::post('/checkCustDetails', 'checkCustDetails');
    Route::post('/itemLists', 'itemLists');
    Route::post('/addItem', 'addItem');
    Route::post('/deleteTempFrameItem', 'deleteTempFrameItem');
    Route::post('/getItemSubTotal', 'getItemSubTotal');
    Route::post('/getSubRefract', 'getSubRefract');
    Route::post('/saveSaleBill', 'saveSaleBill');
    Route::get('/opticalReceipt', 'opticalReceipt');
    Route::post('/getBillNoDetails', 'getBillNoDetails');
    Route::get('/printOpticalReceipt/{id}', 'printOpticalReceipt');
    Route::get('/editSaleBill/{id}', 'editSaleBill');
    Route::post('/saveOpticalReceipt', 'saveOpticalReceipt');
    Route::get('/opticalStockLedger', 'opticalStockLedger');
    Route::post('/viewOpticalStockLedger', 'viewOpticalStockLedger');
    Route::get('/opticalSaleLedger', 'opticalSaleLedger');
    Route::post('/viewOpticalSaleLedger', 'viewOpticalSaleLedger');
    Route::get('/opticalCollectionReport', 'opticalCollectionReport');
    Route::post('/viewOpticalCollectionLedger', 'viewOpticalCollectionLedger');
    Route::get('/makeOrder', 'makeOrder');
    Route::post('/viewMakeOrder', 'viewMakeOrder');
    Route::post('/saveMakeOrder', 'saveMakeOrder');
    Route::get('/opticalSellReport', 'opticalSellReport');
    Route::post('/viewOpticalSellReport', 'viewOpticalSellReport');
    Route::post('/viewOpticalSummaryReport', 'viewOpticalSummaryReport');
    Route::post('/viewReceiptSummaryReport', 'viewReceiptSummaryReport');
    Route::get('/opticalOutstandingReport', 'opticalOutstandingReport');
    Route::post('/viewOpticalOutstandingLedger', 'viewOpticalOutstandingLedger');
});

Route::controller(LenseController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::get('/stockIn', 'stockIn');
    Route::post('/companyLists', 'companyLists');
    Route::post('/modelLists', 'modelLists');
    Route::post('/modelLists2', 'modelLists2');
    Route::post('/powerLists', 'powerLists');
    Route::post('/powerLists2', 'powerLists2');
    Route::post('/saveLense', 'saveLense');
    Route::post('/viewLenseStockList', 'viewLenseStockList');
    Route::post('/editLense', 'editLense');
    Route::post('/deleteLense', 'deleteLense');
    Route::get('/stockOut', 'stockOut');
    Route::post('/saveLenseOut', 'saveLenseOut');
    Route::get('/lenseReport', 'lenseReport');
    Route::post('/model_list', 'model_list');
    Route::post('/power_list', 'power_list');
    Route::post('/viewLenseStockReport', 'viewLenseStockReport');
    Route::post('/viewLenseStockReport2', 'viewLenseStockReport2');
    Route::post('/viewLenseStockReport3', 'viewLenseStockReport3');
    Route::post('/vendorLists', 'vendorLists');
    Route::post('/iolCompanyLists', 'iolCompanyLists');
    Route::post('/srNoLists', 'srNoLists');
});

Route::controller(AppointmentController::class)->group(function(){
   // Artisan::call('cache:clear');
    Route::get('/Appointment','Appointment');
    Route::post('/viewAppointments', 'viewAppointments');
    Route::get('/addNewAppointment','addNewAppointment');
    Route::post('/saveNewAppointmnet', 'saveNewAppointmnet');
    Route::post('/deletAppointment', 'deletAppointment');
    Route::post('/checkAppointment', 'checkAppointment');
    Route::get('/editAppointment/{id}','editAppointment');
    
});


Route::controller(MedicalCertiController::class)->group(function(){
   // Artisan::call('cache:clear');
    Route::get('/medicalCertificate', 'medicalCertificate');
    Route::post('/saveMedicalCertificate', 'saveMedicalCertificate');
    Route::get('/previewMedicalCertificate/{id}', 'previewMedicalCertificate');
    Route::post('/savePrintMedicalCerti', 'savePrintMedicalCerti');
    Route::get('/printMedicalCertificate/{id}', 'printMedicalCertificate');
});

Route::controller(AccountSettingController::class)->group(function(){
   // Artisan::call('cache:clear');
    Route::get('/changePassword', 'changePassword');
    Route::post('/updatePassword', 'updatePassword');
});

Route::controller(PatientBalanceController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::get('/patientBalance', 'patientBalance');
    Route::post('/viewPatientBalance', 'viewPatientBalance');
    Route::get('/addNewPatientBalance', 'addNewPatientBalance');
    Route::post('/saveNewPatientBalance', 'saveNewPatientBalance');
    Route::get('/opdReceipt2/{id}', 'opdReceipt2');
});

Route::controller(UtilityController::class)->group(function(){
   // Artisan::call('cache:clear');
    Route::get('/Cashless', 'Cashless');
    Route::post('/viewCashlessPatients', 'viewCashlessPatients');
    Route::get('/AvgPtStay', 'AvgPtStay');
    Route::post('/viewAvgPatients', 'viewAvgPatients');
    Route::get('/SpecInstReport', 'SpecInstReport');
    Route::post('/viewSpecInstReport', 'viewSpecInstReport');
    Route::get('/ProjectReport', 'ProjectReport');
    Route::post('/viewProjectReport', 'viewProjectReport');
    Route::post('/calAvgTime', 'calAvgTime');
    Route::get('/SpeedTest', 'SpeedTest');
    Route::post('/viewSpeedQueueList', 'viewSpeedQueueList');
    Route::get('/speedoptoform/{id}/{date}/{qid}', 'speedoptoform');
    Route::get('/SendBrochures', 'SendBrochures');
    Route::post('/SaveBrochure', 'SaveBrochure');

    Route::get('/investigationReport', 'investigationReport');
    Route::post('/viewInvestigationReport', 'viewInvestigationReport');
});

Route::controller(YoutubeController::class)->group(function(){
    // Artisan::call('cache:clear');
     Route::get('/youtubelinks','youtubelinks');
     Route::post('/viewYoutubeLinkList','viewYoutubeLinkList');
     Route::post('/saveYoutubeLink','saveYoutubeLink');
     Route::post('/editYoutubeLink','editYoutubeLink');
     Route::post('/deleteYoutubeLink','deleteYoutubeLink');
     Route::post('/sendYoutubeLink','sendYoutubeLink');
     Route::get('/SendYoutubeLinks', 'SendYoutubeLinks');
     
 });

Route::controller(WhatsAppController::class)->group(function(){
   // Artisan::call('cache:clear');
    Route::get('/sendMessage/{id}', 'sendMessage');
    Route::post('/sendWhatsappSms', 'sendWhatsappSms');
    
    
});

Route::controller(ConsultationChargesController::class)->group(function(){
    //Artisan::call('cache:clear');
    Route::get('/ConsultationCharges', 'ConsultationCharges');
    Route::post('/viewConsultationCharges', 'viewConsultationCharges');
    Route::post('/saveConsultationCharges', 'saveConsultationCharges');
    Route::post('/fetchConsultationChargesRecord', 'fetchConsultationChargesRecord');
    Route::post('/deleteConsultationCharges', 'deleteConsultationCharges');
    Route::get('/consultationChargesPrint/{id}', 'consultationChargesPrint');
    
});

Route::controller(VendorController::class)->group(function(){
    Route::get('/vendors', 'vendors');
    Route::post('/viewVendors', 'viewVendors');
    Route::get('/addNewVendor', 'addNewVendor');
    Route::post('/saveNewVendor', 'saveNewVendor');
    Route::post('/deletVendor', 'deletVendor');
    Route::get('/editVendor/{id}','editVendor');
    Route::get('/vendorReceipt', 'vendorReceipt');
    Route::post('/deleteVendorReceipt', 'deleteVendorReceipt');
    Route::post('/viewVendorReceipt', 'viewVendorReceipt');
    Route::get('/addVendorReceipt', 'addVendorReceipt');
    Route::post('/saveVendorReceipt', 'saveVendorReceipt');
    Route::get('/download/{file}', 'download');
    Route::get('/editVendorReceipt/{id}','editVendorReceipt');
    Route::get('/printVendorReceipt/{file}','printVendorReceipt');
    
});

Route::get('/', function () {
    if(session()->has('UserId')){
        return redirect('/dashboard');
    }
    else{
        return view('login');
    }
 });

 Route::get('/logout', function () {
    if(session()->has('UserId')){
        session()->pull('UserId');
    }
    return redirect('/');
 });

 Route::get('/ClearCache', function () {
    Artisan::call('cache:clear');
    dd("All cache cleared");
});