<!DOCTYPE html>
<html lang="en" class="default-style">

<head>
    <title><?php echo e(projectTitle()); ?></title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <link rel="icon" type="image/x-icon" href="<?php echo e(url('assets/img/favicon.jpg')); ?>">

    <?php
        function assetVersion($path)
        {
            $fullPath = public_path($path);
            return file_exists($fullPath) ? filemtime($fullPath) : time();
        }
    ?>

    <!-- Fonts -->
    <link href="<?php echo e(url('assets/fonts/roboto.css')); ?>?v=<?php echo e(assetVersion('assets/fonts/roboto.css')); ?>" rel="stylesheet">
    <link rel="stylesheet"
        href="<?php echo e(url('assets/fonts/fontawesome.css')); ?>?v=<?php echo e(assetVersion('assets/fonts/fontawesome.css')); ?>">
    <link rel="stylesheet"
        href="<?php echo e(url('assets/fonts/linearicons.css')); ?>?v=<?php echo e(assetVersion('assets/fonts/linearicons.css')); ?>">
    <link rel="stylesheet"
        href="<?php echo e(url('assets/fonts/feather.css')); ?>?v=<?php echo e(assetVersion('assets/fonts/feather.css')); ?>">

    <!-- Core CSS -->
    <link rel="stylesheet"
        href="<?php echo e(url('assets/css/bootstrap-material.css')); ?>?v=<?php echo e(assetVersion('assets/css/bootstrap-material.css')); ?>">
    <link rel="stylesheet"
        href="<?php echo e(url('assets/css/shreerang-material.css')); ?>?v=<?php echo e(assetVersion('assets/css/shreerang-material.css')); ?>">

    <!-- DataTables -->
    <link rel="stylesheet"
        href="<?php echo e(url('assets/libs/datatables/datatables.css')); ?>?v=<?php echo e(assetVersion('assets/libs/datatables/datatables.css')); ?>">

    <style>
        .autocomplete-list {
            border: 1px solid #ccc;
            max-height: 150px;
            overflow-y: auto;
            position: absolute;
            background-color: white;
            z-index: 1000;
            width: 100%;
        }

        .autocomplete-item {
            padding: 8px;
            cursor: pointer;
        }

        .autocomplete-item:hover,
        .autocomplete-item.active {
            background-color: #98e6ed;
        }
    </style>
</head>

<body>
    <div class="container-fluid flex-grow-1 container-p-y">
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h3>IPD Case Paper List</h3>
                            <a href="<?php echo e(url('addIpdCasePaper')); ?>" class="btn btn-primary">
                                <i class="feather icon-plus"></i> Add New IPD Case Paper
                            </a>
                        </div>
                        <table id="example33" class="table table-striped table-bordered dt-responsive nowrap"
                            style="width:100%">
                            <thead>
                                <tr>
                                    <th>Record Id</th>
                                    <th>IPD No</th>
                                    <th>MRD No</th>
                                    <th>UHID No</th>
                                    <th>Patient Name</th>
                                    <th>Age/Gender</th>
                                    <th>Mobile</th>
                                    <th>Admission Date</th>
                                    <th>Admission Time</th>
                                    <th>Ward</th>
                                    <th>Bed No</th>
                                    <th>Consultant</th>
                                    <th>Admission Type</th>
                                    <th>Provisional Diagnosis</th>
                                    <th>Final Diagnosis</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($i + 1); ?></td>
                                        <td><?php echo e($result->IpdNo ?? ''); ?></td>
                                        <td><?php echo e($result->MrdNo ?? ''); ?></td>
                                        <td><?php echo e($result->UhidNo ?? ''); ?></td>
                                        <td><?php echo e(strtoupper(strtolower($result->PatientName ?? ''))); ?></td>
                                        <td><?php echo e($result->Age ?? ''); ?> / <?php echo e($result->Gender ?? ''); ?></td>
                                        <td><?php echo e($result->Mobile ?? ''); ?></td>
                                        <td><?php echo e($result->AdmissionDate ? date('d/m/Y', strtotime($result->AdmissionDate)) : ''); ?></td>
                                        <td><?php echo e($result->AdmissionTime ?? ''); ?></td>
                                        <td><?php echo e($result->WardName ?? ($result->WardId && $result->WardId > 0 ? 'Ward ID: ' . $result->WardId : '-')); ?></td>
                                        <td><?php echo e($result->BedNo ?? ''); ?></td>
                                        <td><?php echo e($result->Consultant ?? ''); ?></td>
                                        <td><?php echo e($result->AdmissionType ?? ''); ?></td>
                                        <td><?php echo e($result->ProDiagnosis ? substr($result->ProDiagnosis, 0, 30) . (strlen($result->ProDiagnosis) > 30 ? '...' : '') : ''); ?></td>
                                        <td><?php echo e($result->FinalDiagnosis ? substr($result->FinalDiagnosis, 0, 30) . (strlen($result->FinalDiagnosis) > 30 ? '...' : '') : ''); ?></td>
                                        <td>
                                            <a data-id="<?php echo e($result->id); ?>" href='javascript:void(0);' data-toggle="tooltip" data-placement="top"
                                                title="Edit" data-original-title="Edit" class="update"
                                                onclick="editIpdCasePaper('<?php echo e($result->id); ?>')">
                                                <i class="lnr lnr-pencil mr-2"></i>
                                            </a>
                                            &nbsp;&nbsp;
                                            <a data-id="<?php echo e($result->id); ?>" href='javascript:void(0);' data-toggle="tooltip" data-placement="top"
                                                title="Delete" data-original-title="Delete" class="delete" id="bootbox-confirm"
                                                onclick="deleteIpdCasePaper('<?php echo e($result->id); ?>', '<?php echo e(addslashes($result->PatientName ?? '')); ?>')">
                                                <i class="lnr lnr-trash text-danger"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- JavaScript Includes -->
    <script src="<?php echo e(url('assets/js/jquery-3.6.0.min.js')); ?>?v=<?php echo e(assetVersion('assets/js/jquery-3.6.0.min.js')); ?>">
    </script>
    <script src="<?php echo e(url('assets/js/bootstrap.js')); ?>?v=<?php echo e(assetVersion('assets/js/bootstrap.js')); ?>"></script>
    <script
        src="<?php echo e(url('assets/libs/datatables/datatables.js')); ?>?v=<?php echo e(assetVersion('assets/libs/datatables/datatables.js')); ?>">
    </script>

    <!-- Optional if needed for layout -->
    <script src="<?php echo e(url('assets/js/sidenav.js')); ?>?v=<?php echo e(assetVersion('assets/js/sidenav.js')); ?>"></script>
    <script src="<?php echo e(url('assets/js/layout-helpers.js')); ?>?v=<?php echo e(assetVersion('assets/js/layout-helpers.js')); ?>"></script>
    <script src="<?php echo e(url('assets/js/material-ripple.js')); ?>?v=<?php echo e(assetVersion('assets/js/material-ripple.js')); ?>"></script>
    <?php echo $__env->make('excelscript', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        $(document).ready(function() {
            $('#example33').DataTable({
                responsive: true,
                pageLength: 50,
                order: [
                    [0, 'desc']
                ],
                "scrollX": true,
                dom: 'Bfrtip',
                buttons: [
                    'excelHtml5'
                ]
            });
        });

        function editIpdCasePaper(id) {
            if (id) {
                window.location.href = "<?php echo e(url('addIpdCasePaper')); ?>?id=" + id;
            }
        }

        function deleteIpdCasePaper(id, patientName) {
            if (!confirm("Are you sure you want to delete IPD case paper for patient: " + patientName + "?")) {
                return;
            }
            
            $.ajax({
                url: "<?php echo e(url('deleteIpdCasePaper')); ?>",
                method: "POST",
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    id: id
                },
                dataType: "json",
                success: function(data) {
                    if (data.success) {
                        alert("IPD case paper deleted successfully!");
                        window.location.reload();
                    } else {
                        alert("Error: " + (data.error || 'Failed to delete IPD case paper'));
                    }
                },
                error: function(xhr) {
                    var errorMsg = 'Failed to delete IPD case paper';
                    if (xhr.responseJSON && xhr.responseJSON.error) {
                        errorMsg = xhr.responseJSON.error;
                    }
                    alert("Error: " + errorMsg);
                }
            });
        }
    </script>
</body>

</html>
<?php /**PATH C:\laragon\www\parijathosp\resources\views//ipd/view-ipd-casepaper-list.blade.php ENDPATH**/ ?>