<?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php
$UserId = Session::get('UserId');
?>
<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold py-3 mb-0">IPD Receipts
    </h4>
    <div class="card mb-4">
        <div class="card-body">

            <div class="row align-items-center m-l-0">



                <div class="col-sm-2 text-left">
                    <button class="btn btn-success btn-sm mb-3 btn-round" data-toggle="modal"
                        data-target="#modal-report" id="add_button"><i class="feather icon-plus"></i> Add
                        Receipt</button>
                </div>
                <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="gender">Payment Mode </label>
                                <select class="form-control" id="SrchPayMode" name="SrchPayMode">
                                    <option value="">All</option>
                                    <option value="Cash">Cash</option>
                                    <option value="Cheque">Cheque</option>
                                    <option value="Mobile Payment">Mobile Payment</option>
                                </select>
                            </div>
                        </div>
                <div class="form-group col-md-2">
                            <label class="form-label">From Date </label>
                            <input type="date" id="FromDate" class="form-control" value="<?php echo e(date('Y-m-d')); ?>" autocomplete="off" required>
                        </div>
                        <div class="form-group col-md-2">
                            <label class="form-label">To Date</label>
                            <input type="date" id="ToDate" class="form-control" value="<?php echo e(date('Y-m-d')); ?>" autocomplete="off" required>
                        </div>
                        <input type="hidden" name="Search" value="Search">
                        <div class="form-group col-md-1" style="padding-top:20px;">
                            <button type="button" class="btn btn-primary btn-finish"
                            id="filter">Search</button>
                            <!-- <button type="button" id="refresh" class="btn btn-secondary btn-finish">Refresh</button> -->
                        </div>

                        <div class="col-sm-3 text-right">
                            <a href="javascript:void(0)" class="badge badge-pill badge-danger" id="today">Today's Receipt :
                                <?php echo e($today); ?></a>
                            <a href="javascript:void(0)" class="badge badge-pill badge-success"
                                id="total">Total Receipt : <?php echo e($total); ?></a>
                            
                        </div>
                


            </div>
            <hr>
            <div class="table-responsive" id="custresult">


            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-report" tabindex="-1" role="dialog" aria-labelledby="myExtraLargeModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" style="max-width: 70rem; ">
        <div class="modal-content">


            <div class="modal-header">
                <h5 class="modal-title">Add IPD Receipt</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="validation-form" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="action" id="action" value="Save">
                    <input type="hidden" name="id" id="id" />
                    <div class="row">
                        <div class="col-sm-2">
                            <div class="form-group">
                                <label>Receipt. No <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="ReceiptNo" id="ReceiptNo" placeholder=""
                                    value="" readonly>
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <div class="form-group">
                                <label>Mrd. No <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="MrdNo" id="MrdNo" placeholder="" value="">
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="form-group">
                                <label class="floating-label" for="Name">Patient Name <span
                                        class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="PatientName" id="PatientName"
                                    placeholder="" value="">
                            </div>
                        </div>

                        <div class="col-sm-5">
                            <div class="form-group">
                                <label class="floating-label" for="gender">Procedures <span
                                        class="text-danger">*</span></label>
                                <input class="form-control" list="DataList2" name="Procedures" value="" id="Procedures"
                                    onchange="getProcedureDetails(this.value)">
                                <datalist id="DataList2">
                                    <?php $__currentLoopData = $procedures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <option value="<?php echo e($result->Name); ?>">
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </datalist>
                            </div>
                        </div>


                        <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="Phone">Amount <span
                                        class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="Amount" Name="Amount" placeholder=""
                                    value="" required>
                            </div>
                        </div>

                        <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="Phone">Date <span
                                        class="text-danger">*</span></label>
                                <input type="date" class="form-control" id="CreatedDate" Name="CreatedDate"
                                    value="<?php echo e(date('Y-m-d')); ?>" placeholder="" required>
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="gender">Payment Mode <span
                                        class="text-danger">*</span></label>
                                <select class="form-control" id="PayMode" name="PayMode" required>
                                    <option value=""></option>
                                    <option value="Cash">Cash</option>
                                    <option value="Cheque">Cheque</option>
                                    <option value="Mobile Payment">Mobile Payment</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="Phone">Cheque No</label>
                                <input type="text" class="form-control" id="ChequeNo" Name="ChequeNo" placeholder="">
                            </div>
                        </div>

                        <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="gender">Cheque Deposite On</label>
                                <input type="date" class="form-control" id="ChqDep" Name="ChqDep" placeholder="">
                            </div>
                        </div>

                        <div class="col-sm-2">
                            <div class="form-group">
                                <label class="floating-label" for="gender">Cheque Credit Date </label>
                                <input type="date" class="form-control" id="ChqDate" Name="ChqDate" placeholder="">
                            </div>
                        </div>

                        <div class="col-sm-3">
                            <div class="form-group">
                                <label class="floating-label" for="Phone">Bank Name</label>
                                <input type="text" class="form-control" id="BankName" Name="BankName" placeholder="">
                            </div>
                        </div>

                        <div class="col-sm-3">
                            <div class="form-group">
                                <label class="floating-label" for="Phone">Branch Name</label>
                                <input type="text" class="form-control" id="BranchName" Name="BranchName" placeholder="">
                            </div>
                        </div>

                        <div class="col-sm-3">
                            <div class="form-group">
                                <label class="floating-label" for="Phone">Account No</label>
                                <input type="text" class="form-control" id="AccountNo" Name="AccountNo" placeholder="">
                            </div>
                        </div>

                        <div class="col-sm-3">
                            <div class="form-group">
                                <label class="floating-label" for="Phone">Account Holder</label>
                                <input type="text" class="form-control" id="AccountHolder" Name="AccountHolder" placeholder="">
                            </div>
                        </div>


                        <div class="col-sm-12" style="padding-top: 25px;">
                            <button class="btn btn-primary" type="submit" name="submit" id="submit">Submit</button>
                            <button class="btn btn-danger" type="reset">Clear</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('footerscript', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('excelscript', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script type="text/javascript">
function isNumberKey(evt) {
    var charCode = (evt.which) ? evt.which : evt.keyCode
    if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
    return true;
}

function success_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.notice({
        title: 'Success',
        message: 'New Receipt Added Successfully!',
        location: isRtl ? 'tl' : 'tr'
    });
}

function error_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.error({
        title: 'Error',
        message: 'Receipt Already Exists',
        location: isRtl ? 'tl' : 'tr'
    });
}

function printCard(id) {
    setTimeout(function() {
        window.open(
            '/<?php echo e(projectUrl()); ?>ipdReceiptPrint/' + id, 'name',
            'toolbar=1, scrollbars=1, location=1,statusbar=0, menubar=1, resizable=1, width=900, height=1000'
        );
    }, 1);
}

$('#filter').click(function(){
  var FromDate = $('#FromDate').val();
  var ToDate = $('#ToDate').val();
  var SrchPayMode = $('#SrchPayMode').val();
  if(FromDate != '' &&  ToDate != '')
  {
   queueList(FromDate, ToDate,SrchPayMode);
  }
  else
  {
   alert('Both Date is required');
  }
 });

 $('#refresh').click(function(){
  $('#FromDate').val('');
  $('#ToDate').val('');
  $('#SrchPayMode').val('');
  queueList();
 });

function queueList(FromDate = '', ToDate = '',SrchPayMode='') {
    $.ajax({
        url: "<?php echo e(url('viewIpdReceipts')); ?>",
        method: "POST",
        data: {
            _token: '<?php echo e(csrf_token()); ?>',
            FromDate: FromDate,
            ToDate: ToDate,
            SrchPayMode:SrchPayMode
        },
        success: function(data) {
            console.log(data);
            $('#custresult').html(data);
        }
    });
}

function getProcedureDetails(val) {
    $.ajax({
        method: "POST",
        url: "<?php echo e(url('getProcedureDetails')); ?>",
        data: {
            _token: '<?php echo e(csrf_token()); ?>',
            val: val
        },
        success: function(data) {
            console.log(data);
            $('#Amount').val(data);
        }
    });
}

function getIpdReceiptNo() {
    $.ajax({
        method: "POST",
        url: "<?php echo e(url('getIpdReceiptNo')); ?>",
        data: {
            _token: '<?php echo e(csrf_token()); ?>'
        },
        success: function(data) {
            console.log(data);
            $('#ReceiptNo').val(data);
        }
    });
}

$(document).ready(function() {
    $('#modal-report').modal('show');
    queueList();
    getIpdReceiptNo();

    $(document).on("input", "#MrdNo", function(event) {
        var val = this.value;
        $.ajax({
            url: "<?php echo e(url('getPatientDetails')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                id: val
            },
            dataType: "json",
            success: function(data) {
                //console.log(data);

                $('#MrdNo').val(data.MrdNo);
                $('#PatientName').val(data.PatientName);
                $('#ConsultantId').val(data.Consultant);
                $('#Consultant').val(data.ConsultantName);


            }
        });

    });

    $('#add_button').click(function() {
        getIpdReceiptNo();
        $('.modal-title').html("Add <span class='font-weight-light'>Receipt</span>");
        $('#action').val("Save");
        $('#id').val('');
        $('#PatientId').val('');
        $('#IpdNo').val('');
        $('#MrdNo').val('');
        $('#PatientName').val('');
        $('#AgeGender').val('');
        $('#AdmissionDate').val('');
        $('#AdmissionTime').val('');
        $('#DepositDate').val('');
        $('#DepositTime').val('');
        $('#Amount').val('');
        $('#ChequeNo').val('');
        $('#ChqDate').val('');
        $('#Narration').val('');
        $('#Procedures').val('');
        $('#ReceiptNo').val('');
        $('#ChqDep').val('');
        $('#BankName').val('');
        $('#BranchName').val('');
        $('#AccountNo').val('');
        $('#AccountHolder').val('');
        $('#PayMode').val('').attr("selected", true);
        $('#submit').text('Submit');

    })

    $('#validation-form').on('submit', function(e) {
        e.preventDefault();
        if ($('#validation-form').valid()) {
            $.ajax({
                url: "<?php echo e(url('saveIpdReceipt')); ?>",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                processData: false,
                beforeSend: function() {
                    $('#submit').attr('disabled', 'disabled');
                    $('#submit').text('Please Wait...');
                },
                success: function(data) {

                    //console.log(data);exit();
                    var res = JSON.parse(data);
                    var status = res.status;
                    var today = res.today;
                    var total = res.total;
                    var id = res.id;
                    if (status == 1) {
                        $('#modal-report').modal('hide');
                        success_toast();
                        queueList();
                        $('#today').html(today);
                        $('#total').html(total);
                        //window.location.href="ipd-receipt.php";
                        //window.open('ipd-receipt-print.php?id='+id,'_blank');
                    } else {
                        error_toast();
                        $('#modal-report').modal('show');
                    }
                    $('#submit').attr('disabled', false);
                    $('#submit').text('Submit');
                }
            });
        }
    });

    $(document).on("click", ".update", function(event) {
        event.preventDefault();
        event.stopPropagation();
        var id = $(this).attr("data-id");
        $.ajax({
            url: "<?php echo e(url('fetchIpdReceiptRecord')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                id: id
            },
            dataType: "json",
            success: function(data) {
                console.log(data);
                $('#PatientId').val(data.PatientName + " / " + data.IpdNo).attr("selected",
                    true);
                $('#IpdNo').val(data.IpdNo);
                $('#MrdNo').val(data.MrdNo);
                $('#PatientName').val(data.PatientName);
                $('#Procedures').val(data.Procedures);
                $('#Amount').val(data.Amount);
                $('#PayMode').val(data.PayMode).attr("selected", true);
                $('#ChequeNo').val(data.ChequeNo);
                $('#Narration').val(data.Narration);
                $('#ChqDate').val(data.ChqDate);
                $('#AdmissionDate').val(data.AdmissionDate);
                $('#AdmissionTime').val(data.AdmissionTime);
                $('#DepositDate').val(data.DepositDate);
                $('#DepositTime').val(data.DepositTime);
                $('#ReceiptNo').val(data.ReceiptNo);
                $('#ChqDep').val(data.ChqDep);
                $('#BankName').val(data.BankName);
                $('#BranchName').val(data.BranchName);
                $('#AccountNo').val(data.AccountNo);
                $('#AccountHolder').val(data.AccountHolder);
                $('#action').val('Edit');

                $('#id').val(id);
                $('#submit').text("Update");
                $('#modal-report').modal('show');
                $('.modal-title').html(
                    "Update <span class='font-weight-light'>Receipt</span>");

            }
        });
    });



    $(document).on("click", ".delete", function(event) {
        event.preventDefault();
        var id = $(this).attr("data-id");
        var action = "delete";
        //alert(id);
        swal({
            title: "Are you sure?",
            text: "You will not be able to recover this Charges!",
            type: "warning",
            showCancelButton: true,
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Yes, delete",
            cancelButtonText: "No, cancel",
            closeOnConfirm: false,
            closeOnCancel: false
        }, function(isConfirm) {
            if (isConfirm) {
                $.ajax({
                    url: "<?php echo e(url('deleteIpdReceipt')); ?>",
                    method: "POST",
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        id: id
                    },

                    success: function(data) {
                        var res = JSON.parse(data);
                        var status = res.status;
                        var today = res.today;
                        var total = res.total;
                        queueList();
                        $('#today').html(today);
                        $('#total').html(total);
                        swal("Deleted!", "Receipt has been deleted.", "success");

                    }
                });

            } else {
                swal("Cancelled", "Receipt is safe :)", "error");
            }
        });
    });

});
</script><?php /**PATH C:\laragon\www\parijathosp\resources\views//ipd/view-ipd-receipt.blade.php ENDPATH**/ ?>