<!DOCTYPE html>
<html lang="en" class="default-style">

<head>
    <title><?php echo e(projectTitle()); ?></title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
<!-- Fonts -->
<link rel="stylesheet" href="<?php echo e(url('assets/fonts/roboto.css')); ?>?v=<?php echo e(filemtime(public_path('assets/fonts/roboto.css'))); ?>">
<link rel="stylesheet" href="<?php echo e(url('assets/fonts/fontawesome.css')); ?>?v=<?php echo e(filemtime(public_path('assets/fonts/fontawesome.css'))); ?>">
<link rel="stylesheet" href="<?php echo e(url('assets/fonts/linearicons.css')); ?>?v=<?php echo e(filemtime(public_path('assets/fonts/linearicons.css'))); ?>">

<!-- Core Styles -->
<link rel="stylesheet" href="<?php echo e(url('assets/css/bootstrap-material.css')); ?>?v=<?php echo e(filemtime(public_path('assets/css/bootstrap-material.css'))); ?>">
<link rel="stylesheet" href="<?php echo e(url('assets/css/shreerang-material.css')); ?>?v=<?php echo e(filemtime(public_path('assets/css/shreerang-material.css'))); ?>">

<!-- Plugins -->
<link rel="stylesheet" href="<?php echo e(url('assets/libs/toastr/toastr.css')); ?>?v=<?php echo e(filemtime(public_path('assets/libs/toastr/toastr.css'))); ?>">
<link rel="stylesheet" href="<?php echo e(url('assets/libs/growl/growl.css')); ?>?v=<?php echo e(filemtime(public_path('assets/libs/growl/growl.css'))); ?>">
<link rel="stylesheet" href="<?php echo e(url('assets/libs/bootstrap-select/bootstrap-select.css')); ?>?v=<?php echo e(filemtime(public_path('assets/libs/bootstrap-select/bootstrap-select.css'))); ?>">
<link rel="stylesheet" href="<?php echo e(url('assets/libs/bootstrap-sweetalert/bootstrap-sweetalert.css')); ?>?v=<?php echo e(filemtime(public_path('assets/libs/bootstrap-sweetalert/bootstrap-sweetalert.css'))); ?>">

<!-- Custom Styles -->
<link rel="stylesheet" href="<?php echo e(url('jquery-ui.css')); ?>?v=<?php echo e(filemtime(public_path('jquery-ui.css'))); ?>">
<link rel="stylesheet" href="<?php echo e(url('style.css')); ?>?v=<?php echo e(filemtime(public_path('style.css'))); ?>">


    <style type="text/css">
    fieldset legend {
        background: inherit;
        font-family: "Lato", sans-serif;
        color: #650812;
        font-size: 15px;
        left: 10px;
        padding: 0 10px;
        position: absolute;
        top: -11px;
        font-weight: 400;
        width: auto !important;
        border: none !important;
    }

    fieldset {
        background: #ffffff;
        border: 1px solid #4FAFB8;
        border-radius: 5px;
        margin: 10px 0 1px 0;
        padding: 7px;
        position: relative;
    }

    .form-control {
        min-height: 1px;
        height: 25px;

        font-size: 17px;
    }

    .table th,
    .table td {
        padding: 0.325rem;
        font-weight: bold;
    }

    label {
        font-weight: bold;
    }

    .select {
        height: 32px;
    }

    blink {
        -webkit-animation: 1s linear infinite condemned_blink_effect;
        /* for Safari 4.0 - 8.0 */
        animation: 1s linear infinite condemned_blink_effect;
    }

    /* for Safari 4.0 - 8.0 */
    @-webkit-keyframes condemned_blink_effect {
        0% {
            visibility: hidden;
        }

        50% {
            visibility: hidden;
        }

        100% {
            visibility: visible;
        }
    }

    @keyframes condemned_blink_effect {
        0% {
            visibility: hidden;
        }

        50% {
            visibility: hidden;
        }

        100% {
            visibility: visible;
        }
    }

    .lblclass {
        color: #8b888e;
        font-weight: 400;
    }

    .txtbold {
        font-weight: 600;
    }

    #cover-spin {
    position:fixed;
    width:100%;
    left:0;right:0;top:0;bottom:0;
    background-color: rgba(255,255,255,0.7);
    z-index:9999;
    display:none;
}

@-webkit-keyframes spin {
	from {-webkit-transform:rotate(0deg);}
	to {-webkit-transform:rotate(360deg);}
}

@keyframes spin {
	from {transform:rotate(0deg);}
	to {transform:rotate(360deg);}
}

#cover-spin::after {
    content:'';
    display:block;
    position:absolute;
    left:48%;top:40%;
    width:40px;height:40px;
    border-style:solid;
    border-color:rgb(79, 175, 184);
    border-top-color:transparent;
    border-width: 4px;
    border-radius:50%;
    -webkit-animation: spin .8s linear infinite;
    animation: spin .8s linear infinite;
}
    </style>
</head>

<?php 
$UserId = Session::get('UserId');
 if(file_exists('json_files/json-file.json')){ 
    $json = file_get_contents('json_files/json-file.json');
    //Decode JSON
    $json_data = json_decode($json,true);
    $results = array();
    }

    if(file_exists('json_files/timetables_date.json')){ 
        $json2 = file_get_contents('json_files/timetables_date.json');
        //Decode JSON
        $json_data2 = json_decode($json2,true);
        $results2 = array();
        }
        

            //echo $json_data2['items'][0]['Treatment'];
        
    //$data[0]->ConfirmOpto = explode(",",$data[0]->ConfirmOpto);

    $CopyMrdno = Session::get('MrdNo');
    $CopyMrdno2 = Session::get('MrdNo2');
    
    //for opto data
    //echo $optodata;
    $opto_data = json_decode($optodata,true);
    //echo $opto_data['items']['PatientName'];

    //for comsultant data
    //echo $consultdata;
    $consult_data = json_decode($consultdata,true);

    //for comsultant treatment data
    //echo $consult_treatdata;
    $consult_treat_data = json_decode($consult_treatdata,true);

    //for patient data
    //echo $ptdata;
    $pt_data = json_decode($ptdata,true);

    //for queue patient data
    //echo $queuedata;
    $queue_data = json_decode($queuedata,true);

    //for visit date data
    //echo $visitlist;
    $visit_list = json_decode($visitlist,true);
    $results = array();
?>
<input type="hidden" value="<?php echo e($VisitNo); ?>" id="copyvisitno">
<input type="hidden" value="<?php echo e($VisitDate); ?>" id="copyvisitdate">
<input type="hidden" value="<?php echo e($MrdNo); ?>" id="copymrdno">

<body>
    <div class="layout-wrapper layout-1 layout-without-sidenav">
        <div class="layout-inner">
            <div class="layout-container">
                <!-- [ Layout content ] Start -->
                <div class="container-fluid flex-grow-1">
                    <form id="validation-form66" novalidate="novalidate" method="POST" enctype="multipart/form-data" autocomplete="off"
    action="">
                    <div class="form-row align-items-center">
                        <div class="table-responsive" style="overflow-x: hidden;">
                            <div class="row">
                           <!-- <div class="col-lg-1">
                                <table id="report-table" class="table table-bordered table-striped mb-0" style="padding: 3px;">
                                        <tbody>
                                            <tr>
                                            <th style="padding: 13px;background-color: white;padding-left: 10px;">
                                <img src="<?php echo e(url('VLOGO2.jpg')); ?>" width="75" height="86" />
                                </th>
                                </tr>
                                </tbody>
                                    </table>
                                </div>-->
                                <div class="col-lg-10" style="padding-left: 0px;height: 10px;">
                                    <table id="report-table" class="table table-bordered table-striped" style="margin-bottom: 1px;">
    <tbody>
        <tr>
            <td width="60">
                <input type="text" id="MrdNo" class="form-control" placeholder="" value="<?php echo e($MrdNo); ?>" readonly="readonly"
                    style="height: 26px;font-size: 20px;font-weight: 700;text-align: center;">
            </td>
            <td width="200">
                <strong>
                    <input type="text" class="form-control" placeholder=""
                        value="<?php echo e(strtoupper($pt_data['items']['PatientName'])); ?>" readonly="readonly"
                        style="height: 26px;font-size: 20px;font-weight: 700;">
                </strong>
            </td>
            <td width="35">
                <input type="text" class="form-control" placeholder="" value="<?php echo e($pt_data['items']['Age']); ?>" readonly="readonly"
                    style="height: 26px;font-size: 20px;">
            </td>
            <td width="50">
                <input type="text" class="form-control" placeholder="" value="<?php echo e($pt_data['items']['Gender']); ?>" readonly="readonly"
                    style="height: 26px;font-size: 20px;">
            </td>
            <td width="50">
                <input type="text" class="form-control" value="<?php echo e($VisitNo); ?>" id="VisitNo" placeholder="" readonly="readonly"
                    style="height: 26px;font-size: 20px;">
            </td>
            <td width="50">
                <input type="text" class="form-control" placeholder="" value="<?php echo e($queue_data['items']['Amount']); ?>" id="Fees"
                    oninput="changeFees(<?php echo e($VisitNo); ?>,'<?php echo e($VisitDate); ?>',<?php echo e($MrdNo); ?>)"
                    <?php if($VisitDate != date('Y-m-d')){?> disabled <?php } else{?>disabled<?php } ?>
                    style="height: 26px;font-size: 20px;">
            </td>
            <td width="25">
                <input type="date" id="VisitDate" class="form-control" placeholder="" value="<?php echo e($VisitDate); ?>" readonly="readonly"
                    style="height: 26px;font-size: 20px;">
            </td>

            <!-- ✅ Added "Type of Patient" input field -->
            <td width="120">
                <input type="text" id="TypePatient" name="TypePatient" class="form-control" placeholder="Type of Patient" value="<?php echo e($consult_data['items']['BeOcMov']); ?>"
                    style="height: 26px;font-size: 20px;">
            </td>

            <?php if($PtBal > 0){?>
            <td width="20" style="color:red;">Bal : <?php echo e($PtBal); ?></td>
            <?php } ?>
        </tr>
    </tbody>
</table>

                                   
                                   <!-- <div class="card mb-2">
                                        <div class="card-body"
                                            style="padding: 1px;padding-left: 6px;padding-right: 6px">
                                            <div class="card-header" style="padding-top: 5px">
                                                <ul class="nav nav-tabs card-header-tabs nav-responsive-md">
                                                    <li class="nav-item"><a
                                                            class="nav-link <?php if($_GET['page'] == 'tab1'){?>active<?php } else{}?>"
                                                            data-toggle="tab" href="#navs-wc-home" onclick="pressTab(1)"
                                                            style="font-weight: bold;">Optometrist</a></li>
                                                   
                                                    <li class="nav-item"><a class="nav-link" href="javascript:void(0)"
                                                            onclick="viewSummary(<?php echo e($MrdNo); ?>)">OPD Summary</a></li>
                                                 
                                                         

                                                </ul>
                                            </div>
                                        </div>
                                    </div>-->
                                    <style>
    .col-lg-1-5 {
        width: 12.5%;
        padding-left: 5px;
        padding-right: 5px;
    }
    .lblclass {
        font-size: 12px;
        margin-bottom: 0px !important;
        line-height: 1.2;
    }
    .form-control {
        font-size: 13px;
        padding: 2px 6px;
        
    }
    .input-group-text {
        padding: 2px 6px;
        height: 28px;
    }
    .btn {
        padding: 2px 10px;
        font-size: 13px;
    }
</style>
                                <div class="card mb-2">
                                    <div class="card-body" style="padding: 1px;    padding-left: 5px;">
                                     <div class="form-group col-md-12" style="margin-bottom: 0rem">
            <fieldset style="margin: 3px 0 1px 0;">
                <legend></legend>
                <div class="row" style="margin-bottom: 0px; align-items: flex-end;padding-left: 5px;">

    

<div class="col-lg-1-5">
    <label class="floating-label lblclass">Referred By</label>
    <input class="form-control" list="DataList2" name="RefBy" id="RefBy" value="<?php echo e($opto_data['items']['RefBy']); ?>">
    <datalist id="DataList2">
        <?php $__currentLoopData = $referedbyList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($result->Name); ?>">
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </datalist>
</div>

<div class="col-lg-2">
    <label class="floating-label lblclass">Consultant</label>
    <select class="form-control" name="ConfirmConsult" id="ConfirmConsult">
        <?php $__currentLoopData = $consultantList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($result->id); ?>" <?php if($opto_data['items']['ConfirmConsult'] == $result->id): ?> selected <?php endif; ?>><?php echo e($result->Name); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
</div>

<div class="col-lg-1-5">
    <label class="floating-label lblclass">Optometrist</label>
    <select class="form-control" name="ConfirmOpto" id="ConfirmOpto" required>
        <?php $__currentLoopData = $optometristList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($result->id); ?>" <?php if($result->id == $opto_data['items']['ConfirmOpto']): ?> selected <?php endif; ?>><?php echo e($result->Name); ?></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
</div>

<div class="col-lg-1">
    <label class="floating-label lblclass">To Dilate</label>
    <div class="input-group">
        <div class="input-group-prepend">
            <div class="input-group-text p-1">
                <input type="checkbox" name="Dialated" value="1" <?php if($opto_data['items']['Dialated'] == 1): ?> checked <?php endif; ?> onclick="getDialated()">
            </div>
        </div>
        <select class="form-control" name="DiaEye" id="DiaEye" onchange="getDiaEye(this.value)">
            <option value="BE" <?php if($opto_data['items']['DiaEye'] == 'BE'): ?> selected <?php endif; ?>>BE</option>
            <option value="RE" <?php if($opto_data['items']['DiaEye'] == 'RE'): ?> selected <?php endif; ?>>RE</option>
            <option value="LE" <?php if($opto_data['items']['DiaEye'] == 'LE'): ?> selected <?php endif; ?>>LE</option>
        </select>
    </div>
</div>

<div class="col-lg-1">
    <label class="floating-label lblclass">Last Visit</label>
    <input type="text" class="form-control" id="LastVisitDate" value="<?php echo e($LastVisitDate ?? ''); ?>" readonly>
</div>

<div class="col-lg-1">
    <label class="floating-label lblclass">Total Days</label>
    <input type="text" class="form-control" id="TotalDays" value="<?php echo e($TotalDays ?? ''); ?>" readonly>
</div>

<div class="col-lg-1">
    <label class="floating-label lblclass">Last Paid 400 </label>
    <input type="text" class="form-control" id="Last400VisitDate" value="<?php echo e($Last400VisitDate ?? ''); ?>" readonly>
</div>

<div class="col-lg-1">
    <label class="floating-label lblclass">Total Days</label>
    <input type="text" class="form-control" id="Total400Days" value="<?php echo e($Total400Days ?? ''); ?>" readonly>
</div>

<div class="col-lg-2">
    <label class="lblclass">&nbsp;</label>
    <div>
        <button class="btn btn-info" type="button" id="copybutton" onclick="copy()">Copy</button>
        <button class="btn btn-success" type="button" onclick="paste()" id="pastebutton">Paste</button>
        <button class="btn btn-primary" type="submit" name="submit" id="saveopto2">Save</button>
    </div>
</div>
</div>
            </fieldset>
        </div></div>
                                </div>
                                </div>
                               
                                <div class="col-lg-2" style="padding-left: 0px;">

                                    <table id="report-table" class="table table-bordered table-striped mb-0">
                                        <tbody style="height: 115px;display: inline-block;overflow: auto;">
                                        <?php foreach($visit_list['items'] as $result) {?>
                                            <tr 
                                            <?php if(date('Y-m-d') == $result['VisitDate']){?> 
                                            style="cursor: pointer;background-color: cadetblue;"
                                            <?php } else{?>
                                                style="cursor: pointer;"
                                                <?php } ?> id="VisitCol<?php echo e($result['VisitNo']); ?>"
                                                onclick="getVisitDetails(<?php echo e($MrdNo); ?>,<?php echo e($result['VisitNo']); ?>,'<?php echo e($result['VisitDate']); ?>')">
                                                <th width="50"><?php echo e($result['VisitNo']); ?></th>
                                                <th width="150">
                                                        <?php 
                                                      
                                                        $visitamt = (new \App\Http\Controllers\QueueController)->visitAmount($MrdNo,$result['VisitDate']);
                                                        ?>
                                                        <?php echo e(date('d/m/Y', strtotime($result['VisitDate']))); ?> (&#8377;<?php echo e($visitamt); ?>)</th>
                                                </tr>
                                                <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                                
                               

                            </div>
                        </div>
                    </div>
                    <input type="hidden" value="<?php echo e($VisitNo); ?>" id="PrevVal">
                    <input type="hidden" value="<?php echo e(date('Y-m-d')); ?>" id="CurrDate">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="card mb-2">
                                <div class="card-body" style="padding: 1px;padding-left: 6px;padding-right: 6px">

                                    <input type="hidden" id="pageval" value="<?php echo e($_GET['page']); ?>">
                                    <div class="tab-content">
                                        <div class="tab-pane fade <?php if($_GET['page'] == 'tab1'){?>show active<?php }  else{}?>"
                                            id="navs-wc-home">
                                            <?php echo $__env->make('opd/incoptoform', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </div><!-- Close Tab 1-->
                                        <!-- Open Tab 2 -->
                                        
                                        <div class="tab-pane fade <?php if($_GET['page'] == 'consult'){?>show active<?php } else{}?>"
                                            id="navs-wc-profile">
                                            
                                        </div>
                                        <div class="tab-pane fade" id="navs-wc-summary">
                                            <div class="col-sm-12 sub_btn"
                                                style="padding-top:10px;padding-bottom:10px;">
                                                <button class="btn btn-primary" type="button"
                                                    onclick="viewSummary(<?php echo e($MrdNo); ?>)">View Summary</button>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div><!-- [ Layout content ] Start -->
    <!-- [ Layout container ] End -->
    <!-- Overlay -->
    <div id="cover-spin"></div>
    <script src="<?php echo e(url('assets/js/jquery-3.6.0.min.js')); ?>"></script>
    <?php echo $__env->make('masters/inccommonmodal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('masters/inccommonmodal2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('masters/incdrugmodal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('masters/incspecinstmodal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('masters/incspecclinicmodal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('masters/incinvestigationmodal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="layout-overlay layout-sidenav-toggle"></div><!-- [ Layout wrapper] End -->
    <!-- Modal -->

<!-- Core -->
<script src="<?php echo e(url('assets/js/bootstrap.js')); ?>?v=<?php echo e(filemtime(public_path('assets/js/bootstrap.js'))); ?>"></script>
<script src="<?php echo e(url('assets/js/sidenav.js')); ?>?v=<?php echo e(filemtime(public_path('assets/js/sidenav.js'))); ?>"></script>
<script src="<?php echo e(url('assets/js/layout-helpers.js')); ?>?v=<?php echo e(filemtime(public_path('assets/js/layout-helpers.js'))); ?>"></script>
<script src="<?php echo e(url('assets/js/material-ripple.js')); ?>?v=<?php echo e(filemtime(public_path('assets/js/material-ripple.js'))); ?>"></script>

<!-- Plugins -->
<script src="<?php echo e(url('assets/libs/perfect-scrollbar/perfect-scrollbar.js')); ?>?v=<?php echo e(filemtime(public_path('assets/libs/perfect-scrollbar/perfect-scrollbar.js'))); ?>"></script>
<script src="<?php echo e(url('assets/libs/growl/growl.js')); ?>?v=<?php echo e(filemtime(public_path('assets/libs/growl/growl.js'))); ?>"></script>
<script src="<?php echo e(url('assets/libs/toastr/toastr.js')); ?>?v=<?php echo e(filemtime(public_path('assets/libs/toastr/toastr.js'))); ?>"></script>
<script src="<?php echo e(url('assets/libs/bootstrap-sweetalert/bootstrap-sweetalert.js')); ?>?v=<?php echo e(filemtime(public_path('assets/libs/bootstrap-sweetalert/bootstrap-sweetalert.js'))); ?>"></script>

<!-- Validation -->
<script src="<?php echo e(url('assets/libs/validate/validate.js')); ?>?v=<?php echo e(filemtime(public_path('assets/libs/validate/validate.js'))); ?>"></script>
<script src="<?php echo e(url('assets/js/pages/forms_validation.js')); ?>?v=<?php echo e(filemtime(public_path('assets/js/pages/forms_validation.js'))); ?>"></script>

<!-- Demo (remove if not needed in production) -->
<script src="<?php echo e(url('assets/js/demo.js')); ?>?v=<?php echo e(filemtime(public_path('assets/js/demo.js'))); ?>"></script>

    <script>
function clearAll(){
    $('#Diagnosis').val('');
    $('#Treatment').val('');
    $('#Advice').val('');
    $('#ReferTo').val('');
    deleteConsultantTreatment();

}
function deleteConsultantTreatment(){
    var MrdNo = $('#MrdNo').val();
        var VisitDate = $('#VisitDate').val();
        var VisitNo = $('#VisitNo').val();
        $.ajax({
            url: "<?php echo e(url('deleteConsultantTreatment')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                MrdNo:MrdNo,
                VisitDate:VisitDate,
                VisitNo:VisitNo
            },
            success: function(data) {
                console.log(data);
                $('#showTreatments').html(data);
          
            }
        });
}
function investigationLists() {
    $.ajax({
        url: "<?php echo e(url('investigationLists')); ?>",
        method: "POST",
        data: {
            _token: '<?php echo e(csrf_token()); ?>'
        },
        success: function(data) {
            //console.log(data);
            $('#investigationresult').html(data);
            $('#modal-report-invst').modal("show");
        }
    });

}

    function calDiff(k1,k2,diffid){
        var k1 = $('#'+k1).val();
        var k2 = $('#'+k2).val();
        var diff = Number(k1) - Number(k2);
        $('#'+diffid).val(diff);
    }
        function sendYoutubeLink(){
            var YoutubeLink = $('#YoutubeLink').val();
            var WhatsappNo = $('#WhatsappNo').val();
            $.ajax({
            url: "<?php echo e(url('sendYoutubeLink')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                YoutubeLink:YoutubeLink,
                WhatsappNo:WhatsappNo
            },
            beforeSend: function() {
                $('#sendlinkbtn').attr('disabled', 'disabled');
                $('#sendlinkbtn').text('Sending...');
            },
            success: function(data) {
                $('#sendlinkbtn').attr('disabled', false);
                $('#sendlinkbtn').text('Sent');
            }
        });
        }
        function addNewSpClinic() {
        $('#Spaction').val('Save');
        $('#Spid').val('');
        $('#SpClinicName').val('');
        $('#SpName').val('');
        $('#drugbtn').text("Save");
        $('#specclinictitle').html(
            "Add <span class='font-weight-light'>Specility Clinic</span>");
            spec_clinic_lists();

    }

    function spec_clinic_lists() {
        $.ajax({
            url: "<?php echo e(url('viewSpecialityClinicList')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>'
            },
            success: function(data) {
                //console.log(data);
                $('#speccliniccustresult').html(data);
            }
        });
    }

    function cliniclists() {
        $.ajax({
            url: "<?php echo e(url('getSpecClinic')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>'
            },
            success: function(data) {
                //console.log(data);
                $('#ClinicName').html(data);
            }
        });
    }

  

    function saveSpecialityClinic() {
        var SpClinicName = $('#SpClinicName').val();
        var SpName = $('#SpName').val();
        var action = $('#Spaction').val();
        var id = $('#Spid').val();
        $.ajax({
            url: "<?php echo e(url('saveSpecialityClinic')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                ClinicName: SpClinicName,
                Name: SpName,
                action: action,
                id: id
            },
            beforeSend: function() {
                $('#specclinicbtn').attr('disabled', 'disabled');
                $('#specclinicbtn').text('Please Wait...');
            },
            success: function(data) {
                cliniclists();
                $('#ClinicName').attr("selected",true).val('');
                $('#SpecDocName').attr("selected",true).val('');
                $('#modal-report-spec').modal('hide');
                $('#Spaction').val('Save');
                $('#Spid').val('');
                $('#specclinicbtn').attr('disabled', false);
                $('#specclinicbtn').text('Submit');
                

            }
        });
    }

        function getSpecConsultant(val) {
        $.ajax({
            url: "<?php echo e(url('getSpecConsultant')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                val:val
            },
            success: function(data) {
                //console.log(data);
                $('#SpecDocName').html(data);
            }
        });
    }

       
   

    function dlRestoreValue(i) {

        let t = $('#' + i);
        if (t.val() === '') {

            if (t.attr('org-placeholder') !== t.attr('placeholder')) {
                t.val(t.attr('placeholder'));
            }

            t.attr('placeholder', '');
            if (t.val() === '') {
                t.attr('placeholder', t.attr('org-placeholder'));
            }

        }

    }

    function dlShowAllOnArrowClick(i) {

        $('#' + i)
            .on('click', function(e) {

                let t = $(this);
                if ((t.width() - (e.clientX - t.offset().left)) < 14) {
                    if (t.val() !== "") {
                        t.attr('placeholder', t.val());
                        t.val('');
                    }
                } else {
                    dlRestoreValue(i)
                }
            })

            .on('mouseleave', function() {
                dlRestoreValue(this.id);
            })


            .on('mouseenter', function() {
                if (!$(this).is("[org-placeholder]")) $(this).attr('org-placeholder', $(this).attr('placeholder'));
            })

    }
    dlShowAllOnArrowClick('ReOcMov');
    dlShowAllOnArrowClick('LeOcMov');
    dlShowAllOnArrowClick('ReLids');
    dlShowAllOnArrowClick('LeLids');
    dlShowAllOnArrowClick('ReConj');
    dlShowAllOnArrowClick('LeConj');
    dlShowAllOnArrowClick('ReCornea');
    dlShowAllOnArrowClick('LeCornea');
    dlShowAllOnArrowClick('ReCorneaRemark');
    dlShowAllOnArrowClick('ReAntChamber');
    dlShowAllOnArrowClick('LeAntChamber');
    dlShowAllOnArrowClick('ReIris');
    dlShowAllOnArrowClick('LeIris');
    dlShowAllOnArrowClick('RePupil');
    dlShowAllOnArrowClick('LePupil');
    dlShowAllOnArrowClick('ReLens');
    dlShowAllOnArrowClick('LeLens');
    dlShowAllOnArrowClick('ReLens2');
    dlShowAllOnArrowClick('LeLens2');
    dlShowAllOnArrowClick('ReNlp');
    dlShowAllOnArrowClick('LeNlp');



    function getDialated() {
        if ($('#Dialated').prop('checked') == true) {
            $('#ConsDialated').val(1).prop('checked', true);
            $('#Dialated').val(1).prop('checked', true);
        } else {
            $('#Dialated').val(0).prop('checked', false);
            $('#ConsDialated').val(0).prop('checked', false);
            $('#DiaEye').val('BE').attr("selected", true);
            $('#ConsDiaEye').val('BE').attr("selected", true);
        }
    }

    function getConsDialated() {
        if ($('#ConsDialated').prop('checked') == true) {
            $('#ConsDialated').val(1).prop('checked', true);
            $('#Dialated').val(1).prop('checked', true);
        } else {
            $('#Dialated').val(0).prop('checked', false);
            $('#ConsDialated').val(0).prop('checked', false);
            $('#DiaEye').val('BE').attr("selected", true);
            $('#ConsDiaEye').val('BE').attr("selected", true);
        }
    }

    function getDiaEye(val) {
        if (val == '') {
            $('#DiaEye').val('BE').attr("selected", true);
            $('#ConsDiaEye').val('BE').attr("selected", true);
        } else {
            $('#DiaEye').val(val).attr("selected", true);
            $('#ConsDiaEye').val(val).attr("selected", true);
        }

    }

    function showOTnotes(mrdno) {
        setTimeout(function() {
            window.open(
                '/<?php echo e(projectUrl()); ?>opdOtNotesReport/' + mrdno, 'popUpWindow3',
                'height=1000,width=900,left=0,top=0,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
            );
        }, 1);
    }
    function getPrevOptoCons(mrdno,visitdate){
        $.ajax({
            url: "<?php echo e(url('getPrevOptoCons')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                mrdno: mrdno,
                visitdate:visitdate
            },
            success: function(data) {
                //console.log(data);
                $('#prevoptcons').html(data);
            }
        });
    }
    function getOptoVisitDetails(mrdno, visitno, visitdate) {
        getPrevOptoCons(mrdno,visitdate);
        var CurrDate = $('#CurrDate').val();
        $.ajax({
            url: "<?php echo e(url('getVisitDetails')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                mrdno: mrdno,
                visitno: visitno,
                visitdate: visitdate
            },
            success: function(data) {
                //console.log(data);
                //console.log(data['items'].id);
                //var res = JSON.parse(data);
                //var result = res.items;
                var result = data['items'];
                $('#id').val(result.id)
                $('#VisitNo').val(result.VisitNo)
                $('#VisitDate').val(result.VisitDate)
                $('#OptVisitNo').val(result.VisitNo)
                $('#OptVisitDate').val(result.VisitDate)
                $('#ConsVisitNo').val(result.VisitNo)
                $('#ConsVisitDate').val(result.VisitDate)
                $('#RefBy').val(result.RefBy);
                $('#ArSrSphRe').val(result.ArSrSphRe);
                $('#ArSrCylRe').val(result.ArSrCylRe);
                $('#ArSrAxisRe').val(result.ArSrAxisRe);
                $('#ArSrSphLe').val(result.ArSrSphLe);
                $('#ArSrCylLe').val(result.ArSrCylLe);
                $('#ArSrAxisLe').val(result.ArSrAxisLe);
                $('#ConfirmConsult').val(result.ConfirmConsult).attr("selected", true);
                $("#ConfirmOpto").val(result.ConfirmOpto).attr("selected", true);
                $('#Complaint1').val(result.Complaint1);
                $('#CompDays1').val(result.CompDays1).attr("selected", true);
                $('#CompEyes1').val(result.CompEyes1).attr("selected", true);
                $('#Complaint2').val(result.Complaint2);
                $('#CompDays2').val(result.CompDays2).attr("selected", true);
                $('#CompEyes2').val(result.CompEyes2).attr("selected", true);
                $('#Complaint3').val(result.Complaint3);
                $('#CompDays3').val(result.CompDays3).attr("selected", true);
                $('#CompEyes3').val(result.CompEyes3).attr("selected", true);
                $('#PastHistory').val(result.PastHistory);
                $('#SrSphRe').val(result.SrSphRe);
                $('#SrCylRe').val(result.SrCylRe);
                $('#SrAxisRe').val(result.SrAxisRe);
                $('#SrNearAddRe').val(result.SrNearAddRe);
                $('#SrVaGlassRe').val(result.SrVaGlassRe);
                $('#SrNvRe').val(result.SrNvRe);
                $('#SrSphLe').val(result.SrSphLe);
                $('#SrCylLe').val(result.SrCylLe);
                $('#SrAxisLe').val(result.SrAxisLe);
                $('#SrNearAddLe').val(result.SrNearAddLe);
                $('#SrVaGlassLe').val(result.SrVaGlassLe);
                $('#SrNvLe').val(result.SrNvLe);
                $('#GlassType').val(result.GlassType);
                $('#Uses').val(result.Uses);
                $('#Remarks').val(result.Remarks);
                $('#VaRe').val(result.VaRe);
                $('#VaReNear').val(result.VaReNear);
                $('#VaPhRe').val(result.VaPhRe);
                $('#OgRe').val(result.OgRe);
                $('#VaLe').val(result.VaLe);
                $('#VaLeNear').val(result.VaLeNear);
                $('#VaPhLe').val(result.VaPhLe);
                $('#OgLe').val(result.OgLe);
                $('#PgSphRe').val(result.PgSphRe);
                $('#PgCylRe').val(result.PgCylRe);
                $('#PgCylRe').val(result.PgCylRe);
                $("input[name='PgAxisRe']").val(result.PgAxisRe);
                $('#PgNearAddRe').val(result.PgNearAddRe);
                $('#PgSphLe').val(result.PgSphLe);
                $('#PgCylLe').val(result.PgCylLe);
                $('#PgNearAddLe').val(result.PgNearAddLe);
                $("input[name='PgAxisLe']").val(result.PgAxisLe);
                $('#ColorVision').val(result.ColorVision);
                $("input[name='IopNctRe']").val(result.IopNctRe);
                $("input[name='IopNctLe']").val(result.IopNctLe);
                $("input[name='IopAtRe']").val(result.IopAtRe);
                $("input[name='IopAtLe']").val(result.IopAtLe);
                $("input[name='RefSphRe']").val(result.RefSphRe);
                $("input[name='RefCylRe']").val(result.RefCylRe);
                $("input[name='RefAxisRe']").val(result.RefAxisRe);
                $("input[name='RefK1Re']").val(result.RefK1Re);
                $("input[name='RefK1AxisRe']").val(result.RefK1AxisRe);
                $("input[name='RefK2Re']").val(result.RefK2Re);
                $("input[name='RefK2AxisRe']").val(result.RefK2AxisRe);
                $("input[name='RefDiffRe']").val(result.RefDiffRe);
                $("input[name='RefSphLe']").val(result.RefSphLe);
                $("input[name='RefCylLe']").val(result.RefCylLe);
                $("input[name='RefAxisLe']").val(result.RefAxisLe);
                $("input[name='RefK1Le']").val(result.RefK1Le);
                $("input[name='RefK1AxisLe']").val(result.RefK1AxisLe);
                $("input[name='RefK2Le']").val(result.RefK2Le);
                $("input[name='RefK2AxisLe']").val(result.RefK2AxisLe);
                $("input[name='RefDiffLe']").val(result.RefDiffLe);
                if (result.ChkDm == 'DM') {
                    $("input[name='ChkDm']").val(result.ChkDm).attr('checked', true);
                } else {
                    $("input[name='ChkDm']").val(result.ChkDm).attr('checked', false);
                }

                if (result.ChkHt == 'HT') {
                    $("input[name='ChkHt']").val(result.ChkHt).attr('checked', true);
                } else {
                    $("input[name='ChkHt']").val(result.ChkHt).attr('checked', false);
                }

                if (result.ChkCad == 'C.A.D') {
                    $("input[name='ChkCad']").val(result.ChkCad).attr('checked', true);
                } else {
                    $("input[name='ChkCad']").val(result.ChkCad).attr('checked', false);
                }

                if (result.ChkProst == 'Prost.') {
                    $("input[name='ChkProst']").val(result.ChkProst).attr('checked', true);
                } else {
                    $("input[name='ChkProst']").val(result.ChkProst).attr('checked', false);
                }

                if (result.ChkCopd == 'COPD') {
                    $("input[name='ChkCopd']").val(result.ChkCopd).attr('checked', true);
                } else {
                    $("input[name='ChkCopd']").val(result.ChkCopd).attr('checked', false);
                }

                if (result.ChkOther == 'Other') {
                    $("input[name='ChkOther']").val(result.ChkOther).attr('checked', true);
                } else {
                    $("input[name='ChkOther']").val(result.ChkOther).attr('checked', false);
                }
                $('#dmtext').val(result.DmFrom);
                $('#dmtext2').val(result.HtFrom);
                $('#dmtext3').val(result.ProstFrom);
                $('#dmtext4').val(result.CopdFrom);
                $('#dmtext5').val(result.CadFrom);
                $('#dmtext6').val(result.OtherFrom);

                $('#DmPeriod').val(result.DmPeriod).attr('selected', true);
                $('#HtPeriod').val(result.HtPeriod).attr('selected', true);
                $('#CadPeriod').val(result.CadPeriod).attr('selected', true);
                $('#ProstPeriod').val(result.ProstPeriod).attr('selected', true);
                $('#CopdPeriod').val(result.CopdPeriod).attr('selected', true);
                $('#OtherPeriod').val(result.OtherPeriod).attr('selected', true);
                $('#AllergyHistory').val(result.AllergyHistory);
                $('#MedicalHistory').val(result.MedicalHistory);
                $('#convare').html(result.SrVaGlassRe)
                $('#convale').html(result.SrVaGlassLe)
                $('#connvre').html(result.IopNctRe)
                $('#connvle').html(result.IopNctLe)
                $('#SrPinRe').val(result.SrPinRe);
                $('#SrPinLe').val(result.SrPinLe);
                if (CurrDate == visitdate) {
                    $('#saveopto').attr("disabled", false);
                    $('#saveopto2').attr("disabled", false);

                } else {
                    $('#saveopto').attr("disabled", true);
                    $('#saveopto2').attr("disabled", true);

                }
            }
        });
    }

    function getConsultVisitDetails(mrdno, visitno, visitdate) {
        getPrevOptoCons(mrdno,visitdate);
        var CurrDate = $('#CurrDate').val();
        $.ajax({
            url: "<?php echo e(url('getConsultVisitDetails')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                mrdno: mrdno,
                visitno: visitno,
                visitdate: visitdate
            },
            success: function(data) {
                //console.log(data);

                 var res = JSON.parse(data);
                 //console.log(res);
                 var result = res['result']['items'];
                 var result2 = res['result2']['items'];
                 //console.log(result.id);
                 
                $('#consid').val(result.id)
                $('#VisitNo').val(result.VisitNo)
                $('#VisitDate').val(result.VisitDate)
                $('#OptVisitNo').val(result.VisitNo)
                $('#OptVisitDate').val(result.VisitDate)
                $('#ConsVisitNo').val(result.VisitNo)
                $('#ConsVisitDate').val(result.VisitDate)
                $('#TypePatient').val(result.BeOcMov);
                
                $('#ReOcMov').val(result.ReOcMov);
                $('#LeOcMov').val(result.LeOcMov);
                $('#OrbitalRe').val(result.OrbitalRe);
                $('#OrbitalLe').val(result.OrbitalLe);
                $('#ReLids').val(result.ReLids);
                $('#LeLids').val(result.LeLids);
                $('#ReConj').val(result.ReConj);
                $('#LeConj').val(result.LeConj);
                $('#ReCornea').val(result.ReCornea);
                $('#LeCornea').val(result.LeCornea);
                $('#ReCorneaRemark').val(result.ReCorneaRemark);
                $('#LeCorneaRemark').val(result.LeCorneaRemark);
                $('#ReAntChamber').val(result.ReAntChamber);
                $('#LeAntChamber').val(result.LeAntChamber);
                $('#ReIris').val(result.ReIris);
                $('#LeIris').val(result.LeIris);
                $('#RePupil').val(result.RePupil);
                $('#LePupil').val(result.LePupil);
                $('#ReLens').val(result.ReLens);
                $('#LeLens').val(result.LeLens);
                $('#ReLens2').val(result.ReLens2);
                $('#LeLens2').val(result.LeLens2);
                $('#ReNlp').val(result.ReNlp);
                $('#LeNlp').val(result.LeNlp);
                $('#CouncRemark').val(result.CouncRemark);
                $('#ReMedia').val(result.ReMedia);
                $('#LeMedia').val(result.LeMedia);
                $('#ReOptDisc').val(result.ReOptDisc);
                $('#LeOptDisc').val(result.LeOptDisc);
                $('#FundusRemark').val(result.FundusRemark);
                $("input[name='AlRe']").val(result.AlRe);
                $("input[name='AlLe']").val(result.AlLe);
                $("input[name='WtwRe']").val(result.WtwRe);
                $("input[name='WtwLe']").val(result.WtwLe);
                $("input[name='IOL1']").val(result.IOL1);
                $("input[name='IOL2']").val(result.IOL2);
                $("input[name='IOL4']").val(result.IOL4);
                $("input[name='IOL3']").val(result.IOL3);
                $("input[name='IOL5']").val(result.IOL5);
                $("input[name='IOL6']").val(result.IOL6);
                $("#Diagnosis").val(result.Diagnosis);
                $("#Advice").val(result.Advice);
                $("#Remark").val(result.Remark);
                $("#ReferTo").val(result.ReferTo);
                $('#InvStName').val(result.InvStName);
                $("#BP").val(result.BP);
                $('#ReferTo').val(result.ReferTo);
               // $('#RefBy').val(result.RefBy);
                $('#CouncRemark').val(result.CouncRemark);

                $("#Treatment").val(result2.Treatment);
                if (result2.TreatChk1 == 1) {
                    $("#TreatChk1").val(1).attr('checked', true);
                } else {
                    $("#TreatChk1").val(0).attr('checked', false);
                }
                $("#TreatName1").val(result2.TreatName1);
                $("#TreatType1").val(result2.TreatType1).attr('selected', true);
                $("#TreatDose1").val(result2.TreatDose1).attr('selected', true);
                $("#TreatFreq1").val(result2.TreatFreq1).attr('selected', true);
                $("#TreatDur1").val(result2.TreatDur1).attr('selected', true);
                $("#TreatEye1").val(result2.TreatEye1).attr('selected', true);

                if (result2.TreatChk2 == 1) {
                    $("#TreatChk2").val(1).attr('checked', true);
                } else {
                    $("#TreatChk2").val(0).attr('checked', false);
                }
                $("#TreatName2").val(result2.TreatName2);
                $("#TreatType2").val(result2.TreatType2).attr('selected', true);
                $("#TreatDose2").val(result2.TreatDose2).attr('selected', true);
                $("#TreatFreq2").val(result2.TreatFreq2).attr('selected', true);
                $("#TreatDur2").val(result2.TreatDur2).attr('selected', true);
                $("#TreatEye2").val(result2.TreatEye2).attr('selected', true);

                if (result2.TreatChk3 == 1) {
                    $("#TreatChk3").val(1).attr('checked', true);
                } else {
                    $("#TreatChk3").val(0).attr('checked', false);
                }
                $("#TreatName3").val(result2.TreatName3);
                $("#TreatType3").val(result2.TreatType3).attr('selected', true);
                $("#TreatDose3").val(result2.TreatDose3).attr('selected', true);
                $("#TreatFreq3").val(result2.TreatFreq3).attr('selected', true);
                $("#TreatDur3").val(result2.TreatDur3).attr('selected', true);
                $("#TreatEye3").val(result2.TreatEye3).attr('selected', true);

                if (result2.TreatChk4 == 1) {
                    $("#TreatChk4").val(1).attr('checked', true);
                } else {
                    $("#TreatChk4").val(0).attr('checked', false);
                }
                $("#TreatName4").val(result2.TreatName4);
                $("#TreatType4").val(result2.TreatType4).attr('selected', true);
                $("#TreatDose4").val(result2.TreatDose4).attr('selected', true);
                $("#TreatFreq4").val(result2.TreatFreq4).attr('selected', true);
                $("#TreatDur4").val(result2.TreatDur4).attr('selected', true);
                $("#TreatEye4").val(result2.TreatEye4).attr('selected', true);

                if (result2.TreatChk5 == 1) {
                    $("#TreatChk5").val(1).attr('checked', true);
                } else {
                    $("#TreatChk5").val(0).attr('checked', false);
                }
                $("#TreatName5").val(result2.TreatName5);
                $("#TreatType5").val(result2.TreatType5).attr('selected', true);
                $("#TreatDose5").val(result2.TreatDose5).attr('selected', true);
                $("#TreatFreq5").val(result2.TreatFreq5).attr('selected', true);
                $("#TreatDur5").val(result2.TreatDur5).attr('selected', true);
                $("#TreatEye5").val(result2.TreatEye5).attr('selected', true);

                if (result2.TreatChk6 == 1) {
                    $("#TreatChk6").val(1).attr('checked', true);
                } else {
                    $("#TreatChk6").val(0).attr('checked', false);
                }
                $("#TreatName6").val(result2.TreatName6);
                $("#TreatType6").val(result2.TreatType6).attr('selected', true);
                $("#TreatDose6").val(result2.TreatDose6).attr('selected', true);
                $("#TreatFreq6").val(result2.TreatFreq6).attr('selected', true);
                $("#TreatDur6").val(result2.TreatDur6).attr('selected', true);
                $("#TreatEye6").val(result2.TreatEye6).attr('selected', true);

                if (result2.TreatChk7 == 1) {
                    $("#TreatChk7").val(1).attr('checked', true);
                } else {
                    $("#TreatChk7").val(0).attr('checked', false);
                }
                $("#TreatName7").val(result2.TreatName7);
                $("#TreatType7").val(result2.TreatType7).attr('selected', true);
                $("#TreatDose7").val(result2.TreatDose7).attr('selected', true);
                $("#TreatFreq7").val(result2.TreatFreq7).attr('selected', true);
                $("#TreatDur7").val(result2.TreatDur7).attr('selected', true);
                $("#TreatEye7").val(result2.TreatEye7).attr('selected', true);

                if (result2.TreatChk8 == 1) {
                    $("#TreatChk8").val(1).attr('checked', true);
                } else {
                    $("#TreatChk8").val(0).attr('checked', false);
                }
                $("#TreatName8").val(result2.TreatName8);
                $("#TreatType8").val(result2.TreatType8).attr('selected', true);
                $("#TreatDose8").val(result2.TreatDose8).attr('selected', true);
                $("#TreatFreq8").val(result2.TreatFreq8).attr('selected', true);
                $("#TreatDur8").val(result2.TreatDur8).attr('selected', true);
                $("#TreatEye8").val(result2.TreatEye8).attr('selected', true);

                if (result2.TreatChk9 == 1) {
                    $("#TreatChk9").val(1).attr('checked', true);
                } else {
                    $("#TreatChk9").val(0).attr('checked', false);
                }
                $("#TreatName9").val(result2.TreatName9);
                $("#TreatType9").val(result2.TreatType9).attr('selected', true);
                $("#TreatDose9").val(result2.TreatDose9).attr('selected', true);
                $("#TreatFreq9").val(result2.TreatFreq9).attr('selected', true);
                $("#TreatDur9").val(result2.TreatDur9).attr('selected', true);
                $("#TreatEye9").val(result2.TreatEye9).attr('selected', true);

                if (result2.TreatChk10 == 1) {
                    $("#TreatChk10").val(1).attr('checked', true);
                } else {
                    $("#TreatChk10").val(0).attr('checked', false);
                }
                $("#TreatName10").val(result2.TreatName10);
                $("#TreatType10").val(result2.TreatType10).attr('selected', true);
                $("#TreatDose10").val(result2.TreatDose10).attr('selected', true);
                $("#TreatFreq10").val(result2.TreatFreq10).attr('selected', true);
                $("#TreatDur10").val(result2.TreatDur10).attr('selected', true);
                $("#TreatEye10").val(result2.TreatEye10).attr('selected', true);
                if (CurrDate == visitdate) {
                    $('#consbtns').show();
                    $('#consbtns2').hide();

                } else {
                    $('#consbtns').hide();
                    $('#consbtns2').show();

                }
           
            }
        });
    }

    function getVisitDetails(mrdno, visitno, visitdate) {
        //alert(visitno);alert(visitdate);
        var PrevVal = $('#PrevVal').val();
        //alert(PrevVal);
        $('#VisitCol' + PrevVal).css("background-color", "");
        $('#copymrdno').val(mrdno);
        $('#copyvisitno').val(visitno);
        $('#copyvisitdate').val(visitdate);
        $('#PrevVal').val(visitno);
        $('#VisitCol' + visitno).css("background-color", "cadetblue");
        var pageval = $('#pageval').val();
        // if (pageval == 'tab1') {
        //     getOptoVisitDetails(mrdno, visitno, visitdate);
        // } else {
        //     getConsultVisitDetails(mrdno, visitno, visitdate);
        // }
        getOptoVisitDetails(mrdno, visitno, visitdate);
        getConsultVisitDetails(mrdno, visitno, visitdate);
    }

    function corrRef(orgval, crval) {
        var val = $('#' + orgval).val();
        $('#' + crval).val(val);
    }

    function otNotes() {
        var MrdNo = $('#MrdNo').val();
        setTimeout(function() {
            window.open(
                '/<?php echo e(projectUrl()); ?>addOtNotes2/' + MrdNo, 'otnotes',
                'toolbar=1, scrollbars=1, location=1,statusbar=0, menubar=1, resizable=1, width=1500, height=1000'
            );
        }, 1);
    }

    function otNotesOther() {
        var MrdNo = $('#MrdNo').val();
        setTimeout(function() {
            window.open(
                '/<?php echo e(projectUrl()); ?>addOtNotesOther2/' + MrdNo, 'otnotesother',
                'toolbar=1, scrollbars=1, location=1,statusbar=0, menubar=1, resizable=1, width=1500, height=1000'
            );
        }, 1);
    }



    function treatcheck(val,id,srno) {
        if ($('#' + val).prop('checked') == true) {
            $('#' + val).val(1);
        } else {
            $('#' + val).val(0);
           if(id==0){
            $('#TreatType'+srno).val('');
            $('#TreatDose'+srno).val('');
            $('#TreatName'+srno).val('');
            $('#TreatDose'+srno).val('');
            $('#TreatFreq'+srno).val('');
            $('#TreatDur'+srno).val('');
            $('#TreatEye'+srno).val('');
           }
           else{
            deleteConsDrug(id);
            $('#TreatType'+srno).val('');
            $('#TreatDose'+srno).val('');
            $('#TreatName'+srno).val('');
            $('#TreatDose'+srno).val('');
            $('#TreatFreq'+srno).val('');
            $('#TreatDur'+srno).val('');
            $('#TreatEye'+srno).val('');
           }
           
            
        }
    }
    function deleteConsDrug(id){
        $.ajax({
            url: "<?php echo e(url('deleteConsDrug')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                id:id
            },
            success: function(data) {
                showTreatmentList();
            }
        });
    }

    function showTreatmentList(){
        var MrdNo = $('#MrdNo').val();
        var VisitDate = $('#VisitDate').val();
        var VisitNo = $('#VisitNo').val();
        $.ajax({
            url: "<?php echo e(url('showTreatmentList')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                MrdNo:MrdNo,
                VisitDate:VisitDate,
                VisitNo:VisitNo
            },
            success: function(data) {
                console.log(data);
                $('#showTreatments').html(data);
          
            }
        });
    }

    function addNewDrug() {
        $('#drugaction').val('Save');
        $('#drugid').val('');
        $('#DrugName').val('');
        $('#DrugType').val('').attr("selected", true);
        $('#DrugDose').val('').attr("selected", true);
        $('#DrugFreq').val('').attr("selected", true);
        $('#drugbtn').text("Save");
        $('#drugtitle').html(
            "Add <span class='font-weight-light'>Drug</span>");
        procedure_lists();

    }

    function procedure_lists() {
        $.ajax({
            url: "<?php echo e(url('viewDrugList')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>'
            },
            success: function(data) {
                //console.log(data);
                $('#drugcustresult').html(data);
            }
        });
    }

    function drugList() {
        $.ajax({
            url: "<?php echo e(url('saveDrugList')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>'
            },
            success: function(data) {
                $('.treatments').html(data);

            }
        });
    }

    function saveDrug() {
        var Type = $('#DrugType').val();
        var Name = $('#DrugName').val();
        var Dose = $('#DrugDose').val();
        var Freq = $('#DrugFreq').val();
        var MrdNo = $('#MrdNo').val();
        var VisitDate = $('#VisitDate').val();
        var VisitNo = $('#VisitNo').val();
        var action = $('#drugaction').val();
        var id = $('#drugid').val();
        $.ajax({
            url: "<?php echo e(url('saveDrug')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                Type: Type,
                Name: Name,
                Dose: Dose,
                Freq: Freq,
                action: action,
                id: id
            },
            beforeSend: function() {
                $('#drugbtn').attr('disabled', 'disabled');
                $('#drugbtn').text('Please Wait...');
            },
            success: function(data) {

                $('#modal-report656').modal('hide');
                $('#drugaction').val('Save');
                $('#drugid').val('');
                $('#drugbtn').attr('disabled', false);
                $('#drugbtn').text('Submit');
                drugList();
                //window.location.href = "/<?php echo e(projectUrl()); ?>optoform/" + MrdNo + "/" + VisitDate + "/" + VisitNo + "?page=consult";  

            }
        });
    }


    function addNewSpecInst(idval, type) {
        $('#specinstaction').val('Save');
        $('#specinstid').val('');
        $('#SpecInstName').val('');
        $('#SpecInstDetails').val('');
        $('#specinstcmbid').val(idval);
        $('#SpecInstType').val(type).attr("selecetd", true);
        $('#specinstbtn').text("Save");
        $('#specinsttitle').html(
            "Add <span class='font-weight-light'>New</span>");
        specinstlists(idval, type);

    }

    function specinstlists(idval, type) {
        $.ajax({
            url: "<?php echo e(url('viewSpecInstList')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                Type: type
            },
            success: function(data) {
                //console.log(data);
                $('#specinstcustresult').html(data);
            }
        });
    }

    function specInst_List() {
        var idval = $('#specinstcmbid').val();
        var Type = $('#SpecInstType').val();
        $.ajax({
            url: "<?php echo e(url('saveSpecInstList')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                Type: Type
            },
            success: function(data) {
                $('#' + idval).html(data);

            }
        });
    }

    function saveSpecInst() {
        var SpecInstName = $('#SpecInstName').val();
        var SpecInstDetails = $('#SpecInstDetails').val();
        var SpecInstType = $('#SpecInstType').val();
        var action = $('#specinstaction').val();
        var id = $('#specinstid').val();
        $.ajax({
            url: "<?php echo e(url('saveSpecInst')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                SpecInstName: SpecInstName,
                SpecInstDetails: SpecInstDetails,
                SpecInstType: SpecInstType,
                action: action,
                id: id
            },
            beforeSend: function() {
                $('#specinstbtn').attr('disabled', 'disabled');
                $('#specinstbtn').text('Please Wait...');
            },
            success: function(data) {

                $('#modal-report-inst').modal('hide');
                $('#specinstaction').val('Save');
                $('#specinstid').val('');
                $('#specinstbtn').attr('disabled', false);
                $('#specinstbtn').text('Submit');
                specInst_List();

                //window.location.href = "/<?php echo e(projectUrl()); ?>optoform/" + MrdNo + "/" + VisitDate + "/" + VisitNo + "?page=consult";  

            }
        });
    }


    function getSpecInstDetails(val, detailsid) {
       
        if (val == '') {
            $('#' + detailsid).val('');
        }
        $.ajax({
            url: "<?php echo e(url('getSpecInstDetails')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                val: val
            },

            success: function(data) {
                //console.log(data);
                if (val != '') {
                    $('#' + detailsid).val(data);
                } else {
                    $('#' + detailsid).val('');
                }

            }
        });
    }

    function changeFees(visitno, visitdate, mrdno) {
        var Fees = $('#Fees').val();
        $.ajax({
            url: "<?php echo e(url('changeFees')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                visitno: visitno,
                visitdate: visitdate,
                mrdno: mrdno,
                Fees: Fees
            },

            success: function(data) {


            }
        });
    }

    function getReviewDays(val) {
        $.ajax({
            url: "<?php echo e(url('getReviewDays')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                val: val
            },
            success: function(data) {
                //console.log(data);
                var res = JSON.parse(data);
                var dayname = res.dayname;
                var days = res.days;
                if (dayname == 'Sun') {
                    $('#sundayerrormsg').show();
                    $('#alldaymsg').html('');
                } else {
                    $('#sundayerrormsg').hide();
                    $('#alldaymsg').html(dayname);
                }
                $('#ReviewDay').val(days);
                $('#Review').val('days').attr("selected",true);
            }
        });
    }

    function getTreatNameDetails(name, dose, freq) {
        var treatname = $('#' + name).val();
        $.ajax({
            url: "<?php echo e(url('getTreatNameDetails')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                name: treatname
            },
            dataType: "json",
            success: function(data) {
                //console.log(data);
                //$('#' + dose).val(data.Dose);
                //$('#' + freq).val(data.Freq);
            }
        });
    }

    function getOptoValue(optval, conval) {
        var opt_val = $('#' + optval).val();
        $('#' + conval).html(opt_val);
    }

    function success_toast() {
        var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
        $.growl.notice({
            title: 'Success',
            message: 'Record Saved Successfully!',
            location: isRtl ? 'tl' : 'tr'
        });
    }

    function axisComp(cyl, axis) {
        var cyl = $('#' + cyl).val();
        if (cyl != '') {
            $('#' + axis).attr('required', true);
        } else {
            $('#' + axis).attr('required', false);
        }
    }

    function pressTab(val) {
        if (val == 1) {
            $('#pageval').val('tab1');
        } else {
            $('#pageval').val('consult');
        }

    }

    function exitcoun() {
        window.close();
        window.opener.location.reload(true);
    }

    function copy() {
        var MrdNo = $('#copymrdno').val();
        var VisitNo = $('#copyvisitno').val();
        var VisitDate = $('#copyvisitdate').val();
        //alert(MrdNo);alert(VisionNo);alert(VisitDate);
        //window.location.href = "/<?php echo e(projectUrl()); ?>optoform/" + MrdNo + "/" + VisitDate + "/" + VisionNo + "?page=tab1&action=copy"; 

        $.ajax({
            url: "<?php echo e(url('copyRecord')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                MrdNo: MrdNo,
                VisitNo: VisitNo,
                VisitDate: VisitDate
            },
            beforeSend: function() {
                $('#copybutton').attr('disabled', 'disabled');
                $('#copybutton').text('...');
            },
            success: function(data) {
                //alert("Record Copied");
                // $('#pastebutton').attr('disabled', false);
                // $('#pastebutton').text('Paste');
                $('#copybutton').attr("disabled", false);
                $('#copybutton').text('Copy');

            }
        });
    }

    function paste() {
        // var MrdNo = $('#copymrdno').val();
        //  var VisitNo = $('#copymrdno').val();
        //   var VisitDate = $('#copyvisitdate').val();
        $.ajax({
            url: "<?php echo e(url('pasteRecord')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>'
            },
            beforeSend: function() {
                $('#pastebutton').attr('disabled', 'disabled');
                $('#pastebutton').text('...');
            },
            success: function(data) {
                //console.log(data);exit();
                //alert("Record Pasted Successfully!");
                $('#pastebutton').attr('disabled', false);
                $('#pastebutton').text('Paste');
                var res = JSON.parse(data);
                var result = res.result;
                var result3 = res.result3;
                var result2 = res.result2;
                $('#RefBy').val(result.RefBy);
                $('#ConfirmConsult').val(result.ConfirmConsult).attr("selected", true);
                $("#ConfirmOpto").val(result.ConfirmOpto).attr("selected", true);
                $('#Complaint1').val(result.Complaint1);
                $('#CompDays1').val(result.CompDays1).attr("selected", true);
                $('#CompEyes1').val(result.CompEyes1).attr("selected", true);
                $('#Complaint2').val(result.Complaint2);
                $('#CompDays2').val(result.CompDays2).attr("selected", true);
                $('#CompEyes2').val(result.CompEyes2).attr("selected", true);
                $('#Complaint3').val(result.Complaint3);
                $('#CompDays3').val(result.CompDays3).attr("selected", true);
                $('#CompEyes3').val(result.CompEyes3).attr("selected", true);
                $('#ArSrSphRe').val(result.ArSrSphRe);
                $('#ArSrCylRe').val(result.ArSrCylRe);
                $('#ArSrAxisRe').val(result.ArSrAxisRe);
                $('#ArSrSphLe').val(result.ArSrSphLe);
                $('#ArSrCylLe').val(result.ArSrCylLe);
                $('#ArSrAxisLe').val(result.ArSrAxisLe);
                $('#PastHistory').val(result.PastHistory);
                $('#SrSphRe').val(result.SrSphRe);
                $('#SrCylRe').val(result.SrCylRe);
                $('#SrAxisRe').val(result.SrAxisRe);
                $('#SrNearAddRe').val(result.SrNearAddRe);
                $('#SrVaGlassRe').val(result.SrVaGlassRe);
                $('#SrNvRe').val(result.SrNvRe);
                $('#SrSphLe').val(result.SrSphLe);
                $('#SrCylLe').val(result.SrCylLe);
                $('#SrAxisLe').val(result.SrAxisLe);
                $('#SrNearAddLe').val(result.SrNearAddLe);
                $('#SrVaGlassLe').val(result.SrVaGlassLe);
                $('#SrNvLe').val(result.SrNvLe);
                $('#GlassType').val(result.GlassType);
                $('#Uses').val(result.Uses);
                $('#Remarks').val(result.Remarks);
                $('#VaRe').val(result.VaRe);
                $('#VaReNear').val(result.VaReNear);
                $('#VaPhRe').val(result.VaPhRe);
                $('#OgRe').val(result.OgRe);
                $('#VaLe').val(result.VaLe);
                $('#VaLeNear').val(result.VaLeNear);
                $('#VaPhLe').val(result.VaPhLe);
                $('#OgLe').val(result.OgLe);
                $('#PgSphRe').val(result.PgSphRe);
                $('#PgCylRe').val(result.PgCylRe);
                $('#PgCylRe').val(result.PgCylRe);
                $("input[name='PgAxisRe']").val(result.PgAxisRe);
                $('#PgNearAddRe').val(result.PgNearAddRe);
                $('#PgSphLe').val(result.PgSphLe);
                $('#PgCylLe').val(result.PgCylLe);
                $('#PgNearAddLe').val(result.PgNearAddLe);
                $("input[name='PgAxisLe']").val(result.PgAxisLe);
                $('#ColorVision').val(result.ColorVision);
                $("input[name='IopNctRe']").val(result.IopNctRe);
                $("input[name='IopNctLe']").val(result.IopNctLe);
                $("input[name='IopAtRe']").val(result.IopAtRe);
                $("input[name='IopAtLe']").val(result.IopAtLe);
                $("input[name='RefSphRe']").val(result.RefSphRe);
                $("input[name='RefCylRe']").val(result.RefCylRe);
                $("input[name='RefAxisRe']").val(result.RefAxisRe);
                $("input[name='RefK1Re']").val(result.RefK1Re);
                $("input[name='RefK1AxisRe']").val(result.RefK1AxisRe);
                $("input[name='RefK2Re']").val(result.RefK2Re);
                $("input[name='RefK2AxisRe']").val(result.RefK2AxisRe);
                $("input[name='RefDiffRe']").val(result.RefDiffRe);
                $("input[name='RefSphLe']").val(result.RefSphLe);
                $("input[name='RefCylLe']").val(result.RefCylLe);
                $("input[name='RefAxisLe']").val(result.RefAxisLe);
                $("input[name='RefK1Le']").val(result.RefK1Le);
                $("input[name='RefK1AxisLe']").val(result.RefK1AxisLe);
                $("input[name='RefK2Le']").val(result.RefK2Le);
                $("input[name='RefK2AxisLe']").val(result.RefK2AxisLe);
                $("input[name='RefDiffLe']").val(result.RefDiffLe);
                $('#convare').html(result.SrVaGlassRe)
                $('#convale').html(result.SrVaGlassLe)
                $('#connvre').html(result.IopNctRe)
                $('#connvle').html(result.IopNctLe)
                if (result.ChkDm == 'DM') {
                    $("input[name='ChkDm']").val(result.ChkDm).attr('checked', true);
                } else {
                    $("input[name='ChkDm']").val(result.ChkDm).attr('checked', false);
                }

                if (result.ChkHt == 'HT') {
                    $("input[name='ChkHt']").val(result.ChkHt).attr('checked', true);
                } else {
                    $("input[name='ChkHt']").val(result.ChkHt).attr('checked', false);
                }

                if (result.ChkCad == 'C.A.D') {
                    $("input[name='ChkCad']").val(result.ChkCad).attr('checked', true);
                } else {
                    $("input[name='ChkCad']").val(result.ChkCad).attr('checked', false);
                }

                if (result.ChkProst == 'Prost.') {
                    $("input[name='ChkProst']").val(result.ChkProst).attr('checked', true);
                } else {
                    $("input[name='ChkProst']").val(result.ChkProst).attr('checked', false);
                }

                if (result.ChkCopd == 'COPD') {
                    $("input[name='ChkCopd']").val(result.ChkCopd).attr('checked', true);
                } else {
                    $("input[name='ChkCopd']").val(result.ChkCopd).attr('checked', false);
                }

                if (result.ChkOther == 'Other') {
                    $("input[name='ChkOther']").val(result.ChkOther).attr('checked', true);
                } else {
                    $("input[name='ChkOther']").val(result.ChkOther).attr('checked', false);
                }
                $('#dmtext').val(result.DmFrom);
                $('#dmtext2').val(result.HtFrom);
                $('#dmtext3').val(result.ProstFrom);
                $('#dmtext4').val(result.CopdFrom);
                $('#dmtext5').val(result.CadFrom);
                $('#dmtext6').val(result.OtherFrom);

                $('#DmPeriod').val(result.DmPeriod).attr('selected', true);
                $('#HtPeriod').val(result.HtPeriod).attr('selected', true);
                $('#CadPeriod').val(result.CadPeriod).attr('selected', true);
                $('#ProstPeriod').val(result.ProstPeriod).attr('selected', true);
                $('#CopdPeriod').val(result.CopdPeriod).attr('selected', true);
                $('#OtherPeriod').val(result.OtherPeriod).attr('selected', true);
                $('#AllergyHistory').val(result.AllergyHistory);
                $('#MedicalHistory').val(result.MedicalHistory);
                $('#TypePatient').val(result3.BeOcMov);
                 //consultant record 
                 $('#ReOcMov').val(result3.ReOcMov);
                $('#LeOcMov').val(result3.LeOcMov);
                $('#OrbitalRe').val(result3.OrbitalRe);
                $('#OrbitalLe').val(result3.OrbitalLe);
                $('#ReLids').val(result3.ReLids);
                $('#LeLids').val(result3.LeLids);
                $('#ReConj').val(result3.ReConj);
                $('#LeConj').val(result3.LeConj);
                $('#ReCornea').val(result3.ReCornea);
                $('#LeCornea').val(result3.LeCornea);
                $('#ReCorneaRemark').val(result3.ReCorneaRemark);
                $('#LeCorneaRemark').val(result3.LeCorneaRemark);
                $('#ReAntChamber').val(result3.ReAntChamber);
                $('#LeAntChamber').val(result3.LeAntChamber);
                $('#ReIris').val(result3.ReIris);
                $('#LeIris').val(result3.LeIris);
                $('#RePupil').val(result3.RePupil);
                $('#LePupil').val(result3.LePupil);
                $('#ReLens').val(result3.ReLens);
                $('#LeLens').val(result3.LeLens);
                $('#ReLens2').val(result3.ReLens2);
                $('#LeLens2').val(result3.LeLens2);
                $('#ReNlp').val(result3.ReNlp);
                $('#LeNlp').val(result3.LeNlp);
                $('#CouncRemark').val(result3.CouncRemark);
                $('#ReMedia').val(result3.ReMedia);
                $('#LeMedia').val(result3.LeMedia);
                $('#ReOptDisc').val(result3.ReOptDisc);
                $('#LeOptDisc').val(result3.LeOptDisc);
                $('#FundusRemark').val(result3.FundusRemark);
                $("input[name='AlRe']").val(result3.AlRe);
                $("input[name='AlLe']").val(result3.AlLe);
                $("input[name='WtwRe']").val(result3.WtwRe);
                $("input[name='WtwLe']").val(result3.WtwLe);
                $("input[name='IOL1']").val(result3.IOL1);
                $("input[name='IOL2']").val(result3.IOL2);
                $("input[name='IOL4']").val(result3.IOL4);
                $("input[name='IOL3']").val(result3.IOL3);
                $("input[name='IOL5']").val(result3.IOL5);
                $("input[name='IOL6']").val(result3.IOL6);
                $("#Diagnosis").val(result3.Diagnosis);
                $("#Advice").val(result3.Advice);
                $("#Remark").val(result3.Remark);
                $("#ReferTo").val(result3.ReferTo);
                $('#InvStName').val(result3.InvStName);
                $("#BP").val(result3.BP);
                $('#SrPinRe').val(result.SrPinRe);
                $('#SrPinLe').val(result.SrPinLe);

                $("#Treatment").val(result2.Treatment);
                if (result2.TreatChk1 == 1) {
                    $("#TreatChk1").val(1).attr('checked', true);
                } else {
                    $("#TreatChk1").val(0).attr('checked', false);
                }
                $("#TreatName1").val(result2.TreatName1);
                $("#TreatType1").val(result2.TreatType1).attr('selected', true);
                $("#TreatDose1").val(result2.TreatDose1).attr('selected', true);
                $("#TreatFreq1").val(result2.TreatFreq1).attr('selected', true);
                $("#TreatDur1").val(result2.TreatDur1).attr('selected', true);
                $("#TreatEye1").val(result2.TreatEye1).attr('selected', true);

                if (result2.TreatChk2 == 1) {
                    $("#TreatChk2").val(1).attr('checked', true);
                } else {
                    $("#TreatChk2").val(0).attr('checked', false);
                }
                $("#TreatName2").val(result2.TreatName2);
                $("#TreatType2").val(result2.TreatType2).attr('selected', true);
                $("#TreatDose2").val(result2.TreatDose2).attr('selected', true);
                $("#TreatFreq2").val(result2.TreatFreq2).attr('selected', true);
                $("#TreatDur2").val(result2.TreatDur2).attr('selected', true);
                $("#TreatEye2").val(result2.TreatEye2).attr('selected', true);

                if (result2.TreatChk3 == 1) {
                    $("#TreatChk3").val(1).attr('checked', true);
                } else {
                    $("#TreatChk3").val(0).attr('checked', false);
                }
                $("#TreatName3").val(result2.TreatName3);
                $("#TreatType3").val(result2.TreatType3).attr('selected', true);
                $("#TreatDose3").val(result2.TreatDose3).attr('selected', true);
                $("#TreatFreq3").val(result2.TreatFreq3).attr('selected', true);
                $("#TreatDur3").val(result2.TreatDur3).attr('selected', true);
                $("#TreatEye3").val(result2.TreatEye3).attr('selected', true);

                if (result2.TreatChk4 == 1) {
                    $("#TreatChk4").val(1).attr('checked', true);
                } else {
                    $("#TreatChk4").val(0).attr('checked', false);
                }
                $("#TreatName4").val(result2.TreatName4);
                $("#TreatType4").val(result2.TreatType4).attr('selected', true);
                $("#TreatDose4").val(result2.TreatDose4).attr('selected', true);
                $("#TreatFreq4").val(result2.TreatFreq4).attr('selected', true);
                $("#TreatDur4").val(result2.TreatDur4).attr('selected', true);
                $("#TreatEye4").val(result2.TreatEye4).attr('selected', true);

                if (result2.TreatChk5 == 1) {
                    $("#TreatChk5").val(1).attr('checked', true);
                } else {
                    $("#TreatChk5").val(0).attr('checked', false);
                }
                $("#TreatName5").val(result2.TreatName5);
                $("#TreatType5").val(result2.TreatType5).attr('selected', true);
                $("#TreatDose5").val(result2.TreatDose5).attr('selected', true);
                $("#TreatFreq5").val(result2.TreatFreq5).attr('selected', true);
                $("#TreatDur5").val(result2.TreatDur5).attr('selected', true);
                $("#TreatEye5").val(result2.TreatEye5).attr('selected', true);

                if (result2.TreatChk6 == 1) {
                    $("#TreatChk6").val(1).attr('checked', true);
                } else {
                    $("#TreatChk6").val(0).attr('checked', false);
                }
                $("#TreatName6").val(result2.TreatName6);
                $("#TreatType6").val(result2.TreatType6).attr('selected', true);
                $("#TreatDose6").val(result2.TreatDose6).attr('selected', true);
                $("#TreatFreq6").val(result2.TreatFreq6).attr('selected', true);
                $("#TreatDur6").val(result2.TreatDur6).attr('selected', true);
                $("#TreatEye6").val(result2.TreatEye6).attr('selected', true);

                if (result2.TreatChk7 == 1) {
                    $("#TreatChk7").val(1).attr('checked', true);
                } else {
                    $("#TreatChk7").val(0).attr('checked', false);
                }
                $("#TreatName7").val(result2.TreatName7);
                $("#TreatType7").val(result2.TreatType7).attr('selected', true);
                $("#TreatDose7").val(result2.TreatDose7).attr('selected', true);
                $("#TreatFreq7").val(result2.TreatFreq7).attr('selected', true);
                $("#TreatDur7").val(result2.TreatDur7).attr('selected', true);
                $("#TreatEye7").val(result2.TreatEye7).attr('selected', true);

                if (result2.TreatChk8 == 1) {
                    $("#TreatChk8").val(1).attr('checked', true);
                } else {
                    $("#TreatChk8").val(0).attr('checked', false);
                }
                $("#TreatName8").val(result2.TreatName8);
                $("#TreatType8").val(result2.TreatType8).attr('selected', true);
                $("#TreatDose8").val(result2.TreatDose8).attr('selected', true);
                $("#TreatFreq8").val(result2.TreatFreq8).attr('selected', true);
                $("#TreatDur8").val(result2.TreatDur8).attr('selected', true);
                $("#TreatEye8").val(result2.TreatEye8).attr('selected', true);

                if (result2.TreatChk9 == 1) {
                    $("#TreatChk9").val(1).attr('checked', true);
                } else {
                    $("#TreatChk9").val(0).attr('checked', false);
                }
                $("#TreatName9").val(result2.TreatName9);
                $("#TreatType9").val(result2.TreatType9).attr('selected', true);
                $("#TreatDose9").val(result2.TreatDose9).attr('selected', true);
                $("#TreatFreq9").val(result2.TreatFreq9).attr('selected', true);
                $("#TreatDur9").val(result2.TreatDur9).attr('selected', true);
                $("#TreatEye9").val(result2.TreatEye9).attr('selected', true);

                if (result2.TreatChk10 == 1) {
                    $("#TreatChk10").val(1).attr('checked', true);
                } else {
                    $("#TreatChk10").val(0).attr('checked', false);
                }
                $("#TreatName10").val(result2.TreatName10);
                $("#TreatType10").val(result2.TreatType10).attr('selected', true);
                $("#TreatDose10").val(result2.TreatDose10).attr('selected', true);
                $("#TreatFreq10").val(result2.TreatFreq10).attr('selected', true);
                $("#TreatDur10").val(result2.TreatDur10).attr('selected', true);
                $("#TreatEye10").val(result2.TreatEye10).attr('selected', true);   
                //window.location.href = "/<?php echo e(projectUrl()); ?>optoform/" + MrdNo + "/" + VisitDate + "/" + VisitNo + "?page=tab1";
            }
        });
    }


    function copy2() {
        var MrdNo = $('#copymrdno').val();
        var VisitNo = $('#copyvisitno').val();
        var VisitDate = $('#copyvisitdate').val();
        $.ajax({
            url: "<?php echo e(url('copyRecord2')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                MrdNo: MrdNo,
                VisitNo: VisitNo,
                VisitDate: VisitDate
            },
            beforeSend: function() {
                //$('#copybutton2').attr('disabled', 'disabled');
                $('#copybutton2').text('Please Wait...');
            },
            success: function(data) {
                //alert("Record Copied");
                //     $('#pastebutton2').attr('disabled', false);
                //    $('#pastebutton2').text('Paste');
                //     $('#copybutton2').attr("disabled",true);
                $('#copybutton2').text('Copy');
            }
        });
    }

    function paste2() {
        $.ajax({
            url: "<?php echo e(url('pasteRecord2')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>'
            },
            beforeSend: function() {
                // $('#pastebutton2').attr('disabled', 'disabled');
                $('#pastebutton2').text('Please Wait...');
            },
            success: function(data) {
                //console.log(data);
                var res = JSON.parse(data);
                var result = res.result;
                var result2 = res.result2;
                var result3 = res.result3; //for opto
                 $('#TypePatient').val(result.BeOcMov);
                $('#ReOcMov').val(result.ReOcMov);
                $('#LeOcMov').val(result.LeOcMov);
                $('#OrbitalRe').val(result.OrbitalRe);
                $('#OrbitalLe').val(result.OrbitalLe);
                $('#ReLids').val(result.ReLids);
                $('#LeLids').val(result.LeLids);
                $('#ReConj').val(result.ReConj);
                $('#LeConj').val(result.LeConj);
                $('#ReCornea').val(result.ReCornea);
                $('#LeCornea').val(result.LeCornea);
                $('#ReCorneaRemark').val(result.ReCorneaRemark);
                $('#LeCorneaRemark').val(result.LeCorneaRemark);
                $('#ReAntChamber').val(result.ReAntChamber);
                $('#LeAntChamber').val(result.LeAntChamber);
                $('#ReIris').val(result.ReIris);
                $('#LeIris').val(result.LeIris);
                $('#RePupil').val(result.RePupil);
                $('#LePupil').val(result.LePupil);
                $('#ReLens').val(result.ReLens);
                $('#LeLens').val(result.LeLens);
                $('#ReLens2').val(result.ReLens2);
                $('#LeLens2').val(result.LeLens2);
                $('#ReNlp').val(result.ReNlp);
                $('#LeNlp').val(result.LeNlp);
                $('#CouncRemark').val(result.CouncRemark);
                $('#ReMedia').val(result.ReMedia);
                $('#LeMedia').val(result.LeMedia);
                $('#ReOptDisc').val(result.ReOptDisc);
                $('#LeOptDisc').val(result.LeOptDisc);
                $('#FundusRemark').val(result.FundusRemark);
                $("input[name='AlRe']").val(result.AlRe);
                $("input[name='AlLe']").val(result.AlLe);
                $("input[name='WtwRe']").val(result.WtwRe);
                $("input[name='WtwLe']").val(result.WtwLe);
                $("input[name='IOL1']").val(result.IOL1);
                $("input[name='IOL2']").val(result.IOL2);
                $("input[name='IOL4']").val(result.IOL4);
                $("input[name='IOL3']").val(result.IOL3);
                $("input[name='IOL5']").val(result.IOL5);
                $("input[name='IOL6']").val(result.IOL6);
                $("#Diagnosis").val(result.Diagnosis);
                $("#Advice").val(result.Advice);
                $("#Remark").val(result.Remark);
                $("#ReferTo").val(result.ReferTo);
                $('#InvStName').val(result.InvStName);
                $("#BP").val(result.BP);
                //$('#ReferTo').val(result.ReferTo);
                $('#RefBy').val(result3.RefBy);
                $('#CouncRemark').val(result.CouncRemark);

                $("#Treatment").val(result2.Treatment);
                if (result2.TreatChk1 == 1) {
                    $("#TreatChk1").val(1).attr('checked', true);
                } else {
                    $("#TreatChk1").val(0).attr('checked', false);
                }
                $("#TreatName1").val(result2.TreatName1);
                $("#TreatType1").val(result2.TreatType1).attr('selected', true);
                $("#TreatDose1").val(result2.TreatDose1).attr('selected', true);
                $("#TreatFreq1").val(result2.TreatFreq1).attr('selected', true);
                $("#TreatDur1").val(result2.TreatDur1).attr('selected', true);
                $("#TreatEye1").val(result2.TreatEye1).attr('selected', true);

                if (result2.TreatChk2 == 1) {
                    $("#TreatChk2").val(1).attr('checked', true);
                } else {
                    $("#TreatChk2").val(0).attr('checked', false);
                }
                $("#TreatName2").val(result2.TreatName2);
                $("#TreatType2").val(result2.TreatType2).attr('selected', true);
                $("#TreatDose2").val(result2.TreatDose2).attr('selected', true);
                $("#TreatFreq2").val(result2.TreatFreq2).attr('selected', true);
                $("#TreatDur2").val(result2.TreatDur2).attr('selected', true);
                $("#TreatEye2").val(result2.TreatEye2).attr('selected', true);

                if (result2.TreatChk3 == 1) {
                    $("#TreatChk3").val(1).attr('checked', true);
                } else {
                    $("#TreatChk3").val(0).attr('checked', false);
                }
                $("#TreatName3").val(result2.TreatName3);
                $("#TreatType3").val(result2.TreatType3).attr('selected', true);
                $("#TreatDose3").val(result2.TreatDose3).attr('selected', true);
                $("#TreatFreq3").val(result2.TreatFreq3).attr('selected', true);
                $("#TreatDur3").val(result2.TreatDur3).attr('selected', true);
                $("#TreatEye3").val(result2.TreatEye3).attr('selected', true);

                if (result2.TreatChk4 == 1) {
                    $("#TreatChk4").val(1).attr('checked', true);
                } else {
                    $("#TreatChk4").val(0).attr('checked', false);
                }
                $("#TreatName4").val(result2.TreatName4);
                $("#TreatType4").val(result2.TreatType4).attr('selected', true);
                $("#TreatDose4").val(result2.TreatDose4).attr('selected', true);
                $("#TreatFreq4").val(result2.TreatFreq4).attr('selected', true);
                $("#TreatDur4").val(result2.TreatDur4).attr('selected', true);
                $("#TreatEye4").val(result2.TreatEye4).attr('selected', true);

                if (result2.TreatChk5 == 1) {
                    $("#TreatChk5").val(1).attr('checked', true);
                } else {
                    $("#TreatChk5").val(0).attr('checked', false);
                }
                $("#TreatName5").val(result2.TreatName5);
                $("#TreatType5").val(result2.TreatType5).attr('selected', true);
                $("#TreatDose5").val(result2.TreatDose5).attr('selected', true);
                $("#TreatFreq5").val(result2.TreatFreq5).attr('selected', true);
                $("#TreatDur5").val(result2.TreatDur5).attr('selected', true);
                $("#TreatEye5").val(result2.TreatEye5).attr('selected', true);

                if (result2.TreatChk6 == 1) {
                    $("#TreatChk6").val(1).attr('checked', true);
                } else {
                    $("#TreatChk6").val(0).attr('checked', false);
                }
                $("#TreatName6").val(result2.TreatName6);
                $("#TreatType6").val(result2.TreatType6).attr('selected', true);
                $("#TreatDose6").val(result2.TreatDose6).attr('selected', true);
                $("#TreatFreq6").val(result2.TreatFreq6).attr('selected', true);
                $("#TreatDur6").val(result2.TreatDur6).attr('selected', true);
                $("#TreatEye6").val(result2.TreatEye6).attr('selected', true);

                if (result2.TreatChk7 == 1) {
                    $("#TreatChk7").val(1).attr('checked', true);
                } else {
                    $("#TreatChk7").val(0).attr('checked', false);
                }
                $("#TreatName7").val(result2.TreatName7);
                $("#TreatType7").val(result2.TreatType7).attr('selected', true);
                $("#TreatDose7").val(result2.TreatDose7).attr('selected', true);
                $("#TreatFreq7").val(result2.TreatFreq7).attr('selected', true);
                $("#TreatDur7").val(result2.TreatDur7).attr('selected', true);
                $("#TreatEye7").val(result2.TreatEye7).attr('selected', true);

                if (result2.TreatChk8 == 1) {
                    $("#TreatChk8").val(1).attr('checked', true);
                } else {
                    $("#TreatChk8").val(0).attr('checked', false);
                }
                $("#TreatName8").val(result2.TreatName8);
                $("#TreatType8").val(result2.TreatType8).attr('selected', true);
                $("#TreatDose8").val(result2.TreatDose8).attr('selected', true);
                $("#TreatFreq8").val(result2.TreatFreq8).attr('selected', true);
                $("#TreatDur8").val(result2.TreatDur8).attr('selected', true);
                $("#TreatEye8").val(result2.TreatEye8).attr('selected', true);

                if (result2.TreatChk9 == 1) {
                    $("#TreatChk9").val(1).attr('checked', true);
                } else {
                    $("#TreatChk9").val(0).attr('checked', false);
                }
                $("#TreatName9").val(result2.TreatName9);
                $("#TreatType9").val(result2.TreatType9).attr('selected', true);
                $("#TreatDose9").val(result2.TreatDose9).attr('selected', true);
                $("#TreatFreq9").val(result2.TreatFreq9).attr('selected', true);
                $("#TreatDur9").val(result2.TreatDur9).attr('selected', true);
                $("#TreatEye9").val(result2.TreatEye9).attr('selected', true);

                if (result2.TreatChk10 == 1) {
                    $("#TreatChk10").val(1).attr('checked', true);
                } else {
                    $("#TreatChk10").val(0).attr('checked', false);
                }
                $("#TreatName10").val(result2.TreatName10);
                $("#TreatType10").val(result2.TreatType10).attr('selected', true);
                $("#TreatDose10").val(result2.TreatDose10).attr('selected', true);
                $("#TreatFreq10").val(result2.TreatFreq10).attr('selected', true);
                $("#TreatDur10").val(result2.TreatDur10).attr('selected', true);
                $("#TreatEye10").val(result2.TreatEye10).attr('selected', true);

                //    $('#pastebutton2').attr('disabled', true);
                $('#pastebutton2').text('Paste');
                //alert("Record Pasted Successfully!");
                //window.location.href = "/<?php echo e(projectUrl()); ?>optoform/" + MrdNo + "/" + VisitDate + "/" + VisitNo + "?page=consult";
            }
        });
    }

    function patientCheck(mrdno, visitno) {
        $('#cover-spin').show(0);
        $.ajax({
            url: "<?php echo e(url('patientCheck')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                mrdno: mrdno,
                visitno: visitno
            },
            success: function(data) {
                $('#cover-spin').hide(0);
                //console.log(data);
                window.close();
                //window.location.href="/<?php echo e(projectUrl()); ?>queuemanagement";
                window.opener.location.reload(true);

            }
        });
    }

    function viewSummary(mrdno) {
        setTimeout(function() {
            window.open(
                '/<?php echo e(projectUrl()); ?>opdSummary/' + mrdno, 'popUpWindow2',
                'height=1000,width=1500,left=0,top=0,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
            );
            // window.open(
            //     '/<?php echo e(projectUrl()); ?>ptsummary.html', 'popUpWindow2',
            //     'height=1000,width=1500,left=0,top=0,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
            // );
        }, 1);
    }

    function opdDetailPrint(mrdno, visitno) {
        setTimeout(function() {
            window.open(
                '/<?php echo e(projectUrl()); ?>opdDetailPrint/' + mrdno + '/' + visitno, 'popUpWindow3',
                'height=1000,width=1000,left=0,top=0,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
            );
        }, 1);
    }

    function getConsultRec(val, visitno) {
        var MrdNo = $('#MrdNo').val();
        var page = $('#pageval').val();
        //alert(page);exit();
        $.ajax({
            url: "<?php echo e(url('getVisitNoDate')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                val: val
            },
            success: function(data) {
                var res = JSON.parse(data);
                var VisitDate = res.VisitDate;
                var VisionNo = res.VisionNo;
                //alert(VisitDate);alert(VisionNo);exit();

                window.location.href = "/<?php echo e(projectUrl()); ?>optoform/" + MrdNo + "/" + VisitDate + "/" +
                    VisionNo + "?page=" + page;
            }
        });
        //window.location.href = "/<?php echo e(projectUrl()); ?>optoform/" + MrdNo + "/" + val + "/" + visitno + "?page=tab1";
    }

    function chkre_normal() {
        if ($('#ChkReNormal').prop('checked') == true) {
            $('#ChkReNormal').val(1);
            $('#ReOcMov').val('Normal');
            $('#ReLids').val('Normal');
            $('#ReConj').val('Normal');
            $('#ReCornea').val('Bright and Clear');
            $('#ReAntChamber').val('Normal');
            $('#ReIris').val('Colour and Pattern Normal');
            $('#RePupil').val('NSRL');
            $('#ReLens').val('Normal');
            $('#ReNlp').val('WNL');
            if ($('#ChkBeNormal').prop('checked') == true) {
                $('#LeOcMov').val('Normal');
                $('#LeLids').val('Normal');
                $('#LeConj').val('Normal');
                $('#LeCornea').val('Bright and Clear');
                $('#LeAntChamber').val('Normal');
                $('#LeIris').val('Colour and Pattern Normal');
                $('#LePupil').val('NSRL');
                $('#LeLens').val('Normal');
                $('#LeNlp').val('WNL');

            }
        } else {
            $('#ChkReNormal').val(0);
            $('#ReOcMov').val('');
            $('#ReLids').val('');
            $('#ReConj').val('');
            $('#ReCornea').val('');
            $('#ReAntChamber').val('');
            $('#ReIris').val('');
            $('#RePupil').val('');
            $('#ReLens').val('');
            $('#ReNlp').val('');
        }
    }

    function chkle_normal() {
        if ($('#ChkLeNormal').prop('checked') == true) {
            $('#ChkLeNormal').val(1);
            $('#LeOcMov').val('Normal');
            $('#LeLids').val('Normal');
            $('#LeConj').val('Normal');
            $('#LeCornea').val('Bright and Clear');
            $('#LeAntChamber').val('Normal');
            $('#LeIris').val('Colour and Pattern Normal');
            $('#LePupil').val('NSRL');
            $('#LeLens').val('Normal');
            $('#LeNlp').val('WNL');
        } else {
            $('#ChkLeNormal').val(0);
            $('#LeOcMov').val('');
            $('#LeLids').val('');
            $('#LeConj').val('');
            $('#LeCornea').val('');
            $('#LeAntChamber').val('');
            $('#LeIris').val('');
            $('#LePupil').val('');
            $('#LeLens').val('');
            $('#LeNlp').val('');
        }
    }

    function chkle_fundus() {
        if ($('#ChkLeFundus').prop('checked') == true) {
            $('#ChkLeFundus').val(1);
            $('#LeMedia').val('Hazy');
            $('#LeOptDisc').val('Details not seen');
            $('#LeMacBV').val('Details not seen');
            $('#LeBv').val('Details not seen');
            $('#LeMidPerPh').val('Details not Seen');
        } else {
            $('#ChkLeFundus').val(0);
            $('#LeMedia').val('Clear');
            $('#LeOptDisc').val('Normal');
            $('#LeMacBV').val('Foveal reflex healthy');
            $('#LeBv').val('Blood Vessels are normal');
            $('#LeMidPerPh').val('Details not Seen');
        }
    }

    function chkre_fundus() {
        if ($('#ChkReFundus').prop('checked') == true) {
            $('#ChkReFundus').val(1);
            $('#ReMedia').val('Hazy');
            $('#ReOptDisc').val('Details not seen');
            $('#ReMacBV').val('Details not seen');
            $('#ReBv').val('Details not seen');
            $('#ReMidPerPh').val('Details not seen');
        } else {
            $('#ChkReFundus').val(0);
            $('#ReMedia').val('Clear');
            $('#ReOptDisc').val('Normal');
            $('#ReMacBV').val('Foveal reflex healthy');
            $('#ReBv').val('Blood Vessels are normal');
            $('#ReMidPerPh').val('Details not Seen');
        }
    }
    // function chkbe_normal(){
    //     if ($('#ChkBeNormal').prop('checked') == true) {
    //     $('#ChkReNormal').val(1);
    //         $('#ReOcMov').val('Normal');
    //         $('#ReLids').val('Flat');
    //         $('#ReConj').val('Normal');
    //         $('#ReCornea').val('Bright and Clear');
    //         $('#ReAntChamber').val('Normal Depth');
    //         $('#ReIris').val('Colour and Pattern Normal');
    //         $('#RePupil').val('NSRL');
    //         $('#ReLens').val('Transparent');
    //         $('#ReNlp').val('No Regurgitation');

    //         $('#ChkLeNormal').val(1);
    //         $('#LeOcMov').val('Normal');
    //         $('#LeLids').val('Flat');
    //         $('#LeConj').val('Normal');
    //         $('#LeCornea').val('Bright and Clear');
    //         $('#LeAntChamber').val('Normal Depth');
    //         $('#LeIris').val('Colour and Pattern Normal');
    //         $('#LePupil').val('NSRL');
    //         $('#LeLens').val('Transparent');
    //         $('#LeNlp').val('No Regurgitation');
    //     }
    // }

    function copyValueLe(reval, leval) {
        if ($('#ChkBeNormal').prop('checked') == true) {
            var rightval = $('#' + reval).val();
            $('#' + leval).val(rightval);
        }
    }



    function getValue(val, idval) {
        $('#ModalValue').val(val);
        $('#ValueId').val(idval);
        $('#OldValue').val('');
        $('#search_text77').val('');
        $('#Ref_By').focus();
        desc_lists(val);
        $('.modal-title').html("Add <span class='font-weight-light'>New</span>");
    }

    function getValue2(val, idval) {
        $('#ModalValue2').val(val);
        $('#ValueId2').val(idval);
        $('#OldValue2').val('');
        $('#search_text772').val('');
        desc_lists2(val);
        $('.modal-title').html("Add <span class='font-weight-light'>New</span>");
    }

    function getAppDate2() {
        var Review = $('#Review').val();
        getAppDate(Review);
    }

    function getAppDate(val) {
        var CurrDate = $('#CurrDate').val();
        var ReviewDay = $('#ReviewDay').val();
        $.ajax({
            url: "<?php echo e(url('getAppDate')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                val: val,
                ReviewDay: ReviewDay
            },
            success: function(data) {
                //console.log(data);
                var res = JSON.parse(data);
                var dayname = res.dayname;
                var date = res.date;
                if (dayname == 'Sun') {
                    $('#sundayerrormsg').show();
                    $('#alldaymsg').html('');
                } else {
                    $('#sundayerrormsg').hide();
                    $('#alldaymsg').html(dayname);
                }
                $('#AppointDate').val(date);
            }
        });
    }

    function getTreatmentList(){
        var query = $('#Treatment').val();
        //$('#Diagnosis').val(query);
            var len = query.length;
            if(len > 0){
            if (query != '') {
                $.ajax({
                    url: "<?php echo e(url('fetchData')); ?>",
                    method: "POST",
                    data: {
                        query: query,
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    success: function(data) {
                        //console.log(data);
                        $('#TreatmentList').fadeIn();
                        $('#TreatmentList').html(data);
                    }
                });
            }
        }
        else{
            $('#TreatmentList').fadeOut();
            getRecords(query);
        }
        
    }

    function getRecords(val) {
        //$('#Diagnosis').val(val);
       
        var MrdNo = $('#MrdNo').val();
        var VisitDate = $('#VisitDate').val();
        var VisitNo = $('#VisitNo').val();
        var OldValue = $('#Diagnosis').val();
        var OldValue2 = $('#Advice').val();
        //alert(OldValue2);
        $.ajax({
            url: "<?php echo e(url('getTreatments')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                Treatment: val,
                MrdNo:MrdNo,
                VisitDate:VisitDate,
                VisitNo:VisitNo
            },
            success: function(data) {
                console.log(data);
                $('#showTreatments').html(data.html);
                 $('#Treatment').val(val);
         $('#TreatmentList').fadeOut();
        //  $('#Diagnosis').val(val);
        //     $('#Advice').val(data.advice);
            if(val==""){
            $('#Diagnosis').val(OldValue);
            $('#Advice').val(OldValue2);
            }
            else{
                if(OldValue==''){
                    var ConcatValue = val;
                }
                else{
                    var ConcatValue =  OldValue+", "+val;
                }
                $('#Diagnosis').val(ConcatValue); 

                if(OldValue2==''){
                   // alert(data.advice);
                    // $('#CmbPlanOfMang').val(val).attr("selected",true);
                    // getSpecInstDetails(val, 'Advice');
                     $('#Advice').val(data.advice);
                    //var ConcatValue2 = OldValue2;
                }
                else{
                    var ConcatValue2 =  OldValue2+"\n"+data.advice;
                    $('#Advice').val(ConcatValue2);
                }
                
                
            }
            }
        });
    }

    function getsaveprintval(val, btnval) {
        $('#saveprintval').val(val);
        $('#savebtnval').val(btnval);
    }

    function checkPreviousDetails(mrdno){
        if(confirm("Do you want to print previous record?"))  
           { 
            printDetailPrint(mrdno);
           }
           
    }

    function checkPreviousBrief(mrdno){
        if(confirm("Do you want to print previous record?"))  
           { 
            printBriefPrint(mrdno);
           }
           
    }
    
    function printDetailPrint(mrdno) {
        var visitno = $('#VisitNo').val();
        var visitdate = $('#VisitDate').val();
        setTimeout(function() {
            window.open('/<?php echo e(projectUrl()); ?>opdDetailPrint/' + mrdno +
                '/' + visitno + '/' + visitdate, 'popUpWindow3',
                'height=1000,width=1000,left=0,top=0,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
            );
        }, 1);
    }

    function printBriefPrint(mrdno) {
        var visitno = $('#VisitNo').val();
        var visitdate = $('#VisitDate').val();
        setTimeout(function() {
            window.open(
                '/<?php echo e(projectUrl()); ?>opdShortDetailPrint/' +
                mrdno + '/' + visitno + '/' + visitdate,
                'popUpWindow3',
                'height=1000,width=1000,left=0,top=0,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
            );
        }, 1);
    }
    $(document).ready(function() {

        //  $('#ChkReNormal').prop('checked',true);
        //  $('#ChkLeNormal').prop('checked',true);
        //  chkre_normal();
        //  chkle_normal();

        //  $('#ChkReFundus').prop('checked',true);
        //  $('#ChkLeFundus').prop('checked',true);
        //  chkre_fundus();
        //  chkle_fundus();

        $(document).on("shown.bs.modal", "#modal-report", function() {
            $('#search_text77').focus();
        });

        $(document).on("shown.bs.modal", "#modal-report22", function() {
            $('#search_text772').focus();
        });

        $(document).on("click", ".updatespecinst", function(event) {
            event.preventDefault();
            event.stopPropagation();
            var id = $(this).attr("data-id");
            var action = "fetch_record";
            $.ajax({
                url: "<?php echo e(url('editSpecInst')); ?>",
                method: "POST",
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    id: id
                },
                dataType: "json",
                success: function(data) {
                    //console.log(data);
                    $('#SpecInstName').val(data.Name);
                    $('#SpecInstType').val(data.Type).attr("selected", true);
                    $('#SpecInstDetails').val(data.Details)
                    $('#specinstaction').val('Edit');

                    $('#specinstid').val(id);
                    $('#specinstbtn').text("Update");
                    $('#modal-report-inst').modal('show');
                    $('.modal-title').html(
                        "Update <span class='font-weight-light'>Record</span>");

                }
            });
        });



        $(document).on("click", ".deletespecinst", function(event) {
            event.preventDefault();
            var id = $(this).attr("data-id");
            var action = "delete";
            var idval = $('#specinstcmbid').val();
            var type = $('#SpecInstType').val();
            //alert(id);
            swal({
                title: "Are you sure?",
                text: "You will not be able to recover this Record!",
                type: "warning",
                showCancelButton: true,
                confirmButtonClass: "btn-danger",
                confirmButtonText: "Yes, delete",
                cancelButtonText: "No, cancel",
                closeOnConfirm: false,
                closeOnCancel: false
            }, function(isConfirm) {
                if (isConfirm) {
                    $.ajax({
                        url: "<?php echo e(url('deleteSpecInst')); ?>",
                        method: "POST",
                        data: {
                            _token: '<?php echo e(csrf_token()); ?>',
                            id: id
                        },

                        success: function(data) {
                            swal("Deleted!", "Record has been deleted.", "success");

                            addNewSpecInst(idval, type);
                            specInst_List();

                        }
                    });

                } else {
                    swal("Cancelled", "Record is safe :)", "error");
                }
            });


        });

        $(document).on("click", ".updatedrug", function(event) {
            event.preventDefault();
            event.stopPropagation();
            var id = $(this).attr("data-id");
            var action = "fetch_record";
            $.ajax({
                url: "<?php echo e(url('editDrug')); ?>",
                method: "POST",
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    id: id
                },
                dataType: "json",
                success: function(data) {
                    $('#DrugName').val(data.Name);
                    $('#DrugType').val(data.Type).attr("selected", true);
                    $('#DrugDose').val(data.Dose).attr("selected", true);
                    $('#DrugFreq').val(data.Freq).attr("selected", true);
                    $('#drugaction').val('Edit');

                    $('#drugid').val(id);
                    $('#drugbtn').text("Update");
                    $('#modal-report656').modal('show');
                    $('.modal-title').html(
                        "Update <span class='font-weight-light'>Drug</span>");

                }
            });
        });



        $(document).on("click", ".deletedrug", function(event) {
            event.preventDefault();
            var id = $(this).attr("data-id");
            var action = "delete";
            //alert(id);
            swal({
                title: "Are you sure?",
                text: "You will not be able to recover this Drug!",
                type: "warning",
                showCancelButton: true,
                confirmButtonClass: "btn-danger",
                confirmButtonText: "Yes, delete",
                cancelButtonText: "No, cancel",
                closeOnConfirm: false,
                closeOnCancel: false
            }, function(isConfirm) {
                if (isConfirm) {
                    $.ajax({
                        url: "<?php echo e(url('deleteDrug')); ?>",
                        method: "POST",
                        data: {
                            _token: '<?php echo e(csrf_token()); ?>',
                            id: id
                        },

                        success: function(data) {
                            swal("Deleted!", "Drug has been deleted.", "success");

                            procedure_lists();

                        }
                    });

                } else {
                    swal("Cancelled", "Drug is safe :)", "error");
                }
            });


        });
        // $(document).on("input", "#Treatment", function(event) {
        //     var val = $(this).val();
        //     getRecords(val);
        // });


        $(document).on("click", ".updatespclinic", function(event) {
            event.preventDefault();
            event.stopPropagation();
            var id = $(this).attr("data-id");
            var action = "fetch_record";
            $.ajax({
                url: "<?php echo e(url('editSpecialityClinic')); ?>",
                method: "POST",
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    id: id
                },
                dataType: "json",
                success: function(data) {
                    $('#SpClinicName').val(data.ClinicName);
                    $('#SpName').val(data.Name);
                    $('#Spaction').val('Edit');

                    $('#Spid').val(id);
                    $('#specclinicbtn').text("Update");
                    $('#modal-report-spec').modal('show');
                    $('#specclinictitle').html(
            "Update <span class='font-weight-light'>Specility Clinic</span>");
           

                }
            });
        });



        $(document).on("click", ".deletespclinic", function(event) {
            event.preventDefault();
            var id = $(this).attr("data-id");
            var action = "delete";
            //alert(id);
            swal({
                title: "Are you sure?",
                text: "You will not be able to recover this Record!",
                type: "warning",
                showCancelButton: true,
                confirmButtonClass: "btn-danger",
                confirmButtonText: "Yes, delete",
                cancelButtonText: "No, cancel",
                closeOnConfirm: false,
                closeOnCancel: false
            }, function(isConfirm) {
                if (isConfirm) {
                    $.ajax({
                        url: "<?php echo e(url('deleteSpecialityClinic')); ?>",
                        method: "POST",
                        data: {
                            _token: '<?php echo e(csrf_token()); ?>',
                            id: id
                        },

                        success: function(data) {
                            swal("Deleted!", "Speciality Clinic has been deleted.", "success");

                            spec_clinic_lists();
                   

                        }
                    });

                } else {
                    swal("Cancelled", "Speciality Clinic is safe :)", "error");
                }
            });


        });


        $('#validation-form55').on('submit', function(e) {
            e.preventDefault();
            var saveprintval = $('#saveprintval').val();
            var savebtnval = $('#savebtnval').val();
            if (saveprintval == 2) {
                var btnname = "Detail Print";
            } else if (saveprintval == 3) {
                var btnname = "Brief Print";
            } else {
                var btnname = "Save";
            }
            $.ajax({
                url: "<?php echo e(url('saveConsultant')); ?>",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                processData: false,
                beforeSend: function() {
                    $('#' + savebtnval).attr('disabled', 'disabled');
                    $('#' + savebtnval).text('Please Wait...');
                },
                success: function(data) {
                    //console.log(data);
                    var res = JSON.parse(data);
                    var mrdno = res.mrdno;
                    var visitno = res.visitno;
                    var visitdate = res.visitdate;
                    success_toast();
                    $('#' + savebtnval).attr('disabled', false);
                    $('#' + savebtnval).text(btnname);
                    if (saveprintval == 2) {
                        setTimeout(function() {
                            window.open(
                                '/<?php echo e(projectUrl()); ?>opdDetailPrint/' + mrdno +
                                '/' + visitno + '/' + visitdate, 'popUpWindow3',
                                'height=1000,width=1000,left=0,top=0,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
                            );
                        }, 1);
                    }

                    if (saveprintval == 3) {
                        setTimeout(function() {
                            window.open(
                                '/<?php echo e(projectUrl()); ?>opdShortDetailPrint/' +
                                mrdno + '/' + visitno + '/' + visitdate,
                                'popUpWindow3',
                                'height=1000,width=1000,left=0,top=0,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
                            );
                        }, 1);
                    }
                }
            });

        });

        $('#validation-form66').on('submit', function(e) {
            e.preventDefault();
            var saveprintval = $('#saveprintval').val();
            var savebtnval = $('#savebtnval').val();
            if (saveprintval == 2) {
                var btnname = "Detail Print";
            } else if (saveprintval == 3) {
                var btnname = "Brief Print";
            } else {
                var btnname = "Save";
            }
                $.ajax({
                    url: "<?php echo e(url('saveOpto')); ?>",
                    method: "POST",
                    data: new FormData(this),
                    contentType: false,
                    processData: false,
                    beforeSend: function() {
                    $('#' + savebtnval).attr('disabled', 'disabled');
                    $('#' + savebtnval).text('Please Wait...');
                },
                success: function(data) {
                    //console.log(data);
                    var res = JSON.parse(data);
                    var mrdno = res.mrdno;
                    var visitno = res.visitno;
                    var visitdate = res.visitdate;
                    success_toast();
                    $('#' + savebtnval).attr('disabled', false);
                    $('#' + savebtnval).text(btnname);
                    if (saveprintval == 2) {
                        setTimeout(function() {
                            window.open(
                                '/<?php echo e(projectUrl()); ?>opdDetailPrint/' + mrdno +
                                '/' + visitno + '/' + visitdate, 'popUpWindow3',
                                'height=1000,width=1000,left=0,top=0,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
                            );
                        }, 1);
                    }

                    if (saveprintval == 3) {
                        setTimeout(function() {
                            window.open(
                                '/<?php echo e(projectUrl()); ?>opdShortDetailPrint/' +
                                mrdno + '/' + visitno + '/' + visitdate,
                                'popUpWindow3',
                                'height=1000,width=1000,left=0,top=0,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
                            );
                        }, 1);
                    }
                }
            });
            

        });



        $('#add-drugs').click(function() {
            $('#DrugType').val('').attr("selected", true);
            $('#DrugName').val('');
            $('#DrugDose').val('').attr("selected", true);
            $('#DrugFreq').val('').attr("selected", true);
        });
    });

    function error_toast() {
        var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
        $.growl.error({
            title: 'Error',
            message: 'Please Select Optometric!',
            location: isRtl ? 'tl' : 'tr'
        });
    }
    function get_drug_name(srno){
        var query = $('#TreatName'+srno).val();
        var TreatType = $('#TreatType'+srno).val();
            var len = query.length;
            if(len > 0){
            if (query != '') {
                $.ajax({
                    url: "<?php echo e(url('fetchData2')); ?>",
                    method: "POST",
                    data: {
                        query: query,
                        _token: '<?php echo e(csrf_token()); ?>',
                        srno:srno,
                        TreatType:TreatType
                    },
                    success: function(data) {
                        //console.log(data);
                        $('#DrugLists'+srno).fadeIn();
                        $('#DrugLists'+srno).html(data);
                    }
                });
            }
        }
        else{
            $('#DrugLists'+srno).fadeOut();
        }
        
    }

    function selectliValue(Name,srno){
        $('#TreatName'+srno).val(Name);
        $('#DrugLists'+srno).fadeOut();
    }
    </script>
</body>

</html><?php /**PATH /home/gssnagpu/public_html/hospsoft.in/siddhivinaynetra/resources/views/opd/editoptoform.blade.php ENDPATH**/ ?>