<?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<style>
fieldset {
    border: 1px solid #3b6fa5;
    border-radius: 5px;
    padding: 10px;
    margin-bottom: 10px;
    position: relative;
    background: #f5f8fc;
}
fieldset legend {
    position: absolute;
    top: -12px;
    left: 15px;
    background: #f5f8fc;
    padding: 0 8px;
    font-size: 14px;
    color: #1d4b7f;
}
.form-control {
    height: 28px;
    font-size: 13px;
}
textarea.form-control {
    height: auto;
}
.btn {
    min-width: 80px;
}
</style>

<div class="container-fluid mt-2">

<form id="ipdForm" method="POST">
<?php echo csrf_field(); ?>
<input type="hidden" name="MrdNo" id="MrdNo">
<input type="hidden" name="actionvalue" id="actionvalue" value="Save">
<input type="hidden" name="saveid" id="saveid" value="">

<!-- ================= OPD DETAILS ================= -->
<fieldset>
    <legend>OPD Details</legend>
    <div class="row">
        <div class="col-md-2">
            <label>UHID No.</label>
            <input type="text" class="form-control" id="UhidNo" name="UhidNo">
        </div>
        <div class="col-md-4">
            <label>Name</label>
            <input type="text" class="form-control" id="PatientName" name="PatientName">
        </div>
        <div class="col-md-2">
            <label>Age</label>
            <input type="text" class="form-control" id="Age" name="Age">
        </div>
        <div class="col-md-2">
            <label>Gender</label>
            <select class="form-control" id="Gender" name="Gender">
                <option value="">Select</option>
                <option>Male</option>
                <option>Female</option>
            </select>
        </div>
        <div class="col-md-2">
            <label>Weight</label>
            <input type="text" class="form-control" name="Weight">
        </div>
        <div class="col-md-2 mt-1">
            <label>Temp</label>
            <input type="text" class="form-control" name="Temp">
        </div>
        <div class="col-md-2 mt-1">
            <label>Height</label>
            <input type="text" class="form-control" name="Height">
        </div>
    </div>
</fieldset>

<!-- ================= IPD INFO ================= -->
<fieldset>
    <legend>IPD Info</legend>
    <div class="row">
        <div class="col-md-2">
            <label>IPD No.</label>
            <input type="text" class="form-control" id="IpdNo" name="IpdNo" readonly>
        </div>
        <div class="col-md-2">
            <label>Date Of Adm.</label>
            <input type="date" class="form-control" name="AdmissionDate">
        </div>
        <div class="col-md-2">
            <label>Time</label>
            <input type="time" class="form-control" name="AdmissionTime">
        </div>
        <div class="col-md-2">
            <label>Blood Group</label>
            <select class="form-control" name="BloodGroup">
                <option>A+</option><option>B+</option><option>O+</option>
            </select>
        </div>
        <div class="col-md-2">
            <label>Type</label>
            <select class="form-control" name="PatientType">
                <option>General</option>
                <option>Private</option>
            </select>
        </div>

        <div class="col-md-3 mt-1">
            <label>Aadhar Card</label>
            <input type="text" class="form-control" name="AadharNo">
        </div>
        <div class="col-md-3 mt-1">
            <label>Ward *</label>
            <select class="form-control" name="Ward">
                <option>Ward A</option>
                <option>Ward B</option>
            </select>
        </div>
        <div class="col-md-2 mt-1">
            <label>Bed No.</label>
            <input type="text" class="form-control" name="BedNo">
        </div>

        <div class="col-md-2 mt-1">
            <label>Wt. On Adm.</label>
            <input type="text" class="form-control" name="WtOnAdm">
        </div>
        <div class="col-md-2 mt-1">
            <label>Ht. On Adm.</label>
            <input type="text" class="form-control" name="HtOnAdm">
        </div>
        <div class="col-md-2 mt-1">
            <label>Tmp. On Adm.</label>
            <input type="text" class="form-control" name="TempOnAdm">
        </div>
    </div>
</fieldset>

<!-- ================= RELATIVE DETAILS ================= -->
<fieldset>
    <legend>Relative Details</legend>
    <div class="row">
        <div class="col-md-6">
            <label>Name of Relative / Father *</label>
            <input type="text" class="form-control" name="RelativeName">
        </div>
        <div class="col-md-6">
            <label>Name of Relative 2</label>
            <input type="text" class="form-control" name="RelativeName2">
        </div>
        <div class="col-md-6 mt-1">
            <label>Address *</label>
            <textarea class="form-control" rows="2" name="RelativeAddress"></textarea>
        </div>
        <div class="col-md-6 mt-1">
            <label>Occupation</label>
            <input type="text" class="form-control" name="Occupation">
        </div>
        <div class="col-md-3 mt-1">
            <label>Mob. No.1 *</label>
            <input type="text" class="form-control" name="Mobile1">
        </div>
        <div class="col-md-3 mt-1">
            <label>Mob. No.2</label>
            <input type="text" class="form-control" name="Mobile2">
        </div>
    </div>
</fieldset>

<!-- ================= DIAGNOSIS ================= -->
<fieldset>
    <legend>Diagnosis</legend>
    <div class="row">
        <div class="col-md-6">
            <label>Provisional Diagnosis</label>
            <textarea class="form-control" rows="3" name="ProvisionalDiagnosis"></textarea>
        </div>
        <div class="col-md-6">
            <label>Final Diagnosis</label>
            <textarea class="form-control" rows="3" name="FinalDiagnosis"></textarea>
        </div>
        <div class="col-md-4 mt-1">
            <label>Discharge Status</label>
            <select class="form-control" name="DischargeStatus">
                <option>Recovered</option>
                <option>Referred</option>
            </select>
        </div>
        <div class="col-md-4 mt-1">
            <label>Referred By</label>
            <input type="text" class="form-control" name="ReferredBy">
        </div>
        <div class="col-md-4 mt-1">
            <label>Consultant</label>
            <input type="text" class="form-control" name="Consultant">
        </div>
    </div>
</fieldset>

<!-- ================= OTHER INFO ================= -->
<fieldset>
    <legend>Other Info</legend>
    <div class="row">
        <div class="col-md-4">
            <label>Type Of Admission</label>
            <select class="form-control" name="AdmissionType">
                <option>Emergency</option>
                <option>Planned</option>
            </select>
        </div>
        <div class="col-md-4">
            <label>Indication For Admission</label>
            <textarea class="form-control" rows="2" name="Indication"></textarea>
        </div>
        <div class="col-md-4">
            <label>Admission For</label>
            <select class="form-control" name="AdmissionFor">
                <option>Medical</option>
                <option>Surgical</option>
            </select>
        </div>
    </div>
</fieldset>

<!-- ================= BUTTONS ================= -->
<div class="text-center mt-3">
    <button class="btn btn-primary" type="submit">Save</button>
    <button class="btn btn-success" type="button">Print</button>
    <button class="btn btn-info" type="button" onclick="location.reload()">Refresh</button>
    <button class="btn btn-dark" type="button" onclick="window.close()">Exit</button>
</div>

</form>
</div>

<?php echo $__env->make('footerscript', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script>
let patientTimer;

function generateIpdNo(){
    $.ajax({
        url: "<?php echo e(url('generateIpdNo')); ?>",
        type: "POST",
        data: {_token:"<?php echo e(csrf_token()); ?>"},
        success:function(res){
            if(res.ipd_no){
                $('#IpdNo').val(res.ipd_no);
            }
        }
    });
}

// Fetch patient by MRD No or UHID No
function fetchPatientDetails(searchVal){
    if(!searchVal || searchVal.trim() == ''){
        return;
    }
    
    $.ajax({
        url: "<?php echo e(url('getPatientByMrdOrUhid')); ?>",
        type: "POST",
        data: {
            _token: "<?php echo e(csrf_token()); ?>",
            searchVal: searchVal
        },
        dataType: "json",
        success: function(data){
            if(data){
                $('#PatientName').val(data.PatientName || '');
                $('#Age').val(data.Age || '');
                $('#Gender').val(data.Gender || '').trigger('change');
                $('#Weight').val(data.Weight || '');
                $('#Height').val(data.Height || '');
                if(data.UhidNo) $('#UhidNo').val(data.UhidNo);
                if(data.MrdNo) {
                    $('input[name="MrdNo"]').val(data.MrdNo);
                }
                if(data.Phone) $('input[name="Mobile1"]').val(data.Phone);
                if(data.Address) $('textarea[name="RelativeAddress"]').val(data.Address);
                if(data.BloodGroup) $('select[name="BloodGroup"]').val(data.BloodGroup);
            }
        },
        error: function(){
            console.log('Patient not found');
        }
    });
}

// Listen to UHID No input
$(document).on('input', '#UhidNo', function(){
    clearTimeout(patientTimer);
    let val = $(this).val().trim();
    patientTimer = setTimeout(function(){
        if(val){
            fetchPatientDetails(val);
        }
    }, 500);
});

// Add MRD No field if not exists
if($('input[name="MrdNo"]').length == 0){
    $('<input>').attr({
        type: 'hidden',
        name: 'MrdNo',
        id: 'MrdNo'
    }).appendTo('#ipdForm');
}

// Form submission
$('#ipdForm').on('submit', function(e){
    e.preventDefault();
    
    var formData = new FormData(this);
    formData.append('actionvalue', 'Save');
    
    $.ajax({
        url: "<?php echo e(url('saveIpdCasePaper')); ?>",
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        success: function(res){
            if(res.success){
                alert('IPD case paper saved successfully!');
                $('#ipdForm').append('<input type="hidden" name="saveid" value="' + res.id + '">');
                $('#ipdForm input[name="actionvalue"]').val('Edit');
            } else {
                alert('Error: ' + (res.error || 'Failed to save'));
            }
        },
        error: function(xhr){
            var errorMsg = 'Failed to save IPD case paper';
            if(xhr.responseJSON && xhr.responseJSON.error){
                errorMsg = xhr.responseJSON.error;
            }
            alert(errorMsg);
        }
    });
});

$(document).ready(function(){
    generateIpdNo();
    
    // Set current date and time
    var now = new Date();
    var dateStr = now.toISOString().split('T')[0];
    var timeStr = now.toTimeString().split(' ')[0].substring(0,5);
    
    $('input[name="AdmissionDate"]').val(dateStr);
    $('input[name="AdmissionTime"]').val(timeStr);
});
</script>
<?php /**PATH C:\laragon\www\parijathosp\resources\views//ipd/add-ipd-casepaper.blade.php ENDPATH**/ ?>