<!DOCTYPE html>
<html lang="en" class="default-style">

<head>
    <title><?php echo e(projectTitle()); ?></title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=no,minimum-scale=1,maximum-scale=1">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <meta name="author" content="Codedthemes">
    <?php echo $__env->make('headerscript', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <style type="text/css">
    fieldset legend {
        background: inherit;
        font-family: "Lato", sans-serif;
        color: #650812;
        font-size: 15px;
        left: 10px;
        padding: 0 10px;
        position: absolute;
        top: -12px;
        font-weight: 400;
        width: auto !important;
        border: none !important;
    }

    fieldset {
        background: #ffffff;
        border: 1px solid #C43853;
        border-radius: 5px;
        margin: 17px 0 1px 0;
    padding: 15px;
        position: relative;
    }

    .form-control {
        min-height: 1px;
        height: 25px;
    }
    .container,
.container-fluid {
    padding-right: 15px;
    padding-left: 15px;
}

.table th,
.table td {
    padding: 1px;
    padding-left: 7px;
}
    </style>
</head>
<?php
$UserId = Session::get('UserId');
if(file_exists('json_files/json-file.json')){
$json = file_get_contents('json_files/json-file.json');
//Decode JSON
$json_data = json_decode($json,true);
$results = array();
}

if(file_exists('json_files/timetables_date.json')){
$json2 = file_get_contents('json_files/timetables_date.json');
//Decode JSON
$json_data2 = json_decode($json2,true);
$results2 = array();
}


?>

<div class="container-fluid flex-grow-1 container-p-y">
    <!-- <h4 class="font-weight-bold py-3 mb-0">Discharge Card</h4> -->
    <form id="validation-form" novalidate="novalidate" method="POST" enctype="multipart/form-data" autocomplete="off"
        action="">
        <input type="hidden" name="actionvalue" id="actionvalue" value="Save">
        <input type="hidden" name="saveid" id="saveid" value="">
        <input type="hidden" name="IpdNo" id="IpdNo" value="">
        <input type="hidden" name="CounselingId" id="CounselingId" value="<?php echo e($consellingid); ?>">
        <input type="hidden" name="OptEye" id="OptEye" value="">
        
        <?php echo csrf_field(); ?>
        <div class="row">


            <div class="col-md-12">
                <div class="card mb-12 mb-1">
                    <div class="card-body">
                        <table class="table table-bordered table-striped mb-0">
                            <thead>


                                <tr>


                                    <th width="10" align="center" valign="top">Mrd.No </th>
                                    <th width="50" align="center" valign="top" colspan="1"><input type="text" class="form-control"
                                            placeholder="" id="MrdNo" name="MrdNo" readonly value="<?php echo e($MrdNo); ?>" style="width: 100px;">
                                        <div class="clearfix"></div>
                                    </th>
                                    <th width="30" align="center" valign="top">Patient Name </th>
                                    <th width="180" align="center" valign="top" colspan="1"><input type="text" class="form-control"
                                            placeholder="" name="PatientName" id="PatientName"
                                            value="<?php echo e($otdetails->PatientName); ?>">
                                        <div class="clearfix"></div>
                                    </th>
                                    <th width="20" align="center" valign="top">Age/Gender </th>
                                    <th width="80" align="center" valign="top"><input type="text" class="form-control"
                                            placeholder="" id="AgeGender" name="AgeGender"
                                            value="<?php echo e($otdetails->Age); ?>/<?php echo e($otdetails->Gender); ?>">
                                    <th width="20" align="center" valign="top">Mobile</th>
                                    <th width="80" align="center" valign="top" ><input type="text" class="form-control"
                                            placeholder="" id="Phone" name="Mobile" value="<?php echo e($otdetails->Phone); ?>">
                                        <div class="clearfix"></div>
                                    </th>
                                    <th width="20" align="center" valign="top">Language</th>
                                    <th width="80" align="center" valign="top" >
                                        <select class="form-control" name="Language" id="Language" style="height: 35px;">
                                        <option value="Marathi">Marathi</option>
                                        <option value="Hindi">Hindi</option>
                                    </select>
                                    </th>
                                    
                                    
                                </tr>

                                
                                <tr style="padding-top: 7px;">
                                    <th width="10" align="center" valign="top">Address</th>
                                    <th width="80" align="center" valign="top" colspan="3"><input type="text" class="form-control"
                                            placeholder="" id="Address" name="Address" value="<?php echo e($otdetails->Address); ?>">
                                        <div class="clearfix"></div>
                                    </th>
                                    <th width="175" align="center" valign="top">Dt of Admission </th>
                                    <th width="50" align="center" valign="top"><input type="date" name="AdmissionDate"
                                            class="form-control" id="AdmissionDate" value="<?php echo e($otdetails->AdmissionDate); ?>">
                                    </th>

                                    <th width="20" align="center" valign="top">Dt of Operation </th>
                                    <th width="50" align="center" valign="top"><input type="date" name="OperationDate"
                                            id="OperationDate" class="form-control" value="<?php echo e($otdetails->SurgeryDate); ?>">
                                    </th>
                                    <th width="20" align="center" valign="top">Dt of Discharge </th>
                                    <th width="50" align="center" valign="top"><input type="date" name="DischargeDate"
                                            class="form-control" id="DischargeDate" value="<?php echo e($otdetails->SurgeryDate); ?>" onchange="findFollowupDate(this.value)">
                                    </th>
                                      
                                </tr>

                            </thead>
                            <tbody>
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>
        </div>

        <div class="row">
           

            <div class="col-md-12">
                <div class="row">
                    <div class="col-lg-5">
                        <div class="row">
                            <div class="col-md-12">
                                <fieldset style="padding-bottom: 0px;">
                                    <legend>Diagnosis</legend>
                                    <div class="row">
                                        <div class="col-lg-10">
                                            <div class="form-group">
                                                <textarea class="form-control" placeholder="Search for..."
                                                    name="Diagnosis" id="Diagnosis"><?php echo e($otdetails->Diagnosis); ?></textarea>

                                            </div>
                                        </div>
                                        <div class="col-lg-2">
                                            <span class="input-group-append">
                                                <button class="btn btn-secondary" type="button" data-toggle="modal"
                                                    data-target="#modal-report" id="add_button"
                                                    onclick="getValue('IpdDiagnosis','Diagnosis')">...</button>
                                            </span>
                                        </div>
                                    </div>
                                </fieldset>
                            </div>
                            <div class="col-md-12">
                                <fieldset style="padding-bottom: 0px;">
                                    <legend>Surgery</legend>
                                    <div class="row">
                                        <div class="col-lg-10">
                                            <div class="form-group">
                                                <textarea class="form-control" placeholder="Search for..."
                                                    name="OperationNotes"
                                                    id="OperationNotes"><?php echo e($otdetails->SurgeryName); ?></textarea>

                                            </div>
                                        </div>
                                        <div class="col-lg-2">
                                            <span class="input-group-append">
                                                <button class="btn btn-secondary" type="button" data-toggle="modal"
                                                    data-target="#modal-report" id="add_button"
                                                    onclick="getValue('OperationNotes','OperationNotes')">...</button>
                                            </span>
                                        </div>
                                    </div>


                                </fieldset>
                            </div>

                            <div class="col-md-12">
                                <fieldset style="padding-bottom: 0px;">
                                    <legend>Treatment Given</legend>
                                    <div class="row">
                                        <div class="col-lg-10">
                                            <div class="form-group">
                                                <textarea class="form-control" placeholder="Search for..."
                                                    name="TreatmentGiven" id="TreatmentGiven"></textarea>

                                            </div>
                                        </div>
                                        <div class="col-lg-2">
                                            <span class="input-group-append">
                                                <button class="btn btn-secondary" type="button" data-toggle="modal"
                                                    data-target="#modal-report" id="add_button"
                                                    onclick="getValue('TreatmentGiven','TreatmentGiven')">...</button>
                                            </span>
                                        </div>
                                    </div>


                                </fieldset>
                            </div>

                            <div class="col-md-12">
                                <fieldset style="padding-bottom: 0px;">
                                    <legend>Condition On Discharge</legend>
                                    <div class="row">
                                        <div class="col-lg-10">
                                            <div class="form-group">
                                                <textarea class="form-control" placeholder="Search for..."
                                                    name="CondDischarge" id="CondDischarge"></textarea>

                                            </div>
                                        </div>
                                        <div class="col-lg-2">
                                            <span class="input-group-append">
                                                <button class="btn btn-secondary" type="button" data-toggle="modal"
                                                    data-target="#modal-report" id="add_button"
                                                    onclick="getValue('CondDischarge','CondDischarge')">...</button>
                                            </span>
                                        </div>
                                    </div>


                                </fieldset>
                            </div>

                            

                           
                                <div class="col-md-12">
                                    <fieldset style="height: 240px;">
                                        <legend>Special Instruction</legend>
                                        <div class="row">
                                            <div class="col-lg-9">
                                                <select class="form-control" style="height: 35px;" id="CmbPlanOfMang" name="CmbPlanOfMang"
                                                    onchange="getSpecInstDetails(this.value,'Instruction')">
                                                    <option value="">...</option>
                                                    <?php $__currentLoopData = $pomspecinstList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($result->Name); ?>"><?php echo e($result->Name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                           
                                        </div>
                                        <div class="row" style="padding-top:10px;">
                                            <div class="col-lg-10"><textarea class="form-control" id="Instruction" name="txtremark"
                                                    style="height: 160px;"></textarea>
                                            </div>
                                             <div class="col-lg-1" style="padding-left: 20px;"><span class="input-group-append"><button class="btn btn-secondary"
                                                        type="button" data-toggle="modal" data-target="#modal-report-inst"
                                                        onclick="addNewSpecInst('CmbPlanOfMang','Instruction')">+</button></span>
                                                        </div>
                                                        
                                            
                                        </div>
        
                                       
                                    </fieldset>
                                </div>
                            

                            <div class="col-md-12">
                                <fieldset style="padding-bottom: 0px;">
                                    <legend>After Surgery Instruction </legend>
                                    <div class="row">
                                        <div class="col-lg-10">
                                            <div class="form-group">
                                                <textarea class="form-control" placeholder="Search for..."
                                                    name="SurgeryInstruction" id="SurgeryInstruction"></textarea>

                                            </div>
                                        </div>
                                        <div class="col-lg-2">
                                            <span class="input-group-append">
                                                <button class="btn btn-secondary" type="button" data-toggle="modal"
                                                    data-target="#modal-report" id="add_button"
                                                    onclick="getValue('SurgeryInstruction','SurgeryInstruction')">...</button>
                                            </span>
                                        </div>
                                    </div>


                                </fieldset>
                            </div>

                          




                            <div class="col-md-12">
                                <fieldset>
                                    <button class="btn btn-primary" type="submit" name="submit"
                                        id="submit">Save</button>
                                    <button class="btn btn-success" onclick="printOt()" id="printbtn" type="button"
                                        disabled>Print</button>
                                        <button class="btn btn-danger" onclick="blankRecord()" id="resetbtn" type="button"
                                        >Reset</button>
                                        
                                  
                                </fieldset>
                            </div>




                        </div>
                    </div>


                    <div class="col-lg-7">
                        <div class="row">
                            <div class="col-md-12">
                                <fieldset>
                                    <legend>Investigation</legend>
                                    <div class="row">
                                        <table class="table table-bordered table-striped mb-0">
                                            <thead>

                                                <tr>
                                                    <th width="70" align="center" valign="top">
                                                        
                                                    <select class="form-control" name="InvLabel1" id="InvLabel1" style="height: 35px;">
                                                        <option value="FASTING">FASTING</option>
                                                        <option value="RANDOM" selected>RANDOM</option>
                                                    </select>
                                                    </th>

                                                    <th width="70" align="center" valign="top"><input type="text"
                                                            name="InvValue1" id="InvValue1" class="form-control"
                                                            placeholder="" value="">
                                                        <div class="clearfix"></div>
                                                        </td>
                                                    </th>

                                                    <th width="70" align="center" valign="top">
                                                        
                                                    <select class="form-control" name="InvLabel2" id="InvLabel2" style="height: 35px;">
                                                        <option value="POST MEAL">POST MEAL</option>
                                                        <option value="BP"selected>BP</option>
                                                        
                                                    </select>
                                                    </th>

                                                    <th width="70" align="center" valign="top"><input type="text"
                                                            name="InvValue2" id="InvValue2" class="form-control"
                                                            placeholder="" value="">
                                                        <div class="clearfix"></div>
                                                        </td>
                                                    </th>

                                                    <th width="70" align="center" valign="top">
                                                        <input class="form-control" name="InvLabel3" id="InvLabel3"
                                                        style="height: 31px;" value="HIV">
                                                   
                                                    </th>

                                                    <th width="70" align="center" valign="top"><input type="text"
                                                            name="InvValue3" id="InvValue3" class="form-control"
                                                            placeholder="" value="">
                                                        <div class="clearfix"></div>
                                                        </td>
                                                    </th>
                                                   
                                                </tr>

                                            </thead>
                                            <thead>

                                                <tr>
                                                    <th width="70" align="center" valign="top">
                                                        
                                                    <select class="form-control" name="InvLabel4" id="InvLabel4" style="height: 35px;">
                                                        
                                                        <option value="A SCAN" selected>A SCAN</option>
                                                        
                                                    </select>
                                                    </th>

                                                    <th width="70" align="center" valign="top"><input type="text"
                                                            name="InvValue4" id="InvValue4" class="form-control"
                                                            placeholder="" value="">
                                                        <div class="clearfix"></div>
                                                        </td>
                                                    </th>

                                                    <th width="70" align="center" valign="top">
                                                        
                                                    <select class="form-control" name="InvLabel5" id="InvLabel5" style="height: 35px;">
                                                        
                                                        <option value="INVST">INVST</option>
                                                    </select>
                                                    </th>

                                                    <th width="70" align="center" valign="top"><input type="text"
                                                            name="InvValue5" id="InvValue5" class="form-control"
                                                            placeholder="" value="">
                                                        <div class="clearfix"></div>
                                                        </td>
                                                    </th>

                                                    <th width="70" align="center" valign="top">
                                                        <input class="form-control" name="InvLabel6" id="InvLabel6"
                                                        style="height: 31px;" value="HBsAG">
                                                   
                                                    </th>

                                                    <th width="70" align="center" valign="top"><input type="text"
                                                            name="InvValue6" id="InvValue6" class="form-control"
                                                            placeholder="" value="">
                                                        <div class="clearfix"></div>
                                                        </td>
                                                    </th>
                                                   
                                                </tr>

                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>


                                </fieldset>
                            </div>




                            <div class="col-md-12">
                                <?php echo $__env->make('ipd/inctreatments', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>

                            <div class="col-md-12">
                                <fieldset style="padding-bottom: 38px;">
                                    <legend>Follow Up Dates </legend>
                                    <table class="table table-bordered table-striped mb-0">
                                        <thead>
            
            
                                            <tr>
                                                <th width="100" align="center" valign="top">Follow up Dt 1</th>
                                                <th width="50" align="center" valign="top"><input type="date" name="FollowUpDate1"
                                                        class="form-control" id="FollowUpDate1" value="" onchange="getReviewDays(this.value)">
                                                        
                                                </th>
                                                <th width="100" align="center" valign="top">Follow up Dt 2</th>
                                                <th width="50" align="center" valign="top"><input type="date" name="FollowUpDate2"
                                                        class="form-control" id="FollowUpDate2" value="" onchange="getReviewDays2(this.value)">
                                                       </span>
                                                </th>
            
                                                <th width="50" align="center" valign="top">Time </th>
                                                <th width="150" align="center" valign="top"><input type="text" name="CreatedTime"
                                                        class="form-control" id="CreatedTime" value=""></th>    
                                                
                                            </tr>

                                            <tr>
                                                <th width="100" align="center" valign="top">&nbsp;</th>
                                                <th width="50" align="center" valign="top">
                                                        <span style="color:red;display:none;" id="sundayerrormsg">Sunday</span>
                                <span style="color:#11e311;" id="alldaymsg"></span>
                                                </th>
                                                <th width="100" align="center" valign="top">&nbsp;</th>
                                                <th width="50" align="center" valign="top">
                                                        <span style="color:red;display:none;" id="sundayerrormsg2">Sunday</span>
                                <span style="color:#11e311;" id="alldaymsg2"></span>
                                                </th>
            
                                                <th width="50" align="center" valign="top">&nbsp; </th>
                                                <th width="150" align="center" valign="top">&nbsp;</th>    
                                                
                                            </tr>
            
            
                                        </thead>
                                      
                                    </table>
            


                                </fieldset>
                            </div>

                        </div>
                        <div>

                        </div>

                    </div>
                </div>
            </div>



            <input type="hidden" id="CurrDate" value="<?php echo e(date('Y-m-d')); ?>">


    </form>
</div>
</div>
</div>
<!-- [ Layout content ] Start -->

</div>
<!-- [ Layout container ] End -->

</div>
<!-- Overlay -->

<div class="layout-overlay layout-sidenav-toggle"></div>
</div>
<script src="<?php echo e(url('assets/js/jquery-3.6.0.min.js')); ?>"></script>
<?php echo $__env->make('masters/inccommonmodal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('masters/incspecinstmodal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="layout-overlay layout-sidenav-toggle"></div><!-- [ Layout wrapper] End -->
<!-- Modal -->
<?php echo $__env->make('footerscript', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>

function addNewSpecInst(idval, type) {
        $('#specinstaction').val('Save');
        $('#specinstid').val('');
        $('#SpecInstName').val('');
        $('#SpecInstDetails').val('');
        $('#specinstcmbid').val(idval);
        $('#SpecInstType').val(type).attr("selecetd", true);
        $('#specinstbtn').text("Save");
        $('#specinsttitle').html(
            "Add <span class='font-weight-light'>New</span>");
        specinstlists(idval, type);

    }
function specinstlists(idval, type) {
        $.ajax({
            url: "<?php echo e(url('viewSpecInstList')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                Type: type
            },
            success: function(data) {
                //console.log(data);
                $('#specinstcustresult').html(data);
            }
        });
    }

    function saveSpecInst() {
        var SpecInstName = $('#SpecInstName').val();
        var SpecInstDetails = $('#SpecInstDetails').val();
        var SpecInstType = $('#SpecInstType').val();
        var action = $('#specinstaction').val();
        var id = $('#specinstid').val();
        $.ajax({
            url: "<?php echo e(url('saveSpecInst')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                SpecInstName: SpecInstName,
                SpecInstDetails: SpecInstDetails,
                SpecInstType: SpecInstType,
                action: action,
                id: id
            },
            beforeSend: function() {
                $('#specinstbtn').attr('disabled', 'disabled');
                $('#specinstbtn').text('Please Wait...');
            },
            success: function(data) {

                $('#modal-report-inst').modal('hide');
                $('#specinstaction').val('Save');
                $('#specinstid').val('');
                $('#specinstbtn').attr('disabled', false);
                $('#specinstbtn').text('Submit');
                specInst_List();

                //window.location.href = "/<?php echo e(projectUrl()); ?>optoform/" + MrdNo + "/" + VisitDate + "/" + VisitNo + "?page=consult";  

            }
        });
    }

    function specInst_List() {
        var idval = $('#specinstcmbid').val();
        var Type = $('#SpecInstType').val();
        $.ajax({
            url: "<?php echo e(url('saveSpecInstList')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                Type: Type
            },
            success: function(data) {
                $('#' + idval).html(data);

            }
        });
    }

    function getSpecInstDetails(val, detailsid) {
       
       if (val == '') {
           $('#' + detailsid).val('');
       }
       $.ajax({
           url: "<?php echo e(url('getSpecInstDetails')); ?>",
           method: "POST",
           data: {
               _token: '<?php echo e(csrf_token()); ?>',
               val: val
           },

           success: function(data) {
               //console.log(data);
               if (val != '') {
                   $('#' + detailsid).val(data);
               } else {
                   $('#' + detailsid).val('');
               }

           }
       });
   }

function checkTap(previd,id){
    var PrevTreatDate = $('#TreatDate'+previd).val();
        var TreatDate = $('#TreatDate'+id).val();
            var TreatDur = $('#TreatDur'+id).val();
            //console.log(TreatDate,TreatDur);
        if($('#Tapchk'+id).prop('checked') == true) {
            $.ajax({
        url: "<?php echo e(url('getTapDate')); ?>",
        method: "POST",
        data: {
            _token: '<?php echo e(csrf_token()); ?>',
            TreatDate: TreatDate,
            TreatDur:TreatDur,
            PrevTreatDate:PrevTreatDate
        },
        success: function(data) {
            $('#TreatDate'+id).val(data);
            console.log(data);
        }
    });
        }
        else{
            $.ajax({
        url: "<?php echo e(url('getUnchkTapDate')); ?>",
        method: "POST",
        data: {
            _token: '<?php echo e(csrf_token()); ?>',
            TreatDate: TreatDate,
            TreatDur:TreatDur
        },
        success: function(data) {
            $('#TreatDate'+id).val(data);
            console.log(data);
        }
    });
            }
        }
       
    function getTreatDate(id,val){
        //alert(id);alert(val);
        $.ajax({
        url: "<?php echo e(url('getTreatDate')); ?>",
        method: "POST",
        data: {
            _token: '<?php echo e(csrf_token()); ?>',
            val: val
        },
        success: function(data) {
            //console.log(data);
            $('#TreatDate'+id).val(data);
        }
    });
    }
function ipdBill() {
    var dcid = $('#saveid').val();
    var otid = $('#otid').val();
    var mrdno = $('#MrdNo').val();
    setTimeout(function() {
        window.open(
            '/<?php echo e(projectUrl()); ?>addIpdBill2/' + mrdno + '/' + otid + '/' + dcid, 'popUpWindow4',
            'height=1000,width=1500,left=0,top=0,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
        );
    }, 1);
}

function ipdReceipt() {
    var otid = $('#otid').val();
    var mrdno = $('#MrdNo').val();
    setTimeout(function() {
        window.open(
            '/<?php echo e(projectUrl()); ?>addIpdReceipt/' + mrdno + '/' + otid, 'popUpWindow5',
            'height=1000,width=1500,left=0,top=0,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
        );
    }, 1);
}

function printOt() {
    var id = $('#saveid').val();
    setTimeout(function() {
        window.open(
            '/<?php echo e(projectUrl()); ?>printDischargeCard/' + id, 'popUpWindow2',
            'height=1000,width=800,left=0,top=0,resizable=no,scrollbars=no,toolbar=no,menubar=no,location=no,directories=no,status=no'
        );
    }, 1);
}

function getValue(val, idval) {
    $('#ModalValue').val(val);
    $('#ValueId').val(idval);
    $('#OldValue').val('');
    $('#search_text77').val('');
    $('#Ref_By').focus();
    desc_lists(val);
}


function getRecords(val) {
    $.ajax({
        url: "<?php echo e(url('getTreatments2')); ?>",
        method: "POST",
        data: {
            _token: '<?php echo e(csrf_token()); ?>',
            Treatment: val
        },
        success: function(data) {
            console.log(data);
            $('#showTreatments').html(data);
        }
    });
}



function getPatientTreatment2(val) {
    $.ajax({
        url: "<?php echo e(url('getPatientTreatment2')); ?>",
        method: "POST",
        data: {
            _token: '<?php echo e(csrf_token()); ?>',
            id: val
        },
        success: function(data) {
            //console.log(data);
            var res = JSON.parse(data);
            var result = res.data;
            //var Diagnosis = res.Diagnosis;
            //$('#Diagnosis').val(Diagnosis);
            $('#Treatment').val(result.Treatment);
            if (result.TreatChk1 == 1) {
                $('#TreatChk1').prop("checked", true);
            } else {
                $('#TreatChk1').prop("checked", false);
            }
            $('#TreatType1').val(result.TreatType1);
            $('#TreatName1').val(result.TreatName1);
            $('#TreatDose1').val(result.TreatDose1);
            $('#TreatFreq1').val(result.TreatFreq1);
            $('#TreatDur1').val(result.TreatDur1);
            $('#TreatEye1').val(result.TreatEye1);
            $('#TreatDate1').val(result.TreatDate1);
            if (result.Tapchk1 == 1) {
                $('#Tapchk1').prop("checked", true);
            } else {
                $('#Tapchk1').prop("checked", false);
            }


            if (result.TreatChk2 == 1) {
                $('#TreatChk2').prop("checked", true);
            } else {
                $('#TreatChk2').prop("checked", false);
            }
            $('#TreatType2').val(result.TreatType2);
            $('#TreatName2').val(result.TreatName2);
            $('#TreatDose2').val(result.TreatDose2);
            $('#TreatFreq2').val(result.TreatFreq2);
            $('#TreatDur2').val(result.TreatDur2);
            $('#TreatEye2').val(result.TreatEye2);
            $('#TreatDate2').val(result.TreatDate2);
            if (result.Tapchk2 == 1) {
                $('#Tapchk2').prop("checked", true);
            } else {
                $('#Tapchk2').prop("checked", false);
            }

            if (result.TreatChk3 == 1) {
                $('#TreatChk3').prop("checked", true);
            } else {
                $('#TreatChk3').prop("checked", false);
            }
            $('#TreatType3').val(result.TreatType3);
            $('#TreatName3').val(result.TreatName3);
            $('#TreatDose3').val(result.TreatDose3);
            $('#TreatFreq3').val(result.TreatFreq3);
            $('#TreatDur3').val(result.TreatDur3);
            $('#TreatEye3').val(result.TreatEye3);
            $('#TreatDate3').val(result.TreatDate3);
            if (result.Tapchk3 == 1) {
                $('#Tapchk3').prop("checked", true);
            } else {
                $('#Tapchk3').prop("checked", false);
            }

            if (result.TreatChk4 == 1) {
                $('#TreatChk4').prop("checked", true);
            } else {
                $('#TreatChk4').prop("checked", false);
            }
            $('#TreatType4').val(result.TreatType4);
            $('#TreatName4').val(result.TreatName4);
            $('#TreatDose4').val(result.TreatDose4);
            $('#TreatFreq4').val(result.TreatFreq4);
            $('#TreatDur4').val(result.TreatDur4);
            $('#TreatEye4').val(result.TreatEye4);
            $('#TreatDate4').val(result.TreatDate4);
            if (result.Tapchk4 == 1) {
                $('#Tapchk4').prop("checked", true);
            } else {
                $('#Tapchk4').prop("checked", false);
            }

            if (result.TreatChk5 == 1) {
                $('#TreatChk5').prop("checked", true);
            } else {
                $('#TreatChk5').prop("checked", false);
            }
            $('#TreatType5').val(result.TreatType5);
            $('#TreatName5').val(result.TreatName5);
            $('#TreatDose5').val(result.TreatDose5);
            $('#TreatFreq5').val(result.TreatFreq5);
            $('#TreatDur5').val(result.TreatDur5);
            $('#TreatEye5').val(result.TreatEye5);
            $('#TreatDate5').val(result.TreatDate5);
            if (result.Tapchk5 == 1) {
                $('#Tapchk5').prop("checked", true);
            } else {
                $('#Tapchk5').prop("checked", false);
            }

            if (result.TreatChk6 == 1) {
                $('#TreatChk6').prop("checked", true);
            } else {
                $('#TreatChk6').prop("checked", false);
            }
            $('#TreatType6').val(result.TreatType6);
            $('#TreatName6').val(result.TreatName6);
            $('#TreatDose6').val(result.TreatDose6);
            $('#TreatFreq6').val(result.TreatFreq6);
            $('#TreatDur6').val(result.TreatDur6);
            $('#TreatEye6').val(result.TreatEye6);
            $('#TreatDate6').val(result.TreatDate6);
            if (result.Tapchk6 == 1) {
                $('#Tapchk6').prop("checked", true);
            } else {
                $('#Tapchk6').prop("checked", false);
            }

            if (result.TreatChk7 == 1) {
                $('#TreatChk7').prop("checked", true);
            } else {
                $('#TreatChk7').prop("checked", false);
            }
            $('#TreatType7').val(result.TreatType7);
            $('#TreatName7').val(result.TreatName7);
            $('#TreatDose7').val(result.TreatDose7);
            $('#TreatFreq7').val(result.TreatFreq7);
            $('#TreatDur7').val(result.TreatDur7);
            $('#TreatEye7').val(result.TreatEye7);
            $('#TreatDate7').val(result.TreatDate7);
            if (result.Tapchk7 == 1) {
                $('#Tapchk7').prop("checked", true);
            } else {
                $('#Tapchk7').prop("checked", false);
            }

            if (result.TreatChk8 == 1) {
                $('#TreatChk8').prop("checked", true);
            } else {
                $('#TreatChk8').prop("checked", false);
            }
            $('#TreatType8').val(result.TreatType8);
            $('#TreatName8').val(result.TreatName8);
            $('#TreatDose8').val(result.TreatDose8);
            $('#TreatFreq8').val(result.TreatFreq8);
            $('#TreatDur8').val(result.TreatDur8);
            $('#TreatEye8').val(result.TreatEye8);
            $('#TreatDate8').val(result.TreatDate8);
            if (result.Tapchk8 == 1) {
                $('#Tapchk8').prop("checked", true);
            } else {
                $('#Tapchk8').prop("checked", false);
            }

            if (result.TreatChk9 == 1) {
                $('#TreatChk9').prop("checked", true);
            } else {
                $('#TreatChk9').prop("checked", false);
            }
            $('#TreatType9').val(result.TreatType9);
            $('#TreatName9').val(result.TreatName9);
            $('#TreatDose9').val(result.TreatDose9);
            $('#TreatFreq9').val(result.TreatFreq9);
            $('#TreatDur9').val(result.TreatDur9);
            $('#TreatEye9').val(result.TreatEye9);
            $('#TreatDate9').val(result.TreatDate9);
            if (result.Tapchk9 == 1) {
                $('#Tapchk9').prop("checked", true);
            } else {
                $('#Tapchk9').prop("checked", false);
            }

            if (result.TreatChk10 == 1) {
                $('#TreatChk10').prop("checked", true);
            } else {
                $('#TreatChk10').prop("checked", false);
            }
            $('#TreatType10').val(result.TreatType10);
            $('#TreatName10').val(result.TreatName10);
            $('#TreatDose10').val(result.TreatDose10);
            $('#TreatFreq10').val(result.TreatFreq10);
            $('#TreatDur10').val(result.TreatDur10);
            $('#TreatEye10').val(result.TreatEye10);
            $('#TreatDate10').val(result.TreatDate10);
            if (result.Tapchk10 == 1) {
                $('#Tapchk10').prop("checked", true);
            } else {
                $('#Tapchk10').prop("checked", false);
            }
        }
    });
}

function blankRecord(){
    $('#Diagnosis').val('');
                $('#OperationNotes').val('');
                $('#CondDischarge').val('');
                $('#TreatmentGiven').val('');
                $('#Instruction').val('');
                $('#InvValue1').val('');
                $('#InvValue4').val('');
                $('#InvValue2').val('');
                $('#InvValue5').val('');
                $('#InvLabel3').val('');
                $('#InvLabel6').val('');
                $('#InvValue3').val('');
                $('#InvValue6').val('');
                $('#Treatments').val('');
                $('#CreatedTime').val('');
                $('#Language').val('Marathi').attr("selected",true);
                $('#SurgeryInstruction').val('');
                $('#Treatment').val('');
                for (let i = 1; i <= 10; i++) {
    $('#TreatChk' + i).prop('checked', false);
    $('#TreatType' + i).val('').prop('selected', true);
    $('#TreatName' + i).val('');
    $('#TreatDate' + i).val('');
    $('#TreatDose' + i).val('').prop('selected', true);
    $('#TreatFreq' + i).val('').prop('selected', true);
    $('#TreatDur' + i).val('').prop('selected', true);
    $('#TreatEye' + i).val('').prop('selected', true);
}
$('#FollowUpDate1').val('');
$('#FollowUpDate2').val('');
$('#CreatedTime').val('');
}

function checkDcPatient(val) {
    var CurrDate = $('#CurrDate').val();
    $.ajax({
        url: "<?php echo e(url('checkDcPatient2')); ?>",
        method: "POST",
        data: {
            _token: '<?php echo e(csrf_token()); ?>',
            id: val
        },
        success: function(data) {
            var res = JSON.parse(data);
            var Status = res.Status;
            var result = res.result;
            console.log(result);
            if (Status == 0) {
                $('#actionvalue').val('Save');
                $('#saveid').val('');
                $('#printbtn').attr("disabled", true);
                $('#billbtn').attr("disabled", true);
                $('#receiptbtn').attr("disabled", true);
                $('#IpdNo').val(result.IpdNo);
                $('#MrdNo').val(result.MrdNo);
                $('#PatientName').val(result.PatientName);
                $('#AgeGender').val(result.Age+"/"+result.Gender);
                $('#Phone').val(result.Phone);
                $('#Address').val(result.Address);
                $('#OptEye').val(result.Eye);
                $('#AdmissionDate').val(result.AdmissionDate);
                $('#AdmissionTime').val('');
                $('#OperationDate').val(result.SurgeryDate);
                $('#OperationTime').val('');
                $('#DischargeDate').val(CurrDate);
                $('#DischargeTime').val('');
                $('#FollowUpDate1').val('');
                $('#FollowUpDate2').val('');
                //$('#Diagnosis').val(result.Diagnosis);
                //$('#OperationNotes').val('');
                $('#CondDischarge').val('');
                $('#TreatmentGiven').val('');
                $('#Instruction').val('');
                $('#InvValue1').val('');
                $('#InvValue4').val('');
                $('#InvValue2').val('');
                $('#InvValue5').val('');
                $('#InvLabel3').val('');
                $('#InvLabel6').val('');
                $('#InvValue3').val('');
                $('#InvValue6').val('');
                $('#Treatments').val('');
                $('#CreatedTime').val('');
                $('#Language').val('Marathi').attr("selected",true);
                $('#SurgeryInstruction').val('');
                getPatientTreatment2('');
            } else {
                $('#actionvalue').val('Edit');
                $('#printbtn').attr("disabled", false);
                $('#billbtn').attr("disabled", false);
                $('#receiptbtn').attr("disabled", false);
                $('#saveid').val(result.id);
                $('#IpdNo').val(result.IpdNo);
                $('#MrdNo').val(result.MrdNo);
                $('#PatientName').val(result.PatientName);
                $('#AgeGender').val(result.AgeGender);
                $('#Phone').val(result.Mobile);
                $('#Address').val(result.Address);
                $('#OptEye').val(result.OptEye);
                //$('#AdmissionDate').val(result.AdmissionDate);
                $('#AdmissionTime').val('');
                //$('#OperationDate').val(result.OperationDate);
                $('#OperationTime').val('');
                //$('#DischargeDate').val(result.DischargeDate);
                $('#DischargeTime').val('');
                 $('#FollowUpDate1').val(result.FollowUpDate1);
                 $('#FollowUpDate2').val(result.FollowUpDate2);
                //$('#Diagnosis').val(result.Diagnosis);
                //$('#OperationNotes').val(result.OperationNotes);
                $('#CondDischarge').val(result.CondDischarge);
                $('#TreatmentGiven').val(result.TreatmentGiven);
                $('#Instruction').val(result.txtremark);
                $('#InvLabel1').val(result.InvLabel1).attr("selected",true);
                $('#InvValue1').val(result.InvValue1);
                $('#InvLabel2').val(result.InvLabel2).attr("selected",true);
                $('#InvValue2').val(result.InvValue2);
                $('#InvLabel4').val(result.InvLabel4).attr("selected",true);
                $('#InvValue4').val(result.InvValue4);
                $('#InvLabel5').val(result.InvLabel5).attr("selected",true);
                $('#InvValue5').val(result.InvValue5);
                $('#Language').val(result.Language).attr("selected",true);
                
                $('#InvLabel3').val(result.InvLabel3);
                $('#InvLabel6').val(result.InvLabel6);
                $('#InvValue3').val(result.InvValue3);
                $('#InvValue6').val(result.InvValue6);
                $('#Treatments').val(result.Treatments);
                $('#CreatedTime').val(result.CreatedTime);
                $('#SurgeryInstruction').val(result.SurgeryInstruction);
                getPatientTreatment2(result.id);
                findFollowupDate(result.DischargeDate);

            }
        }
    });
}

function findFollowupDate(DischargeDate){
    //var DischargeDate = $('#DischargeDate').val();
    $.ajax({
            url: "<?php echo e(url('getFollowupDate')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                DischargeDate: DischargeDate
            },
            success: function(data) {
                //alert(data);
                //console.log(data);
                var res = JSON.parse(data);
                var dayname = res.dayname;
                var date = res.date;
                var dayname2 = res.dayname2;
                var date2 = res.date2;
                if (dayname == 'Sun') {
                    $('#sundayerrormsg').show();
                    $('#alldaymsg').html('');
                } else {
                    $('#sundayerrormsg').hide();
                    $('#alldaymsg').html(dayname);
                }

                if (dayname2 == 'Sun') {
                    $('#sundayerrormsg2').show();
                    $('#alldaymsg2').html('');
                } else {
                    $('#sundayerrormsg2').hide();
                    $('#alldaymsg2').html(dayname2);
                }
                //$('#FollowUpDate1').val(date);
                //$('#FollowUpDate2').val(date2);
            }
        });
}

function getReviewDays(val) {
        $.ajax({
            url: "<?php echo e(url('getReviewDays')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                val: val
            },
            success: function(data) {
                //console.log(data);
                var res = JSON.parse(data);
                var dayname = res.dayname;
                var days = res.days;
                if (dayname == 'Sun') {
                    $('#sundayerrormsg').show();
                    $('#alldaymsg').html('');
                } else {
                    $('#sundayerrormsg').hide();
                    $('#alldaymsg').html(dayname);
                }
                
            }
        });
    }

    function getReviewDays2(val) {
        $.ajax({
            url: "<?php echo e(url('getReviewDays')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                val: val
            },
            success: function(data) {
                //console.log(data);
                var res = JSON.parse(data);
                var dayname = res.dayname;
                var days = res.days;
                if (dayname == 'Sun') {
                    $('#sundayerrormsg2').show();
                    $('#alldaymsg2').html('');
                } else {
                    $('#sundayerrormsg2').hide();
                    $('#alldaymsg2').html(dayname);
                }
                
            }
        });
    }
$(document).ready(function() {
    
    var CounselingId = $('#CounselingId').val();
    checkDcPatient(CounselingId);
    $(document).on("input", "#Treatment", function(event) {
        var val = $(this).val();
        getRecords(val);
    });
    $(document).on("shown.bs.modal", "#modal-report", function() {
        $('#search_text77').focus();
    });

    $('#validation-form').on('submit', function(e) {
        e.preventDefault();
        if ($('#validation-form').valid()) {
            $.ajax({
                url: "<?php echo e(url('saveDischargeCard')); ?>",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                processData: false,
                beforeSend: function() {
                    $('#submit').attr('disabled', 'disabled');
                    $('#submit').text('Please Wait...');
                },
                success: function(data) {
                    $('#actionvalue').val('Edit');
                    $('#saveid').val(data);
                    $('#printbtn').attr("disabled", false);
                    $('#submit').attr('disabled', false);
                    $('#submit').text('Submit');
                    $('#billbtn').attr("disabled", false);
    $('#receiptbtn').attr("disabled", false);
                }
            });
        }

    });

    $(document).on("click", ".updatespecinst", function(event) {
            event.preventDefault();
            event.stopPropagation();
            var id = $(this).attr("data-id");
            var action = "fetch_record";
            $.ajax({
                url: "<?php echo e(url('editSpecInst')); ?>",
                method: "POST",
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    id: id
                },
                dataType: "json",
                success: function(data) {
                    //console.log(data);
                    $('#SpecInstName').val(data.Name);
                    $('#SpecInstType').val(data.Type).attr("selected", true);
                    $('#SpecInstDetails').val(data.Details)
                    $('#specinstaction').val('Edit');

                    $('#specinstid').val(id);
                    $('#specinstbtn').text("Update");
                    $('#modal-report-inst').modal('show');
                    $('.modal-title').html(
                        "Update <span class='font-weight-light'>Record</span>");

                }
            });
        });



        $(document).on("click", ".deletespecinst", function(event) {
            event.preventDefault();
            var id = $(this).attr("data-id");
            var action = "delete";
            var idval = $('#specinstcmbid').val();
            var type = $('#SpecInstType').val();
            //alert(id);
            swal({
                title: "Are you sure?",
                text: "You will not be able to recover this Record!",
                type: "warning",
                showCancelButton: true,
                confirmButtonClass: "btn-danger",
                confirmButtonText: "Yes, delete",
                cancelButtonText: "No, cancel",
                closeOnConfirm: false,
                closeOnCancel: false
            }, function(isConfirm) {
                if (isConfirm) {
                    $.ajax({
                        url: "<?php echo e(url('deleteSpecInst')); ?>",
                        method: "POST",
                        data: {
                            _token: '<?php echo e(csrf_token()); ?>',
                            id: id
                        },

                        success: function(data) {
                            swal("Deleted!", "Record has been deleted.", "success");

                            addNewSpecInst(idval, type);
                            specInst_List();

                        }
                    });

                } else {
                    swal("Cancelled", "Record is safe :)", "error");
                }
            });


        });

});
</script><?php /**PATH /home/gssnagpu/public_html/hospsoft.in/deshmukh_hosp/resources/views//ipd/add-dischargecard2.blade.php ENDPATH**/ ?>