<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Session;
use App\Models\AppointmentModel;
use App\Http\Controllers\SpecInstController;
class AppointmentController extends Controller
{
    function Appointment(){
        return view('/appointment/view-appointment');
    }
    function viewAppointments(Request $req){
        if(!empty($req->FromDate))
            {   
                if($req->MrdNo == '' || $req->MrdNo == 0){
                    $result = AppointmentModel::whereBetween('AppDate', array($req->FromDate, $req->ToDate))->get();
                }
                else{
                    $MrdNo = $req->MrdNo;
                    $result = AppointmentModel::whereBetween('AppDate', array($req->FromDate, $req->ToDate))->where(['MrdNo'=>$MrdNo])->get();
                }
            }
            else{
                $result = AppointmentModel::all();
            }
            
        return view('/appointment/view-appointment-lists',['data'=>$result]);
    }
    function addNewAppointment(){
        $clinicnameList = (new SpecialityController)->getSpecClinicName();
        return view('/appointment/add-appointment',['clinicnameList'=>$clinicnameList]);
    }
    function saveNewAppointmnet(Request $req){
        if($req->action == 'Save'){
            $Appoint = new AppointmentModel;
        }
        else{
            $Appoint = AppointmentModel::find($req->saveid);
        }
        $Appoint->MrdNo = $req->MrdNo; 
        $Appoint->PatientName = $req->PatientName;
        $Appoint->Phone = $req->Phone;
        $Appoint->ReferFor = $req->ReferFor;
        $Appoint->Consultant = $req->Consultant;
        $Appoint->AppDate = $req->AppDate;
        $Appoint->AppTime = $req->AppTime;
        $Appoint->save();
        $AppointId = $Appoint->id;
        return json_encode(array('id'=>$AppointId,'Status'=>1));

    }
    function deletAppointment(Request $req){
        $data=AppointmentModel::find($req->id)->delete();
        return 1;
    }
    function checkAppointment(Request $req){
        $currdate = date('Y-m-d');
        $result = AppointmentModel::where('AppDate',$currdate)->get();
        $cnt = $result->count();
        if($cnt > 0){
            return view('/appointment/today-appointment-lists',['data'=>$result]); 
        }
        else{
            return 0;
        }
    }

    function editAppointment($id){
        $result = AppointmentModel::where('id',$id)->first();
        $clinicname = $result->ReferFor;
        $clinicnameList = (new SpecialityController)->getSpecClinicName();
        $clinicdocnameList = (new SpecialityController)->getSpecConsultant2($clinicname);
        return view('/appointment/edit-appointment',['clinicdocnameList'=>$clinicdocnameList,'clinicnameList'=>$clinicnameList,'data'=>$result]);
    }
}
