<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\BillModel;
use App\Http\Controllers\MasterController;
use App\Http\Controllers\TreatmentController;
use App\Models\PackageModel;
use App\Models\TempBillChargeModel;
use App\Http\Controllers\CounsellingController;
use App\Models\OTModel;
use App\Models\DischargeModel;
use App\Http\Controllers\PackageController;
use App\Models\OTNoteOtherModel;
use App\Models\DischargeOtherModel;
use Session;

class BillController extends Controller
{
    function bill(){
        return view('/ipd/view-bill');
    }

    function viewIpdBills(Request $req){
        $CurrDate = date('Y-m-d');
        if(!empty($req->FromDate))
            {   
                if($req->MrdNo == '' || $req->MrdNo == 0){
                    $result =  DB::table('tbl_bills as ti')
                    ->leftJoin('tbl_ipd as tip', 'tip.IpdNo', '=', 'ti.IpdNo')
                    ->leftJoin('tbl_users as tc', 'tc.id', '=', 'ti.Consultant')
                    ->whereBetween('ti.BillDate', array($req->FromDate, $req->ToDate))
                    ->where(['ti.Status'=>'1'])
                    ->select('ti.*','tc.Name As Department')->get();
                }
                else{
                    $MrdNo = $req->MrdNo;
                    $result =  DB::table('tbl_bills as ti')
                    ->leftJoin('tbl_ipd as tip', 'tip.IpdNo', '=', 'ti.IpdNo')
                    ->leftJoin('tbl_users as tc', 'tc.id', '=', 'ti.Consultant')
                    ->whereBetween('ti.BillDate', array($req->FromDate, $req->ToDate))
                    ->where(['ti.Status'=>'1','ti.MrdNo'=>$MrdNo])
                    ->select('ti.*','tc.Name As Department')->get();
                }
               

            }
            else{
                $result =  DB::table('tbl_bills as ti')
                ->leftJoin('tbl_ipd as tip', 'tip.IpdNo', '=', 'ti.IpdNo')
                ->leftJoin('tbl_users as tc', 'tc.id', '=', 'ti.Consultant')
                ->where(['ti.Status'=>'1'])
                ->select('ti.*','tc.Name As Department')
                ->orderBy('ti.id','desc')
                ->limit(10)->get();
            }
        return view('ipd/incipdbills',['data'=>$result]);
    }

    function deletIpdBill(Request $req){
        BillModel::find($req->id)->delete();
        DB::table('tbl_bill_charges')->where(['BillNo'=>$req->id])->delete();
        return 1;
    }

    function BillNo(){
        $BillNo = BillModel::select()->max('SrNo');
        if($BillNo == '' || $BillNo == 0 || $BillNo == NULL){
            $BillNo = 1;
        }
        else{
            $BillNo = $BillNo+1;
        }
        return $BillNo;
    }

    function BillNoList(){
        $BillNoList = BillModel::all();
        return $BillNoList;
    }
    function addIpdBill(){
        $patientList = (new MasterController)->ipdPatientList();
        $consultantList = (new MasterController)->consultantList();
        //$counsellingList = (new CounsellingController)->getCounsellingId();
        $BillNoList = $this->BillNoList();
        $BillNo = $this->BillNo();
        $counsellingList = OTModel::all();
        $packagelist = (new PackageController)->packageList();
        return view('/ipd/add-ipd-bill',['packagelist'=>$packagelist,'roll'=>1,'BillNoList'=>$BillNoList,'counsellingList'=>$counsellingList,'BillNo'=>$BillNo,'consultantList'=>$consultantList,'patientList'=>$patientList]);
    }

    function addIpdBill2($mrdno,$otid,$dcid){
        //$patientList = (new MasterController)->ipdPatientList();
        $consultantList = (new MasterController)->consultantList();
        //$counsellingList = (new CounsellingController)->getCounsellingId();
        //$BillNoList = $this->BillNoList();
        $BillNo = $this->BillNo();
        //$counsellingList = OTModel::all();
        $otresult = OTModel::where('id',$otid)->first();
        $dcresult = DischargeModel::where('id',$dcid)->first();
        $packagelist = (new PackageController)->packageList();
        return view('/ipd/add-ipd-bill2',['roll'=>1,'dcresult'=>$dcresult,'packagelist'=>$packagelist,'otresult'=>$otresult,'BillNo'=>$BillNo,'consultantList'=>$consultantList]);
    }

    function addOtherIpdBill2($mrdno,$otid,$dcid){
        //$patientList = (new MasterController)->ipdPatientList();
        $consultantList = (new MasterController)->consultantList();
        //$counsellingList = (new CounsellingController)->getCounsellingId();
        //$BillNoList = $this->BillNoList();
        $BillNo = $this->BillNo();
        //$counsellingList = OTModel::all();
        $otresult = OTNoteOtherModel::where('id',$otid)->first();
        $dcresult = DischargeOtherModel::where('id',$dcid)->first();
        $packagelist = (new PackageController)->packageList();
        return view('/ipd/add-ipd-bill2',['roll'=>2,'dcresult'=>$dcresult,'packagelist'=>$packagelist,'otresult'=>$otresult,'BillNo'=>$BillNo,'consultantList'=>$consultantList]);
    }
    

    function getBillPackageDetails(Request $req){
        $SessionId = Session::getId();
        $PackageName = $req->PackageName;
        //$PackageAmt = $req->PackageAmt;
        //return $PackageName;
        DB::table('tbl_temp_bill_charges')->where(['SessionId'=>$SessionId])->delete();
        $result = PackageModel::select()->where(['PackageName'=>$PackageName])->get();
        $firstrecord = $result->first();
        for($count = 0; $count < count($result); $count++)
        {
         if($PackageName == 'Cashless'){
            $PackageAmt = $req->PackageAmt;
         }
         else{
            $PackageAmt = $result[$count]['PackageAmt'];
         }
        $data = array(
        'SessionId'=>$SessionId,
        'PackageName'=>$PackageName,
        'PackageAmt'=>$PackageAmt,
        'BalanceAmt'=>$result[$count]['BalanceAmt'],
        'Name'=>$result[$count]['Name'],
        'Amount'=>$result[$count]['Amount'],
        'Days'=>$result[$count]['Days'],
        'Rate'=>$result[$count]['Rate'],
        'Status'=>1,
        'CreatedBy' => 19,
       );
       $insert_data[] = $data; 
       }
       //return $insert_data;exit();
       TempBillChargeModel::insert($insert_data);
        return json_encode($firstrecord);
    }

    
    function getBillPackageDetails2(Request $req){
        $SessionId = Session::getId();
        $PackageName = $req->PackageName;
        $PackageAmt = $req->PackageAmt;
        //return $PackageName;
        DB::table('tbl_temp_bill_charges')->where(['SessionId'=>$SessionId])->delete();
        if($PackageName == 'Cashless'){
        $otcharges = $req->PackageAmt;
        $Package = new TempBillChargeModel;
        $Package->SessionId = $SessionId;
        //$result = TempBillChargeModel::select('Name')->where(['SessionId'=>$SessionId])->first();
        $Package->Name = 'Package Rate Of RE Cataract Surgery by Phaco with ERV foldable IOL'; 
        $Package->Days = 1;
        $Package->Rate = $otcharges; $Package->Amount = $otcharges;
        $Package->PackageName = $req->PackageName; $Package->PackageAmt = $req->PackageAmt;
        $Package->BalanceAmt = 0; $Package->Status = 1;
        $Package->save();
        }
        else{
        $otcharges = $req->PackageAmt - (1500+1000+3000+1200);
        $Package = new TempBillChargeModel;
        $Package->SessionId = $SessionId;
        $Package->Name = 'Operation Charges'; $Package->Days = 1;
        $Package->Rate = $otcharges; $Package->Amount = $otcharges;
        $Package->PackageName = $req->PackageName; $Package->PackageAmt = $req->PackageAmt;
        $Package->BalanceAmt = 0; $Package->Status = 1;
        $Package->save();
        
        $Package2 = new TempBillChargeModel;
        $Package2->SessionId = $SessionId;
        $Package2->Name = 'Assistant Charges'; $Package2->Days = 1;
        $Package2->Rate = 1500; $Package2->Amount = 1500;
        $Package2->PackageName = $req->PackageName; $Package2->PackageAmt = $req->PackageAmt;
        $Package2->BalanceAmt = 0; $Package2->Status = 1;
        $Package2->save();
        
        $Package3 = new TempBillChargeModel;
        $Package3->SessionId = $SessionId;
        $Package3->Name = 'Admission Charges'; $Package3->Days = 1;
        $Package3->Rate = 1000; $Package3->Amount = 1000;
        $Package3->PackageName = $req->PackageName; $Package3->PackageAmt = $req->PackageAmt;
        $Package3->BalanceAmt = 0; $Package3->Status = 1;
        $Package3->save();

        $Package4 = new TempBillChargeModel;
        $Package4->SessionId = $SessionId;
        $Package4->Name = 'Operation Theater Charges'; $Package4->Days = 1;
        $Package4->Rate = 3000; $Package4->Amount = 3000;
        $Package4->PackageName = $req->PackageName; $Package4->PackageAmt = $req->PackageAmt;
        $Package4->BalanceAmt = 0; $Package4->Status = 1;
        $Package4->save();
        
        $Package5 = new TempBillChargeModel;
        $Package5->SessionId = $SessionId;
        $Package5->Name = 'Nursing Charges'; $Package5->Days = 1;
        $Package5->Rate = 1200; $Package5->Amount = 1200;
        $Package5->PackageName = $req->PackageName; $Package5->PackageAmt = $req->PackageAmt;
        $Package5->BalanceAmt = 0; $Package5->Status = 1;
        $Package5->save();
        }
        return 1;
    }

    function billChargesView(Request $req){
        $SessionId = Session::getId();
        $PackageName = $req->PackageName;
        $result = TempBillChargeModel::select()->where(['PackageName'=>$PackageName,'SessionId'=>$SessionId])->get();
        return view('ipd/incipdbillchargeview',['data'=>$result]);
    }

    function billChargesView2(Request $req){
        $SessionId = Session::getId();
        $PackageName = $req->PackageName;
        $result = TempBillChargeModel::select()->where(['PackageName'=>$PackageName,'SessionId'=>$SessionId])->get();
        return view('ipd/incipdbillchargeview2',['data'=>$result]);
    }

    function calBillBalanceAmt(Request $req){
        $PackageName = $req->PackageName;
        $SessionId = Session::getId();
        $result = DB::select("SELECT SUM(Amount) As Amount FROM tbl_temp_bill_charges WHERE PackageName = '$PackageName' AND SessionId='$SessionId'");
        $TotAmt = $result[0]->Amount;
        //$PackageAmt = $result[0]->PackageAmt;
        $PackageAmt = $req->PackageAmt;
    $BalanceAmt = $PackageAmt - $TotAmt;
    return $BalanceAmt;
    }

    function totSumBills(Request $req){
        $SessionId = Session::getId();
        $result = TempBillChargeModel::select()->where(['SessionId'=>$SessionId])->sum('Amount');
        return $result;
    }
    function saveTempBills(Request $req){
        $SessionId = Session::getId();
        if($req->action == 'Save'){
            $TempBillCharge = new TempBillChargeModel;
            }
            else{
            $TempBillCharge = TempBillChargeModel::firstWhere(['id'=>$req->id,'SessionId'=>$SessionId]);
            }
            $TempBillCharge->SessionId = Session::getId();
        $TempBillCharge->Name = $req->ChargesName;
        $TempBillCharge->Days = $req->Days;
        $TempBillCharge->Rate = $req->Rate;
        $TempBillCharge->Amount = $req->Amount;
        $TempBillCharge->PackageName = $req->PackageName;
        $TempBillCharge->PackageAmt = $req->PackageAmt;
        $TempBillCharge->BalanceAmt = $req->BalanceAmt;
        $TempBillCharge->Status = 1;
        $TempBillCharge->CreatedBy =19;
        $TempBillCharge->save();
        return 1;
    }

    function saveIpdBill(Request $req){
        DB::table('tbl_bills')->where(['BillNo'=>$req->BillNo])->delete();
        DB::table('tbl_bill_charges')->where(['BillNo'=>$req->BillNo])->delete();
        DB::table('tbl_bills')->where(['OtId'=>$req->OtId,'DscId'=>$req->DscId])->delete();
        $SessionId = Session::getId();
        $Bill = new BillModel;
        $Bill->Roll = $req->Roll;
        $Bill->SrNo = $req->BillNo;
        $Bill->BillNo = $req->BillNo;
        $Bill->BillType = $req->BillType;
  $Bill->MrdNo = $req->MrdNo;
  $Bill->IpdNo = $req->IpdNo;
  $Bill->PatientName = $req->PatientName;
  $Bill->AgeGender = $req->AgeGender;
  $Bill->BillDate = $req->BillDate;
  $Bill->AdmissionDate = $req->AdmissionDate;
  $Bill->DischargeDate = $req->DischargeDate;
  $Bill->OperationDate = $req->OperationDate;
  $Bill->Consultant = $req->Consultant;
  $Bill->Diagnosis = $req->Diagnosis;
  $Bill->SurgeryDone = $req->SurgeryDone;
  $Bill->InsuranceComp = $req->InsuranceComp;
  $Bill->ClainNo = $req->ClainNo;
  $Bill->PackageName = $req->PackageName;
  $Bill->PackageAmt = $req->PackageAmt;
  $Bill->BalanceAmt = $req->BalanceAmt;
  $Bill->SubTotal = $req->SubTotal;
  $Bill->Discount = $req->Discount;
  $Bill->GrossAmt = $req->GrossAmt;
  $Bill->BalAmt = $req->BalAmt;
  $Bill->PaidAmt = $req->PaidAmt;
  $Bill->PayMode = $req->PayMode;
  $Bill->Narration = $req->Narration;
  $Bill->OtId = $req->OtId;
  $Bill->DscId = $req->DscId;
  $Bill->CreatedBy =19;
  $Bill->save();       
  $BillId = $Bill->id;
        
  $result = TempBillChargeModel::select()->where(['SessionId'=>$SessionId])->get();
  for($count = 0; $count < count($result); $count++)
  {
 $data = array(
  'BillNo' => $req->BillNo,
  'MrdNo' => $req->MrdNo,
  'IpdNo' => $req->IpdNo,
  'PackageName'=>$result[$count]['PackageName'],
  'PackageAmt'=>$result[$count]['PackageAmt'],
  'BalanceAmt'=>$result[$count]['BalanceAmt'],
  'Name'=>$result[$count]['Name'],
  'Amount'=>$result[$count]['Amount'],
  'Days'=>$result[$count]['Days'],
  'Rate'=>$result[$count]['Rate'],
  'Status'=>1,
  'CreatedBy' => 19,
 );
 $insert_data[] = $data; 
 }
 //return $insert_data;exit();
 DB::table('tbl_bill_charges')->insert($insert_data);
 DB::table('tbl_temp_bill_charges')->where(['SessionId'=>$SessionId])->delete();
 //return redirect('/ipdBillPrint/'.$BillId);
 return $BillId;
    }

    function fetchBillChargesRecord(Request $req){
        $result = TempBillChargeModel::select()->where(['id'=>$req->id])->first();
        echo json_encode($result);
    }

    function deleteBillChargesRecord(Request $req){
        $SessionId = Session::getId();
        TempBillChargeModel::where(['id'=>$req->id,'SessionId'=>$SessionId])->delete();
        return 1;
    }

    function deleteBillChargesRecord2(Request $req){
        DB::table('tbl_bill_charges')->where(['id'=>$req->id])->delete();
        return 1;
    }

    function getBillDetails(Request $req){
        $val = $req->id;
        $seperate = explode(" / ", $val);
        $BillNo = $seperate[0];
        $result = BillModel::select()->where('BillNo',$BillNo)->first();
        return json_encode($result);
    }
    function ipdBillPrint($id){
        //$result = BillModel::select()->where('id',$id)->first();
        $result = DB::table('tbl_bills as tbc')
        ->join('tbl_patients as tp', 'tp.MrdNo', '=', 'tbc.MrdNo')
        ->where(['tbc.id'=>$id])
        ->select('tbc.*','tp.Phone','tp.Address')->get();
        $BillNo = $result[0]->BillNo;

        $result2 = DB::table('tbl_bill_charges')->select()->where(['BillNo'=>$BillNo])->get();
        return view('/ipd/inc-bill-print',['data'=>$result,'BillNo'=>$BillNo,'data2'=>$result2]);
    }

    function getBillCharges(Request $req){
        $billno = $req->billno;
        $SessionId = Session::getId();
        DB::table('tbl_temp_bill_charges')->where(['SessionId'=>$SessionId])->delete();
        DB::select("INSERT INTO tbl_temp_bill_charges (SessionId,PackageName,PackageAmt,BalanceAmt,Name,Days,Rate,Amount,Status,CreatedBy)
        SELECT '$SessionId',PackageName,PackageAmt,BalanceAmt,Name,Days,Rate,Amount,Status,CreatedBy FROM `tbl_bill_charges` WHERE BillNo=$billno");
        $result2 = DB::table('tbl_temp_bill_charges')->select()->where(['SessionId'=>$SessionId])->get();
        return view('ipd/incipdbillchargeview',['data'=>$result2]);
    }

    function fetchBillChargesRecord2(Request $req){
        $result = DB::table('tbl_bill_charges')->select()->where(['id'=>$req->id])->first();
        echo json_encode($result);
    }

    function updateBillCharges(Request $req){
        if($req->action=='Save'){
            DB::table('tbl_bill_charges')->insert(['BillNo'=>$req->BillNo,'MrdNo'=>$req->MrdNo,'Name'=>$req->ChargesName,
            'Amount'=>$req->Amount,'Days'=>$req->Days,'Rate'=>$req->Rate,'Status'=>'1']);
            return 1;
        }
        else{
            DB::table('tbl_bill_charges')->where(['id'=>$req->id])->update(['Name'=>$req->ChargesName,
            'Amount'=>$req->Amount,'Days'=>$req->Days,'Rate'=>$req->Rate]);
            return 1;
        }
       
    }

    function totSumBills2(Request $req){
        $result = DB::table('tbl_bill_charges')->where(['BillNo'=>$req->BillNo])->sum('Amount');
        return $result;
    }

    function updateIpdBill(Request $req){
        DB::table('tbl_bills')->where(['id'=>$req->BillId])->update(['SubTotal'=>$req->SubTotal,
        'Discount'=>$req->Discount,'GrossAmt'=>$req->GrossAmt,'PaidAmt'=>$req->PaidAmt,
        'BalAmt'=>$req->BalAmt,'PayMode'=>$req->PayMode,'Narration'=>$req->Narration,'BillDate'=>$req->BillDate,
        'AdmissionDate'=>$req->AdmissionDate,'OperationDate'=>$req->OperationDate,'DischargeDate'=>$req->DischargeDate,
    'Consultant'=>$req->ConsultantId,'PatientName'=>$req->PatientName,'AgeGender'=>$req->AgeGender]);
        return 1;
    }

    function saveUpdateCharges(Request $req){
        TempBillChargeModel::where(['id'=>$req->id])->update(['Name'=>$req->name]);
        return 1;
    }

    function editBill($id){
        $consultantList = (new MasterController)->consultantList();
        $packagelist = (new PackageController)->packageList();
        $result = BillModel::where('BillNo',$id)->first();
        $SessionId = Session::getId();
        DB::table('tbl_temp_bill_charges')->where(['SessionId'=>$SessionId])->delete();
        DB::select("INSERT INTO tbl_temp_bill_charges (SessionId,PackageName,PackageAmt,BalanceAmt,Name,Days,Rate,Amount,Status,CreatedBy)
        SELECT '$SessionId',PackageName,PackageAmt,BalanceAmt,Name,Days,Rate,Amount,Status,CreatedBy FROM `tbl_bill_charges` WHERE BillNo=$id");
        $result2 = DB::table('tbl_temp_bill_charges')->select()->where(['SessionId'=>$SessionId])->get();
        return view('/ipd/edit-ipd-bill',['packagelist'=>$packagelist,'consultantList'=>$consultantList,'data'=>$result,'data2'=>$result2]);
    }
}