<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\MasterController;
use App\Http\Controllers\OtScheduledController;
use App\Models\OTModel;
use App\Models\ConsultantModel;
use App\Models\LenseModel;
use App\Http\Controllers\PackageController;

use Session;
class OTNoteController extends Controller
{
    function otNotes(){
        return view('/ipd/view-otnotes');
    }
    function addOtNotes(){
        //$patientList = (new MasterController)->patientList();
        $patientList = (new OtScheduledController)->getOtSchId();
        $optometristList = (new MasterController)->optometristList();
        $packagelist = (new PackageController)->packageList();
        $otpatientList = OTModel::select()->where(['Roll'=>1])->orderBy('id','desc')->get();
        return view('/ipd/add-otnotes',['packagelist'=>$packagelist,'patientList'=>$patientList,'otpatientList'=>$otpatientList,'optometristList'=>$optometristList]);
    }
    function addOtNotes2($mrdno){
        $patientList = (new MasterController)->patientList();
        $optometristList = (new MasterController)->optometristList();
        $packagelist = (new PackageController)->packageList();
        return view('/ipd/add-otnotes2',['packagelist'=>$packagelist,'optometristList'=>$optometristList,'patientList'=>$patientList,'MrdNo'=>$mrdno]);
    }

    function saveOtNotes(Request $req){
        if($req->action == 'Save'){
        $OtNote = new OTModel;
        }
        else{
        $OtNote = OTModel::find($req->saveid);   
        }
        $OtNote->PatientId = $req->PatientId; 
        $OtNote->OtPatientId = $req->OtPatientId;
        $OtNote->MrdNo = $req->MrdNo;
        $OtNote->PatientName = $req->PatientName; 
        $OtNote->Age = $req->Age;
        $OtNote->Phone = $req->Phone;
        $OtNote->Address = $req->Address; 
        $OtNote->Gender = $req->Gender;
        $OtNote->Eye = $req->Eye;
        $OtNote->Diagnosis = $req->Diagnosis;
        $OtNote->Bs = $req->Bs; 
        $OtNote->Bp = $req->Bp;
        $OtNote->IopRe = $req->IopRe;
        $OtNote->IopLe = $req->IopLe; 
        $OtNote->Other = $req->Other;
        $OtNote->Category = $req->Category;
        $OtNote->K1Re = $req->K1Re; 
        $OtNote->K1Le = $req->K1Le;
        $OtNote->K2Re = $req->K2Re;
        $OtNote->K2Le = $req->K2Le;
        $OtNote->AL = $req->AL; 
        $OtNote->Acd = $req->Acd;
        $OtNote->IolPower = $req->IolPower;
        $OtNote->Formula = $req->Formula; 
        $OtNote->Aconstant = $req->Aconstant;
        $OtNote->Surgeon = $req->Surgeon;
        $OtNote->Assistant = $req->Assistant; 
        $OtNote->Anaethetist = $req->Anaethetist;
        $OtNote->Package = $req->Package;
        $OtNote->SurgeryPerformed = $req->SurgeryPerformed;
        $OtNote->DilatedBy = $req->DilatedBy; 
        $OtNote->AnesthesiaType = $req->AnesthesiaType;
        $OtNote->Draping = $req->Draping;
        $OtNote->Speculum = $req->Speculum; 
        $OtNote->ConjunctivalWash = $req->ConjunctivalWash;
        $OtNote->SideportIncision = $req->SideportIncision;
        $OtNote->Viscoelastic = $req->Viscoelastic; 
        $OtNote->ccc = $req->ccc;
        $OtNote->CapStaining = $req->CapStaining;
        $OtNote->IrrigationSol = $req->IrrigationSol;
        $OtNote->Hydroscetion = $req->Hydroscetion; 
        $OtNote->Nucleus = $req->Nucleus;
        $OtNote->CorticalWash = $req->CorticalWash;
        $OtNote->Lri = $req->Lri; 
        $OtNote->WoundHydration = $req->WoundHydration;
        $OtNote->Intracameral = $req->Intracameral;
        $OtNote->PkgAmt = $req->PkgAmt; 
        $OtNote->InsComp = $req->InsComp;
        $OtNote->ReqAmt = $req->ReqAmt;
        $OtNote->SanctAmt = $req->SanctAmt;
        $OtNote->AddAmt = $req->AddAmt; 
        $OtNote->SettleAmt = $req->SettleAmt;
        $OtNote->SettleDate = $req->SettleDate;
        $OtNote->UtrNo = $req->UtrNo; 
        $OtNote->ProcedureComments = $req->ProcedureComments;
        $OtNote->Remarks = $req->Remarks;
        $OtNote->IolName = $req->IolName;
        $OtNote->IolType = $req->IolType;
        $OtNote->StudyPatient = $req->StudyPatient;
        $OtNote->ConfirmOpto = $req->ConfirmOpto;
        $OtNote->Cyl = $req->Cyl;
        $OtNote->NearAdd = $req->NearAdd;
        $OtNote->PackageAmount = $req->PackageAmount;
        $OtNote->Status = 1;
        $OtNote->Roll = 1;
        $OtNote->CreatedBy = Session::get('UserId'); 
        $OtNote->CreatedDate = $req->CreatedDate;
        $OtNote->CreatedTime = $req->CreatedTime;
        $OtNote->save();
        LenseModel::where('OtId',$OtNote->id)->delete();
        $Lense = new LenseModel;
        $Lense->Cname = $req->IolName;
        $Lense->Model = $req->IolType;
        $Lense->Power = $req->IolPower;
        $Lense->ExpMonth = null;
        $Lense->ExpYear = null;
        $Lense->StockDate = $req->CreatedDate;
        $Lense->Quantity = 1;
        $Lense->Narration = "Used For OP";
        $Lense->TransType = 'OP';
        $Lense->CrDr = 'C';
        $Lense->OtId = $OtNote->id;
        $Lense->CreatedDate = $req->CreatedDate;
        $Lense->CreatedTime = date('h:i a');
        $Lense->MrdNo = $req->MrdNo;
        $Lense->PatientName = $req->PatientName; 
        $Lense->Age = $req->Age;
        $Lense->Phone = $req->Phone;
        $Lense->Address = $req->Address; 
        $Lense->Gender = $req->Gender;
        $Lense->Eye = $req->Eye;
        $Lense->save();
        return $OtNote->id;

    }

    function checkOtPatient(Request $req){
        $val = $req->id;
        $seperate = explode(" / ", $val);
        $otid = $seperate[0];
        //$eye = $req->eye;
        $result = OTModel::where(['id'=>$otid])->first();
        $cnt = OTModel::where(['id'=>$otid])->count();
        if($cnt > 0){
            return json_encode(array('Status'=>1,'result'=>$result));
        }
        else{
            return json_encode(array('Status'=>0));
        }
    }

    function printOtNotes($id){
        $result = OTModel::find($id);
        return view('/ipd/view-print-ot-notes',['data'=>$result]);
    }

    function getPrevVisitDetails(Request $req){
        $MrdNo = $req->MrdNo;
        $visitno = ConsultantModel::where('MrdNo',$MrdNo)->max('VisitNo');
        $result2 =  DB::table('tbl_optometrist as topt')
        ->join('tbl_consultants as tc',function($join){
                $join->on("topt.MrdNo","=","tc.MrdNo")
                    ->on("topt.VisitNo","=","tc.VisitNo");
            })
        ->where(['topt.MrdNo'=>$MrdNo,'topt.VisitNo'=>$visitno])
->select('topt.RefK1Re','topt.RefK1Le','topt.RefK2Re','topt.RefK2Le','topt.RefDiffRe','tc.Diagnosis','tc.BP',
        'topt.IopNctRe','topt.IopReTime','topt.IopNctLe','topt.IopLeTime','tc.Advice')
->first();

        //$result2 = ConsultantModel::where(['VisitNo'=>$visitno,'MrdNo'=>$MrdNo])->first();
        return json_encode($result2);
    }

    function checkLastOtPatient(Request $req){
        $MrdNo = $req->id;
        $cnt = OTModel::where('MrdNo',$MrdNo)->count();
        if($cnt > 0){
            $maxid = OTModel::select('id')->where('MrdNo',$MrdNo)->orderBy('CreatedDate','desc')->first();
            $id = $maxid->id;
            $result = OTModel::where('id',$id)->first();
            //return $result;
            return json_encode($result);
        }
        else{
            return 0;
        }
    }

    function opdOtNotesReport($mrdno){
        $result = OTModel::where('MrdNo',$mrdno)->get();
        return view('/ipd/view-ot-notes-report',['data'=>$result]);
    }

    function viewOtNoteLists(){
       return view('/ipd/view-ot-note-list');
    }

    function otNoteLists(Request $req){
        if(!empty($req->FromDate))
        {
        $result = OTModel::where(['CreatedDate'=>$req->FromDate])->get();
        }
        return view('/ipd/inc-ot-note-list',['data'=>$result]);
    }

    function addOtNotes3($id){
        $result = OTModel::where('id',$id)->first();
        $optometristList = (new MasterController)->optometristList();
        $packagelist = (new PackageController)->packageList();
        return view('/ipd/add-otnotes3',['id'=>$id,'data'=>$result,'packagelist'=>$packagelist,'optometristList'=>$optometristList]);
    }
}