<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\MasterController;
use App\Models\OTNoteOtherModel;
use App\Models\ConsultantModel;
use App\Models\OTModel;
use Session;
class OTNoteOtherController extends Controller
{
    function otNotes(){
        return view('/ipd/view-otnotes');
    }
    function addOtNotesOther(){
        $patientList = (new OtScheduledController)->getOtSchId();
        $optometristList = (new MasterController)->optometristList();
        $packagelist = (new PackageController)->packageList();
        $otpatientList = OTModel::select()->where(['Roll'=>2])->orderBy('id','desc')->get();
        return view('/ipd/add-otnotes-other',['packagelist'=>$packagelist,'patientList'=>$patientList,'otpatientList'=>$otpatientList,'optometristList'=>$optometristList]);
    }
    function addOtNotesOther2($mrdno){
        $patientList = (new MasterController)->patientList();
        $surgerynotesList = (new MasterController)->surgerynotesList();
        return view('/ipd/add-otnotes-other2',['surgerynotesList'=>$surgerynotesList,'patientList'=>$patientList,'MrdNo'=>$mrdno]);
    }

    function checkOtOtherPatient(Request $req){
        $val = $req->id;
        $seperate = explode(" / ", $val);
        $otid = $seperate[0];
        //$eye = $req->eye;
        $result = OTModel::where(['id'=>$otid])->first();
        $cnt = OTModel::where(['id'=>$otid])->count();
        if($cnt > 0){
            return json_encode(array('Status'=>1,'result'=>$result));
        }
        else{
            return json_encode(array('Status'=>0));
        }

       
    }

    function saveOtNotesOther(Request $req){
        if($req->action == 'Save'){
        $OtNote = new OTModel;
        }
        else{
            $OtNote = OTModel::find($req->saveid);   
        }
        $OtNote->PatientId = $req->PatientId; 
        $OtNote->OtPatientId = $req->OtPatientId;
        $OtNote->MrdNo = $req->MrdNo;
        $OtNote->PatientName = $req->PatientName; 
        $OtNote->Age = $req->Age;
        $OtNote->Phone = $req->Phone;
        $OtNote->Address = $req->Address; 
        $OtNote->Gender = $req->Gender;
        $OtNote->Eye = $req->Eye;
        $OtNote->Diagnosis = $req->Diagnosis;
        $OtNote->Bs = $req->Bs; 
        $OtNote->Bp = $req->Bp;
        $OtNote->IopRe = $req->IopRe;
        $OtNote->IopLe = $req->IopLe; 
        $OtNote->Other = $req->Other;
        $OtNote->Category = $req->Category;
        
        $OtNote->Surgeon = $req->Surgeon;
        $OtNote->Assistant = $req->Assistant; 
        $OtNote->Anaethetist = $req->Anaethetist;
        $OtNote->Package = $req->Package;
        $OtNote->SurgeryPerformed = $req->SurgeryPerformed;
        $OtNote->DilatedBy = $req->DilatedBy; 
        $OtNote->AnesthesiaType = $req->AnesthesiaType;
        $OtNote->Draping = $req->Draping;
        $OtNote->Speculum = $req->Speculum; 
        $OtNote->ConjunctivalWash = $req->ConjunctivalWash;
        
        $OtNote->PkgAmt = $req->PkgAmt; 
        $OtNote->InsComp = $req->InsComp;
        $OtNote->ReqAmt = $req->ReqAmt;
        $OtNote->SanctAmt = $req->SanctAmt;
        $OtNote->AddAmt = $req->AddAmt; 
        $OtNote->SettleAmt = $req->SettleAmt;
        $OtNote->SettleDate = $req->SettleDate;
        $OtNote->UtrNo = $req->UtrNo; 
        $OtNote->ProcedureComments = $req->ProcedureComments;
        $OtNote->Remarks = $req->Remarks;
        $OtNote->IolName = $req->IolName;
        $OtNote->IolType = $req->IolType;
        $OtNote->StudyPatient = $req->StudyPatient;
        $OtNote->ConfirmOpto = $req->ConfirmOpto;
        $OtNote->Cyl = $req->Cyl;
        $OtNote->NearAdd = $req->NearAdd;
        $OtNote->PackageAmount = $req->PackageAmount;
        $OtNote->Status = 1;
        $OtNote->CreatedBy = Session::get('UserId'); 
        $OtNote->CreatedDate = $req->CreatedDate;
        $OtNote->Roll = 2;
        $OtNote->save();
        return $OtNote->id;

    }

   

    function printOtNotesOther($id){
        $result = OTModel::find($id);
        return view('/ipd/view-print-ot-notes-other',['data'=>$result]);
    }

}
