<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\MasterController;
use App\Models\OpdAppointmentModel;
use App\Models\UserMaster;
use App\Models\QueueManagement;
use App\Models\PatientModel;
use Session;
class OpdAppointmentController extends Controller
{
    function opdAppointment(){
        $patientList = (new MasterController)->patientList();
        $consultantList = (new MasterController)->consultantList();
        $cityList = (new MasterController)->cityList();
        $stateList = (new MasterController)->stateList();
        return view('/opd/opd-appointment',['patientList'=>$patientList,'consultantList'=>$consultantList,'stateList'=>$stateList,'cityList'=>$cityList]);
    }

    function viewOpdAppointmentList(Request $req){
        $CurrDate = date('Y-m-d');
        if(!empty($req->FromDate))
            {
                $result =  OpdAppointmentModel::select()
                            ->whereBetween('AppointDate', array($req->FromDate, $req->ToDate))->get();  
            }
            else{
        $result = OpdAppointmentModel::select()->where(['AppointDate'=>$CurrDate])->get();
            }
        //return $result;
        return view('opd/viewopdappointmentlists',['data'=>$result]);
    }

    function saveAppointment(Request $req){
            if($req->action == 'EditAppointment'){
                $OpdAppointment = OpdAppointmentModel::find($req->id);
            }
            else{
                $OpdAppointment = new OpdAppointmentModel;   
            }
            if($req->MrdNo == ''){
                $MrdNo = 0;
            }
            else{
                $MrdNo = $req->MrdNo;
            }
            $OpdAppointment->MrdNo = $MrdNo;
            $OpdAppointment->Suffix = $req->Suffix;
            $OpdAppointment->Fname = $req->Fname;
            $OpdAppointment->Mname = $req->Mname;
            $OpdAppointment->Lname = $req->Lname;
            $OpdAppointment->Gender = $req->Gender;
            $OpdAppointment->Age = $req->Age;
            $OpdAppointment->Phone = $req->Phone;
            $OpdAppointment->City = $req->City;
            $OpdAppointment->State = $req->State;
            $OpdAppointment->Address = $req->Address;
            $OpdAppointment->Consultant = $req->Consultant;
            //$result = UserMaster::select('Name')->where('id',$req->Consultant)->first();
            //$ConsultantName = $result->Name;
            //$OpdAppointment->ConsultantName = $ConsultantName;
            $OpdAppointment->Fees = $req->Fees;
            $OpdAppointment->PayMode = $req->PayMode;
            $OpdAppointment->AppointDate = $req->AppointDate;
            $OpdAppointment->AppointTime = $req->AppointTime;
            $OpdAppointment->CreatedBy = 19;
            $OpdAppointment->CreatedDate = date('Y-m-d');
            $OpdAppointment->Flag = 0;
            $OpdAppointment->PatientName = $req->Suffix." ".$req->Fname." ".$req->Mname." ".$req->Lname;
            $OpdAppointment->save();
            return 1;
    }

    function addInQueue(Request $req){
        $id = $req->id;
        OpdAppointmentModel::where('id',$id)->update(['Flag'=>1]);
        $result = OpdAppointmentModel::find($req->id);
        //return $result->MrdNo;
                if($result->MrdNo == 0){
            $Patient = new PatientModel;   
            $Patient->srno = 0;
            $Patient->Suffix = $result->Suffix;
            $Patient->Fname = $result->Fname;
            $Patient->Mname = $result->Mname;
            $Patient->Lname = $result->Lname;
            $Patient->Gender = $result->Gender;
            $Patient->Age = $result->Age;
            $Patient->Phone = $result->Phone;
            $Patient->City = $result->City;
            $Patient->State = $result->State;
            $Patient->Address = $result->Address;
            //$Patient->Consultant = $result->Consultant;
            //$result2 = UserMaster::select('Name')->where('id',$result->Consultant)->first();
            //$ConsultantName = $result2->Name;
          //  $Patient->ConsultantName = $ConsultantName;
            $Patient->Fees = $result->Fees;
            $Patient->PayMode = $result->PayMode;
            $Patient->Status = 1;
            $Patient->CreatedBy = 19;
            $Patient->ModifiedBy = 19;
            $Patient->CreatedDate = date('Y-m-d');
            $Patient->PatientName = $result->Suffix." ".$result->Fname." ".$result->Mname." ".$result->Lname;
            $Patient->save();
            $MrdNo = $Patient->id;
            PatientModel::where('id',$MrdNo)->update(array('MrdNo'=>$MrdNo,'srno'=>$MrdNo)); 
            $PatientType = "New";
        }
        else{
            $MrdNo = $result->MrdNo;
            $PatientType = "Old";
        }
        
        $QueueManagement = new QueueManagement;
        $QueueManagement->MrdNo = $MrdNo;
        $QueueManagement->PatientName = $result->Suffix." ".$result->Fname." ".$result->Mname." ".$result->Lname;
        $QueueManagement->PatientType = $PatientType;
        $QueueManagement->Age = $result->Age;
        $QueueManagement->Gender = $result->Gender;
        $QueueManagement->InDate = $result->AppointDate;
        $QueueManagement->InTime = $result->AppointTime;
        // $QueueManagement->Consultant = $result->Consultant;
        // $result2 = UserMaster::select('Name')->where('id',$result->Consultant)->first();
        // $ConsultantName = $result2->Name;
        // $QueueManagement->ConsultantName = $ConsultantName;
        $QueueManagement->Amount = $result->Fees;
        $QueueManagement->PayMode = $result->PayMode;
        $QueueManagement->Status = 1;
        $QueueManagement->Appointment = 1;
        $QueueManagement->CreatedBy = 19;
        $QueueManagement->ModifiedBy = 19;
        //$maxid = QueueManagement::select()->where(['MrdNo'=>$result->MrdNo])->max('VisitNo');
        //$VisitNo = $maxid+1;
        //$QueueManagement->VisitNo = $VisitNo;
        $QueueManagement->save();
        //return $QueueManagement->id;
        OpdAppointmentModel::where('id',$id)->update(['MrdNo'=>$MrdNo]);
    }

    function checkTime($appdate,$apptime){
        $cnt = OpdAppointmentModel::where(['AppointDate'=>$appdate,'AppointTime'=>$apptime])->count();
        return $cnt;
    }

    function getAppTime(Request $req){
        $AppointDate = $req->CurrDate;
        $output = '';
        $output.='<option value="" disabled="" selected="">Select Appointment Time</option>';
         for($h=10; $h<18; $h++){
    for($i=0; $i<60; $i=$i+15){
      $time = date('h:i a',strtotime($h.':'.$i));
      $time2 = date('H:i:s',strtotime($h.':'.$i));
      $chktime = $this->checkTime($AppointDate,$time2);
      if($chktime > 0){} else{
        $output.='<option value="'.$time2.'">'.$time.'</option>';
}
}
}

$output.='<option value="06:00:00">06:00 pm</option>';
return $output;
}
}