<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\OpdExpenseModel;
use App\Http\Controllers\MasterController;
use App\Models\ProcedureModel;
use Session;

class OpdExpenseController extends Controller
{
    function OpdReceipt(){
        $patientList = (new MasterController)->patientList();
        $today = $this->todayOpdReceipt();
        $total = $this->totalOpdReceipt();
        return view('/opd/view-opd-expense',['today'=>$today,'total'=>$total]);
    }

    function viewOpdReceipts(Request $req){
        $CurrDate = date('Y-m-d');
        if(!empty($req->FromDate))
            {
                $result =  OpdExpenseModel::select()->whereBetween('CreatedDate', array($req->FromDate, $req->ToDate))->get();  
            }
            else{
                $result =  OpdExpenseModel::select()->where(['CreatedDate'=>$CurrDate])->get();  
                //$result =  OpdExpenseModel::select()->get();  
            }
        return view('opd/incopdexpenses',['data'=>$result]);
    }

    function fetchOpdReceiptRecord(Request $req){
        $result = OpdExpenseModel::find($req->id);
        echo json_encode($result);
    }

    function deleteOpdReceipt(Request $req){
        OpdExpenseModel::where(['id'=>$req->id])->delete();
        $today = $this->todayOpdReceipt();
        $total = $this->totalOpdReceipt();
        echo json_encode(array('status'=>'1','today'=>$today,'total'=>$total)); 
    }
    function saveOpdReceipt(Request $req){
            $CurrDate = date('Y-m-d');
            if($req->action == 'Save'){
            $OpdReceipt = new OpdExpenseModel;
            }
            else{
            $OpdReceipt = OpdExpenseModel::find($req->id);
            }
            //$OpdReceipt->MrdNo = $req->MrdNo;
            //$OpdReceipt->PatientId = $req->PatientId;
            //$OpdReceipt->PatientName = $req->PatientName;
            $OpdReceipt->PayMode = 'Cash';
            $OpdReceipt->ChequeNo = $req->ChequeNo;
            $OpdReceipt->Narration = $req->Narration;
            if($req->ProcedureId != ''){
            $Procedure = implode(",",$req->ProcedureId);
            $OpdReceipt->Procedures = $Procedure;
            }
            // $number = count($req->ProcedureChk);
            // if($number > 0){
            //     //$ProcAmount = ProcedureModel::select('Amount')->whereIn('id',array($Procedure))->sum('Amount');
            //     $result = DB::select("SELECT SUM(Amount) As Amount FROM tbl_procedures WHERE id IN($Procedure)");
            //     $ProcAmount = $result[0]->Amount;
            // }
            $OpdReceipt->Amount = $req->Amount;
            //$OpdReceipt->ConsultantId = $req->ConsultantId;
            //$OpdReceipt->Consultant = $req->Consultant;
            $OpdReceipt->Status = 1;
            $OpdReceipt->CreatedBy = 19;
            $OpdReceipt->CreatedDate = $req->CreatedDate;
            $OpdReceipt->save();
            $postid = $OpdReceipt->id;
            $today = $this->todayOpdReceipt();
            $total = $this->totalOpdReceipt();
            return json_encode(array('status'=>1,'today'=>$today,'total'=>$total,'id'=>$postid));
    }

    function todayOpdReceipt(){
        $CurrDate = date('Y-m-d');
        $rncnt =  OpdExpenseModel::where(['CreatedDate'=>$CurrDate])->count();
        return $rncnt;
    }

    function totalOpdReceipt(){
        $rncnt =  OpdExpenseModel::count();
        return $rncnt;
    }

    function getProcRec(Request $req){
        $result = ProcedureModel::where('Type',2)->get();
        return view('/opd/inc-opd-expense-procedure',['data'=>$result]);
    }   

    function getProcRec2(Request $req){
        $result2 = OpdExpenseModel::select('Procedures')->where('id',$req->id)->get();
        $Procedures = $result2[0]->Procedures;
        $result = DB::select("SELECT * FROM tbl_procedures WHERE Type=2 AND id NOT IN($Procedures)");
        //$result3 = ProcedureModel::select()->whereIn('id',[$Procedures])->get();
        $result3 = DB::select("SELECT * FROM tbl_procedures WHERE Type=2 AND id IN($Procedures)");
        //$result = DB::select("SELECT * FROM tbl_procedures WHERE id IN($Procedures)");
        return view('/opd/inc-opd-expense-procedure2',['data2'=>$result3,'data'=>$result,'Procedures'=>$Procedures]);
    } 

    function getProcedureNames($procid){
        $result = DB::select("SELECT GROUP_CONCAT(Name) As ProcedureName FROM tbl_procedures WHERE Type=2 AND id IN($procid)");
        $ProcedureName = $result[0]->ProcedureName;
        return $ProcedureName;
    }

    function opdReceiptPrint($id){
        $result =  OpdExpenseModel::select()->where('id',$id)->get();
        $ProId = $result[0]->Procedures;
        $result2 = DB::select("SELECT GROUP_CONCAT(Name) As ProcedureName FROM tbl_procedures WHERE Type=2 AND id IN($ProId)");
        $ProcedureName = $result2[0]->ProcedureName;
        return view('/opd/opd-expense-print',['result'=>$result,'ProcedureName'=>$ProcedureName]);
    }

    function useOpdReceipt($id){
        $result =  OpdExpenseModel::select()->whereIn('Procedures',[$id])->toSql();
        return $result;
    }
}