<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\OpdReceiptModel;
use App\Http\Controllers\MasterController;
use App\Models\ProcedureModel;
use App\Models\PatientBalanceModel;
use Session;

class OpdReceiptController extends Controller
{
    function OpdReceipt(){
        //$patientList = (new MasterController)->patientList();
        $today = $this->todayOpdReceipt();
        $total = $this->totalOpdReceipt();
        $procedures = ProcedureModel::where('Type',1)->get();
        return view('/opd/view-opd-receipt',['today'=>$today,'total'=>$total,'procedures'=>$procedures]);
    }

    function viewOpdReceipts(Request $req){
        $CurrDate = date('Y-m-d');
        $Procedures = $req->SrchProcedures;
        $SrchPayMode = $req->SrchPayMode;
        if(!empty($req->FromDate))
            {

                $sql = "SELECT *  From tbl_opd_receipts WHERE Status=1 AND CreatedDate>='$req->FromDate' AND CreatedDate<='$req->ToDate'";
                if($Procedures != ''){
                    $sql.= " AND Procedures = '$Procedures'";
                }
                if($SrchPayMode != ''){
                    $sql.= " AND PayMode = '$SrchPayMode'";
                }
                $result = DB::select($sql);

                $sql2 = "SELECT SUM(Amount) AS Amount  From tbl_opd_receipts WHERE Status=1 AND CreatedDate>='$req->FromDate' AND CreatedDate<='$req->ToDate'";
                if($Procedures != ''){
                    $sql2.= " AND Procedures = '$Procedures'";
                }
                if($SrchPayMode != ''){
                    $sql2.= " AND PayMode = '$SrchPayMode'";
                }
                $result2 = DB::select($sql2);
                $total = $result2[0]->Amount;

                // if($Procedures==''){
                //     $result =  OpdReceiptModel::select()->whereBetween('CreatedDate', array($req->FromDate, $req->ToDate))->where(['PayMode'=>$SrchPayMode])->get();  
                // }
                // else{
                //     if($SrchPayMode == ''){
                //         $result =  OpdReceiptModel::select()->whereBetween('CreatedDate', array($req->FromDate, $req->ToDate))->where(['Procedures'=>$Procedures])->get();  
                //     }
                //     else{
                //         $result =  OpdReceiptModel::select()->whereBetween('CreatedDate', array($req->FromDate, $req->ToDate))->where(['Procedures'=>$Procedures,'PayMode'=>$SrchPayMode])->get();  
                //     }
                    
                // }
            }
            else{
                $result =  OpdReceiptModel::select()->where(['CreatedDate'=>$CurrDate])->get();  
                //$result =  OpdReceiptModel::select()->get();  
                $total = $result->sum('Amount');
            }

            //
            
        return view('opd/incopdreceipts',['data'=>$result,'total'=>$total]);
    }

    function fetchOpdReceiptRecord(Request $req){
        $result = OpdReceiptModel::find($req->id);
        echo json_encode($result);
    }

    function deleteOpdReceipt(Request $req){
        OpdReceiptModel::where(['id'=>$req->id])->delete();
        $today = $this->todayOpdReceipt();
        $total = $this->totalOpdReceipt();
        echo json_encode(array('status'=>'1','today'=>$today,'total'=>$total)); 
    }
    function saveOpdReceipt(Request $req){
        $CurrDate = date('Y-m-d');
        if($req->action == 'Save'){
        $OpdReceipt = new OpdReceiptModel;
        }
        else{
        $OpdReceipt = OpdReceiptModel::find($req->id);
        }
        $OpdReceipt->MrdNo = $req->MrdNo;
        $OpdReceipt->PatientId = $req->PatientId;
        $OpdReceipt->PatientName = $req->PatientName;
        $OpdReceipt->PayMode = $req->PayMode;
        $OpdReceipt->ChequeNo = $req->ChequeNo;
        $OpdReceipt->Narration = $req->Narration;
        $OpdReceipt->Procedures = $req->Procedures;
        $OpdReceipt->CountAmt = $req->CountAmt;
        // if($req->ProcedureId != ''){
        // $Procedure = implode(",",$req->ProcedureId);
        // $OpdReceipt->Procedures = $Procedure;
        // }
        // $number = count($req->ProcedureChk);
        // if($number > 0){
        //     //$ProcAmount = ProcedureModel::select('Amount')->whereIn('id',array($Procedure))->sum('Amount');
        //     $result = DB::select("SELECT SUM(Amount) As Amount FROM tbl_procedures WHERE id IN($Procedure)");
        //     $ProcAmount = $result[0]->Amount;
        // }
        $OpdReceipt->Amount = $req->Amount;
        $OpdReceipt->ConsultantId = $req->ConsultantId;
        $OpdReceipt->Consultant = $req->Consultant;
        $OpdReceipt->Status = 1;
        $OpdReceipt->CreatedBy = Session::get('UserId');
        $OpdReceipt->CreatedDate = $req->CreatedDate;
        $OpdReceipt->save();
        $postid = $OpdReceipt->id;
        $today = $this->todayOpdReceipt();
        $total = $this->totalOpdReceipt();

        $Package = new ProcedureModel;
        $cnt=ProcedureModel::Where(['Name'=>$req->Procedures,'Type'=>1])->count();
        if($cnt>0){}
        else{
            $Package->Name = $req->Procedures; 
            $Package->Amount = $req->Amount;
            $Package->Type = 1;
            $Package->CountAmt = $req->CountAmt;
            $Package->Status = 1;
            $Package->CreatedBy = 19;
            $Package->ModifiedBy = 19;
            $Package->save();
        }

        if($req->pageval == 'ptbal'){
            PatientBalanceModel::find($req->ptbalid)->delete();
        }
        return json_encode(array('status'=>1,'today'=>$today,'total'=>$total,'id'=>$postid));
    }

    function todayOpdReceipt(){
        $CurrDate = date('Y-m-d');
        $rncnt =  OpdReceiptModel::where(['CreatedDate'=>$CurrDate])->count();
        return $rncnt;
    }

    function totalOpdReceipt(){
        $rncnt =  OpdReceiptModel::count();
        return $rncnt;
    }

    function getProcRec(Request $req){
        $result = ProcedureModel::where('Type',1)->get();
        return view('/opd/inc-opd-receipt-procedure',['data'=>$result]);
    }   

    function getProcRec2(Request $req){
        $result2 = OpdReceiptModel::select('Procedures')->where('id',$req->id)->get();
        $Procedures = $result2[0]->Procedures;
        $result = DB::select("SELECT * FROM tbl_procedures WHERE Type=1 AND id NOT IN($Procedures)");
        //$result3 = ProcedureModel::select()->whereIn('id',[$Procedures])->get();
        $result3 = DB::select("SELECT * FROM tbl_procedures WHERE Type=1 AND id IN($Procedures)");
        //$result = DB::select("SELECT * FROM tbl_procedures WHERE id IN($Procedures)");
        return view('/opd/inc-opd-receipt-procedure2',['data2'=>$result3,'data'=>$result,'Procedures'=>$Procedures]);
    } 

    function getProcedureNames($procid){
        //return $procid;
        $result = DB::select("SELECT GROUP_CONCAT(Name) As ProcedureName FROM tbl_procedures WHERE Type=1 AND id IN($procid)");
        // $result = DB::table('tbl_procedures')
        //     ->selectRaw('GROUP_CONCAT(Name) As ProcedureName')
        //     ->whereIn('id',[$procid])
        //     ->get();
        $ProcedureName = $result[0]->ProcedureName;
        return $ProcedureName;
    }

    function opdReceiptPrint($id){
        $result =  OpdReceiptModel::select()->where('id',$id)->get();
        // $ProId = $result[0]->Procedures;
        // $result2 = DB::select("SELECT GROUP_CONCAT(Name) As ProcedureName FROM tbl_procedures WHERE Type=1 AND id IN($ProId)");
        // $ProcedureName = $result2[0]->ProcedureName;
        $ProcedureName = $result[0]->Procedures;
        return view('/opd/opd-receipt-print',['result'=>$result,'ProcedureName'=>$ProcedureName]);
    }

    function useOpdReceipt($id){
        $result =  OpdReceiptModel::select()->whereIn('Procedures',[$id])->toSql();
        return $result;
    }
}