<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\OtScheduledModel;
use App\Http\Controllers\MasterController;
use App\Http\Controllers\PackageController;
use App\Models\MedicineModel;
use Session;
class OtScheduledController extends Controller
{
   function OtScheduled(){
    $otschid = $this->getOtSchId();
    //$patientList = (new MasterController)->patientList();
    $packagelist = (new PackageController)->packageList();
    return view('/ipd/add-ot-scheduled',['packagelist'=>$packagelist,'otschid'=>$otschid,]);
   }
   function getOtSchId(){
        $result = OtScheduledModel::select()->orderBy('id','desc')->get();
        return $result;
   }

   function saveOtScheduled(Request $req){
    if($req->action == 'Save'){
        $OtScheduled = new OtScheduledModel;
        $OtScheduled->CreatedBy = Session::get('UserId');
        $OtScheduled->CreatedDate = date('Y-m-d');
        }
        else{
        $OtScheduled = OtScheduledModel::find($req->id); 
        $OtScheduled->ModifiedBy = Session::get('UserId');
        $OtScheduled->ModifiedDate = date('Y-m-d');  
        }
        $OtScheduled->PatientId = $req->PatientId;
        $OtScheduled->MrdNo = $req->MrdNo;
        $OtScheduled->PatientName = $req->PatientName;
        $OtScheduled->ScheduleDate = $req->ScheduleDate;
        $OtScheduled->Phone = $req->Phone;
        $OtScheduled->Age = $req->Age;
        $OtScheduled->Address = $req->Address;
        $OtScheduled->Gender = $req->Gender;
        $OtScheduled->Eye = $req->Eye;
        $OtScheduled->K1Re = $req->K1Re;
        $OtScheduled->K1Le = $req->K1Le;
        $OtScheduled->K2Re = $req->K2Re;
        $OtScheduled->K2Le = $req->K2Le;
        $OtScheduled->Diff = $req->Diff;
        $OtScheduled->Category = $req->Category;
        $OtScheduled->IolPower = $req->IolPower;
        $OtScheduled->Aconstant = $req->Aconstant;
        $OtScheduled->Diagnosis = $req->Diagnosis;
        $OtScheduled->Ga = $req->Ga;
        $OtScheduled->Amount = $req->Amount;
        $OtScheduled->Bs = $req->Bs;
        $OtScheduled->Us = $req->Us;
        $OtScheduled->Bp = $req->Bp;
        $OtScheduled->Package = $req->Package;
        $OtScheduled->IopRe = $req->IopRe;
        $OtScheduled->IopLe = $req->IopLe;
        $OtScheduled->Advice = $req->Advice;
        $OtScheduled->PkgAmt = $req->PkgAmt;
        $OtScheduled->InsComp = $req->InsComp;
        $OtScheduled->ReqAmt = $req->ReqAmt;
        $OtScheduled->SanctAmt = $req->SanctAmt;
        $OtScheduled->AddAmt = $req->AddAmt;
        $OtScheduled->SettleAmt = $req->SettleAmt;
        $OtScheduled->SettleDate = $req->SettleDate;
        $OtScheduled->UtrNo = $req->UtrNo;
        $OtScheduled->AL = $req->AL;
        $OtScheduled->Acd = $req->Acd;
        $OtScheduled->Consultant = $req->Consultant;
        $OtScheduled->IolType = $req->IolType;
        $OtScheduled->Cyl = $req->Cyl;
        $OtScheduled->LT = $req->LT;
        $OtScheduled->Wtw = $req->Wtw;
        $OtScheduled->IolName = $req->IolName;
        $OtScheduled->AddIol = $req->AddIol;
        $OtScheduled->Language = $req->Language;
        if($req->PostPone == 1){
        $OtScheduled->PostPone = 1;
        }
        else{
          $OtScheduled->PostPone = 0;
        }
       
        $OtScheduled->Status = 1;
        $cnt = DB::table('tbl_fixed_date')->where('FixedDate',$req->ScheduleDate)->count();
        if($cnt > 0){
        return 0;
        }
        else{
          $OtScheduled->save();
        return 1;
        }
        

   }

   function getOtSchDetails(Request $req){
    $result = OtScheduledModel::where('id',$req->id)->orderBy('id','desc')->first(); 
    $cnt = OtScheduledModel::where('id',$req->id)->count(); 
    if($cnt > 0){
        return json_encode($result);
    }
    else{
        return 0;
    }
    
   }

   function getMaxSchId(Request $req){
    // $result = DB::select("SELECT AUTO_INCREMENT FROM information_schema.TABLES WHERE TABLE_SCHEMA = 'vyawaharehosp' AND TABLE_NAME = 'tbl_otscheduled'");
    // $max_id = $result[0]->AUTO_INCREMENT;
    // return $max_id;
    $max_id = OtScheduledModel::max('id');
    $MaxId = $max_id+1;
    return $MaxId;
   }

   function viewOtScheduleList(Request $req){
        $ToDate = $req->ToDate;
        $FromDate = $req->FromDate;
        $result = OtScheduledModel::whereBetween('ScheduleDate', array($FromDate, $ToDate))->where('PostPone','0')->get();
        return view('/ipd/view-ot-scheduled',['data'=>$result]);
   }

   function otSchList($ScheduleDate){
    $result = OtScheduledModel::whereBetween('ScheduleDate', array($ScheduleDate, $ScheduleDate))->where('PostPone','0')->get();
    return view('/ipd/view-ot-scheduled-lists',['data'=>$result,'ScheduleDate'=>$ScheduleDate]);
   }

   function deleteOtSchedule(Request $req){
    OtScheduledModel::find($req->id)->delete();
    return 1;
   }

   function preOptNotes($id){
    $result = OtScheduledModel::where('id',$id)->first();
    return view('/ipd/print-pre-operative-notes',['data'=>$result]);
   }
   function printSurgicalPres($id){
     $result = DB::table('tbl_surgical_medicines as ts')
               ->leftJoin('tbl_otscheduled as tc', 'tc.id', '=', 'ts.OtSchId')
               ->leftJoin('tbl_medicines as tm', 'tm.id', '=', 'ts.MedId')
               ->select('ts.*','tc.*','tm.*')
               ->where('ts.OtSchId',$id)
               ->orderBy('ts.id','asc')->get();
               //return $result;
     $total = $result->sum('Amount');          
    return view('/ipd/print-surgical-pres',['data'=>$result,'total'=>$total]);
   }

   function fixedDate(Request $req){
      $FixedDate = $req->FixedDate;
      $data=array('FixedDate'=>$FixedDate);
      DB::table('tbl_fixed_date')->where('FixedDate',$FixedDate)->delete();
      $result = DB::table('tbl_fixed_date')->insert($data);
      echo 1;
   }

   function surgicalPrescLists(Request $req){
        $result = MedicineModel::all();
        return view('/ipd/incsurgicalpreslists',['data'=>$result]);
   }

   function saveSurgicalPres(Request $req){
    $ProcId = $req->ProcId;
    $OtSchId = $req->id;
    DB::table('tbl_surgical_medicines')->where('OtSchId',$req->id)->delete();
    $result = DB::select("INSERT INTO tbl_surgical_medicines (OtSchId,MedId,Amount) SELECT '$OtSchId',id,Amount FROM tbl_medicines WHERE id IN ($ProcId)");
    return 1;
   }

   function getSurgTotAmount(Request $req){
    $ProcId = $req->ProcId;
    $result = DB::select("SELECT SUM(Amount) As Amount FROM tbl_medicines WHERE id IN ($ProcId)");
    return $result[0]->Amount;
   }

   function viewOtSchedulePostPoneList(Request $req){
     $ToDate = $req->ToDate;
     $FromDate = $req->FromDate;
     $result = OtScheduledModel::where('PostPone','1')->get();
     //return $result;
     return view('/ipd/view-postpone-ot-scheduled',['data'=>$result]);
   }

   function updateOperationDate(Request $req){
     $OperationDate = $req->OperationDate;
     $number = count($req->chechvalue);
     if($number > 0)  
     {  
        for($i=0; $i<$number; $i++)  
          {  
            if(trim($req->chechvalue[$i] != '0'))  
              {
                    $otid = $req->otid[$i];
                    OtScheduledModel::where(['id'=>$otid])->update(['ScheduleDate'=>$OperationDate,'PostPone'=>0]);     
              }
          }
     }

     return 1;
   }

   function viewOtSchLists(){
    return view('/ipd/view-all-ot-scheduled-list');

   }
}