<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\OtherReceiptModel;
use App\Http\Controllers\MasterController;
use App\Models\OTModel;
use App\Models\ProcedureModel;
use App\Models\DischargeModel;
use App\Models\DischargeOtherModel;
use App\Models\OTNoteOtherModel;
use Session;

class OtherReceiptController extends Controller
{
    function OtherReceipt(){
        $today = $this->todayOtherReceipt();
        $total = $this->totalOtherReceipt();
        $procedures = ProcedureModel::where('Type',1)->get();
        return view('/utility/view-other-receipt',['procedures'=>$procedures,'today'=>$today,'total'=>$total]);
    }

   
    
    function viewOtherReceipts(Request $req){
        $CurrDate = date('Y-m-d');
        $SrchPayMode = $req->SrchPayMode;
        if(!empty($req->FromDate))
            {

                $sql = "SELECT *  From tbl_other_receipts WHERE Status=1 AND CreatedDate>='$req->FromDate' AND CreatedDate<='$req->ToDate'";
                if($SrchPayMode != ''){
                    $sql.= " AND PayMode = '$SrchPayMode'";
                }
                $result = DB::select($sql);

                $sql2 = "SELECT SUM(Amount) AS Amount  From tbl_other_receipts WHERE Status=1 AND CreatedDate>='$req->FromDate' AND CreatedDate<='$req->ToDate'";
                if($SrchPayMode != ''){
                    $sql2.= " AND PayMode = '$SrchPayMode'";
                }
                $result2 = DB::select($sql2);
                $total = $result2[0]->Amount;

            }
            else{
                $result =  OtherReceiptModel::select()->where(['CreatedDate'=>$CurrDate])->get();  
                $total = $result->sum('Amount');
            }
        return view('utility/incotherreceipts',['data'=>$result,'total'=>$total]);
    }
    function fetchOtherReceiptRecord(Request $req){
        $result = OtherReceiptModel::find($req->id);
        echo json_encode($result);
    }

    function deleteOtherReceipt(Request $req){
        OtherReceiptModel::where(['id'=>$req->id])->delete();
        $today = $this->todayOtherReceipt();
        $total = $this->totalOtherReceipt();
        echo json_encode(array('status'=>'1','today'=>$today,'total'=>$total)); 
    }
    function saveOtherReceipt(Request $req){
            $CurrDate = date('Y-m-d');
            if($req->action == 'Save'){
            $IpdReceipt = new OtherReceiptModel;
            }
            else{
            $IpdReceipt = OtherReceiptModel::find($req->id);
            }
            $IpdReceipt->MrdNo = $req->MrdNo;
            $IpdReceipt->IpdNo = $req->IpdNo;
            $IpdReceipt->PatientName = $req->PatientName;
            $IpdReceipt->Procedures = $req->Procedures;
            $IpdReceipt->Amount = $req->Amount;
            $IpdReceipt->PayMode = $req->PayMode;
            $IpdReceipt->ChequeNo = $req->ChequeNo;
            $IpdReceipt->Narration = $req->Narration;
            $IpdReceipt->AdmissionDate = $req->AdmissionDate;
            $IpdReceipt->AdmissionTime = $req->AdmissionTime;
            $IpdReceipt->DepositDate = $req->DepositDate;
            $IpdReceipt->DepositTime = $req->DepositTime;
            $IpdReceipt->ChqDate = $req->ChqDate;
            $IpdReceipt->ChqDep = $req->ChqDep;
            $IpdReceipt->Status = 1;
            $IpdReceipt->CreatedBy = 19;
            $IpdReceipt->CreatedDate = $req->CreatedDate;
            $IpdReceipt->ReceiptNo = $req->ReceiptNo;
            $IpdReceipt->BankName = $req->BankName;
            $IpdReceipt->BranchName = $req->BranchName;
            $IpdReceipt->AccountNo = $req->AccountNo;
            $IpdReceipt->AccountHolder = $req->AccountHolder;
            $IpdReceipt->save();
            $postid = $IpdReceipt->id;
            $today = $this->todayOtherReceipt();
            $total = $this->totalOtherReceipt();
            return json_encode(array('status'=>1,'today'=>$today,'total'=>$total,'id'=>$postid));
    }

    function todayOtherReceipt(){
        $CurrDate = date('Y-m-d');
        $rncnt =  OtherReceiptModel::where(['CreatedDate'=>$CurrDate])->count();
        return $rncnt;
    }

    function totalOtherReceipt(){
        $rncnt =  OtherReceiptModel::count();
        return $rncnt;
    }

    function otherReceiptPrint($id){
        $result =  OtherReceiptModel::select()->where('id',$id)->get();
        $ProcedureName = $result[0]->Procedures;
        return view('/utility/other-receipt-print',['result'=>$result,'ProcedureName'=>$ProcedureName]);
    }

    function getOtherReceiptNo(Request $req){
        $maxid = OtherReceiptModel::select('id')->max('id');
        $curryr = substr(date('Y'), -2);
        $currmonth = date('m');
        if($maxid == 0 || $maxid == ''){
            $maxid = "1/".($curryr-1)."-".$curryr."/".$currmonth;
        }
        else{
            $maxid2 = $maxid + 1;
            $maxid = "".$maxid2."/".($curryr-1)."-".$curryr."/".$currmonth;
        }
        return $maxid;
       
    }
}
