<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\ProcedureModel;
use Session;
class ProcedureController extends Controller
{
    function procedure(){
        return view('masters/procedure');
    }
    function viewProcedureList(Request $req){
        $result = ProcedureModel::all();
        return view('masters/viewprocedurelist',['data'=>$result]);
    }

    function saveProcedure(Request $req){
        if($req->action == 'Save'){
            $Package = new ProcedureModel;
        }
        else{
            $Package = ProcedureModel::find($req->id);
        }
        $Package->Name = $req->Name; 
        $Package->Amount = $req->Amount;
        $Package->Type = $req->Type;
        $Package->CountAmt = $req->CountAmt;
        $Package->Status = 1;
        $Package->CreatedBy = 19;
        $Package->ModifiedBy = 19;
        $Package->save();
        return 1;
    }

    function editProcedure(Request $req){
        $data = ProcedureModel::find($req->id);
        return json_encode($data);
    }

    function deleteProcedure(Request $req){
        $data=ProcedureModel::find($req->id)->delete();
        return 1;
    }

    function getProcedureDetails(Request $req){
        $data=ProcedureModel::select('Amount','CountAmt')->Where(['Name'=>$req->val,'Type'=>1])->first();
        return json_encode($data);
    }
}
