<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\QueueManagement;
use App\Models\PatientModel;
use App\Models\VisitModel;
use App\Models\OptoModel;
use App\Models\OTModel;
use App\Models\ConsultantModel;
use App\Models\UserMaster;
use App\Models\PatientBalanceModel;
use Session;
use DataTables;
use App\Http\Controllers\MasterController;
class QueueController extends Controller
{
    function maxMrdNo(){
        $result = PatientModel::max('MrdNo');
        if($result == 0){
            $NewMrdNo = 1;
        }
        else{
            $NewMrdNo = $result + 1;
        }
        return $NewMrdNo;
    }
    function queuemanagement(){
        $totalPatient = $this->totalPatient();
        $totalCheckPatient = $this->totalCheckPatient();
        //$queuelist = $this->queuelist();
        $consultantList = (new MasterController)->consultantList();
        $cityList = (new MasterController)->cityList();
        $stateList = (new MasterController)->stateList();
        $patientList = (new MasterController)->patientList();
        $totalUncheckPatient = $totalPatient - $totalCheckPatient;
        $NewMrdNo = $this->maxMrdNo();
        return view('opd/queuemanagement',['NewMrdNo'=>$NewMrdNo,'patientList'=>$patientList,'stateList'=>$stateList,'cityList'=>$cityList,'consultantList'=>$consultantList,'totalPatient'=>$totalPatient,'totalCheckPatient'=>$totalCheckPatient,'totalUncheckPatient'=>$totalUncheckPatient]);
    }

    function getPatientList(Request $req){
        $Patient_Name = $req->Patient_Name;
        $query = DB::select("SELECT * FROM tbl_patients WHERE (Fname LIKE '$Patient_Name%' 
                 OR Mname LIKE '$Patient_Name%' 
                 OR Lname LIKE '$Patient_Name%' 
                 OR PatientName LIKE '$Patient_Name%' 
                 OR Phone LIKE '$Patient_Name%') LIMIT 10");
        return view('opd/viewoldptlists',['data'=>$query]);
        
    }
    function viewQueueList(Request $request){
        $CurrDate = date('Y-m-d');
        if(!empty($request->FromDate))
            {
                $result =  DB::table('tbl_queue_managements as tq')
                ->leftJoin('tbl_users as tu', 'tu.id', '=', 'tq.Consultant')
                ->leftJoin('tbl_patients as tp', 'tp.MrdNo', '=', 'tq.MrdNo')
                ->leftJoin('tbl_users as tu2', 'tu2.id', '=', 'tq.ConfirmConsult')
                ->leftJoin('tbl_users as tu3', 'tu3.id', '=', 'tq.ConfirmOpto')
                ->where('InDate',$request->FromDate)
                ->select('tq.*','tp.Phone','tu2.Name As Consultant','tu3.Name As Opto')
                ->orderBy('tq.InTime','asc')->get();
            }
            else{
        $result = DB::select("SELECT tq.*,tp.Phone,tu2.Name As Consultant,tu3.Name As Opto FROM tbl_queue_managements tq 
                    LEFT JOIN tbl_users tu ON tq.Consultant=tu.id 
                    LEFT JOIN tbl_patients tp ON tp.MrdNo=tq.MrdNo 
                    LEFT JOIN tbl_users tu2 ON tq.ConfirmConsult=tu2.id 
                    LEFT JOIN tbl_users tu3 ON tq.ConfirmOpto=tu3.id 
                    WHERE Checked=0 AND tq.InDate='$CurrDate' ORDER BY tq.InTime");
            }
        //return $result;
       
        return view('opd/viewqueuelists',['data'=>$result]);
    }
    function checkOtPatient($mrdno){
        //return $mrdno;
        // $result =   DB::select("SELECT CreatedDate FROM tbl_ot_notes WHERE MrdNo='$mrdno' ORDER BY id DESC LIMIT 1");
        // $CreatedDate = $result[0]->CreatedDate;
        // if($CreatedDate == ''){
        //     $otdate = "";
        // }
        // else{
        //     $dt = strtotime($result[0]->CreatedDate);
        //     $otdate = date('Y-m-d', strtotime('+2 month', $dt));
        //     //return $result[0]->CreatedDate;
        // }
        // return $otdate;
        $result = OTModel::select('CreatedDate')->where('MrdNo',$mrdno)->orderBy('id','DESC')->limit(1)->get();

        $cnt = $result->count();
            if($cnt > 0){
                $dt = strtotime($result[0]->CreatedDate);
                $otdate = date('Y-m-d', strtotime('+2 month', $dt));
            }
            else{
                $otdate = "";
            }
            return $otdate;
    }
    function checkOtStudyPatient($mrdno){
        // $result =   DB::select("SELECT StudyPatient FROM tbl_ot_notes WHERE MrdNo='$mrdno' ORDER BY id DESC LIMIT 1");
        // $StudyPatient = $result[0]->StudyPatient;
        // if($StudyPatient == ""){
        //     $study = "";
        // }
        // else{
        //     $study = $result[0]->StudyPatient;
        // }
        // return $study;
        $result = OTModel::select('StudyPatient')->where('MrdNo',$mrdno)->orderBy('id','DESC')->limit(1)->get();
        $cnt = $result->count();
            if($cnt > 0){
                $study = $result[0]->StudyPatient;
            }
            else{
                $study = "";
            }
            return $study;
    }
    function queuelist(Request $request){
        $CurrDate = date('Y-m-d');
        //$query = QueueManagement::select()->where(['InDate'=>$CurrDate])->get();
        //$query = DB::select("SELECT tq.*,tu.Name AS Consultant_Name FROM tbl_queue_managements tq LEFT JOIN tbl_users tu ON tq.Consultant=tu.id WHERE Checked is null AND tq.InDate='$CurrDate'");
        //return $query;
        if ($request->ajax()) {
            if(!empty($request->FromDate))
            {
                $data =  DB::table('tbl_queue_managements as tq')
                ->leftJoin('tbl_users as tu', 'tu.id', '=', 'tq.Consultant')
                ->whereBetween('InDate', array($request->FromDate, $request->ToDate))
                 ->select('tq.id','tq.MrdNo','tq.PatientName','tq.Gender','tq.PatientType','tq.PatientType','tu.Name AS Consultant_Name','tq.InTime','tq.Age','tq.Amount')
                 ->orderBy('tq.InDate','desc')->get();
                // $data = PatientModel::select('id','MrdNo','PatientName','Gender','ConsultantName','Age','Fees')
                // ->whereBetween('created_at', array($request->InDate, $request->InDate))->get();   
            }
            else{
            $data = DB::select("SELECT tq.id,tq.MrdNo,tq.PatientName,tq.Gender,tq.PatientType,tq.PatientType,tu.Name AS Consultant_Name,tq.InTime,tq.Age,tq.Amount FROM tbl_queue_managements tq LEFT JOIN tbl_users tu ON tq.Consultant=tu.id WHERE Checked is null AND tq.InDate='$CurrDate'");
            }
            //$data = PatientModel::select('id','MrdNo','PatientName','Gender','ConsultantName','Age','Fees')->limit(10000)->get();
            return Datatables::of($data)
         
                    ->addIndexColumn()
                    ->addColumn('action', function($row){
     
                           $btn = '<a href="javascript:void(0)" class="edit btn btn-primary btn-sm">View</a>';
    
                            return $btn;
                    })
                    ->addColumn('srno')
                    ->rawColumns(['action','srno'])
                    ->make(true);
        }
        return view('opd/queuemanagement');
    }

    function totalPatient(){
        $CurrDate = date('Y-m-d');
        $count = QueueManagement::select()->where(['InDate'=>$CurrDate])->count();
        return $count;
    }
    function totalCheckPatient(){
        $CurrDate = date('Y-m-d');
        $count = QueueManagement::select()->where(['InDate'=>$CurrDate,'Checked'=>'1'])->count();
        return $count;
    }

    function saveQueue(Request $req){
        $Patient = new PatientModel;   
        $Patient->srno = 0;
        $Patient->Suffix = $req->Suffix;
        $Patient->Fname = $req->Fname;
        $Patient->Mname = $req->Mname;
        $Patient->Lname = $req->Lname;
        $Patient->Gender = $req->Gender;
        $Patient->Dob = $req->Dob;
        $Patient->Age = $req->Age;
        $Patient->Phone = $req->Phone;
        $Patient->Phone2 = $req->Phone2;
        $Patient->City = $req->City;
        $Patient->State = $req->State;
        $Patient->Address = $req->Address;
        $Patient->Consultant = $req->Consultant;
        //$result = UserMaster::select('Name')->where('id',$req->Consultant)->first();
        //$ConsultantName = $result->Name;
        $Patient->ConsultantName = null;
        $Patient->Fees = $req->Fees;
        $Patient->PayMode = $req->PayMode;
        $Patient->RefBy = $req->RefBy;
        $Patient->Status = 1;
        $Patient->CreatedBy = 19;
        $Patient->ModifiedBy = 19;
        $Patient->CreatedDate = date('Y-m-d');
        $Patient->PatientName = $req->Suffix." ".$req->Fname." ".$req->Mname." ".$req->Lname;
        $PatientName = $req->Suffix." ".$req->Fname." ".$req->Mname." ".$req->Lname;
        $cnt = PatientModel::where('PatientName',$PatientName)->count();
        if($cnt > 0){
        return json_encode(array('Status'=>0));
        }
        else{
        $Patient->save();
        $MrdNo = $Patient->id;
        PatientModel::where('id',$MrdNo)->update(array('MrdNo'=>$MrdNo,'srno'=>$MrdNo)); 
        $QueueManagement = new QueueManagement;
        $QueueManagement->MrdNo = $MrdNo;
        $QueueManagement->PatientName = $req->Suffix." ".$req->Fname." ".$req->Mname." ".$req->Lname;
        $QueueManagement->PatientType = 'New';
        $QueueManagement->Age = $req->Age;
        $QueueManagement->Gender = $req->Gender;
        $QueueManagement->InDate = date('Y-m-d');
        $QueueManagement->InTime = date('H:i:s');
        $QueueManagement->Consultant = $req->Consultant;
        //$result = UserMaster::select('Name')->where('id',$req->Consultant)->first();
        //$ConsultantName = $result->Name;
        $QueueManagement->ConsultantName = null;
        $QueueManagement->Amount = $req->Fees;
        $QueueManagement->PayMode = $req->PayMode;
        $QueueManagement->OpdType = $req->OpdType;
        $QueueManagement->Status = 1;
        $QueueManagement->CreatedBy = 19;
        $QueueManagement->ModifiedBy = 19;
        //$details = $this->getVisitDetails($MrdNo);
        // if(!$details->isEmpty()){
        //     $ConfirmConsult = $details[0]->ConfirmConsult;
        //     $ConfirmOpto = $details[0]->ConfirmOpto;
        //     $InvStName = $details[0]->InvStName;
           
        // }
        // else{
        //     $ConfirmConsult = 0;
        //     $ConfirmOpto = 0;
        //     $InvStName = 0;
        // }
        // $QueueManagement->ConfirmConsult = $ConfirmConsult;
        // $QueueManagement->ConfirmOpto = $ConfirmOpto;
        // $QueueManagement->InvStName = $InvStName;
        $QueueManagement->save();
        $totalPatient = $this->totalPatient();
        $totalCheckPatient = $this->totalCheckPatient();
        $totalUncheckPatient = $totalPatient - $totalCheckPatient;
        $NewMrdNo = $this->maxMrdNo();
        return json_encode(array('MrdNo'=>$MrdNo,'NewMrdNo'=>$NewMrdNo,'Status'=>1,'totalPatient'=>$totalPatient,'totalCheckPatient'=>$totalCheckPatient,'totalUncheckPatient'=>$totalUncheckPatient));  
        }
    }

function EditQueue(Request $req){
    $Patient = PatientModel::firstWhere(['MrdNo'=>$req->Mrd_No]);
    $Patient->Suffix = $req->Suffix;
    $Patient->Fname = $req->Fname;
    $Patient->Mname = $req->Mname;
    $Patient->Lname = $req->Lname;
    $Patient->Gender = $req->Gender;
    $Patient->Dob = $req->Dob;
    $Patient->Age = $req->Age;
    $Patient->Phone = $req->Phone;
    $Patient->Phone2 = $req->Phone2;
    $Patient->City = $req->City;
    $Patient->State = $req->State;
    $Patient->Address = $req->Address;
    $Patient->Consultant = $req->Consultant;
    //$result = UserMaster::select('Name')->where('id',$req->Consultant)->first();
    //$ConsultantName = $result->Name;
    //$Patient->ConsultantName = $ConsultantName;
    $Patient->Fees = $req->Fees;
    $Patient->PayMode = $req->PayMode;
    $Patient->RefBy = $req->RefBy;
    $Patient->Status = 1;
    $Patient->CreatedBy = 19;
    $Patient->ModifiedBy = 19;
    $Patient->CreatedDate = date('Y-m-d');
    $Patient->PatientName = $req->Suffix." ".$req->Fname." ".$req->Mname." ".$req->Lname;
    $Patient->save();
    $PatientName = $req->Suffix." ".$req->Fname." ".$req->Mname." ".$req->Lname;
    $ModifiedBy = 19;
    DB::select("UPDATE tbl_queue_managements SET PatientName='$PatientName',Age='$req->Age',Gender='$req->Gender',ModifiedBy='$ModifiedBy' WHERE MrdNo='$req->Mrd_No'");
    $totalPatient = $this->totalPatient();
    $totalCheckPatient = $this->totalCheckPatient();
    $totalUncheckPatient = $totalPatient - $totalCheckPatient;
    $NewMrdNo = $this->maxMrdNo();
    return json_encode(array('NewMrdNo'=>$NewMrdNo,'Status'=>1,'totalPatient'=>$totalPatient,'totalCheckPatient'=>$totalCheckPatient,'totalUncheckPatient'=>$totalUncheckPatient)); 
    }

    function deletqueue(Request $req){
        $result = QueueManagement::select('MrdNo','InDate')->where(['id'=>$req->id])->get();
        $MrdNo = $result[0]->MrdNo;
        $VisitDate = $result[0]->InDate;
        $whereArray = array('MrdNo' => $MrdNo,'VisitDate' => $VisitDate);
        VisitModel::where($whereArray)->delete();
        ConsultantModel::where($whereArray)->delete();
        OptoModel::where($whereArray)->delete();
        QueueManagement::find($req->id)->delete();
        $totalPatient = $this->totalPatient();
        $totalCheckPatient = $this->totalCheckPatient();
        $totalUncheckPatient = $totalPatient - $totalCheckPatient;
            return json_encode(array('Status'=>1,'totalPatient'=>$totalPatient,'totalCheckPatient'=>$totalCheckPatient,'totalUncheckPatient'=>$totalUncheckPatient));

    }

    function saveOldQueue(Request $req){
        $OutTime = date('H:i:s');
        QueueManagement::where(['MrdNo'=>$req->MRD_NO])->update(['Checked'=>1,'OutTime'=>$OutTime]);
        $CurrDate = date('Y-m-d');
        $QueueManagement = new QueueManagement;
        $QueueManagement->MrdNo = $req->MRD_NO;
        $QueueManagement->PatientName = $req->PatientName;
        $QueueManagement->PatientType = 'Old';
        $QueueManagement->Age = $req->PatientAge;
        $QueueManagement->Gender = $req->PatGender;
        $QueueManagement->OpdType = $req->OpdType;
        $QueueManagement->InDate = date('Y-m-d');
        $QueueManagement->InTime = date('H:i:s');
        //$QueueManagement->Consultant = $req->Consultant;
        //$result = UserMaster::select('Name')->where('id',$req->Consultant)->first();
        //$ConsultantName = $result->Name;
        // $details = $this->getVisitDetails($req->MRD_NO);
        
        // if(!$details->isEmpty()){
        //     $ConfirmConsult = $details[0]->ConfirmConsult;
        //     $ConfirmOpto = $details[0]->ConfirmOpto;
        //     $InvStName = $details[0]->InvStName;
           
        // }
        // else{
        //     $ConfirmConsult = 0;
        //     $ConfirmOpto = 0;
        //     $InvStName = 0;
        // }
        // $QueueManagement->ConfirmConsult = $ConfirmConsult;
        // $QueueManagement->ConfirmOpto = $ConfirmOpto;
        // $QueueManagement->InvStName = $InvStName;
        
        $result = QueueManagement::select('ConsultantName')->where(['MrdNo'=>$req->MRD_NO,'Checked'=>1])->orderBy('InDate','desc')->first();
        $PrevConsultant2 = $result->ConsultantName;
        if($PrevConsultant2 == ""){
            $PrevConsultant = "none";
        }
        else{
            $PrevConsultant = $result->ConsultantName;
        }
        $QueueManagement->PrevConsultant = $PrevConsultant;
        $QueueManagement->ConsultantName = null;
        $QueueManagement->Amount = $req->Fees;
        $QueueManagement->PayMode = $req->PayMode;
        $QueueManagement->Status = 1;
        $QueueManagement->CreatedBy = 19;
        $QueueManagement->ModifiedBy = 19;
        // $maxid = OptoModel::select()->where(['MrdNo'=>$req->MRD_NO])->max('VisitNo');
        // $VisitNo = $maxid+1;
        // $QueueManagement->VisitNo = $VisitNo;
        //$exitrow = QueueManagement::where(['MrdNo'=>$req->MRD_NO,'InDate'=>$CurrDate,'Checked'=>'0'])->count();
        $exitrow = QueueManagement::where(['MrdNo'=>$req->MRD_NO,'InDate'=>$CurrDate])->count();
        if($exitrow > 0){
            return json_encode(array('Status'=>0));
        }
        else{
        $QueueManagement->save();
        PatientModel::where(['MrdNo'=>$req->MRD_NO])->update(['Age'=>$req->PatientAge,'Gender'=>$req->PatGender,'Address'=>$req->PatientAddress,'City'=>$req->PatientCity]);     
        //return redirect('/queuemanagement');
        $totalPatient = $this->totalPatient();
        $totalCheckPatient = $this->totalCheckPatient();
        $totalUncheckPatient = $totalPatient - $totalCheckPatient;
        $NewMrdNo = $this->maxMrdNo();
        return json_encode(array('NewMrdNo'=>$NewMrdNo,'Status'=>1,'totalPatient'=>$totalPatient,'totalCheckPatient'=>$totalCheckPatient,'totalUncheckPatient'=>$totalUncheckPatient));
        }
    }

    function newpatients(Request $request){
        if ($request->ajax()) {
            if(!empty($request->FromDate))
            {
                $data = PatientModel::select('id','MrdNo','PatientName','Gender','ConsultantName','Age','Fees')
                ->whereBetween('CreatedDate', array($request->FromDate, $request->ToDate))->get();   
            }
            else{
            $data = DB::select("CALL getPatients()");
            }
            //$data = PatientModel::select('id','MrdNo','PatientName','Gender','ConsultantName','Age','Fees')->limit(10000)->get();
            return Datatables::of($data)
                    ->addIndexColumn()
                    ->addColumn('action', function($row){
     
                           $btn = '<a href="javascript:void(0)" class="edit btn btn-primary btn-sm">View</a>';
    
                            return $btn;
                    })
                    ->rawColumns(['action'])
                    ->make(true);
        }
        //$result = PatientModel::select()->limit(10)->get();
        //return $result;
        return view('opd/newpatientlists');
    }

    function viewNewPatientList(Request $request){
        $CurrDate = date('Y-m-d');
        if(!empty($request->FromDate))
            {
                $result = PatientModel::select('id','MrdNo','PatientName','Gender','ConsultantName','Age','Fees')
                ->whereBetween('CreatedDate', array($request->FromDate, $request->ToDate))->get();  
            }
            else{
                $result = DB::select("CALL getPatients()");
            }
        //return $result;
        return view('opd/viewnewpatientlists',['data'=>$result]);
    }

    function fetchPatientDetails(Request $req){
        $result = PatientModel::select()->where(['MrdNo'=>$req->id])->first();
        return json_encode($result);
    }

    function fetchQueuePatientDetails(Request $req){
        $result = QueueManagement::select()->where(['id'=>$req->id])->first();
        return json_encode($result);
    }
    function newPatient(){
        $consultantList = (new MasterController)->consultantList();
        $cityList = (new MasterController)->cityList();
        $stateList = (new MasterController)->stateList();
        $patientList = (new MasterController)->patientList();
        return view('opd/newpatientlists',['patientList'=>$patientList,'stateList'=>$stateList,'cityList'=>$cityList,'consultantList'=>$consultantList]);

    }

    function deletPatient(Request $req){
        QueueManagement::where(['MrdNo'=>$req->id])->delete();
        PatientModel::where(['MrdNo'=>$req->id])->delete();
        return 1;
    }

    function patientOut(Request $req){
        $id = $req->id;
        $mrdno = $req->mrdno;
        $indate = $req->indate;
        $OutTime = date('H:i:s');
        QueueManagement::where(['id'=>$id])->update(['Checked'=>1,'OutTime'=>$OutTime]);
        ConsultantModel::where(['MrdNo'=>$mrdno,'VisitDate'=>$indate])->update(['Checked'=>1]);
        VisitModel::where(['MrdNo'=>$mrdno,'VisitDate'=>$indate])->update(['Checked'=>1]);
        OptoModel::where(['MrdNo'=>$mrdno,'VisitDate'=>$indate])->update(['Checked'=>1]);
        $totalPatient = $this->totalPatient();
        $totalCheckPatient = $this->totalCheckPatient();
        $totalUncheckPatient = $totalPatient - $totalCheckPatient;
        return json_encode(array('Status'=>1,'totalPatient'=>$totalPatient,'totalCheckPatient'=>$totalCheckPatient,'totalUncheckPatient'=>$totalUncheckPatient));
    }

    function updateQueueDetails(Request $req){
        $QueueManagement = QueueManagement::find($req->id2);
        $QueueManagement->Age = $req->Age2;
        $QueueManagement->Gender = $req->Gender2;
        $QueueManagement->Consultant = $req->Consultant2;
        // $result = UserMaster::select('Name')->where('id',$req->Consultant2)->first();
        // $ConsultantName = $result->Name;
        // $QueueManagement->ConsultantName = $ConsultantName;
        $QueueManagement->Amount = $req->Amount2;
        $QueueManagement->PayMode = $req->PayMode2;
        $QueueManagement->save();
        PatientModel::where(['MrdNo'=>$req->MrdNo2])->update(['Age'=>$req->Age2,'Gender'=>$req->Gender2]);
        $totalPatient = $this->totalPatient();
        $totalCheckPatient = $this->totalCheckPatient();
        $totalUncheckPatient = $totalPatient - $totalCheckPatient;
        return json_encode(array('Status'=>1,'totalPatient'=>$totalPatient,'totalCheckPatient'=>$totalCheckPatient,'totalUncheckPatient'=>$totalUncheckPatient));
 
    }

    function changeFees(Request $req){
        $visitno = $req->visitno;
        $visitdate = $req->visitdate;
        $mrdno = $req->mrdno;
        $Fees = $req->Fees;
        
        $data4 = QueueManagement::select('Amount')->where(['MrdNo'=>$mrdno,'InDate'=>$visitdate,'VisitNo'=>$visitno])->get();
        $cntrow4 = $data4->count();   
        if($cntrow4 > 0){
            QueueManagement::where(['MrdNo'=>$mrdno,'InDate'=>$visitdate,'VisitNo'=>$visitno])->update(['Amount'=>$Fees]);
        }
        else{
        $data5 =  QueueManagement::select('Amount')->where(['MrdNo'=>$mrdno,'InDate'=>$visitdate])->get();
        $cntrow5 = $data5->count(); 
        if($cntrow5 > 0){
            QueueManagement::where(['MrdNo'=>$mrdno,'InDate'=>$visitdate])->update(['Amount'=>$Fees]);
        }  
        else{
            
        }
       
        }

        
        return 1;
    }
  
    function refreshQueue(){
        $totalPatient = $this->totalPatient();
        $totalCheckPatient = $this->totalCheckPatient();
        $totalUncheckPatient = $totalPatient - $totalCheckPatient;
        $NewMrdNo = $this->maxMrdNo();
        return json_encode(array('NewMrdNo'=>$NewMrdNo,'totalPatient'=>$totalPatient,'totalCheckPatient'=>$totalCheckPatient,'totalUncheckPatient'=>$totalUncheckPatient));
    }

    function dailyReport($fromdate){
        $result = QueueManagement::where("InDate",$fromdate)->get();
        $total = $result->count();
        $male = QueueManagement::where(['InDate'=>$fromdate,'Gender'=>'Male'])->count();
        $female = QueueManagement::where(['InDate'=>$fromdate,'Gender'=>'Female'])->count();
        $new = QueueManagement::where(['InDate'=>$fromdate,'PatientType'=>'New'])->count();
        $old = QueueManagement::where(['InDate'=>$fromdate,'PatientType'=>'Old'])->count();
        $free = QueueManagement::where(['InDate'=>$fromdate,'Amount'=>'0'])->count();
        $paid = QueueManagement::where(['InDate'=>$fromdate])->where('Amount', '>', '0')->count();
        $appointment = QueueManagement::where(['InDate'=>$fromdate,'Appointment'=>'1'])->count();
        $dialted = QueueManagement::where(['InDate'=>$fromdate,'Dilated'=>'1'])->count();
        return view('/opd/incqueuereport',['data'=>$result,'total'=>$total,'male'=>$male,'female'=>$female,
                    'new'=>$new,'old'=>$old,'free'=>$free,'paid'=>$paid,'appointment'=>$appointment,
                    'dialted'=>$dialted]);
    }

    function viewOpdQueue(Request $request){
        $CurrDate = date('Y-m-d');
        $result = DB::select("SELECT tq.* FROM tbl_queue_managements tq LEFT JOIN tbl_users tu ON tq.Consultant=tu.id WHERE Checked=0 AND tq.InDate='$CurrDate' ORDER BY tq.InTime");
        return view('opd/view-opd-queue-list',['data'=>$result]);
    }

    function patientPrevSummary(){
        $patientList = (new MasterController)->patientList();
        return view('/opd/view-patient-summary',['patientList'=>$patientList]);
    }

    function getLastVisit(Request $req){
        $mrdno = $req->mrdno;
        $maxvisitno = OptoModel::select()->where(['MrdNo'=>$mrdno,'Checked'=>1])->max('VisitNo');
        return $maxvisitno;
    }

    function getVisitDetails($mrdno){
    //    $result = DB::table('tbl_optometrist as topt')
    //             ->leftJoin('tbl_consultants as tc', 'tc.MrdNo', '=', 'topt.MrdNo')
    //             ->where(['topt.MrdNo'=>$mrdno])
    //             ->select('topt.ConfirmConsult','topt.ConfirmOpto','tc.InvStName')
    //             ->orderBy('topt.VisitNo','desc')->limit(1)->get();
    //     if($result->count() > 0){
    //         return $result;
    //     }
    //     else{
    //         return "";
    //     }

    $cnt = OptoModel::select('ConfirmConsult')->where(['MrdNo'=>$mrdno,'Checked'=>1])->count();
    if($cnt > 0){
        //$result = OptoModel::select('ConfirmConsult')->where(['MrdNo'=>$mrdno,'Checked'=>1])->first();
        // $result =  DB::table('tbl_optometrist as topt')
        //         ->leftJoin('tbl_users as tu2', 'tu2.id', '=', 'topt.ConfirmConsult')
        //         ->where(['topt.MrdNo'=>$mrdno,'topt.Checked'=>1])
        //         ->select('tu2.Name As Consultant')
        //         ->orderBy('topt.VisitNo','desc')->first();
        $result = QueueManagement::select('ConsultantName')->where(['MrdNo'=>$mrdno,'Checked'=>1])->orderBy('InDate','desc')->limit(1)->first();
        return $result->ConsultantName;
    }
    else{
        return "";
    }
    
       

    }

    function BringBackToQueue(){
        return view('/opd/bring-back-to-queue');
    }

    function getLastQueueDetails(Request $req){
        $MrdNo = $req->MrdNo;
        $VisitDate = $req->VisitDate;
        $result =  QueueManagement::where(['MrdNo'=>$MrdNo,'InDate'=>$VisitDate])->first();
        return json_encode($result);
    }
    function backToQueue(Request $req){
        $MrdNo = $req->MrdNo;
        $VisitDate = $req->VisitDate;
        QueueManagement::where(['MrdNo'=>$MrdNo,'InDate'=>$VisitDate])->update(['Checked'=>0]);
        ConsultantModel::where(['MrdNo'=>$MrdNo,'VisitDate'=>$VisitDate])->update(['Checked'=>0]);
        VisitModel::where(['MrdNo'=>$MrdNo,'VisitDate'=>$VisitDate])->update(['Checked'=>0]);
        OptoModel::where(['MrdNo'=>$MrdNo,'VisitDate'=>$VisitDate])->update(['Checked'=>0]);
        return 1;
    }

    function getPatientBal($mrdno){
        $Amount2 = PatientBalanceModel::where(['MrdNo'=>$mrdno])->sum('Amount');
        if($Amount2 == ''){
            $Amount = 0;
        }
        else{
            $Amount = $Amount2;
        }
        return $Amount;
    }

    function stickerPrint($MrdNo){
        $result =  PatientModel::where(['MrdNo'=>$MrdNo])->first();
        return view('/opd/stricker-print',['data'=>$result]);
    }

    function viewAttachedFiles($mrdno){
        $result =  PatientModel::where(['MrdNo'=>$mrdno])->first();
        $visitdates = OptoModel::select('id','MrdNo','PatientName','Photo1','Photo2','Photo3','Photo4','Photo5','Photo6','VisitDate')->where(['MrdNo'=>$mrdno])->get();
        return view('/opd/view-attached-files',['data'=>$result,'visitdates'=>$visitdates]);
    }

    function deletPhoto(Request $req){
        $mrdno = $req->mrdno;
        $visitno = $req->visitno;
        $visitdate = $req->visitdate;
        $mrdno = $req->mrdno;
        $fieldname = $req->fieldname;
        OptoModel::where(['MrdNo'=>$mrdno,'VisitNo'=>$visitno,'VisitDate'=>$visitdate])->update([$fieldname=>'']);
        return 1;
       }
}