<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\SpecialityModel;
use Session;
class SpecialityController extends Controller
{
    function specialityclinic(){
        $result = $this->getSpecClinicName();
        return view('masters/speciality-clinic',['data'=>$result]);
    }
    function viewSpecialityClinicList(Request $req){
        $result = SpecialityModel::all();
        return view('masters/view-speciality-clinic-list',['data'=>$result]);
    }

    function getSpecClinicName(){
        $result = SpecialityModel::select('ClinicName')->distinct()->get();
        return $result;
    }
    
    function getSpecConsultant(Request $req){
        $result = SpecialityModel::select('Name')->Where(['ClinicName'=>$req->val])->get();
        $output = '';
        $output.= '';
        foreach($result as $drugdata){
        $output.= '<option value="'.$drugdata->Name.'">'.$drugdata->Name.'</option>';
        }
        return $output;
    }

    function getSpecClinic(Request $req){
        $result = SpecialityModel::select('ClinicName')->get();
        $output = '';
        $output.= '<option value="">...</option>';
        foreach($result as $drugdata){
        $output.= '<option value="'.$drugdata->ClinicName.'">'.$drugdata->ClinicName.'</option>';
        }
        return $output;
    }

    function getSpecConsultant2($val){
        $result = SpecialityModel::select('Name')->Where(['ClinicName'=>$val])->get();
    
        return $result;
    }

    function saveSpecialityClinic(Request $req){
        if($req->action == 'Save'){
            $Package = new SpecialityModel;
            $Package->CreatedBy = Session::get('UserId'); 
        }
        else{
            $Package = SpecialityModel::find($req->id);
            $Package->ModifiedBy = Session::get('UserId'); 
        }
        $Package->Name = $req->Name; 
        $Package->ClinicName = $req->ClinicName;
        $Package->Status = 1;
        $Package->save();
        return 1;
    }

    function editSpecialityClinic(Request $req){
        $data = SpecialityModel::find($req->id);
        return json_encode($data);
    }

    function deleteSpecialityClinic(Request $req){
        $data=SpecialityModel::find($req->id)->delete();
        return 1;
    }

    function getSpecialityClinicDetails(Request $req){
        $data=SpecialityModel::select('Amount')->Where(['Name'=>$req->val])->first();
        return $data->Amount;
    }
}
