<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Http\Controllers\MasterController;
use App\Http\Controllers\TreatmentController;
use App\Models\PackageModel;
use App\Models\TempBillChargeModel;
use App\Http\Controllers\CounsellingController;
use App\Models\TempBillModel;
use App\Models\CounsellingModel;
use App\Models\BillModel;
use App\Models\OTModel;
use Session;

class TempBillController extends Controller
{
    function tempbill(){
        return view('/ipd/view-temp-bill');
    }

    function viewIpdTempBills(Request $req){
        $CurrDate = date('Y-m-d');
        if(!empty($req->FromDate))
            {
                $result =  DB::table('tbl_temp_bills as ti')
                ->leftJoin('tbl_ipd as tip', 'tip.IpdNo', '=', 'ti.IpdNo')
                ->leftJoin('tbl_users as tc', 'tc.id', '=', 'ti.Consultant')
                ->whereBetween('ti.BillDate', array($req->FromDate, $req->ToDate))
                ->where(['ti.Status'=>'1','ti.Flag'=>0])
                ->select('ti.*','tc.Name As Department')->get();
            }
            else{
                $result =  DB::table('tbl_temp_bills as ti')
                ->leftJoin('tbl_ipd as tip', 'tip.IpdNo', '=', 'ti.IpdNo')
                ->leftJoin('tbl_users as tc', 'tc.id', '=', 'ti.Consultant')
                ->where(['ti.Status'=>'1','ti.Flag'=>0])
                ->select('ti.*','tc.Name As Department')->get();
            }
            $consultantList = (new MasterController)->consultantList();
        return view('ipd/incipdtempbills',['consultantList'=>$consultantList,'data'=>$result]);
    }

    function deletIpdTempBill(Request $req){
        TempBillModel::find($req->id)->delete();
        DB::table('tbl_bill_charges_temp')->where(['BillNo'=>$req->id])->delete();
        return 1;
    }

    function BillNo(){
        $BillNo = TempBillModel::select()->max('id');
        if($BillNo == '' || $BillNo == 0 || $BillNo == NULL){
            $BillNo = 1;
        }
        else{
            $BillNo = $BillNo+1;
        }
        return $BillNo;
    }

    function BillNoList(){
        $BillNoList = TempBillModel::all();
        return $BillNoList;
    }
    function addIpdTempBill(){
        $patientList = (new MasterController)->ipdPatientList();
        $consultantList = (new MasterController)->consultantList();
        //$counsellingList = (new CounsellingController)->getCounsellingId();
        $BillNoList = $this->BillNoList();
        $BillNo = $this->BillNo();
        $counsellingList = OTModel::all();
        return view('/ipd/add-ipd-temp-bill',['BillNoList'=>$BillNoList,'counsellingList'=>$counsellingList,'BillNo'=>$BillNo,'consultantList'=>$consultantList,'patientList'=>$patientList]);
    }

    function getBillPackageDetails(Request $req){
        $SessionId = Session::getId();
        $PackageName = $req->PackageName;
        DB::table('tbl_temp_bill_charges')->where(['SessionId'=>$SessionId])->delete();
        $result = PackageModel::select()->where(['PackageName'=>$PackageName])->get();
        $firstrecord = $result->first();
        for($count = 0; $count < count($result); $count++)
        {
       $data = array(
        'SessionId'=>$SessionId,
        'PackageName'=>$PackageName,
        'PackageAmt'=>$result[$count]['PackageAmt'],
        'BalanceAmt'=>$result[$count]['BalanceAmt'],
        'Name'=>$result[$count]['Name'],
        'Amount'=>$result[$count]['Amount'],
        'Days'=>$result[$count]['Days'],
        'Rate'=>$result[$count]['Rate'],
        'Status'=>1,
        'CreatedBy' => 19,
       );
       $insert_data[] = $data; 
       }
       //return $insert_data;exit();
       TempBillChargeModel::insert($insert_data);
        return json_encode($firstrecord);
    }

    function billChargesView(Request $req){
        $SessionId = Session::getId();
        $PackageName = $req->PackageName;
        $result = TempBillChargeModel::select()->where(['PackageName'=>$PackageName,'SessionId'=>$SessionId])->get();
        return view('ipd/incipdbillchargeview2',['data'=>$result]);
    }

    function calBillBalanceAmt(Request $req){
        $PackageName = $req->PackageName;
        $SessionId = Session::getId();
        $result = DB::select("SELECT SUM(Amount) As Amount,PackageAmt FROM tbl_temp_bill_charges WHERE PackageName = '$PackageName' AND SessionId='$SessionId'");
        $TotAmt = $result[0]->Amount;
        $PackageAmt = $result[0]->PackageAmt;
    $BalanceAmt = $PackageAmt - $TotAmt;
    return $BalanceAmt;
    }

    function totSumBills(Request $req){
        $SessionId = Session::getId();
        $result = TempBillChargeModel::select()->where(['SessionId'=>$SessionId])->sum('Amount');
        return $result;
    }
    function saveTempBills(Request $req){
        $SessionId = Session::getId();
        if($req->action == 'Save'){
            $TempBillCharge = new TempBillChargeModel;
            }
            else{
            $TempBillCharge = TempBillChargeModel::firstWhere(['id'=>$req->id,'SessionId'=>$SessionId]);
            }
            $TempBillCharge->SessionId = Session::getId();
        $TempBillCharge->Name = $req->ChargesName;
        $TempBillCharge->Days = $req->Days;
        $TempBillCharge->Rate = $req->Rate;
        $TempBillCharge->Amount = $req->Amount;
        $TempBillCharge->PackageName = $req->PackageName;
        $TempBillCharge->PackageAmt = $req->PackageAmt;
        $TempBillCharge->BalanceAmt = $req->BalanceAmt;
        $TempBillCharge->Status = 1;
        $TempBillCharge->CreatedBy =19;
        $TempBillCharge->save();
        return 1;
    }

    function saveIpdTempBill(Request $req){
        $SessionId = Session::getId();
        $Bill = new TempBillModel;
        $Bill->ConsId = $req->CounId;
        $Bill->BillType = $req->BillType;
        $Bill->BillNo = $req->BillNo;
  $Bill->MrdNo = $req->MrdNo;
  $Bill->IpdNo = $req->IpdNo;
  $Bill->PatientName = $req->PatientName;
  $Bill->AgeGender = $req->AgeGender;
  $Bill->BillDate = $req->BillDate;
  $Bill->OperationDate = $req->OperationDate;
  $Bill->AdmissionDate = $req->AdmissionDate;
  $Bill->DischargeDate = $req->DischargeDate;
  $Bill->Consultant = $req->Consultant;
  $Bill->Diagnosis = $req->Diagnosis;
  $Bill->SurgeryDone = $req->SurgeryDone;
  $Bill->InsuranceComp = $req->InsuranceComp;
  $Bill->ClainNo = $req->ClainNo;
  $Bill->PackageName = $req->PackageName;
  $Bill->PackageAmt = $req->PackageAmt;
  $Bill->BalanceAmt = $req->BalanceAmt;
  $Bill->SubTotal = $req->SubTotal;
  $Bill->Discount = $req->Discount;
  $Bill->GrossAmt = $req->GrossAmt;
  $Bill->BalAmt = $req->BalAmt;
  $Bill->PaidAmt = $req->PaidAmt;
  $Bill->PayMode = $req->PayMode;
  $Bill->Narration = $req->Narration;
  $Bill->CreatedBy =19;
  $Bill->save();       
  $BillId = $Bill->id;
        
  $result = TempBillChargeModel::select()->where(['SessionId'=>$SessionId])->get();
  for($count = 0; $count < count($result); $count++)
  {
 $data = array(
  'BillNo' => $BillId,
  'MrdNo' => $req->MrdNo,
  'IpdNo' => $req->IpdNo,
  'PackageName'=>$result[$count]['PackageName'],
  'PackageAmt'=>$result[$count]['PackageAmt'],
  'BalanceAmt'=>$result[$count]['BalanceAmt'],
  'Name'=>$result[$count]['Name'],
  'Amount'=>$result[$count]['Amount'],
  'Days'=>$result[$count]['Days'],
  'Rate'=>$result[$count]['Rate'],
  'Status'=>1,
  'CreatedBy' => 19,
 );
 $insert_data[] = $data; 
 }
 //return $insert_data;exit();
 DB::table('tbl_bill_charges_temp')->insert($insert_data);
 DB::table('tbl_temp_bill_charges')->where(['SessionId'=>$SessionId])->delete();
 return redirect('/tempBill');
    }

    function fetchBillChargesRecord(Request $req){
        $result = TempBillChargeModel::select()->where(['id'=>$req->id])->first();
        echo json_encode($result);
    }

    function deleteBillChargesRecord(Request $req){
        $SessionId = Session::getId();
        TempBillChargeModel::where(['id'=>$req->id,'SessionId'=>$SessionId])->delete();
        return 1;
    }

    function getCounsellingDetails(Request $req){
        $val = $req->id;
        $seperate = explode(" / ", $val);
        $id = $seperate[0];
        $result = CounsellingModel::select()->where('id',$id)->first();
        return json_encode($result);
    }

    function transferTempBill(Request $req){
        $number = count($req->BillId);
        if($number > 0)
        {  
            for($count = 0; $count < $number; $count++)
            {
             
                if(trim($req->chkvalue[$count] != 0))  
                     {
                         $BillId = $req->BillId[$count];
                         $result = TempBillModel::select()->where('id',$BillId)->first();
                         $maxid = BillModel::where('FinYr','22-23')->max('SrNo');
                         $SrNo = $maxid+1;
                         $BillNo = $SrNo."/22-23";
                         $Bill = new BillModel;
                         $Bill->SrNo = $SrNo;
                         $Bill->BillNo = $BillNo;
                         $Bill->BillType = $result->BillType;
                         $Bill->FinYr = '22-23';
                         $Bill->MrdNo = $result->MrdNo;
                         $Bill->PatientName = $result->PatientName;
                         $Bill->AgeGender = $result->AgeGender;
                         $Bill->BillDate = $result->BillDate;
                        $Bill->AdmissionDate = $result->AdmissionDate;
                        $Bill->OperationDate = $result->OperationDate;
                        $Bill->DischargeDate = $result->DischargeDate;
                        $Bill->Consultant = $req->Consultant;
                        $Bill->Diagnosis = $result->Diagnosis;
                        $Bill->SurgeryDone = $result->SurgeryDone;
                        $Bill->InsuranceComp = $result->InsuranceComp;
                        $Bill->ClainNo = $result->ClainNo;
                        $Bill->PackageName = $result->PackageName;
                        $Bill->PackageAmt = $result->PackageAmt;
                        $Bill->BalanceAmt = $result->BalanceAmt;
                        $Bill->SubTotal = $result->SubTotal;
                        $Bill->Discount = $result->Discount;
                        $Bill->GrossAmt = $result->GrossAmt;
                        $Bill->BalAmt = $result->BalAmt;
                        $Bill->PaidAmt = $result->PaidAmt;
                        $Bill->PayMode = $result->PayMode;
                        $Bill->Narration = $result->Narration;
                        $Bill->CreatedBy =19;
                        $Bill->save();      

                        $result2 = DB::table('tbl_bill_charges_temp')->select()->where('BillNo',$BillId)->get();
                        DB::select("INSERT INTO tbl_bill_charges(BillNo,MrdNo,PackageName,PackageAmt,BalanceAmt,Name,Days,Rate,Amount,Status,CreatedBy)
                         SELECT '$BillNo',MrdNo,PackageName,PackageAmt,BalanceAmt,Name,Days,Rate,Amount,Status,CreatedBy FROM `tbl_bill_charges_temp` WHERE BillNo=$BillId");
                        //return $result2;exit();
                        // for($count2 = 0; $count2 < count($result2); $count2++)
                        // {
                        //   return $result2[$count2]['BillNo'];
                        // }
                       TempBillModel::where('id',$BillId)->update(['Flag'=>1]); 
                        
                }
                
            }
           
           
        }
       
        return redirect('/tempBill');
    }

    function divideAmt(Request $req){
        $pkgamt = $req->pkgamt;
        $SessionId = Session::getId();
        // $TotAmt = DB::table('tbl_temp_bill_charges')->where('SessionId',$SessionId)
        // ->whereNotIn('Name', ['Operation Charges','Operation Theatre Charges with IOL'])->sum('Amount');
        // $BalAmt = $pkgamt - $TotAmt;
        // $Divide40 = $BalAmt*(40/100);
        // $Divide60 = $BalAmt*(60/100);
        // DB::table('tbl_temp_bill_charges')->where(['SessionId'=>$SessionId,'Name'=>'Operation Charges'])->update(['Rate'=>$Divide40,'Amount'=>$Divide40]);
        // DB::table('tbl_temp_bill_charges')->where(['SessionId'=>$SessionId,'Name'=>'Operation Theatre Charges with IOL'])->update(['Rate'=>$Divide60,'Amount'=>$Divide60]);
        $TotAmt = DB::table('tbl_temp_bill_charges')->where('SessionId',$SessionId)->sum('Amount');
        return $pkgamt;
    }

    function editTempBill($id){
        $consultantList = (new MasterController)->consultantList();
        $result = TempBillModel::find($id);
        return view('/ipd/edit-temp-bill',['consultantList'=>$consultantList,'data'=>$result]);
    }

    function getBillCharges(Request $req){
        $billno = $req->billno;
        $result = DB::table('tbl_bill_charges_temp')->select()->where(['BillNo'=>$billno])->get();
        return view('ipd/incipdbillchargeview2',['data'=>$result]);
    }

    function fetchBillChargesRecord3(Request $req){
        $result = DB::table('tbl_bill_charges_temp')->select()->where(['id'=>$req->id])->first();
        echo json_encode($result);
    }

    function updateBillCharges2(Request $req){
        DB::table('tbl_bill_charges_temp')->where(['id'=>$req->id])->update(['Name'=>$req->ChargesName,
        'Amount'=>$req->Amount,'Days'=>$req->Days,'Rate'=>$req->Amount]);
        return 1;
    }

    function totSumBills3(Request $req){
        $result = DB::table('tbl_bill_charges_temp')->where(['BillNo'=>$req->BillNo])->sum('Amount');
        return $result;
    }

    function updateIpdTempBill(Request $req){
        DB::table('tbl_temp_bills')->where(['BillNo'=>$req->BillNo])->update(['SubTotal'=>$req->SubTotal,
        'Discount'=>$req->Discount,'GrossAmt'=>$req->GrossAmt,'PaidAmt'=>$req->PaidAmt,
        'BalAmt'=>$req->BalAmt,'PayMode'=>$req->PayMode,'Narration'=>$req->Narration]);
        return redirect('/tempBill');
    }
}