<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\TreatmentModel;
use App\Models\DrugsModel;
use App\Http\Controllers\MasterController;
use Session;
class TreatmentController extends Controller
{   
    function getTreatments(Request $req){
        $Treatment = $req->Treatment;
        $data = TreatmentModel::select()->where(['Treatment'=>$Treatment])->orderBy('id')->get();
        $rncnt = $data->count();
        $balance = 9 - $rncnt;
        $TreatName = $this->getTreatmentName();
        //$this->getTreatmentList();
        $doseList = (new TreatmentController)->doseList();
$treatInstructionList = (new TreatmentController)->treatInstructionList();
        $result = view('masters/treatmentlist',['doseList'=>$doseList,'treatInstructionList'=>$treatInstructionList,'data'=>$data,'rncnt'=>$rncnt,'TreatName'=>$TreatName]);
        return $result;
    }

    function getTreatments2(Request $req){
        $Treatment = $req->Treatment;
        $data = TreatmentModel::select()->where(['Treatment'=>$Treatment])->orderBy('id')->get();
        $rncnt = $data->count();
        $balance = 9 - $rncnt;
        $TreatName = $this->getTreatmentName();
        $durationList = (new MasterController)->durationList();
        //$this->getTreatmentList();
        $result = view('masters/treatmentlist2',['durationList'=>$durationList,'data'=>$data,'rncnt'=>$rncnt,'TreatName'=>$TreatName]);
        return $result;
    }

    function getTreatmentName(){
        //$result = TreatmentModel::select('TreatName1  as TreatName')->distinct()->get();
        $result = DrugsModel::select('Name  as TreatName')->distinct()->get();
        return $result;
    }

    function treatmentmaster(){
        $treatments = $this->getTreatmentList();
        $drugList = (new MasterController)->drugList();
        return view('masters/treatmentmaster',['drugList'=>$drugList,'treatments'=>$treatments]);
    }

    function getTreatmentList(){
        $result = TreatmentModel::select('Treatment')->distinct()->orderBy('Treatment','asc')->get();
        $final_data = json_encode(array('items' => $result));
        if(file_put_contents('json_files/timetables_date.json', $final_data))  
                {  

                }
        //return $result;
    }

    function getMoreTreatments(Request $req){
        $drugList = (new MasterController)->drugList();
        return view('masters/getmoretreatments',['drugList'=>$drugList]);
    }

    function saveTreatments(Request $req){
        TreatmentModel::where(['Treatment'=>$req->Treatment])->delete();    
      $TreatType1 = $req->TreatType1;
      $TreatName1 = $req->TreatName1;
      $TreatDose1 = $req->TreatDose1;
      $TreatFreq1 = $req->TreatFreq1;
      $TreatDur1 = $req->TreatDur1;
      $TreatEye1 = $req->TreatEye1;
      for($count = 0; $count < count($TreatName1); $count++)
      {
        if($TreatType1[$count] != ''){
       $data = array(
        'Treatment'=>$req->Treatment,
        'TreatChk1' => 1,
        'TreatType1' => $TreatType1[$count],
        'TreatName1'  => $TreatName1[$count],
        'TreatDose1'  => $TreatDose1[$count],
        'TreatFreq1'  => $TreatFreq1[$count],
        'TreatDur1'  => $TreatDur1[$count],
        'TreatEye1'  => $TreatEye1[$count],
        'CreatedBy' => 19,
        'ModifiedBy' => 19
       );
       $insert_data[] = $data; 
    }
      }

      TreatmentModel::insert($insert_data);
      $this->getTreatmentList();
      return redirect('/treatmentmaster');
    }

    function getSaveTreatments(Request $req){
        $drugList = (new MasterController)->drugList();
        $result = TreatmentModel::select()->where(['Treatment'=>$req->Treatment])
        ->orderBy('id')->get();
        return view('masters/getsavetreatments',['data'=>$result,'drugList'=>$drugList]);
    }

    function deleteTreatment(Request $req){
        TreatmentModel::where(['Treatment'=>$req->Treatment])->delete();
        $this->getTreatmentList();
        return "Record Deleted Successfully!";
    }

    function getTreatDate(Request $req){
        $val = $req->val;
        $result = DB::table('tbl_duration')->where('Duration',$val)->first();
        $dur = $result->DurVal;
        $period = $result->DurPeriod;
        $valid_period = "+ ".$dur." ".$period;
        $dt = strtotime(date('Y-m-d'));
        $reviewdt = date("Y-m-d", strtotime("+$valid_period", $dt));
        return $reviewdt;
    }

    function getTreatDate2($val){
        //$val = $req->val;
        $result = DB::table('tbl_duration')->where('Duration',$val)->first();
        $cnt = DB::table('tbl_duration')->where('Duration',$val)->count();
        if($cnt > 0){
        $dur = $result->DurVal;
        $period = $result->DurPeriod;
        $valid_period = "+ ".$dur." ".$period;
        $dt = strtotime(date('Y-m-d'));
        $reviewdt = date("Y-m-d", strtotime("+$valid_period", $dt));
        return $reviewdt;
        }
        else{
            return 0;   
        }
    }

    function getTapDate(Request $req){
        $TreatDate = $req->TreatDate;
        $PrevTreatDate = $req->PrevTreatDate;
        $TreatDur = $req->TreatDur;
        $result = DB::table('tbl_duration')->where('Duration',$TreatDur)->first();
        $cnt = DB::table('tbl_duration')->where('Duration',$TreatDur)->count();
        if($cnt > 0){
            $dur = $result->DurVal;
            $period = $result->DurPeriod;
            $valid_period = $dur." ".$period;
            $reviewdt = date('Y-m-d', strtotime($PrevTreatDate. " + $valid_period"));
            return $reviewdt;
            }
            else{
                return 0;   
            }

    }

    function getUnchkTapDate(Request $req){
        $TreatDate = $req->TreatDate;
        $TreatDur = $req->TreatDur;
        $result = DB::table('tbl_duration')->where('Duration',$TreatDur)->first();
        $cnt = DB::table('tbl_duration')->where('Duration',$TreatDur)->count();
        if($cnt > 0){
            $dur = $result->DurVal;
            $period = $result->DurPeriod;
            $valid_period = $dur." ".$period;
            $reviewdt = date('Y-m-d', strtotime($TreatDate. " - $valid_period"));
            return $reviewdt;
            }
            else{
                return 0;   
            }

    }
    
    function doseList(){
        $result = DB::table('tbl_freq')->get();
        return $result;
    }
    
    function treatInstructionList(){
        $result = DB::table('tbl_treat_instruction')->get();
        return $result;
    }

    function durationList(){
        $result = DB::table('tbl_duration')->get();
        return $result;
    }
    function frequencyList(){
        $result = DB::table('tbl_treat_freq')->get();
        return $result;
    }

    
}