@include('header')
@php
if(file_exists('json_files/json-file.json')){
$json = file_get_contents('json_files/json-file.json');
//Decode JSON
$json_data = json_decode($json,true);
$results = array();
}
@endphp
<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold py-3 mb-0">Drug Master</h4>

    <div class="row">
        <!-- customar project  start -->
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <div class="row align-items-center m-l-0">



                        <div class="col-sm-2 text-left">
                            <button class="btn btn-success btn-sm mb-3 btn-round" data-toggle="modal"
                                data-target="#modal-report" id="add_button"><i class="feather icon-plus"></i> Add
                                New Drug</button>
                        </div>


                    </div>
                    <hr>
                    <div class="table-responsive" id="custresult">

                    </div>
                </div>
            </div>
        </div>
        <!-- customar project  end -->
    </div>


    <div class="modal fade" id="modal-report" tabindex="-1" role="dialog" aria-labelledby="myExtraLargeModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" style="max-width: 70rem; ">
            <div class="modal-content">


                <div class="modal-header">
                    <h5 class="modal-title">Add Drug</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="validation-form" method="POST" action="/saveDrug">
                        @csrf
                        <div class="row">

                            <input type="hidden" name="action" id="action" value="Save">
                            <input type="hidden" name="id" id="id" />
                            


                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label class="floating-label" for="Phone">Type <span
                                            class="text-danger">*</span></label>
                                    <select class="form-control" name="Type" id="Type" style="height:31px;">

                                        <option value="" selected>...</option>
                                        <?php
                                        foreach($json_data['JsonData']['TreatType'] as $result) {?>
                                        <option value="<?php echo $result['Values']; ?>">
                                            {{$result['Values']}}</option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label class="floating-label" for="Name">Drug Name <span
                                            class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="Name" id="Name" placeholder=""
                                        required="">
                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="floating-label" for="Name">Dose <span
                                            class="text-danger">*</span></label>
                                            <select class="form-control" name="Dose" id="Dose" style="height:31px;">

<option value="" selected>...</option>
<?php
foreach($json_data['JsonData']['TreatDose'] as $result) {?>
<option value="<?php echo $result['Values']; ?>">
    {{$result['Values']}}</option>
<?php } ?>
</select>
                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label class="floating-label" for="Name">Freq. <span
                                            class="text-danger">*</span></label>
                                            <select class="form-control" name="Freq" id="Freq" style="height:31px;">

<option value="" selected>...</option>
<?php
foreach($json_data['JsonData']['TreatFreq'] as $result) {?>
<option value="<?php echo $result['Values']; ?>">
    {{$result['Values']}}</option>
<?php } ?>
</select>
                                </div>
                            </div>



                            <div class="col-sm-12">
                                <button class="btn btn-primary" type="submit" name="submit" id="submit">Submit</button>
                                <button class="btn btn-danger" type="reset">Clear</button>
                            </div>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>

</div>
@include('footerscript')
<script>
function isNumberKey(evt) {
    var charCode = (evt.which) ? evt.which : evt.keyCode
    if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
    return true;
}

function success_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.notice({
        title: 'Success',
        message: 'New Drug Added Successfully!',
        location: isRtl ? 'tl' : 'tr'
    });
}

function error_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.error({
        title: 'Error',
        message: 'Drug Name Already Exists',
        location: isRtl ? 'tl' : 'tr'
    });
}



function procedure_lists() {
    $.ajax({
        url: "{{ url('viewDrugList') }}",
        method: "POST",
        data: {
            _token: '{{csrf_token()}}'
        },
        success: function(data) {
            console.log(data);
            $('#custresult').html(data);
        }
    });
}

$(document).ready(function() {
    procedure_lists();

    $('#add_button').click(function() {
        $('.modal-title').html("Add <span class='font-weight-light'>New Drug</span>");
        $('#action').val("Save");
        $('#id').val('');

        $('#Name').val('');
        $('#Type').val('').attr("selected",true);
        $('#Dose').val('').attr("selected",true);
        $('#Freq').val('').attr("selected",true);
        $('#submit').text('Submit');

    })

    $('#validation-form').on('submit', function(e) {
        e.preventDefault();
        if ($('#validation-form').valid()) {
            $.ajax({
                url: "{{ url('saveDrug') }}",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                processData: false,
                beforeSend: function() {
                    $('#submit').attr('disabled', 'disabled');
                    $('#submit').text('Please Wait...');
                },
                success: function(data) {
                    console.warn(data);
                    if (data == 1) {
                        $('#modal-report').modal('hide');
                        success_toast();
                        procedure_lists();

                    } else {
                        error_toast();
                        $('#modal-report').modal('show');
                    }
                    $('#submit').attr('disabled', false);
                    $('#submit').text('Submit');
                }
            });
        }
    });

    $(document).on("click", ".updatedrug", function(event) {
        event.preventDefault();
        event.stopPropagation();
        var id = $(this).attr("data-id");
        var action = "fetch_record";
        $.ajax({
            url: "{{ url('editDrug') }}",
            method: "POST",
            data: {
                _token: '{{csrf_token()}}',
                id: id
            },
            dataType: "json",
            success: function(data) {
                $('#Name').val(data.Name);
                $('#Type').val(data.Type).attr("selected",true);
                $('#Dose').val(data.Dose).attr("selected",true);
                $('#Freq').val(data.Freq).attr("selected",true);
                $('#action').val('Edit');

                $('#id').val(id);
                $('#submit').text("Update");
                $('#modal-report').modal('show');
                $('.modal-title').html(
                    "Update <span class='font-weight-light'>Drug</span>");

            }
        });
    });



    $(document).on("click", ".deletedrug", function(event) {
        event.preventDefault();
        var id = $(this).attr("data-id");
        var action = "delete";
        //alert(id);
        swal({
            title: "Are you sure?",
            text: "You will not be able to recover this Drug!",
            type: "warning",
            showCancelButton: true,
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Yes, delete",
            cancelButtonText: "No, cancel",
            closeOnConfirm: false,
            closeOnCancel: false
        }, function(isConfirm) {
            if (isConfirm) {
                $.ajax({
                    url: "{{ url('deleteDrug') }}",
                    method: "POST",
                    data: {
                        _token: '{{csrf_token()}}',
                        id: id
                    },

                    success: function(data) {
                        swal("Deleted!", "Drug has been deleted.", "success");

                        procedure_lists();

                    }
                });

            } else {
                swal("Cancelled", "Drug is safe :)", "error");
            }
        });


    });

});
</script>
