<?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php
$UserId = Session::get('UserId');
?>
<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold py-3 mb-0">Appointment List
       <span style="float: right;">
            <a href="/<?php echo e(projectUrl()); ?>addNewAppointment" class="btn btn-secondary btn-round"><i class="ion ion-md-add mr-2"></i> New Appointment</a></span> 
    </h4>
    <div class="card mb-4">
        <div class="card-body">
            <div id="alert_message"></div>
            <form id="validation-form" method="post" enctype="multipart/form-data">
                <div class="form-row">
                    <div class="form-group col-md-2">
                        <label class="form-label">MRD No </label>
                        <input type="text" name="MrdNo" id="MrdNo" class="form-control" value=""
                            autocomplete="off">
                    </div>
                    <div class="form-group col-md-3">
                        <label class="form-label">Patient Name </label>
                        <input type="text" name="PatientName" id="PatientName" class="form-control" value=""
                            autocomplete="off" readonly>
                    </div>
                    <div class="form-group col-md-2">
                        <label class="form-label">From Date </label>
                        <input type="date" name="FromDate" id="FromDate" class="form-control" value="<?php echo e(date('Y-m-d')); ?>"
                            autocomplete="off">
                    </div>
                    <div class="form-group col-md-2">
                        <label class="form-label">To Date </label>
                        <input type="date" name="ToDate" id="ToDate" class="form-control" value="<?php echo e(date('Y-m-d')); ?>"
                            autocomplete="off">
                    </div>
                    <!-- <div class="form-group col-md-2">
                        <label class="form-label">Bill Date To</label>
                        <input type="date" name="ToDate" id="ToDate" class="form-control" value="<?php echo e(date('Y-m-d')); ?>" autocomplete="off">
                    </div> -->
                    <input type="hidden" name="Search" value="Search">
                    <div class="form-group col-md-2" style="padding-top:20px;">
                    <button type="button" class="btn btn-primary btn-finish"
                            id="filter">Search</button>
                            <a href="<?php echo e(projectUrl()); ?>Appointment" class="btn btn-secondary btn-finish"
                            >Refresh</a>        
                    </div>
                </div>

            </form>

            <div class="table-responsive" id="custresult">


            </div>
        </div>
    </div>




</div>

<?php echo $__env->make('footerscript', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('excelscript', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script type="text/javascript">
$(document).ready(function() {
    var FromDate = $('#FromDate').val();
    var ToDate = $('#ToDate').val();
    queueList(FromDate,ToDate);

    $('#filter').click(function(){
  var FromDate = $('#FromDate').val();
  var ToDate = $('#ToDate').val();
  var MrdNo = $('#MrdNo').val();
  if(FromDate != '')
  {
   //$('.yajra-datatable').DataTable().destroy();
   //load_data(FromDate, ToDate);
   queueList(FromDate,ToDate, MrdNo);
  }
  else
  {
   alert('Date is required');
  }
 });

 $('#refresh').click(function(){
  $('#FromDate').val('');
  $('#ToDate').val('');
  //$('.yajra-datatable').DataTable().destroy();
  //load_data();
  queueList();
 });

 $(document).on("input", "#MrdNo", function(event) {
        var val = this.value;
        $.ajax({
            url: "<?php echo e(url('getPatientDetails')); ?>",
            method: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                id: val
            },
            dataType: "json",
            success: function(data) {
                //console.log(data);
                $('#MrdNo').val(data.MrdNo);
                $('#PatientName').val(data.PatientName);

            }
        });

    });
 
 $(document).on("click", ".delete", function(event) {
        event.preventDefault();
        var id = $(this).attr("data-id");
        var action = "delete";
        swal({
            title: "Are you sure?",
            text: "You will not be able to recover this Record!",
            type: "warning",
            showCancelButton: true,
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Yes, delete",
            cancelButtonText: "No, cancel",
            closeOnConfirm: false,
            closeOnCancel: false
        }, function(isConfirm) {
            if (isConfirm) {
                $.ajax({
                    url: "<?php echo e(url('deletAppointment')); ?>",
                    method: "POST",
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                        id: id
                    },
                    beforeSend:function(){
                $('.confirm').attr('disabled','disabled');
                $('.confirm').text('Please Wait...');
                },

                    success: function(data) {
                       
                        swal("Deleted!", "Record has been deleted.", "success");
                        //window.location.href = "/queuemanagement";
                        queueList();



                    }
                });

            } else {
                swal("Cancelled", "Record is safe :)", "error");
            }
        });


    });
});

function queueList(FromDate = '',ToDate='',MrdNo = '') {
    //alert(FromDate);alert(MrdNo);
    $.ajax({
        url: "<?php echo e(url('viewAppointments')); ?>",
        method: "POST",
        data: {
            _token: '<?php echo e(csrf_token()); ?>',
            FromDate: FromDate,
            ToDate:ToDate,
            MrdNo:MrdNo
        },
        success: function(data) {
            console.log(data);
            $('#custresult').html(data);
        }
    });
}


</script>
</script>
<?php /**PATH C:\vyawaharehosp_new_2\resources\views//appointment/view-appointment.blade.php ENDPATH**/ ?>