<!DOCTYPE>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
    <title>Vyawahare Hospital</title>
    <link rel="stylesheet" href="<?php echo e(url('assets/fonts/feather.css')); ?>">
    <style type="text/css">
    body {
        margin-left: 20px;
        margin-top: 5px;
        margin-right: 5px;
        margin-bottom: 0px;
    }
    </style>
    <style>
    .tblborder {
        border: 1px solid #ada9a9;
        border-collapse: collapse;
    }

    .alltextfont {
        font-family: Poppins;
        font-size: 11px;
        font-style: normal;
        line-height: normal;
        font-weight: normal;
        font-variant: normal;

        color: #4C4C4C;
    }

    .smalltextfont {
        font-family: Poppins;
        font-size: 12px;
        font-style: normal;
        line-height: normal;
        font-weight: normal;
        font-variant: normal;

        color: #000000;
    }

    .addrfont {
        font-family: "Poppins Light";
        font-size: 9pt;
        font-style: normal;
        line-height: normal;
        font-weight: normal;
        font-variant: normal;

        color: #000000;
    }

    .tblrightbtm {
        border-right-width: 1px;
        border-bottom-width: 1px;
        border-right-style: solid;
        border-bottom-style: solid;
        border-right-color: #CCCCCC;
        border-bottom-color: #CCCCCC;
    }

    .tblonlybtm {

        border-bottom-width: 1px;
        border-bottom-style: solid;
        border-right-color: #CCCCCC;
        border-bottom-color: #CCCCCC;
    }

    .tophdfnt {
        font-family: "Poppins Medium";
        font-size: 14pt;
        font-style: normal;
        line-height: normal;
        font-weight: normal;
        font-variant: normal;

        color: #000000;
        letter-spacing: 0.3mm;
    }

    .thbrd {
        border: 1px solid #ada9a9;
        border-collapse: collapse;
    }

    .tdbrd {
        border: 1px solid #ada9a9;
        border-collapse: collapse;
        font-family: "Poppins Medium";
        font-size: 8pt;
        font-style: normal;
        line-height: normal;
        font-weight: normal;
        font-variant: normal;
        color: #424242;
        word-spacing: normal;
        letter-spacing: 0.2mm;
    }

    .txtfundus {

        border-collapse: collapse;
        font-family: "Poppins Medium";
        font-size: 8pt;
        font-style: normal;
        line-height: normal;
        font-weight: normal;
        font-variant: normal;
        color: #4C4C4C;
        word-spacing: normal;
        letter-spacing: 0.2mm;
    }

    .txtallvalues {

        border-collapse: collapse;
        font-family: "Poppins Medium";
        font-size: 8pt;
        font-style: normal;
        line-height: normal;
        font-weight: normal;
        font-variant: normal;
        color: #626262;
        word-spacing: normal;

    }

    .txtdegree {

        border-collapse: collapse;
        font-family: "Poppins Light";
        font-size: 8pt;
        font-style: normal;
        line-height: normal;
        font-weight: normal;
        font-variant: normal;
        color: #424242;
        word-spacing: normal;

    }

    .txtallheading {
        font-family: "Poppins SemiBold";
        font-size: 9pt;
        font-style: normal;
        line-height: normal;
        font-weight: normal;
        font-variant: normal;

        color: #000000;

    }

    .txtdrname {
        font-family: "Poppins Light";
        font-size: 9pt;
        font-style: normal;
        line-height: normal;
        font-weight: normal;
        font-variant: normal;

        color: #000000;

    }

    .txtnabhlogo {
        font-family: "Poppins Medium";
        font-size: 7pt;
        font-style: normal;
        line-height: normal;
        font-weight: normal;
        font-variant: normal;
        letter-spacing: 0.2mm color: #000000;
        letter-spacing: 0.3mm;
    }

    .tdbrd1 {
        border: 1px solid #ada9a9;
        border-collapse: collapse;
        font-family: Poppins;
        font-size: 11px;
        font-style: normal;
        line-height: normal;
        font-weight: normal;
        font-variant: normal;

        color: #4C4C4C;
    }

    .style1 {
        border: 1px solid #ada9a9;
        border-collapse: collapse;
        font-family: Poppins;
        font-size: 11px;
        font-style: normal;
        line-height: normal;
        font-weight: normal;
        font-variant: normal;
        color: #4C4C4C;
        letter-spacing: 0.2mm;
    }

    .style3 {
        font-size: 10
    }

    .singleline {
        border-left-width: 1px;
        border-left-style: solid;
        border-left-color: #ada9a9;
    }

    @media print {
        @page {
            margin-top: 10px;
            margin-left: 50px;
            margin-right: 0px;
            margin-bottom: 0px;
        }

        @page :footer {
            display: none
        }

        .noPrint {
            display: none;
        }

        @page :header {
            display: none
        }
    }

    @media print {
        a[href]:after {
            content: none !important;
        }
    }

    @media screen {
        div.divFooter {
            display: none;
        }
    }

    @media print {
        div.divFooter {
            position: fixed;
            bottom: 20;
        }
    }
    </style>
</head>
<script>
window.print();
window.onafterprint = window.close;
</script>
<?php
use App\Http\Controllers\ConsultantController;
use App\Http\Controllers\OptoController;
?>

<body>
    <table width="700" border="0" cellspacing="1" cellpadding="1">
        <tr class="noPrint">
            <td style="float:right;"><button align="center" style="text-align:center;font-size: 18px;width: 100px;"
                    onclick="window.print();" class="noPrint">Print</button> </td>
        </tr>
        <tr>
            <td align="left" valign="top">
                <table width="100%" border="0" cellspacing="0" cellpadding="0" class="tdbrd1">
                    <tr>
                        <td align="left" valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="0" style="padding-bottom: 10px;padding-top:10px;">
                          <tr>
                            <td width="35%" align="center" valign="middle" ><img src="<?php echo e(url('logo.jpg')); ?>"></td>
                            <td width="39%" align="center" valign="middle"><span class="txtdegree"><strong>Khaparde Garden, Near Irwin Square,<br>
                              Netradan Road,
                              Amravati -444601<br>
                              Ph:(0721) 2663151
                              | Mob :
                              8698249358</strong><br>
                              website : www.deshmukheyehospital.com</span></td>
                            <td width="26%" align="center" valign="middle"><img src="<?php echo e(url('nabh.jpg')); ?>"></td>
                          </tr>
                        </table></td>
                      </tr> 
                </table>
            </td>
        </tr>
        <tr>
            <td align="center" valign="top" class="txtallheading"><strong>
                    Medical Report</strong> </td>
        </tr>
        <td align="left" valign="top">
            <table width="100%" border="0" cellpadding="4" cellspacing="0" class="tblborder">
                <tr style="border:1px; color:#333333">
                    <td width="21%" align="left" valign="middle" class="tdbrd">Name/Age/Gender</td>
                    <td width="39%" align="left" valign="middle" class="tblonlybtm txtallheading">
                    <?php echo e(strtoupper($pt_data['items']['PatientName'])); ?> / <?php echo e($queue_data['items']['Age']); ?> /
        <?php echo e($pt_data['items']['Gender']); ?> </td>
                    <td width="10%" align="left" valign="middle" class="tdbrd">MRD No</td>
                    <td width="10%" align="center" valign="middle" class="txtallheading"><?php echo e($pt_data['items']['MrdNo']); ?><</td>
                    <td width="7%" align="center" valign="middle" class="tdbrd">Date</td>
                    <td width="13%" align="center" valign="middle" class="txtallvalues txtallheading" style="font-family: 'Poppins SemiBold';">
                    <?php echo e(date("d/m/Y", strtotime(str_replace('-', '/',$opto_data['items']['VisitDate'])))); ?></td>
                </tr>
                <tr>
                    <td align="left" valign="middle" class="tdbrd">Address</td>
                    <td colspan="2" align="left" valign="middle" class="txtallvalues">
                    <?php echo e(strtoupper($pt_data['items']['Address'])); ?></td>
                    <td colspan="2" align="center" valign="middle" class="tdbrd"><i class="feather icon-phone-call"></i> &nbsp;&nbsp;<?php echo e($pt_data['items']['Phone']); ?> </td>
                    <td align="center" valign="middle" class="txtallvalues"></td>
                </tr>
            </table>
        </td>
        </tr>

        <tr>
            <td>
                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                    <tr>
                        <td width="13%" align="left" valign="top" class="txtallheading"><strong>Visual Acuity </strong>
                        </td>
                        <td width="21%" align="center" valign="top" class="txtallheading"><span
                                class="txtnabhlogo">RE</span></td>
                        <td width="34%" align="center" valign="top" class="txtallheading"><span
                                class="txtnabhlogo">LE</span></td>
                        <?php if($opto_data['items']['IopAtRe2'] != '' || $opto_data['items']['IopAtLe2'] != ''): ?>        
                        <td width="5%" align="left" valign="top" class="txtallheading"><strong>AT</strong></td>
                        <td width="12%" align="center" valign="middle" class="txtnabhlogo"> RE</td>
                        <td width="25%" align="center" valign="middle" class="txtnabhlogo">LE</td>
                        <?php endif; ?>         
                        <?php if($opto_data['items']['IopAtRe2'] == '' || $opto_data['items']['IopAtLe2'] == ''): ?> 
                        <?php if($opto_data['items']['IopNctRe'] != '' || $opto_data['items']['IopNctLe'] != ''): ?>        
                        <td width="5%" align="left" valign="top" class="txtallheading"><strong>IOP</strong></td>
                        <td width="12%" align="center" valign="middle" class="txtnabhlogo"> RE</td>
                        <td width="25%" align="center" valign="middle" class="txtnabhlogo">LE</td>
                        <?php endif; ?>
                        <?php endif; ?>
                    </tr>
                   
                </table>
            </td>
        </tr>
        <td align="left" valign="top">
            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr>
                    <td width="68%" align="left" valign="top">
                        <table width="98%" border="0" cellspacing="0" cellpadding="4" class="tdbrd1">

                            <tr>
                                <td width="10%" align="center" valign="top" class="tdbrd">&nbsp;Unaid</td>
                                <td width="17%" align="center" valign="top" class="tdbrd txtallheading">&nbsp;<?php echo e($opto_data['items']['VaRe']); ?>

                                </td>
                                <td width="5%" align="center" valign="top" class="tdbrd"> PH </td>
                                <td width="17%" align="center" valign="top" class="tdbrd txtallheading">
                                    &nbsp;<?php echo e($opto_data['items']['VaPhRe']); ?></td>
                                <td width="10%" align="center" valign="top" class="tdbrd">Unaid</td>
                                <td width="17%" align="center" valign="top" class="tdbrd txtallheading">&nbsp;<?php echo e($opto_data['items']['VaLe']); ?>

                                </td>
                                <td width="7%" align="center" valign="top" class="tdbrd">&nbsp; PH </td>
                                <td width="17%" align="center" valign="top" class="tdbrd txtallheading">
                                    &nbsp;<?php echo e($opto_data['items']['VaPhLe']); ?></td>
                            </tr>
                        </table>
                    </td>
                    <?php if($opto_data['items']['IopAtRe2'] == '' || $opto_data['items']['IopAtLe2'] == ''): ?> 
                    <?php if($opto_data['items']['IopNctRe'] != '' || $opto_data['items']['IopNctLe'] != ''): ?>
                    <td width="32%" align="right" valign="top">
                        <table width="100%" border="0" cellspacing="0" cellpadding="4" class="tdbrd1">
                            <tr>
                                <td width="50%" align="center" valign="top" class="txtallvalues txtallheading">
                                    <?php if($opto_data['items']['IopNctRe'] != ''): ?>
                                    <?php echo e($opto_data['items']['IopNctRe']); ?> mm/hg
                                    <?php else: ?>
                                    -
                                    <?php endif; ?> </td>
                                <td width="50%" align="center" valign="top" class="singleline txtallheading">
                                    <?php if($opto_data['items']['IopNctLe'] != ''): ?>
                                    <?php echo e($opto_data['items']['IopNctLe']); ?> mm/hg
                                    <?php else: ?>
                                    -
                                    <?php endif; ?> </td>
                            </tr>
                        </table>
                    </td>
                    <?php endif; ?>
                    <?php endif; ?>

                   
                    <?php if($opto_data['items']['IopAtRe2'] != '' || $opto_data['items']['IopAtLe2'] != ''): ?>
                    <td width="32%" align="right" valign="top">
                        <table width="100%" border="0" cellspacing="0" cellpadding="4" class="tdbrd1">
                        <tr>
                                <td width="50%" align="center" valign="top" class="txtallvalues">
                                    <?php if($opto_data['items']['IopAtRe2'] != ''): ?>
                                    <?php echo e($opto_data['items']['IopAtRe2']); ?> mm/hg
                                    <?php else: ?>
                                    -
                                    <?php endif; ?> </td>
                                <td width="50%" align="center" valign="top" class="singleline">
                                    <?php if($opto_data['items']['IopAtLe2'] != ''): ?>
                                    <?php echo e($opto_data['items']['IopAtLe2']); ?> mm/hg
                                    <?php else: ?>
                                    -
                                    <?php endif; ?> </td>
                            </tr>
                        </table>
                    </td>
                    <?php endif; ?>
                    



                    
                </tr>
            </table>
        </td>

        


       

        </tr>
    </table>


    <table width="700" height="400" border="0" cellpadding="2" cellspacing="2" class="tblborder">
        <tr>
          <td height="400" align="left" valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="5">
          <?php if($consult_data['items']['InvStName'] != ''): ?>
            <tr>
                <td height="21" align="left" valign="top" class="tblrightbtm txtallheading" style="color: #939393;">Investigation </td>
                <td align="left" valign="top" class="tblonlybtm txtallheading">
                    <span style="white-space: pre-wrap;"><strong><?php echo e($consult_data['items']['InvStName']); ?></strong></span>
                </td>
            </tr>
            <?php endif; ?>
            <tr>
                <td height="21" align="left" valign="top" class="tblrightbtm txtallheading" style="color: #939393;">Diagnosis </td>
                <td align="left" valign="top" class="tblonlybtm txtallheading">
                    <span style="white-space: pre-wrap;"><strong><?php echo e($consult_data['items']['Diagnosis']); ?></strong></span>
                </td>
            </tr>
            <?php if($consult_data['items']['Advice'] != ''): ?>
            <tr>
                <td align="left" valign="middle" class="tblrightbtm txtallheading" style="color: #939393;">Advice </td>
                <td align="left" valign="top" class="tblonlybtm txtallheading">
                    <span style="white-space: pre-wrap;font-size: 8pt;"><strong><?php echo e($consult_data['items']['Advice']); ?></strong></span>
                </td>
            </tr>
            <?php endif; ?>
            <?php if($consult_data['items']['Remark'] != ''): ?>
            <tr>
                <td align="left" valign="middle" class="tblrightbtm txtallheading" style="color: #939393;">Special Instruction </td>
                <td align="left" valign="top" class="tblonlybtm txtallvalues">
                    <span style="white-space: pre-wrap;"><?php echo e($consult_data['items']['Remark']); ?></span>
                </td>
            </tr>
            <?php endif; ?>
            <?php if($consult_data['items']['ReferTo'] != ''): ?>
            <tr>
                <td align="left" valign="middle" class="tblrightbtm txtallheading" style="color: #939393;">Refer To </td>
                <td align="left" valign="top" class="tblonlybtm txtallheading">
                    <span style="white-space: pre-wrap;"><strong><?php echo e($consult_data['items']['ReferTo']); ?></strong></span>
                </td>
            </tr>
            <?php endif; ?>
            <tr class="tblrightbtm txtallheading">
              <td width="21%" align="left" valign="top" > Treatment</td>
              <td height="53" align="left" valign="top" >
              <table width="100%" border="0" cellspacing="0" cellpadding="0">
       
        <?php if($consult_treat_data['items']['TreatChk1'] == 1 || $consult_treat_data['items']['TreatChk2'] == 1 || $consult_treat_data['items']['TreatChk3'] == 1 || $consult_treat_data['items']['TreatChk4'] == 1 || $consult_treat_data['items']['TreatChk5'] == 1 || $consult_treat_data['items']['TreatChk6'] == 1 || $consult_treat_data['items']['TreatChk7'] == 1 || $consult_treat_data['items']['TreatChk8'] == 1 || $consult_treat_data['items']['TreatChk9'] == 1 || $consult_treat_data['items']['TreatChk10'] == 1): ?>
                    Rx,
                    <?php endif; ?>
        <?php if($consult_treat_data['items']['TreatChk1'] == 1): ?>
                                <?php if($consult_treat_data['items']['TreatFreq1'] == '8 TAP' || $consult_treat_data['items']['TreatFreq1'] == '6 TAP' ||
                                $consult_treat_data['items']['TreatFreq1'] == '4 TAP' || $consult_treat_data['items']['TreatFreq1'] == '3 TAP' ||
                                $consult_treat_data['items']['TreatFreq1'] == '2 TAP' || $consult_treat_data['items']['TreatFreq1'] == '1 TAP'): ?>
                                <tr>
                                    <td align="left" valign="top" class="addrfont"><strong><?php echo e($consult_treat_data['items']['TreatName1']); ?></strong></td>
                                </tr>
                                <?php
                                $TapValue = $consult_treat_data['items']['TreatFreq1'];
                                $data1 = (new ConsultantController)->getTapValue($TapValue);
                                ?>
                                <?php $__currentLoopData = $data1; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result1): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $treattapname1 = (new
                                OptoController)->convertMarathi($consult_treat_data['items']['TreatType1'],$consult_treat_data['items']['TreatDose1'],
                                $result1->Value,$consult_treat_data['items']['TreatDur1'],$consult_treat_data['items']['TreatEye1']); ?>
                                <tr>

                                    <td style="text-align:justify;font-family: Shivaji01;padding-left: 25px;" >
                                        <?php echo e($treattapname1); ?></td>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tr>
                                <?php else: ?>
                                <tr>

                                    <td align="left" valign="top" class="addrfont"><strong><?php echo e($consult_treat_data['items']['TreatName1']); ?></strong></td>
                                </tr>
                                <tr>
                                    <td style="text-align:justify;font-family: Shivaji01;padding-left: 25px;">
                                        <?php echo e($TreatName1); ?></td>
                                </tr>
                                <?php endif; ?>
                                <!-- <tr>
                                    <td align="left" valign="top">&nbsp;</td>
                                </tr> -->
                                <?php endif; ?>

                                <?php if($consult_treat_data['items']['TreatChk2'] == 1): ?>
                                <?php if($consult_treat_data['items']['TreatFreq2'] == '8 TAP' || $consult_treat_data['items']['TreatFreq2'] == '6 TAP' ||
                                $consult_treat_data['items']['TreatFreq2'] == '4 TAP' || $consult_treat_data['items']['TreatFreq2'] == '3 TAP' ||
                                $consult_treat_data['items']['TreatFreq2'] == '2 TAP' || $consult_treat_data['items']['TreatFreq2'] == '1 TAP'): ?>
                                <tr>
                                    <td align="left" valign="top" class="addrfont"><strong><?php echo e($consult_treat_data['items']['TreatName2']); ?> </strong></td>
                                </tr>
                                <?php
                                $TapValue2 = $consult_treat_data['items']['TreatFreq2'];
                                $data2 = (new ConsultantController)->getTapValue($TapValue2);
                                ?>
                                <?php $__currentLoopData = $data2; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $treattapname2 = (new
                                OptoController)->convertMarathi($consult_treat_data['items']['TreatType2'],$consult_treat_data['items']['TreatDose2'],
                                $result2->Value,$consult_treat_data['items']['TreatDur2'],$consult_treat_data['items']['TreatEye2']); ?>
                                <tr>

                                    <td style="text-align:justify;font-family: Shivaji01;padding-left: 25px;">
                                        <?php echo e($treattapname2); ?></td>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tr>
                                <?php else: ?>
                                <tr>

                                    <td align="left" valign="top" class="addrfont"><strong><?php echo e($consult_treat_data['items']['TreatName2']); ?> </strong></td>
                                </tr>
                                <tr>
                                    <td style="text-align:justify;font-family: Shivaji01;padding-left: 25px;">
                                        <?php echo e($TreatName2); ?></td>
                                </tr>
                                <?php endif; ?>
                                <!-- <tr>
                                    <td align="left" valign="top">&nbsp;</td>
                                </tr> -->
                                <?php endif; ?>


                                <?php if($consult_treat_data['items']['TreatChk3'] == 1): ?>
                                <?php if($consult_treat_data['items']['TreatFreq3'] == '8 TAP' || $consult_treat_data['items']['TreatFreq3'] == '6 TAP' ||
                                $consult_treat_data['items']['TreatFreq3'] == '4 TAP' || $consult_treat_data['items']['TreatFreq3'] == '3 TAP' ||
                                $consult_treat_data['items']['TreatFreq3'] == '2 TAP' || $consult_treat_data['items']['TreatFreq3'] == '1 TAP'): ?>
                                <tr>
                                    <td align="left" valign="top" class="addrfont"><strong><?php echo e($consult_treat_data['items']['TreatName3']); ?> </td>
                                </tr>
                                <?php
                                $TapValue3 = $consult_treat_data['items']['TreatFreq3'];
                                $data3 = (new ConsultantController)->getTapValue($TapValue3);
                                ?>
                                <?php $__currentLoopData = $data3; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result3): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $treattapname3 = (new
                                OptoController)->convertMarathi($consult_treat_data['items']['TreatType3'],$consult_treat_data['items']['TreatDose3'],
                                $result3->Value,$consult_treat_data['items']['TreatDur3'],$consult_treat_data['items']['TreatEye3']); ?>
                                <tr>

                                    <td style="text-align:justify;font-family: Shivaji01;padding-left: 25px;">
                                        <?php echo e($treattapname3); ?></td>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tr>
                                <?php else: ?>
                                <tr>

                                    <td align="left" valign="top" class="addrfont"><strong><?php echo e($consult_treat_data['items']['TreatName3']); ?> </td>
                                </tr>
                                <tr>
                                    <td style="text-align:justify;font-family: Shivaji01;padding-left: 25px;">
                                        <?php echo e($TreatName3); ?></td>
                                </tr>
                                <?php endif; ?>
                                <!-- <tr>
                                    <td align="left" valign="top">&nbsp;</td>
                                </tr> -->
                                <?php endif; ?>

                                <?php if($consult_treat_data['items']['TreatChk4'] == 1): ?>
                                <?php if($consult_treat_data['items']['TreatFreq4'] == '8 TAP' || $consult_treat_data['items']['TreatFreq4'] == '6 TAP' ||
                                $consult_treat_data['items']['TreatFreq4'] == '4 TAP' || $consult_treat_data['items']['TreatFreq4'] == '3 TAP' ||
                                $consult_treat_data['items']['TreatFreq4'] == '2 TAP' || $consult_treat_data['items']['TreatFreq4'] == '1 TAP'): ?>
                                <tr>
                                    <td align="left" valign="top" class="addrfont"><strong><?php echo e($consult_treat_data['items']['TreatName4']); ?></strong> </td>
                                </tr>
                                <?php
                                $TapValue4 = $consult_treat_data['items']['TreatFreq4'];
                                $data4 = (new ConsultantController)->getTapValue($TapValue4);
                                ?>
                                <?php $__currentLoopData = $data4; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result4): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $treattapname4 = (new
                                OptoController)->convertMarathi($consult_treat_data['items']['TreatType4'],$consult_treat_data['items']['TreatDose4'],
                                $result4->Value,$consult_treat_data['items']['TreatDur4'],$consult_treat_data['items']['TreatEye4']); ?>
                                <tr>

                                    <td style="text-align:justify;font-family: Shivaji01;padding-left: 25px;">
                                        <?php echo e($treattapname4); ?></td>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tr>
                                <?php else: ?>
                                <tr>

                                    <td align="left" valign="top" class="addrfont"><strong><?php echo e($consult_treat_data['items']['TreatName4']); ?></strong> </td>
                                </tr>
                                <tr>
                                    <td style="text-align:justify;font-family: Shivaji01;padding-left: 25px;">
                                        <?php echo e($TreatName4); ?></td>
                                </tr>
                                <?php endif; ?>
                                <!-- <tr>
                                    <td align="left" valign="top">&nbsp;</td>
                                </tr> -->
                                <?php endif; ?>

                                <?php if($consult_treat_data['items']['TreatChk5'] == 1): ?>
                                <?php if($consult_treat_data['items']['TreatFreq5'] == '8 TAP' || $consult_treat_data['items']['TreatFreq5'] == '6 TAP' ||
                                $consult_treat_data['items']['TreatFreq5'] == '4 TAP' || $consult_treat_data['items']['TreatFreq5'] == '3 TAP' ||
                                $consult_treat_data['items']['TreatFreq5'] == '2 TAP' || $consult_treat_data['items']['TreatFreq5'] == '1 TAP'): ?>
                                <tr>
                                    <td align="left" valign="top"><strong><?php echo e($consult_treat_data['items']['TreatName5']); ?></strong></td>
                                </tr>
                                <?php
                                $TapValue5 = $consult_treat_data['items']['TreatFreq5'];
                                $data5 = (new ConsultantController)->getTapValue($TapValue5);
                                ?>
                                <?php $__currentLoopData = $data5; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result5): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $treattapname5 = (new
                                OptoController)->convertMarathi($consult_treat_data['items']['TreatType5'],$consult_treat_data['items']['TreatDose5'],
                                $result5->Value,$consult_treat_data['items']['TreatDur5'],$consult_treat_data['items']['TreatEye5']); ?>
                                <tr>

                                    <td style="text-align:justify;font-family: Shivaji01;padding-left: 25px;">
                                        <?php echo e($treattapname5); ?></td>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tr>
                                <?php else: ?>
                                <tr>

                                    <td align="left" valign="top" class="addrfont"><strong><?php echo e($consult_treat_data['items']['TreatName5']); ?></strong> </td>
                                </tr>
                                <tr>
                                    <td style="text-align:justify;font-family: Shivaji01;padding-left: 25px;">
                                        <?php echo e($TreatName5); ?></td>
                                </tr>
                                <?php endif; ?>
                                <!-- <tr>
                                    <td align="left" valign="top">&nbsp;</td>
                                </tr> -->
                                <?php endif; ?>

                                <?php if($consult_treat_data['items']['TreatChk6'] == 1): ?>
                                <?php if($consult_treat_data['items']['TreatFreq6'] == '8 TAP' || $consult_treat_data['items']['TreatFreq6'] == '6 TAP' ||
                                $consult_treat_data['items']['TreatFreq6'] == '4 TAP' || $consult_treat_data['items']['TreatFreq6'] == '3 TAP' ||
                                $consult_treat_data['items']['TreatFreq6'] == '2 TAP' || $consult_treat_data['items']['TreatFreq6'] == '1 TAP'): ?>
                                <tr>
                                    <td align="left" valign="top" class="addrfont"><strong><?php echo e($consult_treat_data['items']['TreatName6']); ?></strong> </td>
                                </tr>
                                <?php
                                $TapValue6 = $consult_treat_data['items']['TreatFreq6'];
                                $data6 = (new ConsultantController)->getTapValue($TapValue6);
                                ?>
                                <?php $__currentLoopData = $data6; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result6): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $treattapname6 = (new
                                OptoController)->convertMarathi($consult_treat_data['items']['TreatType6'],$consult_treat_data['items']['TreatDose6'],
                                $result6->Value,$consult_treat_data['items']['TreatDur6'],$consult_treat_data['items']['TreatEye6']); ?>
                                <tr>

                                    <td style="text-align:justify;font-family: Shivaji01;padding-left: 25px;">
                                        <?php echo e($treattapname6); ?></td>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tr>
                                <?php else: ?>
                                <tr>

                                    <td align="left" valign="top" class="addrfont"><strong><?php echo e($consult_treat_data['items']['TreatName6']); ?></strong> </td>
                                </tr>
                                <tr>
                                    <td style="text-align:justify;font-family: Shivaji01;padding-left: 25px;">
                                        <?php echo e($TreatName6); ?></td>
                                </tr>
                                <?php endif; ?>
                                <!-- <tr>
                                    <td align="left" valign="top">&nbsp;</td>
                                </tr> -->
                                <?php endif; ?>

                                <?php if($consult_treat_data['items']['TreatChk7'] == 1): ?>
                                <?php if($consult_treat_data['items']['TreatFreq7'] == '8 TAP' || $consult_treat_data['items']['TreatFreq7'] == '6 TAP' ||
                                $consult_treat_data['items']['TreatFreq7'] == '4 TAP' || $consult_treat_data['items']['TreatFreq7'] == '3 TAP' ||
                                $consult_treat_data['items']['TreatFreq7'] == '2 TAP' || $consult_treat_data['items']['TreatFreq7'] == '1 TAP'): ?>
                                <tr>
                                    <td align="left" valign="top" class="addrfont"><strong><?php echo e($consult_treat_data['items']['TreatName7']); ?></strong></td>
                                </tr>
                                <?php
                                $TapValue7 = $consult_treat_data['items']['TreatFreq7'];
                                $data7 = (new ConsultantController)->getTapValue($TapValue7);
                                ?>
                                <?php $__currentLoopData = $data7; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result7): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $treattapname7 = (new
                                OptoController)->convertMarathi($consult_treat_data['items']['TreatType7'],$consult_treat_data['items']['TreatDose7'],
                                $result7->Value,$consult_treat_data['items']['TreatDur7'],$consult_treat_data['items']['TreatEye7']); ?>
                                <tr>

                                    <td style="text-align:justify;font-family: Shivaji01;padding-left: 25px;">
                                        <?php echo e($treattapname7); ?></td>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tr>
                                <?php else: ?>
                                <tr>

                                    <td align="left" valign="top" class="addrfont"><strong><?php echo e($consult_treat_data['items']['TreatName7']); ?></strong> </td>
                                </tr>
                                <tr>
                                    <td style="text-align:justify;font-family: Shivaji01;padding-left: 25px;">
                                        <?php echo e($TreatName7); ?></td>
                                </tr>
                                <?php endif; ?>
                                <!-- <tr>
                                    <td align="left" valign="top">&nbsp;</td>
                                </tr> -->
                                <?php endif; ?>

                                <?php if($consult_treat_data['items']['TreatChk8'] == 1): ?>
                                <?php if($consult_treat_data['items']['TreatFreq8'] == '8 TAP' || $consult_treat_data['items']['TreatFreq8'] == '6 TAP' ||
                                $consult_treat_data['items']['TreatFreq8'] == '4 TAP' || $consult_treat_data['items']['TreatFreq8'] == '3 TAP' ||
                                $consult_treat_data['items']['TreatFreq8'] == '2 TAP' || $consult_treat_data['items']['TreatFreq8'] == '1 TAP'): ?>
                                <tr>
                                    <td align="left" valign="top" class="addrfont"><strong><?php echo e($consult_treat_data['items']['TreatName8']); ?></strong></td>
                                </tr>
                                <?php
                                $TapValue8 = $consult_treat_data['items']['TreatFreq8'];
                                $data8 = (new ConsultantController)->getTapValue($TapValue8);
                                ?>
                                <?php $__currentLoopData = $data8; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result8): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $treattapname8 = (new
                                OptoController)->convertMarathi($consult_treat_data['items']['TreatType8'],$consult_treat_data['items']['TreatDose8'],
                                $result8->Value,$consult_treat_data['items']['TreatDur8'],$consult_treat_data['items']['TreatEye8']); ?>
                                <tr>

                                    <td style="text-align:justify;font-family: Shivaji01;padding-left: 25px;">
                                        <?php echo e($treattapname8); ?></td>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tr>
                                <?php else: ?>
                                <tr>

                                    <td align="left" valign="top" class="addrfont"><strong><?php echo e($consult_treat_data['items']['TreatName8']); ?></strong> </td>
                                </tr>
                                <tr>
                                    <td style="text-align:justify;font-family: Shivaji01;padding-left: 25px;">
                                        <?php echo e($TreatName8); ?></td>
                                </tr>
                                <?php endif; ?>
                                <!-- <tr>
                                    <td align="left" valign="top">&nbsp;</td>
                                </tr> -->
                                <?php endif; ?>

                                <?php if($consult_treat_data['items']['TreatChk9'] == 1): ?>
                                <?php if($consult_treat_data['items']['TreatFreq9'] == '8 TAP' || $consult_treat_data['items']['TreatFreq9'] == '6 TAP' ||
                                $consult_treat_data['items']['TreatFreq9'] == '4 TAP' || $consult_treat_data['items']['TreatFreq9'] == '3 TAP' ||
                                $consult_treat_data['items']['TreatFreq9'] == '2 TAP' || $consult_treat_data['items']['TreatFreq9'] == '1 TAP'): ?>
                                <tr>
                                    <td align="left" valign="top" class="addrfont"><strong><?php echo e($consult_treat_data['items']['TreatName9']); ?></strong> </td>
                                </tr>
                                <?php
                                $TapValue9 = $consult_treat_data['items']['TreatFreq9'];
                                $data9 = (new ConsultantController)->getTapValue($TapValue9);
                                ?>
                                <?php $__currentLoopData = $data9; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result9): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $treattapname9 = (new
                                OptoController)->convertMarathi($consult_treat_data['items']['TreatType9'],$consult_treat_data['items']['TreatDose9'],
                                $result9->Value,$consult_treat_data['items']['TreatDur9'],$consult_treat_data['items']['TreatEye9']); ?>
                                <tr>

                                    <td style="text-align:justify;font-family: Shivaji01;padding-left: 25px;">
                                        <?php echo e($treattapname9); ?></td>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tr>
                                <?php else: ?>
                                <tr>

                                    <td align="left" valign="top" class="addrfont"><strong><?php echo e($consult_treat_data['items']['TreatName9']); ?></strong> </td>
                                </tr>
                                <tr>
                                    <td style="text-align:justify;font-family: Shivaji01;padding-left: 25px;">
                                        <?php echo e($TreatName9); ?></td>
                                </tr>
                                <?php endif; ?>
                                <!-- <tr>
                                    <td align="left" valign="top">&nbsp;</td>
                                </tr> -->
                                <?php endif; ?>

                                <?php if($consult_treat_data['items']['TreatChk10'] == 1): ?>
                                <?php if($consult_treat_data['items']['TreatFreq10'] == '8 TAP' || $consult_treat_data['items']['TreatFreq10'] == '6 TAP' ||
                                $consult_treat_data['items']['TreatFreq10'] == '4 TAP' || $consult_treat_data['items']['TreatFreq10'] == '3 TAP' ||
                                $consult_treat_data['items']['TreatFreq10'] == '2 TAP' || $consult_treat_data['items']['TreatFreq10'] == '1 TAP'): ?>
                                <tr>
                                    <td align="left" valign="top" class="addrfont"><strong><?php echo e($consult_treat_data['items']['TreatName10']); ?></strong> </td>
                                </tr>
                                <?php
                                $TapValue10 = $consult_treat_data['items']['TreatFreq10'];
                                $data10 = (new ConsultantController)->getTapValue($TapValue10);
                                ?>
                                <?php $__currentLoopData = $data10; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result10): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $treattapname10 = (new
                                OptoController)->convertMarathi($consult_treat_data['items']['TreatType10'],$consult_treat_data['items']['TreatDose10'],
                                $result10->Value,$consult_treat_data['items']['TreatDur10'],$consult_treat_data['items']['TreatEye10']); ?>
                                <tr>

                                    <td style="text-align:justify;font-family: Shivaji01;padding-left: 25px;">
                                        <?php echo e($treattapname10); ?></td>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tr>
                                <?php else: ?>
                                <tr>

                                    <td align="left" valign="top" class="addrfont"><strong><?php echo e($consult_treat_data['items']['TreatName10']); ?></strong> </td>
                                </tr>
                                <tr>
                                    <td style="text-align:justify;font-family: Shivaji01;padding-left: 25px;">
                                        <?php echo e($TreatName10); ?></td>
                                </tr>
                                <?php endif; ?>
                                <!-- <tr>
                                    <td align="left" valign="top">&nbsp;</td>
                                </tr> -->
                                <?php endif; ?>
                              
      
                                <tr>
                                    <td align="left" valign="top">&nbsp;</td>
                                </tr>
                                <?php if($consult_treat_data['items']['TreatChk1'] == 1 || $consult_treat_data['items']['TreatChk2'] == 1 || $consult_treat_data['items']['TreatChk3'] == 1 || $consult_treat_data['items']['TreatChk4'] == 1 || $consult_treat_data['items']['TreatChk5'] == 1 || $consult_treat_data['items']['TreatChk6'] == 1 || $consult_treat_data['items']['TreatChk7'] == 1 || $consult_treat_data['items']['TreatChk8'] == 1 || $consult_treat_data['items']['TreatChk9'] == 1 || $consult_treat_data['items']['TreatChk10'] == 1): ?>
                              <tr>
                                <td><span style="font-size: 9px;line-height: 10px;">Or any other cheaper generic medicine as per choice of patient. <br>
In case of severe redness,pain,decreased vision or any other emergency,please call <span style="font-size:14px;">9370109617.</span></span></td>
</tr>
<?php endif; ?>
        
        </table>
            </td>
            </tr>
          </table></td>
        </tr>
        <?php if($consult_data['items']['ReviewDay'] != 0): ?>
        <tr>
          <td height="100" align="right" valign="bottom" class="tblrightbtm txtallheading" style="padding-right: 20px;padding-bottom:10px;">
          <span style="font-family: Shivaji01;font-size: 15px;">tumacyaa PauZIla tPaasaNaIcaI tairK        Aaho </span>
                                <?php echo e(date("d M Y", strtotime(str_replace('-', '/',$consult_data['items']['AppointDate'])))); ?>

                                <?php if($consult_data['items']['ClinicName'] != ''): ?>
    for <?php echo e($consult_data['items']['ClinicName']); ?><span class="txtallheading"> @ <?php echo e(date("h:i a", strtotime(str_replace('-', '/',$consult_data['items']['AppTime'])))); ?></span>
    <?php endif; ?>
                            </td>
        </tr>
        <?php endif; ?>
</table>

    </td>
    </tr>


    </table>
    <br>
    <br>
    <div class="divFooter">
    <table width="700" border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td>
                    <table width="100%" border="0" cellspacing="2" cellpadding="2">
                        <tr>
                            <td width="46%" align="left" valign="top" class="txtallheading"><strong>Prescription of Eye
                                    Glasses</strong></td>
                        </tr>
                        <tr>
                            <td width="46%" align="center" valign="top" class="txtfundus"><strong>RE</strong></td>
                            <td width="54%" align="center" valign="top" class="txtfundus"><strong>LE</strong></td>
                        </tr>
                        <tr>
                          <td width="50%" align="center" valign="top" class="txtfundus"><table width="100%" border="0" cellspacing="0" cellpadding="3" class="tblborder">
                            <tr>
                              <td width="12%" align="center" valign="top" class="txtallvalues">SPH</td>
                              <td width="12%" align="center" valign="top" class="txtallvalues">CYL</td>
                              <td width="12%" align="center" valign="top" class="txtallvalues">AXIS</td>
                              <td width="12%" align="center" valign="top" class="txtallvalues">VISION</td>
                            </tr>
                            <tr>
                            <td align="center" valign="top" class="tdbrd"><?php echo e($opto_data['items']['SrSphRe']); ?></td>
                            <td align="center" valign="top" class="tdbrd"><?php echo e($opto_data['items']['SrCylRe']); ?></td>
                            <td align="center" valign="top" class="tdbrd"><?php echo e($opto_data['items']['SrAxisRe']); ?></td>
                            <td align="center" valign="top" class="tdbrd"><?php echo e($opto_data['items']['SrVaGlassRe']); ?></td>
  
                            </tr>
                            <tr>
                              <td colspan="3" align="center" valign="top" class="tdbrd">Pls Add
                              <?php echo e($opto_data['items']['SrNearAddRe']); ?> </td>
                              <td align="center" valign="top" class="tdbrd1"><?php echo e($opto_data['items']['SrNvRe']); ?></td>
                            </tr>
                          </table></td>
                          <td width="50%" align="center" valign="top" class="txtfundus"><table width="100%" border="0" cellspacing="0" cellpadding="3" class="tblborder">
                            <tr>
                              <td width="12%" align="center" valign="top" class="txtallvalues">SPH</td>
                              <td width="12%" align="center" valign="top" class="txtallvalues">CYL</td>
                              <td width="12%" align="center" valign="top" class="txtallvalues">AXIS</td>
                              <td width="12%" align="center" valign="top" class="txtallvalues">VISION</td>
                            </tr>
                            <tr>
                            <td align="center" valign="top" class="tdbrd"><?php echo e($opto_data['items']['SrSphLe']); ?></td>
                            <td align="center" valign="top" class="tdbrd"><?php echo e($opto_data['items']['SrCylLe']); ?></td>
                            <td align="center" valign="top" class="tdbrd"><?php echo e($opto_data['items']['SrAxisLe']); ?></td>
                            <td align="center" valign="top" class="tdbrd"><?php echo e($opto_data['items']['SrVaGlassLe']); ?></td>
                            </tr>
                            <tr>
                              <td colspan="3" align="center" valign="top" class="tdbrd">Pls Add
                              <?php echo e($opto_data['items']['SrNearAddLe']); ?> </td>
                              <td align="center" valign="top" class="tdbrd1"><?php echo e($opto_data['items']['SrNvLe']); ?></td>
                            </tr>
                          </table></td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
              <td align="left" valign="top">&nbsp;</td>
            </tr>
            <tr>
                <td align="left" valign="top">
                    <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                                <tr>
                            <td align="left" valign="top" class="smalltextfont"><strong>Instruction to dispensing
                                    optician:-</strong> <span style=""><?php echo e($opto_data['items']['Remarks']); ?></span></td>
                        </tr>
                                                <tr>
                            <td align="left" valign="top" class="smalltextfont">
                                <table width="701" height="80" border="0" cellpadding="3" cellspacing="0"
                                    class="tblborder">
                                    <tr>
                                        <!-- <td width="488" height="31" align="left" valign="bottom" class="txtfundus">Your next appointment is on <span class="txtallheading">15 Aug 2022</span></td> -->
                                        <td width="213" align="right" valign="bottom" class="txtallheading">
                                        <?php echo e($DocName); ?><br>
                                        <?php echo e(date("d/m/Y", strtotime(str_replace('-', '/',$consult_data['items']['VisitDate'])))); ?> <?php echo e(date("h:i a")); ?></td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        

        <table width="700" border="0" cellspacing="0" cellpadding="3">
            <tr>
                <td width="422" align="left" valign="middle" class="txtallheading">Working Hours :&nbsp; 08:00 AM -
                    08:00 PM
                    <br>
                    OPD Hours&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;: &nbsp;10:00 AM - 08:00 PM
                </td>
                <td width="278" align="right" valign="middle" class="txtallheading">Sunday Closed </td>
            </tr>
        </table>
    </div>
</body>

</html><?php /**PATH I:\deshmukh_hosp\resources\views//opd/short-opd-print.blade.php ENDPATH**/ ?>