<?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="container-fluid flex-grow-1 container-p-y">
    <h4 class="font-weight-bold py-3 mb-0">Optical Receipt</h4>


    <div class="card mb-4">
        <div class="card-body">
            <div id="alert_message"></div>
            <form id="validation-form" method="post" autocomplete="off" enctype="multipart/form-data">
                <input type="hidden" name="receiptid" value="" id="receiptid">
                <input type="hidden" name="action" value="Save" id="action">
                <?php echo csrf_field(); ?>
                <div class="form-row">
                    <div class="form-group col-md-3">
                        <label class="form-label">Sale Bill No <span class="text-danger">*</span></label>
                        <input type="text" name="BillNo" class="form-control" id="BillNo" placeholder="" value="SB"
                            required oninput="searchBillNo()">
                        <div class="clearfix"></div>
                    </div>


                    <div class="form-group col-md-3">
                        <label class="form-label">Date <span class="text-danger">*</span></label>
                        <input type="date" name="ReceiptDate" class="form-control" id="ReceiptDate" placeholder=""
                            value="<?php echo e(date('Y-m-d')); ?>" required>
                        <div class="clearfix"></div>
                    </div>

                    <input type="hidden" name="MrdNo" class="form-control" id="MrdNo" placeholder="" value="">


                    <div class="form-group col-md-3">
                        <label class="form-label">Customer Name <span class="text-danger">*</span></label>
                        <input type="text" name="PatientName" class="form-control" id="PatientName" placeholder=""
                            value="">
                        <div class="clearfix"></div>
                    </div>

                    <div class="form-group col-md-3">
                        <label class="form-label">Mobile No <span class="text-danger">*</span></label>
                        <input type="text" name="MobileNo" class="form-control" id="MobileNo" placeholder="" value="">
                        <div class="clearfix"></div>
                    </div>







                    <div class="form-group col-md-2">
                        <label class="form-label">Total Amount <span class="text-danger">*</span></label>
                        <input type="text" name="SubTotal" class="form-control" id="SubTotal" placeholder="" value=""
                            >
                        <div class="clearfix"></div>
                    </div>

                    <div class="form-group col-md-2">
                        <label class="form-label">Advance <span class="text-danger">*</span></label>
                        <input type="text" name="Advance" class="form-control" id="Advance" placeholder="" value=""
                            >
                        <div class="clearfix"></div>
                    </div>

                    <div class="form-group col-md-2">
                        <label class="form-label">Balance <span class="text-danger">*</span></label>
                        <input type="text" name="Balance" class="form-control" id="Balance" placeholder="" value=""
                            >
                        <div class="clearfix"></div>
                    </div>

                    <div class="form-group col-md-2">
                        <label class="form-label">Paid Amount <span class="text-danger">*</span></label>
                        <input type="text" name="PaidAmount" class="form-control" id="PaidAmount" placeholder=""
                            value="" onKeyPress="return isNumberKey(event)"
                            oninput="netAmount(document.getElementById('Balance').value,document.getElementById('PaidAmount').value)"
                            required>
                        <div class="clearfix"></div>
                    </div>

                    <div class="form-group col-md-2">
                        <label class="form-label">Net Amount <span class="text-danger">*</span></label>
                        <input type="text" name="NetAmount" class="form-control" id="NetAmount" placeholder="" value=""
                        >
                        <div class="clearfix"></div>
                    </div>

                    <div class="form-group col-md-2">
                        <label class="form-label">Payment Mode <span class="text-danger">*</span></label>
                        <select class="form-control" id="PayMode" name="PayMode" required>
                            <option value="Cash">Cash</option>
                            <option value="Card">Card</option>
                            <option value="Mobile Payment">Mobile Payment</option>
                        </select>
                    </div>


                    <div class="form-group col-md-12">
                        <label class="form-label">Narration</label>
                        <textarea class="form-control" name="Narration" id="Narration"></textarea>
                    </div>


                </div>
                <!-- <button id="growl-default" class="btn btn-default">Default</button> -->
                <button type="submit" name="submit" class="btn btn-primary btn-finish" 
                    id="submit">Save</button>
                <button type="button" class="btn btn-success btn-finish" id="printbtn" 
                    onclick="print()">Print</button>
            </form>
        </div>
    </div>




</div>

<?php echo $__env->make('footerscript', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
function print() {
    var BillNo = $('#BillNo').val();
    setTimeout(function() {
        window.open(
            '/<?php echo e(projectUrl()); ?>printOpticalReceipt/' + BillNo, 'name',
            'toolbar=1, scrollbars=1, location=1,statusbar=0, menubar=1, resizable=1, width=1500, height=1000'
        );
    }, 1);
}

function success_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.notice({
        title: 'Success',
        message: 'Receipt Created Successfully!',
        location: isRtl ? 'tl' : 'tr'
    });
}

function error_toast() {
    var isRtl = $('body').attr('dir') === 'rtl' || $('html').attr('dir') === 'rtl';
    $.growl.error({
        title: 'Error',
        message: 'Receipt No Already Exists',
        location: isRtl ? 'tl' : 'tr'
    });
}

function isNumberKey(evt) {
    var charCode = (evt.which) ? evt.which : evt.keyCode
    if (charCode != 46 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
    return true;
}

function searchBillNo() {
    var BillNo = $('#BillNo').val();
    var action = 'billDetails';
    $.ajax({
        type: "POST",
        url: "<?php echo e(url('getBillNoDetails')); ?>",
        data: {
            _token: '<?php echo e(csrf_token()); ?>',
            BillNo: BillNo
        },
        success: function(data) {
            var res = JSON.parse(data);
            var Status = res.Status;
            var result = res.result;
            if (Status == 1) {
                $('#MrdNo').val(result.MrdNo);
                $('#PatientName').val(result.PatientName);
                $('#MobileNo').val(result.MobileNo);
                $('#SubTotal').val(result.SubTotal);
                $('#Advance').val(result.Advance);
                $('#Balance').val(result.Balance);
                $('#PaidAmount').val(result.PaidAmount);
                $('#NetAmount').val(result.NetAmount);
                $('#PayMode').val(result.PayMode).attr("selected", true);
                $('#Narration').val(result.Narration);
                $('#receiptid').val(result.id);
                $('#action').val('Edit');
                $('#printbtn').attr("disabled", false);
                $('#submit').attr("disabled", false);
            } else if (Status == 2) {
                $('#MrdNo').val(result.MrdNo);
                $('#PatientName').val(result.PatientName);
                $('#MobileNo').val(result.MobileNo);
                $('#SubTotal').val(result.SubTotal);
                $('#Advance').val(result.Advance);
                $('#Balance').val(result.NetAmount);
                $('#PaidAmount').val(result.NetAmount);
                $('#NetAmount').val(0);
                $('#PayMode').val(result.PayMode).attr("selected", true);
                $('#Narration').val(result.Narration);
                $('#receiptid').val('');
                $('#action').val('Save');
                $('#printbtn').attr("disabled", false);
                $('#submit').attr("disabled", false);
            } else {
                $('#receiptid').val('');
                $('#action').val('Save');
                $('#MrdNo').val('');
                $('#PatientName').val('');
                $('#MobileNo').val('');
                $('#SubTotal').val('');
                $('#Advance').val('');
                $('#Balance').val('');
                $('#PaidAmount').val('');
                $('#NetAmount').val(0);
                $('#PayMode').val('Cash').attr("selected", true);
                $('#Narration').val('');
                $('#printbtn').attr("disabled", false);
                $('#submit').attr("disabled", false);

            }
        }
    });
}

function netAmount(Balance, PaidAmount) {
    var NetAmount = Number(Balance) - Number(PaidAmount);
    $('#NetAmount').val(parseFloat(NetAmount).toFixed(2));
}

$(document).ready(function() {
    $('#BillNo').focus().val('').val('SB');

    $('#validation-form').on('submit', function(e) {
        e.preventDefault();
        if ($('#validation-form').valid()) {
            $.ajax({
                url: "<?php echo e(url('saveOpticalReceipt')); ?>",
                method: "POST",
                data: new FormData(this),
                contentType: false,
                processData: false,
                beforeSend: function() {
                    $('#submit').attr('disabled', 'disabled');
                    $('#submit').text('Please Wait...');
                },
                success: function(data) {
                    if (data == 1) {
                        success_toast();
                    } 
                    else {
                        error_toast();
                    }
                    $('#submit').attr('disabled', false);
                    $('#submit').text('Submit');

                }
            });
        }
    });
});
</script>
<?php /**PATH C:\vyawaharehosp_new_2\resources\views//optical/create-optical-receipt.blade.php ENDPATH**/ ?>